/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.codeInsight.inspections;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypeInfoImpl;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFieldFromUsageFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFieldFromUsageHelper;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.VisibilityUtil;
import com.intellij.xml.XmlElementDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.javaFX.fxml.JavaFxFileTypeFactory;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxBuiltInTagDescriptor;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxClassTagDescriptorBase;
import org.jetbrains.plugins.javaFX.fxml.refs.JavaFxFieldIdReferenceProvider;

public class JavaFxUnresolvedFxIdReferenceInspection
extends XmlSuppressableInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JavaFxUnresolvedFxIdReferenceInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JavaFxUnresolvedFxIdReferenceInspection.$$$reportNull$$$0(1);
        }
        if (!JavaFxFileTypeFactory.isFxml(session.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                JavaFxUnresolvedFxIdReferenceInspection.$$$reportNull$$$0(2);
            }
            return psiElementVisitor;
        }
        XmlElementVisitor xmlElementVisitor = new XmlElementVisitor(){

            public void visitXmlAttribute(XmlAttribute attribute) {
                PsiClass fieldClass;
                PsiReference reference;
                PsiClass controllerClass;
                XmlAttributeValue valueElement;
                super.visitXmlAttribute(attribute);
                if ("fx:id".equals(attribute.getName()) && (valueElement = attribute.getValueElement()) != null && valueElement.getTextLength() > 0 && (controllerClass = JavaFxPsiUtil.getControllerClass(attribute.getContainingFile())) != null && (reference = valueElement.getReference()) instanceof JavaFxFieldIdReferenceProvider.JavaFxControllerFieldRef && ((JavaFxFieldIdReferenceProvider.JavaFxControllerFieldRef)reference).isUnresolved() && (fieldClass = JavaFxUnresolvedFxIdReferenceInspection.checkContext(((JavaFxFieldIdReferenceProvider.JavaFxControllerFieldRef)reference).getXmlAttributeValue())) != null) {
                    LocalQuickFix[] localQuickFixArray;
                    String text = reference.getCanonicalText();
                    NamesValidator namesValidator = (NamesValidator)LanguageNamesValidation.INSTANCE.forLanguage(fieldClass.getLanguage());
                    boolean validName = namesValidator != null && namesValidator.isIdentifier(text, fieldClass.getProject());
                    PsiElement psiElement = reference.getElement();
                    TextRange textRange = reference.getRangeInElement();
                    if (isOnTheFly && validName) {
                        LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                        localQuickFixArray = localQuickFixArray2;
                        localQuickFixArray2[0] = new CreateFieldFromUsageQuickFix(text);
                    } else {
                        localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                    }
                    holder.registerProblem(psiElement, textRange, "Unresolved fx:id reference", localQuickFixArray);
                }
            }
        };
        if (xmlElementVisitor == null) {
            JavaFxUnresolvedFxIdReferenceInspection.$$$reportNull$$$0(3);
        }
        return xmlElementVisitor;
    }

    protected static PsiClass checkContext(XmlAttributeValue attributeValue) {
        if (attributeValue == null) {
            return null;
        }
        PsiElement parent = attributeValue.getParent();
        if (parent instanceof XmlAttribute) {
            return JavaFxUnresolvedFxIdReferenceInspection.checkClass(((XmlAttribute)parent).getParent());
        }
        return null;
    }

    private static PsiClass checkClass(XmlTag tag) {
        if (tag != null) {
            XmlTag includedRoot;
            XmlElementDescriptor descriptor = tag.getDescriptor();
            if (descriptor instanceof JavaFxClassTagDescriptorBase) {
                PsiElement declaration = descriptor.getDeclaration();
                if (declaration instanceof PsiClass) {
                    return (PsiClass)declaration;
                }
            } else if (descriptor instanceof JavaFxBuiltInTagDescriptor && (includedRoot = JavaFxBuiltInTagDescriptor.getIncludedRoot(tag)) != null && !includedRoot.equals(tag)) {
                return JavaFxUnresolvedFxIdReferenceInspection.checkClass(includedRoot);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxUnresolvedFxIdReferenceInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxUnresolvedFxIdReferenceInspection";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CreateFieldFromUsageQuickFix
    implements LocalQuickFix {
        private final String myCanonicalName;

        private CreateFieldFromUsageQuickFix(String canonicalName) {
            this.myCanonicalName = canonicalName;
        }

        @NotNull
        public String getName() {
            String string = QuickFixBundle.message((String)"create.field.from.usage.text", (Object[])new Object[]{this.myCanonicalName});
            if (string == null) {
                CreateFieldFromUsageQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = QuickFixBundle.message((String)"create.field.from.usage.family", (Object[])new Object[0]);
            if (string == null) {
                CreateFieldFromUsageQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                CreateFieldFromUsageQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                CreateFieldFromUsageQuickFix.$$$reportNull$$$0(3);
            }
            PsiElement psiElement = descriptor.getPsiElement();
            XmlAttributeValue attrValue = (XmlAttributeValue)PsiTreeUtil.getParentOfType((PsiElement)psiElement, XmlAttributeValue.class, (boolean)false);
            assert (attrValue != null);
            JavaFxFieldIdReferenceProvider.JavaFxControllerFieldRef reference = (JavaFxFieldIdReferenceProvider.JavaFxControllerFieldRef)attrValue.getReference();
            assert (reference != null);
            PsiClass targetClass = reference.getAClass();
            if (!FileModificationService.getInstance().prepareFileForWrite(targetClass.getContainingFile())) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            PsiField field = factory.createField(reference.getCanonicalText(), (PsiType)PsiType.INT);
            PsiModifierList modifierList = field.getModifierList();
            if (modifierList != null) {
                String visibility = ((JavaCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)targetClass.getProject()).getCustomSettings(JavaCodeStyleSettings.class)).VISIBILITY;
                if ("EscalateVisible".equals(visibility)) {
                    visibility = "private";
                }
                VisibilityUtil.setVisibility((PsiModifierList)modifierList, (String)visibility);
                if (!"public".equals(visibility)) {
                    modifierList.addAnnotation("javafx.fxml.FXML");
                }
            }
            field = CreateFieldFromUsageHelper.insertField((PsiClass)targetClass, (PsiField)field, (PsiElement)psiElement);
            PsiClassType fieldType = factory.createType(JavaFxUnresolvedFxIdReferenceInspection.checkContext(reference.getXmlAttributeValue()));
            ExpectedTypeInfo[] types = new ExpectedTypeInfo[]{new ExpectedTypeInfoImpl((PsiType)fieldType, 1, (PsiType)fieldType, TailType.NONE, null, ExpectedTypeInfoImpl.NULL)};
            CreateFieldFromUsageFix.createFieldFromUsageTemplate((PsiClass)targetClass, (Project)project, (Object)types, (PsiField)field, (boolean)false, (PsiElement)psiElement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxUnresolvedFxIdReferenceInspection$CreateFieldFromUsageQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxUnresolvedFxIdReferenceInspection$CreateFieldFromUsageQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

