/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.refs;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.XmlTagInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.XmlPatterns;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.xml.TagNameVariantCollector;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ProcessingContext;
import com.intellij.xml.XmlElementDescriptor;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxClassTagDescriptorBase;
import org.jetbrains.plugins.javaFX.fxml.refs.JavaFxTagNameReference;

public class JavaFxCompletionContributor
extends CompletionContributor {
    public JavaFxCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().inside((ElementPattern)XmlPatterns.xmlTag()), new JavaFxTagCompletionContributor());
    }

    private static class JavaFxTagInsertHandler
    extends XmlTagInsertHandler {
        public static final JavaFxTagInsertHandler INSTANCE = new JavaFxTagInsertHandler();

        private JavaFxTagInsertHandler() {
        }

        public void handleInsert(InsertionContext context, LookupElement item) {
            super.handleInsert(context, item);
            Object object = item.getObject();
            if (object instanceof JavaFxClassTagDescriptorBase) {
                XmlFile xmlFile = (XmlFile)context.getFile();
                String shortName = ((JavaFxClassTagDescriptorBase)object).getName();
                context.commitDocument();
                JavaFxPsiUtil.insertImportWhenNeeded(xmlFile, shortName, ((JavaFxClassTagDescriptorBase)object).getQualifiedName());
            }
        }
    }

    private static class JavaFxTagCompletionContributor
    extends CompletionProvider<CompletionParameters> {
        private JavaFxTagCompletionContributor() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
            PsiReference reference;
            if (parameters == null) {
                JavaFxTagCompletionContributor.$$$reportNull$$$0(0);
            }
            if (result == null) {
                JavaFxTagCompletionContributor.$$$reportNull$$$0(1);
            }
            if ((reference = parameters.getPosition().getContainingFile().findReferenceAt(parameters.getOffset())) instanceof JavaFxTagNameReference) {
                JavaFxTagCompletionContributor.addJavaFxTagVariants((JavaFxTagNameReference)reference, result);
                result.stopHere();
            }
        }

        private static void addJavaFxTagVariants(JavaFxTagNameReference reference, CompletionResultSet result) {
            XmlTag xmlTag = (XmlTag)reference.getElement();
            List<String> namespaces = Arrays.asList(xmlTag.knownNamespaces());
            List variants = TagNameVariantCollector.getTagDescriptors((XmlTag)xmlTag, namespaces, null);
            for (XmlElementDescriptor descriptor : variants) {
                String descriptorName = descriptor.getName(reference.getElement());
                if (descriptorName == null) continue;
                LookupElementBuilder lookupElement = LookupElementBuilder.create((Object)descriptor, (String)descriptorName);
                result.addElement((LookupElement)lookupElement.withInsertHandler((InsertHandler)JavaFxTagInsertHandler.INSTANCE));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxCompletionContributor$JavaFxTagCompletionContributor";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

