/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.radComponents;

import com.intellij.uiDesigner.ModuleProvider;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.XmlWriter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.designSurface.ComponentDragObject;
import com.intellij.uiDesigner.designSurface.ComponentDropLocation;
import com.intellij.uiDesigner.designSurface.EventProcessor;
import com.intellij.uiDesigner.designSurface.FeedbackLayer;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.palette.Palette;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadComponentFactory;
import com.intellij.uiDesigner.radComponents.RadContainer;
import com.intellij.uiDesigner.radComponents.RadLayoutManager;
import com.intellij.uiDesigner.snapShooter.SnapshotContext;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RadSplitPane
extends RadContainer {
    public RadSplitPane(ModuleProvider module, Class componentClass, String id) {
        super(module, componentClass, id);
    }

    public RadSplitPane(Class componentClass, @NotNull String id, Palette palette) {
        if (id == null) {
            RadSplitPane.$$$reportNull$$$0(0);
        }
        super(componentClass, id, palette);
    }

    @Override
    protected RadLayoutManager createInitialLayoutManager() {
        return new RadSplitPaneLayoutManager();
    }

    private static boolean isEmptySplitComponent(Component component) {
        return component == null || ((JComponent)component).getClientProperty("radComponent") == null;
    }

    private boolean isLeft(Point pnt) {
        if (this.getSplitPane().getOrientation() == 0) {
            return pnt.y < this.getDividerPos();
        }
        return pnt.x < this.getDividerPos();
    }

    private int getDividerPos() {
        int size;
        JSplitPane splitPane = this.getSplitPane();
        int n = size = splitPane.getOrientation() == 0 ? splitPane.getHeight() : splitPane.getWidth();
        if (splitPane.getDividerLocation() > splitPane.getDividerSize() && splitPane.getDividerLocation() < size - splitPane.getDividerSize()) {
            return splitPane.getDividerLocation() + splitPane.getDividerSize() / 2;
        }
        return size / 2;
    }

    private JSplitPane getSplitPane() {
        return (JSplitPane)this.getDelegee();
    }

    @Override
    @Nullable
    public EventProcessor getEventProcessor(MouseEvent event) {
        int pos;
        JSplitPane splitPane = this.getSplitPane();
        Point pnt = SwingUtilities.convertPoint(event.getComponent(), event.getPoint(), splitPane);
        int n = pos = splitPane.getOrientation() == 0 ? pnt.y : pnt.x;
        if (event.getID() == 501 && pos >= splitPane.getDividerLocation() && pos < splitPane.getDividerLocation() + splitPane.getDividerSize()) {
            return new DividerDragProcessor();
        }
        return null;
    }

    @Override
    public void write(XmlWriter writer) {
        writer.startElement("splitpane");
        try {
            this.writeId(writer);
            this.writeClassIfDifferent(writer, JSplitPane.class.getName());
            this.writeBinding(writer);
            this.writeConstraints(writer);
            this.writeProperties(writer);
            this.writeBorder(writer);
            this.writeChildren(writer);
        }
        finally {
            writer.endElement();
        }
    }

    @Override
    protected void importSnapshotComponent(SnapshotContext context, JComponent component) {
        JSplitPane splitPane = (JSplitPane)component;
        this.importSideComponent(splitPane.getLeftComponent(), context, "left");
        this.importSideComponent(splitPane.getRightComponent(), context, "right");
    }

    private void importSideComponent(Component sideComponent, SnapshotContext context, String position) {
        RadComponent radSideComponent;
        if (sideComponent instanceof JComponent && (radSideComponent = RadSplitPane.createSnapshotComponent(context, (JComponent)sideComponent)) != null) {
            radSideComponent.setCustomLayoutConstraints(position);
            this.addComponent(radSideComponent);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/uiDesigner/radComponents/RadSplitPane", "<init>"));
    }

    private class DividerDragProcessor
    extends EventProcessor {
        private DividerDragProcessor() {
        }

        @Override
        protected void processKeyEvent(KeyEvent e) {
        }

        @Override
        protected void processMouseEvent(MouseEvent event) {
            JSplitPane splitPane = RadSplitPane.this.getSplitPane();
            Point pnt = SwingUtilities.convertPoint(event.getComponent(), event.getPoint(), splitPane);
            splitPane.dispatchEvent(new MouseEvent(splitPane, event.getID(), event.getWhen(), event.getModifiers(), pnt.x, pnt.y, event.getClickCount(), event.isPopupTrigger(), event.getButton()));
        }

        @Override
        public boolean needMousePressed() {
            return true;
        }

        @Override
        protected boolean cancelOperation() {
            return false;
        }
    }

    private class MyDropLocation
    implements ComponentDropLocation {
        private final boolean myLeft;

        public MyDropLocation(boolean left) {
            this.myLeft = left;
        }

        @Override
        public RadContainer getContainer() {
            return RadSplitPane.this;
        }

        @Override
        public boolean canDrop(ComponentDragObject dragObject) {
            return dragObject.getComponentCount() == 1 && RadSplitPane.isEmptySplitComponent(this.myLeft ? RadSplitPane.this.getSplitPane().getLeftComponent() : RadSplitPane.this.getSplitPane().getRightComponent());
        }

        @Override
        public void placeFeedback(FeedbackLayer feedbackLayer, ComponentDragObject dragObject) {
            JSplitPane splitPane = RadSplitPane.this.getSplitPane();
            int dividerPos = RadSplitPane.this.getDividerPos();
            int dividerStartPos = dividerPos - splitPane.getDividerSize() / 2;
            int dividerEndPos = dividerPos + splitPane.getDividerSize() - splitPane.getDividerSize() / 2;
            Rectangle rc = splitPane.getOrientation() == 0 ? (this.myLeft ? new Rectangle(0, 0, RadSplitPane.this.getWidth(), dividerStartPos) : new Rectangle(0, dividerEndPos, RadSplitPane.this.getWidth(), RadSplitPane.this.getHeight() - dividerEndPos)) : (this.myLeft ? new Rectangle(0, 0, dividerStartPos, RadSplitPane.this.getHeight()) : new Rectangle(dividerEndPos, 0, RadSplitPane.this.getWidth() - dividerEndPos, RadSplitPane.this.getHeight()));
            feedbackLayer.putFeedback(RadSplitPane.this.getDelegee(), rc, this.getInsertFeedbackTooltip());
        }

        private String getInsertFeedbackTooltip() {
            String pos = RadSplitPane.this.getSplitPane().getOrientation() == 0 ? (this.myLeft ? UIDesignerBundle.message("insert.feedback.top", new Object[0]) : UIDesignerBundle.message("insert.feedback.bottom", new Object[0])) : (this.myLeft ? UIDesignerBundle.message("insert.feedback.left", new Object[0]) : UIDesignerBundle.message("insert.feedback.right", new Object[0]));
            return RadSplitPane.this.getDisplayName() + " (" + pos + ")";
        }

        @Override
        public void processDrop(GuiEditor editor, RadComponent[] components, GridConstraints[] constraintsToAdjust, ComponentDragObject dragObject) {
            components[0].setCustomLayoutConstraints(this.myLeft ? "left" : "right");
            RadSplitPane.this.addComponent(components[0]);
        }

        @Override
        @Nullable
        public ComponentDropLocation getAdjacentLocation(ComponentDropLocation.Direction direction) {
            return null;
        }
    }

    private class RadSplitPaneLayoutManager
    extends RadLayoutManager {
        private RadSplitPaneLayoutManager() {
        }

        @Override
        @Nullable
        public String getName() {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeChildConstraints(XmlWriter writer, RadComponent child) {
            writer.startElement("splitpane");
            try {
                String position = (String)child.getCustomLayoutConstraints();
                if (!"left".equals(position) && !"right".equals(position)) {
                    throw new IllegalStateException("invalid position: " + position);
                }
                writer.addAttribute("position", position);
            }
            finally {
                writer.endElement();
            }
        }

        @Override
        public void addComponentToContainer(RadContainer container, RadComponent component, int index) {
            JSplitPane splitPane = (JSplitPane)container.getDelegee();
            JComponent delegee = component.getDelegee();
            if ("left".equals(component.getCustomLayoutConstraints())) {
                splitPane.setLeftComponent(delegee);
            } else if ("right".equals(component.getCustomLayoutConstraints())) {
                splitPane.setRightComponent(delegee);
            } else {
                throw new IllegalStateException("invalid layout constraints on component added to RadSplitPane");
            }
        }

        @Override
        @NotNull
        public ComponentDropLocation getDropLocation(RadContainer container, @Nullable Point location) {
            if (location == null) {
                MyDropLocation myDropLocation = new MyDropLocation(RadSplitPane.isEmptySplitComponent(RadSplitPane.this.getSplitPane().getLeftComponent()));
                if (myDropLocation == null) {
                    RadSplitPaneLayoutManager.$$$reportNull$$$0(0);
                }
                return myDropLocation;
            }
            MyDropLocation myDropLocation = new MyDropLocation(RadSplitPane.this.isLeft(location));
            if (myDropLocation == null) {
                RadSplitPaneLayoutManager.$$$reportNull$$$0(1);
            }
            return myDropLocation;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/radComponents/RadSplitPane$RadSplitPaneLayoutManager", "getDropLocation"));
        }
    }

    public static class Factory
    extends RadComponentFactory {
        @Override
        public RadComponent newInstance(ModuleProvider module, Class aClass, String id) {
            return new RadSplitPane(module, aClass, id);
        }

        @Override
        public RadComponent newInstance(Class componentClass, String id, Palette palette) {
            return new RadSplitPane(componentClass, id, palette);
        }
    }
}

