/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.flex;

import com.intellij.flex.CommandLineArgumentsTokenizer;
import com.intellij.flex.SourcePathResolver;
import flash.localization.ILocalizer;
import flash.localization.LocalizationManager;
import flash.localization.ResourceBundleLocalizer;
import flash.swf.Movie;
import flex2.compiler.Compiler;
import flex2.compiler.CompilerException;
import flex2.compiler.CompilerSwcContext;
import flex2.compiler.FileSpec;
import flex2.compiler.ILocalizableMessage;
import flex2.compiler.LicenseException;
import flex2.compiler.ResourceBundlePath;
import flex2.compiler.ResourceContainer;
import flex2.compiler.SourceList;
import flex2.compiler.SourcePath;
import flex2.compiler.SymbolTable;
import flex2.compiler.Transcoder;
import flex2.compiler.common.CompilerConfiguration;
import flex2.compiler.common.Configuration;
import flex2.compiler.common.DefaultsConfigurator;
import flex2.compiler.common.SinglePathResolver;
import flex2.compiler.config.ConfigurationBuffer;
import flex2.compiler.config.ConfigurationException;
import flex2.compiler.i18n.I18nUtils;
import flex2.compiler.io.FileUtil;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.swc.SwcCache;
import flex2.compiler.swc.SwcException;
import flex2.compiler.util.Benchmark;
import flex2.compiler.util.NameMappings;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.linker.API;
import flex2.linker.ConsoleApplication;
import flex2.linker.LinkerException;
import flex2.linker.PostLink;
import flex2.tools.CommandLineConfiguration;
import flex2.tools.Compc;
import flex2.tools.CompcConfiguration;
import flex2.tools.CompcPreLink;
import flex2.tools.Compiler;
import flex2.tools.PreLink;
import flex2.tools.SimpleShell;
import flex2.tools.SwcTarget;
import flex2.tools.Target;
import flex2.tools.Tool;
import flex2.tools.VersionInfo;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import macromedia.asc.util.ContextStatics;

public class SimpleShellWithFix
extends Tool {
    private static int counter;
    private static boolean exit;
    private static Map targets;
    private static Map processes;

    public static void main(String[] args) throws IOException {
        String s;
        exit = false;
        counter = 1;
        targets = new HashMap();
        processes = new HashMap();
        BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
        flex2.compiler.API.useAS3();
        LocalizationManager localizationManager = new LocalizationManager();
        localizationManager.addLocalizer((ILocalizer)new ResourceBundleLocalizer());
        ThreadLocalToolkit.setLocalizationManager((LocalizationManager)localizationManager);
        SimpleShellWithFix.intro();
        SimpleShellWithFix.prompt();
        while ((s = r.readLine()) != null) {
            flex2.compiler.API.useConsoleLogger();
            if (s.trim().length() == 0) {
                SimpleShellWithFix.prompt();
                continue;
            }
            SimpleShellWithFix.process(s);
            if (exit) break;
            SimpleShellWithFix.prompt();
        }
    }

    private static void process(String s) {
        block56: {
            LocalizationManager l10n = ThreadLocalToolkit.getLocalizationManager();
            if (s.startsWith("mxmlc")) {
                CommandLineArgumentsTokenizer t = new CommandLineArgumentsTokenizer(s.substring("mxmlc".length()).trim(), " ");
                String[] args = new String[((StringTokenizer)t).countTokens()];
                int i = 0;
                while (((StringTokenizer)t).hasMoreTokens()) {
                    args[i] = ((StringTokenizer)t).nextToken();
                    ++i;
                }
                if (args.length == 1) {
                    try {
                        int id = Integer.parseInt(args[0]);
                        Target target = (Target)targets.get("" + id);
                        if (target == null) {
                            ThreadLocalToolkit.logInfo((String)l10n.getLocalizedTextString((Object)new SimpleShell.TargetNotFound("" + id)));
                            break block56;
                        }
                        SimpleShellWithFix.mxmlc(target.args, id);
                    }
                    catch (NumberFormatException ex) {
                        ThreadLocalToolkit.logInfo((String)l10n.getLocalizedTextString((Object)new SimpleShell.AssignTargetID(counter)));
                        SimpleShellWithFix.mxmlc(args, counter++);
                    }
                } else {
                    ThreadLocalToolkit.logInfo((String)l10n.getLocalizedTextString((Object)new SimpleShell.AssignTargetID(counter)));
                    SimpleShellWithFix.mxmlc(args, counter++);
                }
            } else if (s.startsWith("compc")) {
                CommandLineArgumentsTokenizer t = new CommandLineArgumentsTokenizer(s.substring("compc".length()).trim(), " ");
                String[] args = new String[((StringTokenizer)t).countTokens()];
                int i = 0;
                while (((StringTokenizer)t).hasMoreTokens()) {
                    args[i] = ((StringTokenizer)t).nextToken();
                    ++i;
                }
                if (args.length == 1) {
                    try {
                        int id = Integer.parseInt(args[0]);
                        Target target = (Target)targets.get("" + id);
                        if (target == null) {
                            ThreadLocalToolkit.logInfo((String)l10n.getLocalizedTextString((Object)new SimpleShell.TargetNotFound("" + id)));
                            break block56;
                        }
                        SimpleShellWithFix.compc(target.args, id);
                    }
                    catch (NumberFormatException ex) {
                        ThreadLocalToolkit.logInfo((String)l10n.getLocalizedTextString((Object)new SimpleShell.AssignTargetID(counter)));
                        SimpleShellWithFix.compc(args, counter++);
                    }
                } else {
                    ThreadLocalToolkit.logInfo((String)l10n.getLocalizedTextString((Object)new SimpleShell.AssignTargetID(counter)));
                    SimpleShellWithFix.compc(args, counter++);
                }
            } else if (s.startsWith("compile")) {
                String id = s.substring("compile".length()).trim();
                if (targets.containsKey(id)) {
                    SimpleShellWithFix.compile(id);
                    if (ThreadLocalToolkit.errorCount() == 0) {
                        SimpleShellWithFix.link(id, true);
                    }
                } else {
                    ThreadLocalToolkit.logInfo((String)l10n.getLocalizedTextString((Object)new SimpleShell.TargetNotFound(id)));
                }
            } else if (s.startsWith("clear")) {
                String id = s.substring("clear".length()).trim();
                if (id.length() == 0) {
                    HashSet keys = new HashSet(targets.keySet());
                    Iterator i = keys.iterator();
                    while (i.hasNext()) {
                        SimpleShellWithFix.clear((String)i.next());
                    }
                } else if (targets.containsKey(id)) {
                    SimpleShellWithFix.clear(id);
                } else {
                    ThreadLocalToolkit.logInfo((String)l10n.getLocalizedTextString((Object)new SimpleShell.TargetNotFound(id)));
                }
            } else if (s.startsWith("info")) {
                String id = s.substring("info".length()).trim();
                if (id.length() == 0) {
                    HashSet keys = new HashSet(targets.keySet());
                    Iterator i = keys.iterator();
                    while (i.hasNext()) {
                        SimpleShellWithFix.info((String)i.next());
                    }
                } else if (targets.containsKey(id)) {
                    SimpleShellWithFix.info(id);
                } else {
                    ThreadLocalToolkit.logInfo((String)l10n.getLocalizedTextString((Object)new SimpleShell.TargetNotFound(id)));
                }
            } else if (s.startsWith("touch")) {
                String args = s.substring("touch".length()).trim();
                CommandLineArgumentsTokenizer stok = new CommandLineArgumentsTokenizer(args);
                while (((StringTokenizer)stok).hasMoreTokens()) {
                    String f = ((StringTokenizer)stok).nextToken();
                    if (!new File(f).canWrite()) {
                        ThreadLocalToolkit.logInfo((String)("touch: cannot write " + f));
                        continue;
                    }
                    new File(f).setLastModified(System.currentTimeMillis());
                }
            } else if (s.startsWith("cp")) {
                String args = s.substring("cp".length()).trim();
                CommandLineArgumentsTokenizer stok = new CommandLineArgumentsTokenizer(args);
                if (((StringTokenizer)stok).countTokens() != 2) {
                    ThreadLocalToolkit.logInfo((String)"cp fileFrom fileTo");
                } else {
                    String copyFrom = ((StringTokenizer)stok).nextToken();
                    String copyTo = ((StringTokenizer)stok).nextToken();
                    try {
                        FileUtil.writeBinaryFile((File)new File(copyTo), (InputStream)FileUtil.openStream((String)copyFrom));
                    }
                    catch (IOException e) {
                        ThreadLocalToolkit.logInfo((String)e.getMessage());
                    }
                }
            } else if (s.startsWith("mv")) {
                String args = s.substring("mv".length()).trim();
                CommandLineArgumentsTokenizer stok = new CommandLineArgumentsTokenizer(args);
                if (((StringTokenizer)stok).countTokens() != 2) {
                    ThreadLocalToolkit.logInfo((String)"mv fileFrom fileTo");
                } else {
                    String moveFrom = ((StringTokenizer)stok).nextToken();
                    String moveTo = ((StringTokenizer)stok).nextToken();
                    new File(moveFrom).renameTo(new File(moveTo));
                }
            } else if (s.startsWith("rm")) {
                String args = s.substring("rm".length()).trim();
                CommandLineArgumentsTokenizer stok = new CommandLineArgumentsTokenizer(args);
                if (((StringTokenizer)stok).countTokens() != 1) {
                    ThreadLocalToolkit.logInfo((String)"rm file");
                } else {
                    String rmFile = ((StringTokenizer)stok).nextToken();
                    new File(rmFile).delete();
                }
            } else if (s.equals("quit")) {
                HashSet names = new HashSet(targets.keySet());
                Iterator i = names.iterator();
                while (i.hasNext()) {
                    SimpleShellWithFix.process("clear " + (String)i.next());
                }
                exit = true;
            } else {
                SimpleShellWithFix.cmdList();
            }
        }
    }

    private static void clear(String target) {
        Process p = (Process)processes.remove(target);
        if (p != null) {
            p.destroy();
        }
        targets.remove(target);
    }

    private static void info(String target) {
        Target s = (Target)targets.get(target);
        ThreadLocalToolkit.logInfo((String)("id: " + s.id));
        StringBuffer b = new StringBuffer();
        int size = s.args.length;
        for (int i = 0; i < size; ++i) {
            b.append(s.args[i]);
            b.append(' ');
        }
        ThreadLocalToolkit.logInfo((String)((s instanceof SwcTarget ? "compc: " : "mxmlc: ") + b));
    }

    private static void compile(String id) {
        Target s = (Target)targets.get(id);
        if (s instanceof SwcTarget) {
            SimpleShellWithFix.compile_compc((SwcTarget)s);
        } else {
            SimpleShellWithFix.compile_mxmlc(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void compile_compc(SwcTarget s) {
        LocalizationManager l10n = ThreadLocalToolkit.getLocalizationManager();
        try {
            flex2.compiler.API.usePathResolver();
            ConfigurationBuffer cfgbuf = new ConfigurationBuffer(CompcConfiguration.class, CompcConfiguration.getAliases());
            cfgbuf.setDefaultVar("include-classes");
            DefaultsConfigurator.loadCompcDefaults((ConfigurationBuffer)cfgbuf);
            CompcConfiguration configuration = (CompcConfiguration)flex2.tools.Compiler.processConfiguration((LocalizationManager)ThreadLocalToolkit.getLocalizationManager(), (String)"compc", (String[])s.args, (ConfigurationBuffer)cfgbuf, CompcConfiguration.class, (String)"include-classes");
            flex2.compiler.API.setupHeadless((Configuration)configuration);
            if (configuration.benchmark()) {
                flex2.compiler.API.runBenchmark();
            } else {
                flex2.compiler.API.disableBenchmark();
            }
            s.sourcePath.clearCache();
            s.bundlePath.clearCache();
            s.resources.refresh();
            CompilerConfiguration compilerConfig = configuration.getCompilerConfiguration();
            compilerConfig.setMetadataExport(true);
            NameMappings mappings = flex2.compiler.API.getNameMappings((Configuration)configuration);
            Transcoder[] transcoders = flex2.tools.API.getTranscoders((Configuration)configuration);
            Compiler[] compilers = flex2.tools.API.getCompilers((CompilerConfiguration)compilerConfig, (NameMappings)mappings, (Transcoder[])transcoders);
            if (ThreadLocalToolkit.getBenchmark() != null) {
                ThreadLocalToolkit.getBenchmark().benchmark(l10n.getLocalizedTextString((Object)new Compiler.InitialSetup()));
            }
            CompilerSwcContext swcContext = new CompilerSwcContext(false, true, configuration.getCompatibilityVersionString());
            swcContext.load(compilerConfig.getLibraryPath(), compilerConfig.getExternalLibraryPath(), null, null, mappings, I18nUtils.getTranslationFormat((CompilerConfiguration)compilerConfig), s.swcCache);
            configuration.addExterns((Collection)swcContext.getExterns());
            if (ThreadLocalToolkit.getBenchmark() != null) {
                ThreadLocalToolkit.getBenchmark().benchmark(l10n.getLocalizedTextString((Object)new Compiler.LoadedSWCs(swcContext.getNumberLoaded())));
            }
            boolean recompile = false;
            int newChecksum = cfgbuf.checksum_ts() + swcContext.checksum();
            if (newChecksum != s.checksum) {
                ThreadLocalToolkit.logInfo((String)l10n.getLocalizedTextString((Object)new SimpleShell.DetectConfigurationChange()));
                s.checksum = newChecksum;
                s.resources = new ResourceContainer();
                recompile = true;
            }
            if (flex2.compiler.API.validateCompilationUnits((FileSpec)s.fileSpec, (SourceList)s.sourceList, (SourcePath)s.sourcePath, (ResourceBundlePath)s.bundlePath, (ResourceContainer)s.resources, (CompilerSwcContext)swcContext, (ContextStatics)s.perCompileData, (boolean)recompile, (Configuration)configuration) > 0) {
                List units;
                Map licenseMap = configuration.getLicensesConfiguration().getLicenseMap();
                SymbolTable symbolTable = new SymbolTable(s.perCompileData);
                s.configuration = configuration;
                HashMap classes = new HashMap();
                s.nsComponents = flex2.compiler.swc.API.setupNamespaceComponents((CompcConfiguration)configuration, (NameMappings)mappings, (SourcePath)s.sourcePath, classes);
                flex2.compiler.swc.API.setupClasses((CompcConfiguration)configuration, (SourcePath)s.sourcePath, classes);
                HashMap rbFiles = new HashMap();
                ThreadLocalToolkit.getPathResolver().addSinglePathResolver((SinglePathResolver)new SourcePathResolver(s.sourcePath));
                s.units = units = flex2.compiler.API.compile((FileSpec)s.fileSpec, (SourceList)s.sourceList, classes.values(), (SourcePath)s.sourcePath, (ResourceContainer)s.resources, (ResourceBundlePath)s.bundlePath, (CompilerSwcContext)swcContext, (SymbolTable)symbolTable, (Configuration)configuration, (Compiler[])compilers, (flex2.compiler.PreLink)new CompcPreLink(rbFiles, configuration.getIncludeResourceBundles()), (Map)licenseMap, new ArrayList());
                s.rbFiles = rbFiles;
                s.sourcePath.clearCache();
                s.bundlePath.clearCache();
                s.resources.refresh();
                s.classes = classes.keySet();
            } else {
                ThreadLocalToolkit.logInfo((String)l10n.getLocalizedTextString((Object)new SimpleShell.NoChange()));
            }
        }
        catch (ConfigurationException ex) {
            Compc.displayStartMessage();
            flex2.tools.Compiler.processConfigurationException((ConfigurationException)ex, (String)"compc");
        }
        catch (LicenseException ex) {
            ThreadLocalToolkit.logError((String)ex.getMessage());
        }
        catch (CompilerException ex) {
            assert (ThreadLocalToolkit.errorCount() > 0);
        }
        catch (SwcException ex) {
            assert (ThreadLocalToolkit.errorCount() > 0);
        }
        catch (IOException t) {
            ThreadLocalToolkit.logError((String)t.getMessage());
            t.printStackTrace();
        }
        finally {
            Benchmark benchmark = ThreadLocalToolkit.getBenchmark();
            if (benchmark != null) {
                benchmark.totalTime();
                benchmark.peakMemoryUsage(true);
            }
            flex2.compiler.API.removePathResolver();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void compile_mxmlc(Target s) {
        LocalizationManager l10n = ThreadLocalToolkit.getLocalizationManager();
        try {
            flex2.compiler.API.usePathResolver();
            ConfigurationBuffer cfgbuf = new ConfigurationBuffer(CommandLineConfiguration.class, Configuration.getAliases());
            cfgbuf.setDefaultVar("file-specs");
            DefaultsConfigurator.loadDefaults((ConfigurationBuffer)cfgbuf);
            CommandLineConfiguration configuration = (CommandLineConfiguration)flex2.tools.Compiler.processConfiguration((LocalizationManager)ThreadLocalToolkit.getLocalizationManager(), (String)"mxmlc", (String[])s.args, (ConfigurationBuffer)cfgbuf, CommandLineConfiguration.class, (String)"file-specs");
            flex2.compiler.API.setupHeadless((Configuration)configuration);
            if (configuration.benchmark()) {
                flex2.compiler.API.runBenchmark();
            } else {
                flex2.compiler.API.disableBenchmark();
            }
            s.sourcePath.clearCache();
            s.bundlePath.clearCache();
            s.resources.refresh();
            CompilerConfiguration compilerConfig = configuration.getCompilerConfiguration();
            NameMappings mappings = flex2.compiler.API.getNameMappings((Configuration)configuration);
            Transcoder[] transcoders = flex2.tools.API.getTranscoders((Configuration)configuration);
            Compiler[] compilers = flex2.tools.API.getCompilers((CompilerConfiguration)compilerConfig, (NameMappings)mappings, (Transcoder[])transcoders);
            if (ThreadLocalToolkit.getBenchmark() != null) {
                ThreadLocalToolkit.getBenchmark().benchmark(l10n.getLocalizedTextString((Object)new Compiler.InitialSetup()));
            }
            CompilerSwcContext swcContext = new CompilerSwcContext(false, true, configuration.getCompatibilityVersionString());
            swcContext.load(compilerConfig.getLibraryPath(), Configuration.getAllExcludedLibraries((CompilerConfiguration)compilerConfig, (Configuration)configuration), compilerConfig.getThemeFiles(), compilerConfig.getIncludeLibraries(), mappings, I18nUtils.getTranslationFormat((CompilerConfiguration)compilerConfig), s.swcCache);
            configuration.addExterns((Collection)swcContext.getExterns());
            configuration.addIncludes((Collection)swcContext.getIncludes());
            configuration.getCompilerConfiguration().addDefaultsCssFiles(swcContext.getDefaultsStyleSheets());
            configuration.getCompilerConfiguration().addThemeCssFiles(swcContext.getThemeStyleSheets());
            if (ThreadLocalToolkit.getBenchmark() != null) {
                ThreadLocalToolkit.getBenchmark().benchmark(l10n.getLocalizedTextString((Object)new Compiler.LoadedSWCs(swcContext.getNumberLoaded())));
            }
            boolean recompile = false;
            int newChecksum = cfgbuf.checksum_ts() + swcContext.checksum();
            if (newChecksum != s.checksum) {
                ThreadLocalToolkit.logInfo((String)l10n.getLocalizedTextString((Object)new SimpleShell.DetectConfigurationChange()));
                s.checksum = newChecksum;
                s.resources = new ResourceContainer();
                recompile = true;
            }
            if (flex2.compiler.API.validateCompilationUnits((FileSpec)s.fileSpec, (SourceList)s.sourceList, (SourcePath)s.sourcePath, (ResourceBundlePath)s.bundlePath, (ResourceContainer)s.resources, (CompilerSwcContext)swcContext, (ContextStatics)s.perCompileData, (boolean)recompile, (Configuration)configuration) > 0) {
                Map licenseMap = configuration.getLicensesConfiguration().getLicenseMap();
                SymbolTable symbolTable = new SymbolTable(s.perCompileData);
                s.configuration = configuration;
                VirtualFile projector = configuration.getProjector();
                if (projector != null && projector.getName().endsWith("avmplus.exe")) {
                    List units;
                    ThreadLocalToolkit.getPathResolver().addSinglePathResolver((SinglePathResolver)new SourcePathResolver(s.sourcePath));
                    s.units = units = flex2.compiler.API.compile((FileSpec)s.fileSpec, (SourceList)s.sourceList, null, (SourcePath)s.sourcePath, (ResourceContainer)s.resources, (ResourceBundlePath)s.bundlePath, (CompilerSwcContext)swcContext, (SymbolTable)symbolTable, (Configuration)configuration, (Compiler[])compilers, null, (Map)licenseMap, new ArrayList());
                } else {
                    List units;
                    ThreadLocalToolkit.getPathResolver().addSinglePathResolver((SinglePathResolver)new SourcePathResolver(s.sourcePath));
                    s.units = units = flex2.compiler.API.compile((FileSpec)s.fileSpec, (SourceList)s.sourceList, null, (SourcePath)s.sourcePath, (ResourceContainer)s.resources, (ResourceBundlePath)s.bundlePath, (CompilerSwcContext)swcContext, (SymbolTable)symbolTable, (Configuration)configuration, (Compiler[])compilers, (flex2.compiler.PreLink)new PreLink(), (Map)licenseMap, new ArrayList());
                }
                s.sourcePath.clearCache();
                s.bundlePath.clearCache();
                s.resources.refresh();
            } else {
                ThreadLocalToolkit.logInfo((String)l10n.getLocalizedTextString((Object)new SimpleShell.NoChange()));
            }
        }
        catch (ConfigurationException ex) {
            flex2.tools.Compiler.processConfigurationException((ConfigurationException)ex, (String)"mxmlc");
        }
        catch (LicenseException ex) {
            ThreadLocalToolkit.logError((String)ex.getMessage());
        }
        catch (CompilerException ex) {
            assert (ThreadLocalToolkit.errorCount() > 0);
        }
        catch (SwcException ex) {
            assert (ThreadLocalToolkit.errorCount() > 0);
        }
        catch (IOException t) {
            ThreadLocalToolkit.logError((String)t.getMessage());
            t.printStackTrace();
        }
        finally {
            Benchmark benchmark = ThreadLocalToolkit.getBenchmark();
            if (benchmark != null) {
                benchmark.totalTime();
                benchmark.peakMemoryUsage(true);
            }
            flex2.compiler.API.removePathResolver();
        }
    }

    private static void link(String target, boolean optimize) {
        Target s = (Target)targets.get(target);
        if (s instanceof SwcTarget) {
            SimpleShellWithFix.link_compc((SwcTarget)s);
        } else {
            SimpleShellWithFix.link_mxmlc(s, optimize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void link_compc(SwcTarget s) {
        try {
            ThreadLocalToolkit.resetBenchmark();
            flex2.compiler.API.usePathResolver();
            if (s.units != null) {
                flex2.compiler.swc.API.exportSwc((CompcConfiguration)((CompcConfiguration)s.configuration), (List)s.units, (List)s.nsComponents, (SwcCache)s.swcCache, (Map)s.rbFiles);
                if (s.outputName != null && ThreadLocalToolkit.errorCount() == 0) {
                    File file = new File(s.outputName);
                    s.outputName = FileUtil.getCanonicalPath((File)file);
                    ThreadLocalToolkit.log((ILocalizableMessage)new Compiler.OutputMessage(s.outputName, Long.toString(file.length())));
                }
            }
        }
        catch (LinkerException ex) {
            assert (ThreadLocalToolkit.errorCount() > 0);
        }
        catch (Exception t) {
            ThreadLocalToolkit.logError((String)t.getMessage());
            t.printStackTrace();
        }
        finally {
            Benchmark benchmark = ThreadLocalToolkit.getBenchmark();
            if (benchmark != null) {
                benchmark.totalTime();
                benchmark.peakMemoryUsage(true);
            }
            flex2.compiler.API.removePathResolver();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void link_mxmlc(Target s, boolean optimize) {
        OutputStream swfOut = null;
        try {
            ThreadLocalToolkit.resetBenchmark();
            if (s.units != null) {
                VirtualFile projector = ((CommandLineConfiguration)s.configuration).getProjector();
                if (projector != null && projector.getName().endsWith("avmplus.exe")) {
                    s.app = API.linkConsole((List)s.units, (PostLink)(optimize ? new flex2.tools.PostLink((flex2.linker.Configuration)s.configuration) : null), (Configuration)s.configuration);
                    File file = FileUtil.openFile((String)s.outputName, (boolean)true);
                    swfOut = new BufferedOutputStream(new FileOutputStream(file));
                    flex2.tools.Compiler.createProjector((VirtualFile)projector, (ConsoleApplication)s.app, (OutputStream)swfOut);
                    swfOut.flush();
                    swfOut.close();
                    ThreadLocalToolkit.log((ILocalizableMessage)new Compiler.OutputMessage(s.outputName, Long.toString(file.length())));
                } else {
                    s.movie = API.link((List)s.units, (PostLink)(optimize ? new flex2.tools.PostLink((flex2.linker.Configuration)s.configuration) : null), (Configuration)s.configuration);
                    File file = FileUtil.openFile((String)s.outputName, (boolean)true);
                    swfOut = new BufferedOutputStream(new FileOutputStream(file));
                    if (projector != null) {
                        flex2.tools.Compiler.createProjector((VirtualFile)projector, (Movie)s.movie, (OutputStream)swfOut);
                    } else {
                        flex2.compiler.API.encode((Movie)s.movie, (OutputStream)swfOut);
                    }
                    swfOut.flush();
                    swfOut.close();
                    ThreadLocalToolkit.log((ILocalizableMessage)new Compiler.OutputMessage(s.outputName, Long.toString(file.length())));
                }
            }
        }
        catch (LinkerException ex) {
            assert (ThreadLocalToolkit.errorCount() > 0);
        }
        catch (IOException t) {
            ThreadLocalToolkit.logError((String)t.getMessage());
            t.printStackTrace();
        }
        finally {
            Benchmark benchmark = ThreadLocalToolkit.getBenchmark();
            if (benchmark != null) {
                benchmark.totalTime();
                benchmark.peakMemoryUsage(true);
            }
            if (swfOut != null) {
                try {
                    swfOut.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void mxmlc(String[] args, int id) {
        LocalizationManager l10n = ThreadLocalToolkit.getLocalizationManager();
        OutputStream swfOut = null;
        Target s = new Target();
        s.id = id;
        try {
            flex2.compiler.API.usePathResolver();
            ConfigurationBuffer cfgbuf = new ConfigurationBuffer(CommandLineConfiguration.class, Configuration.getAliases());
            cfgbuf.setDefaultVar("file-specs");
            DefaultsConfigurator.loadDefaults((ConfigurationBuffer)cfgbuf);
            CommandLineConfiguration configuration = (CommandLineConfiguration)flex2.tools.Compiler.processConfiguration((LocalizationManager)ThreadLocalToolkit.getLocalizationManager(), (String)"mxmlc", (String[])args, (ConfigurationBuffer)cfgbuf, CommandLineConfiguration.class, (String)"file-specs");
            s.configuration = configuration;
            flex2.compiler.API.setupHeadless((Configuration)configuration);
            if (configuration.benchmark()) {
                flex2.compiler.API.runBenchmark();
            } else {
                flex2.compiler.API.disableBenchmark();
            }
            String target = configuration.getTargetFile();
            targets.put("" + id, s);
            s.args = args;
            VirtualFile targetFile = flex2.compiler.API.getVirtualFile((String)target);
            flex2.tools.API.checkSupportedTargetMimeType((VirtualFile)targetFile);
            List virtualFileList = flex2.compiler.API.getVirtualFileList((List)configuration.getFileList());
            CompilerConfiguration compilerConfig = configuration.getCompilerConfiguration();
            NameMappings mappings = flex2.compiler.API.getNameMappings((Configuration)configuration);
            Transcoder[] transcoders = flex2.tools.API.getTranscoders((Configuration)configuration);
            Compiler[] compilers = flex2.tools.API.getCompilers((CompilerConfiguration)compilerConfig, (NameMappings)mappings, (Transcoder[])transcoders);
            VirtualFile projector = configuration.getProjector();
            if (projector != null && projector.getName().endsWith("avmplus.exe")) {
                s.outputName = configuration.getOutput();
                if (s.outputName == null) {
                    s.outputName = targetFile.getName();
                    s.outputName = s.outputName.substring(0, s.outputName.lastIndexOf(46)) + ".exe";
                }
            } else {
                s.outputName = configuration.getOutput();
                if (s.outputName == null) {
                    s.outputName = targetFile.getName();
                    s.outputName = projector != null ? s.outputName.substring(0, s.outputName.lastIndexOf(46)) + ".exe" : s.outputName.substring(0, s.outputName.lastIndexOf(46)) + ".swf";
                }
            }
            VirtualFile[] asClasspath = compilerConfig.getSourcePath();
            s.fileSpec = new FileSpec(Collections.EMPTY_LIST, flex2.tools.API.getFileSpecMimeTypes());
            s.sourceList = new SourceList(virtualFileList, asClasspath, targetFile, flex2.tools.API.getSourcePathMimeTypes());
            s.sourcePath = new SourcePath(asClasspath, targetFile, flex2.tools.API.getSourcePathMimeTypes(), compilerConfig.allowSourcePathOverlap());
            s.resources = new ResourceContainer();
            s.bundlePath = new ResourceBundlePath(configuration.getCompilerConfiguration(), targetFile);
            if (ThreadLocalToolkit.getBenchmark() != null) {
                ThreadLocalToolkit.getBenchmark().benchmark(l10n.getLocalizedTextString((Object)new Compiler.InitialSetup()));
            }
            s.swcCache = new SwcCache();
            CompilerSwcContext swcContext = new CompilerSwcContext(true, true, configuration.getCompatibilityVersionString());
            swcContext.load(compilerConfig.getLibraryPath(), Configuration.getAllExcludedLibraries((CompilerConfiguration)compilerConfig, (Configuration)configuration), compilerConfig.getThemeFiles(), compilerConfig.getIncludeLibraries(), mappings, I18nUtils.getTranslationFormat((CompilerConfiguration)compilerConfig), s.swcCache);
            configuration.addExterns((Collection)swcContext.getExterns());
            configuration.addIncludes((Collection)swcContext.getIncludes());
            configuration.getCompilerConfiguration().addDefaultsCssFiles(swcContext.getDefaultsStyleSheets());
            configuration.getCompilerConfiguration().addThemeCssFiles(swcContext.getThemeStyleSheets());
            if (ThreadLocalToolkit.getBenchmark() != null) {
                ThreadLocalToolkit.getBenchmark().benchmark(l10n.getLocalizedTextString((Object)new Compiler.LoadedSWCs(swcContext.getNumberLoaded())));
            }
            s.checksum = cfgbuf.checksum_ts() + swcContext.checksum();
            SymbolTable symbolTable = SymbolTable.newSymbolTable((Configuration)configuration);
            s.perCompileData = symbolTable.perCompileData;
            Map licenseMap = configuration.getLicensesConfiguration().getLicenseMap();
            if (projector != null && projector.getName().endsWith("avmplus.exe")) {
                List units;
                ThreadLocalToolkit.getPathResolver().addSinglePathResolver((SinglePathResolver)new SourcePathResolver(s.sourcePath));
                s.units = units = flex2.compiler.API.compile((FileSpec)s.fileSpec, (SourceList)s.sourceList, null, (SourcePath)s.sourcePath, (ResourceContainer)s.resources, (ResourceBundlePath)s.bundlePath, (CompilerSwcContext)swcContext, (SymbolTable)symbolTable, (Configuration)configuration, (Compiler[])compilers, null, (Map)licenseMap, new ArrayList());
                s.sourcePath.clearCache();
                s.bundlePath.clearCache();
                s.resources.refresh();
                s.app = API.linkConsole((List)units, (PostLink)new flex2.tools.PostLink((flex2.linker.Configuration)configuration), (Configuration)configuration);
                File file = FileUtil.openFile((String)s.outputName, (boolean)true);
                swfOut = new BufferedOutputStream(new FileOutputStream(file));
                flex2.tools.Compiler.createProjector((VirtualFile)projector, (ConsoleApplication)s.app, (OutputStream)swfOut);
                swfOut.flush();
                swfOut.close();
                ThreadLocalToolkit.log((ILocalizableMessage)new Compiler.OutputMessage(s.outputName, Long.toString(file.length())));
            } else {
                List units;
                ThreadLocalToolkit.getPathResolver().addSinglePathResolver((SinglePathResolver)new SourcePathResolver(s.sourcePath));
                s.units = units = flex2.compiler.API.compile((FileSpec)s.fileSpec, (SourceList)s.sourceList, null, (SourcePath)s.sourcePath, (ResourceContainer)s.resources, (ResourceBundlePath)s.bundlePath, (CompilerSwcContext)swcContext, (SymbolTable)symbolTable, (Configuration)configuration, (Compiler[])compilers, (flex2.compiler.PreLink)new PreLink(), (Map)licenseMap, new ArrayList());
                s.sourcePath.clearCache();
                s.bundlePath.clearCache();
                s.resources.refresh();
                s.movie = API.link((List)units, (PostLink)new flex2.tools.PostLink((flex2.linker.Configuration)configuration), (Configuration)configuration);
                File file = FileUtil.openFile((String)s.outputName, (boolean)true);
                swfOut = new BufferedOutputStream(new FileOutputStream(file));
                if (projector != null) {
                    flex2.tools.Compiler.createProjector((VirtualFile)projector, (Movie)s.movie, (OutputStream)swfOut);
                } else {
                    flex2.compiler.API.encode((Movie)s.movie, (OutputStream)swfOut);
                }
                swfOut.flush();
                swfOut.close();
                ThreadLocalToolkit.log((ILocalizableMessage)new Compiler.OutputMessage(s.outputName, Long.toString(file.length())));
            }
        }
        catch (ConfigurationException ex) {
            flex2.tools.Compiler.processConfigurationException((ConfigurationException)ex, (String)"mxmlc");
        }
        catch (LicenseException ex) {
            ThreadLocalToolkit.logError((String)ex.getMessage());
        }
        catch (CompilerException ex) {
            assert (ThreadLocalToolkit.errorCount() > 0);
        }
        catch (LinkerException ex) {
            assert (ThreadLocalToolkit.errorCount() > 0);
        }
        catch (SwcException ex) {
            assert (ThreadLocalToolkit.errorCount() > 0);
        }
        catch (IOException thr) {
            ThreadLocalToolkit.logError((String)thr.getMessage());
            thr.printStackTrace();
        }
        finally {
            Benchmark benchmark = ThreadLocalToolkit.getBenchmark();
            if (benchmark != null) {
                benchmark.totalTime();
                benchmark.peakMemoryUsage(true);
            }
            flex2.compiler.API.removePathResolver();
            if (swfOut != null) {
                try {
                    swfOut.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void compc(String[] args, int id) {
        LocalizationManager l10n = ThreadLocalToolkit.getLocalizationManager();
        SwcTarget s = new SwcTarget();
        s.id = id;
        try {
            File file;
            List units;
            flex2.compiler.API.usePathResolver();
            ConfigurationBuffer cfgbuf = new ConfigurationBuffer(CompcConfiguration.class, CompcConfiguration.getAliases());
            cfgbuf.setDefaultVar("include-classes");
            DefaultsConfigurator.loadCompcDefaults((ConfigurationBuffer)cfgbuf);
            CompcConfiguration configuration = (CompcConfiguration)flex2.tools.Compiler.processConfiguration((LocalizationManager)ThreadLocalToolkit.getLocalizationManager(), (String)"compc", (String[])args, (ConfigurationBuffer)cfgbuf, CompcConfiguration.class, (String)"include-classes");
            s.configuration = configuration;
            flex2.compiler.API.setupHeadless((Configuration)configuration);
            if (configuration.benchmark()) {
                flex2.compiler.API.runBenchmark();
            } else {
                flex2.compiler.API.disableBenchmark();
            }
            targets.put("" + id, s);
            s.args = args;
            String[] sourceMimeTypes = flex2.tools.API.getSourcePathMimeTypes();
            CompilerConfiguration compilerConfig = configuration.getCompilerConfiguration();
            s.sourcePath = new SourcePath(sourceMimeTypes, compilerConfig.allowSourcePathOverlap());
            s.sourcePath.addPathElements(compilerConfig.getSourcePath());
            List[] array = flex2.compiler.API.getVirtualFileList((Collection)configuration.getIncludeSources(), configuration.getStylesheets().values(), new HashSet<String>(Arrays.asList(sourceMimeTypes)), (List)s.sourcePath.getPaths());
            NameMappings mappings = flex2.compiler.API.getNameMappings((Configuration)configuration);
            compilerConfig.setMetadataExport(true);
            Transcoder[] transcoders = flex2.tools.API.getTranscoders((Configuration)configuration);
            Compiler[] compilers = flex2.tools.API.getCompilers((CompilerConfiguration)compilerConfig, (NameMappings)mappings, (Transcoder[])transcoders);
            s.outputName = FileUtil.getCanonicalPath((File)FileUtil.openFile((String)configuration.getOutput()));
            s.fileSpec = new FileSpec(array[0], flex2.tools.API.getFileSpecMimeTypes(), false);
            s.sourceList = new SourceList(array[1], compilerConfig.getSourcePath(), null, flex2.tools.API.getSourceListMimeTypes(), false);
            s.resources = new ResourceContainer();
            s.bundlePath = new ResourceBundlePath(configuration.getCompilerConfiguration(), null);
            if (ThreadLocalToolkit.getBenchmark() != null) {
                ThreadLocalToolkit.getBenchmark().benchmark(l10n.getLocalizedTextString((Object)new Compiler.InitialSetup()));
            }
            s.swcCache = new SwcCache();
            CompilerSwcContext swcContext = new CompilerSwcContext(true, true, configuration.getCompatibilityVersionString());
            swcContext.load(compilerConfig.getLibraryPath(), compilerConfig.getExternalLibraryPath(), null, null, mappings, I18nUtils.getTranslationFormat((CompilerConfiguration)compilerConfig), s.swcCache);
            configuration.addExterns((Collection)swcContext.getExterns());
            if (ThreadLocalToolkit.getBenchmark() != null) {
                ThreadLocalToolkit.getBenchmark().benchmark(l10n.getLocalizedTextString((Object)new Compiler.LoadedSWCs(swcContext.getNumberLoaded())));
            }
            s.checksum = cfgbuf.checksum_ts() + swcContext.checksum();
            SymbolTable symbolTable = SymbolTable.newSymbolTable((Configuration)configuration);
            s.perCompileData = symbolTable.perCompileData;
            Map licenseMap = configuration.getLicensesConfiguration().getLicenseMap();
            HashMap classes = new HashMap();
            s.nsComponents = flex2.compiler.swc.API.setupNamespaceComponents((CompcConfiguration)configuration, (NameMappings)mappings, (SourcePath)s.sourcePath, classes);
            flex2.compiler.swc.API.setupClasses((CompcConfiguration)configuration, (SourcePath)s.sourcePath, classes);
            HashMap rbFiles = new HashMap();
            ThreadLocalToolkit.getPathResolver().addSinglePathResolver((SinglePathResolver)new SourcePathResolver(s.sourcePath));
            s.units = units = flex2.compiler.API.compile((FileSpec)s.fileSpec, (SourceList)s.sourceList, classes.values(), (SourcePath)s.sourcePath, (ResourceContainer)s.resources, (ResourceBundlePath)s.bundlePath, (CompilerSwcContext)swcContext, (SymbolTable)symbolTable, (Configuration)configuration, (Compiler[])compilers, (flex2.compiler.PreLink)new CompcPreLink(rbFiles, configuration.getIncludeResourceBundles()), (Map)licenseMap, new ArrayList());
            s.rbFiles = rbFiles;
            s.sourcePath.clearCache();
            s.bundlePath.clearCache();
            s.resources.refresh();
            s.classes = classes.keySet();
            flex2.compiler.swc.API.exportSwc((CompcConfiguration)configuration, (List)units, (List)s.nsComponents, (SwcCache)s.swcCache, (Map)s.rbFiles);
            if (s.outputName != null && ThreadLocalToolkit.errorCount() == 0 && (file = FileUtil.openFile((String)s.outputName)) != null && file.exists() && file.isFile()) {
                s.outputName = FileUtil.getCanonicalPath((File)file);
                ThreadLocalToolkit.log((ILocalizableMessage)new Compiler.OutputMessage(s.outputName, Long.toString(file.length())));
            }
        }
        catch (ConfigurationException ex) {
            Compc.displayStartMessage();
            flex2.tools.Compiler.processConfigurationException((ConfigurationException)ex, (String)"compc");
        }
        catch (LicenseException ex) {
            ThreadLocalToolkit.logError((String)ex.getMessage());
        }
        catch (CompilerException ex) {
            assert (ThreadLocalToolkit.errorCount() > 0);
        }
        catch (LinkerException ex) {
            assert (ThreadLocalToolkit.errorCount() > 0);
        }
        catch (SwcException ex) {
            assert (ThreadLocalToolkit.errorCount() > 0);
        }
        catch (Exception t) {
            ThreadLocalToolkit.logError((String)t.getMessage());
            t.printStackTrace();
        }
        finally {
            Benchmark benchmark = ThreadLocalToolkit.getBenchmark();
            if (benchmark != null) {
                benchmark.totalTime();
                benchmark.peakMemoryUsage(true);
            }
            flex2.compiler.API.removePathResolver();
        }
    }

    private static String getPlayer() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.startsWith("windows")) {
            return "SAFlashPlayer";
        }
        if (osName.startsWith("mac os x")) {
            return "SAFlashPlayer";
        }
        return "flashplayer";
    }

    private static void intro() {
        LocalizationManager l10n = ThreadLocalToolkit.getLocalizationManager();
        System.out.println(l10n.getLocalizedTextString((Object)new SimpleShell.ShellMessage("fcsh", VersionInfo.buildMessage())));
    }

    private static void prompt() {
        System.out.print("(fcsh) ");
    }

    private static void cmdList() {
        LocalizationManager l10n = ThreadLocalToolkit.getLocalizationManager();
        System.out.println(l10n.getLocalizedTextString((Object)new SimpleShell.CommandList()));
    }
}

