/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.boot.run.SpringBootRunBundle;
import com.intellij.spring.boot.run.lifecycle.AsyncApplicationLiveProperty;
import com.intellij.spring.boot.run.lifecycle.LifecycleErrorHandler;
import com.intellij.spring.boot.run.lifecycle.LifecycleException;
import com.intellij.spring.boot.run.lifecycle.LiveProperty;
import com.intellij.spring.boot.run.lifecycle.SpringBootActuatorConnector;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationConnector;
import com.intellij.spring.boot.run.lifecycle.SpringBootModuleDescriptor;
import com.intellij.spring.boot.run.lifecycle.beans.LiveBeansModel;
import java.util.List;
import org.jetbrains.annotations.Nullable;

abstract class EndpointLiveProperty<T>
extends AsyncApplicationLiveProperty<T> {
    private static final String ENDPOINT_BEAN_NAME_SUFFIX = "Endpoint";
    private final String myEndpointId;
    private final String myEndpointName;
    private LiveProperty<SpringBootModuleDescriptor> myModuleDescriptor;
    private LiveProperty<LiveBeansModel> myLiveBeansModel;

    EndpointLiveProperty(String endpointId, String endpointName, LiveProperty<String> applicationAdminJmxName, int jmxPort, LifecycleErrorHandler errorHandler, Disposable parent) {
        super(applicationAdminJmxName, jmxPort, errorHandler, parent);
        this.myEndpointId = endpointId;
        this.myEndpointName = endpointName;
    }

    EndpointLiveProperty<T> withModuleDescriptor(LiveProperty<SpringBootModuleDescriptor> moduleDescriptor) {
        this.myModuleDescriptor = moduleDescriptor;
        return this;
    }

    EndpointLiveProperty<T> withLiveBeansModel(LiveProperty<LiveBeansModel> liveBeansModel) {
        this.myLiveBeansModel = liveBeansModel;
        return this;
    }

    @Override
    public T doCompute() throws LifecycleException {
        String endpointEnabledProperty;
        SpringBootModuleDescriptor moduleDescriptor;
        boolean isSB20 = false;
        if (this.myModuleDescriptor != null && (moduleDescriptor = (SpringBootModuleDescriptor)this.myModuleDescriptor.getValue()) != null) {
            if (!moduleDescriptor.isActuatorsEnabled()) {
                return null;
            }
            isSB20 = moduleDescriptor.isSB20();
        }
        String endpointDomain = "org.springframework.boot";
        String endpointDisabledMessage = null;
        try (SpringBootApplicationConnector connector = this.getApplicationConnector();){
            String endpointsJmxEnabledProperty;
            String string = endpointsJmxEnabledProperty = isSB20 ? "endpoints.default.jmx.enabled" : "endpoints.jmx.enabled";
            if (!connector.getBooleanProperty(endpointsJmxEnabledProperty, true)) {
                endpointDisabledMessage = SpringBootRunBundle.message("spring.boot.application.endpoints.error.property.is.set.to.false", endpointsJmxEnabledProperty);
            } else {
                endpointEnabledProperty = isSB20 ? "endpoints.default.enabled" : "endpoints.enabled";
                boolean endpointsEnabled = connector.getBooleanProperty(endpointEnabledProperty, true);
                boolean endpointEnabled = connector.getBooleanProperty(String.format("endpoints.%s.enabled", this.myEndpointId), endpointsEnabled);
                if (!endpointEnabled) {
                    String propertyName = endpointsEnabled ? String.format("endpoints.%s.enabled", this.myEndpointId) : endpointEnabledProperty;
                    endpointDisabledMessage = SpringBootRunBundle.message("spring.boot.application.endpoints.error.property.is.set.to.false", propertyName);
                } else {
                    Object o = connector.getProperty(isSB20 ? "management.endpoints.jmx.domain" : "endpoints.jmx.domain");
                    if (o instanceof String) {
                        endpointDomain = (String)o;
                    } else {
                        o = connector.getProperty("spring.jmx.default-domain");
                        if (o instanceof String) {
                            endpointDomain = (String)o;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            throw new LifecycleException(SpringBootRunBundle.message("spring.boot.application.endpoints.error.failed.to.retrieve.endpoint.data", this.myEndpointId, e.getLocalizedMessage()), e);
        }
        if (endpointDisabledMessage == null) {
            LiveBeansModel model;
            LiveBeansModel liveBeansModel = model = this.myLiveBeansModel != null ? (LiveBeansModel)this.myLiveBeansModel.getValue() : null;
            if (model != null) {
                List beans = model.getBeans();
                String endpointBeanName = this.myEndpointName + ENDPOINT_BEAN_NAME_SUFFIX;
                if (beans.stream().noneMatch(bean -> endpointBeanName.equals(bean.getId()))) {
                    endpointDisabledMessage = SpringBootRunBundle.message("spring.boot.application.endpoints.error.bean.not.initialized", endpointBeanName);
                }
            }
        }
        String mbeanName = isSB20 ? StringUtil.capitalize((String)this.myEndpointId) : this.myEndpointName + ENDPOINT_BEAN_NAME_SUFFIX;
        Throwable throwable = null;
        try (SpringBootActuatorConnector connector = new SpringBootActuatorConnector(this.getJmxPort(), endpointDomain, mbeanName);){
            endpointEnabledProperty = this.parseData(connector.getData(isSB20 ? this.myEndpointId : null));
            return (T)endpointEnabledProperty;
        }
        catch (Exception e) {
            try {
                if (endpointDisabledMessage != null) {
                    throw new LifecycleException(null, new LifecycleException(endpointDisabledMessage, null));
                }
                throw new LifecycleException(SpringBootRunBundle.message("spring.boot.application.endpoints.error.failed.to.retrieve.endpoint.data", this.myEndpointId, e.getLocalizedMessage()), e);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    protected abstract T parseData(@Nullable Object var1);
}

