/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle;

import com.intellij.spring.boot.run.lifecycle.SpringBootJmxConnector;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.ObjectInstance;

class SpringBootLiveBeansConnector
extends SpringBootJmxConnector {
    private static final String SPRING_BOOT_LIVE_BEANS_OBJECT_NAME = ":application=*";
    private static final String SNAPSHOT_ATTR = "SnapshotAsJson";

    SpringBootLiveBeansConnector(int jmxPort) {
        super(jmxPort, SPRING_BOOT_LIVE_BEANS_OBJECT_NAME);
    }

    String getSnapshot() throws Exception {
        Set<ObjectInstance> objectInstances = this.getJmxConnection().queryMBeans(this.getObjectName(), null);
        ObjectInstance objectInstance = (ObjectInstance)ContainerUtil.getFirstItem(objectInstances);
        if (objectInstance == null) {
            throw new InstanceNotFoundException(this.getObjectName().toString());
        }
        return (String)this.getJmxConnection().getAttribute(objectInstance.getObjectName(), SNAPSHOT_ATTR);
    }
}

