/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle.beans.diagram;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringPresentationProvider;
import com.intellij.spring.boot.run.lifecycle.beans.LiveBean;
import com.intellij.spring.boot.run.lifecycle.tabs.LiveBeansPanel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.perspectives.diagrams.beans.SpringElementWrapper;
import com.intellij.xml.util.PsiElementPointer;
import icons.SpringApiIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LiveBeanWrapper
extends SpringElementWrapper<LiveBean> {
    @NotNull
    private final Project myProject;
    @NotNull
    private final PsiElementPointer myPointer;

    LiveBeanWrapper(@NotNull LiveBean bean, @NotNull LiveBeansPanel.LiveBeanContext beanContext, @Nullable CommonSpringModel springModel) {
        if (bean == null) {
            LiveBeanWrapper.$$$reportNull$$$0(0);
        }
        if (beanContext == null) {
            LiveBeanWrapper.$$$reportNull$$$0(1);
        }
        super((Object)bean);
        this.myProject = beanContext.project;
        if (DumbService.isDumb((Project)this.myProject)) {
            this.myPointer = () -> null;
        } else {
            PsiElement resourceElement = bean.getResource() == null ? null : bean.getResource().getResourceElement(beanContext.project, beanContext.module, (PsiElement)beanContext.mainClass, beanContext.searchScope);
            PsiClass beanClass = bean.getBeanClass(beanContext.project, beanContext.searchScope);
            this.myPointer = bean.getBeanPointer(beanClass, resourceElement, springModel);
        }
    }

    public String getName() {
        return ((LiveBean)this.getWrapped()).getName();
    }

    @Nullable
    public CommonSpringModel getProcessingSpringModel(boolean localModel) {
        return null;
    }

    @Nullable
    public String getFqn() {
        return ((LiveBean)this.getWrapped()).getClassName();
    }

    @Nullable
    public Module getModule() {
        return null;
    }

    @Nullable
    public Icon getIcon() {
        PsiElementPointer pointer = this.getPointer();
        return pointer instanceof SpringBeanPointer ? SpringPresentationProvider.getSpringIcon((Object)pointer) : SpringApiIcons.SpringJavaBean;
    }

    @NotNull
    public PsiElementPointer getPointer() {
        PsiElementPointer psiElementPointer = DumbService.isDumb((Project)this.myProject) ? () -> null : this.myPointer;
        if (psiElementPointer == null) {
            LiveBeanWrapper.$$$reportNull$$$0(2);
        }
        return psiElementPointer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/run/lifecycle/beans/diagram/LiveBeanWrapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/beans/diagram/LiveBeanWrapper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPointer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

