/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle.tabs;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfiguration;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationInfo;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationLifecycleManager;
import com.intellij.spring.boot.run.lifecycle.beans.LiveBeansModel;
import com.intellij.ui.FinderRecursivePanel;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class LifecycleFinderRecursivePanel<T>
extends FinderRecursivePanel<T> {
    @NotNull
    private final SpringBootApplicationRunConfiguration myRunConfiguration;
    @NotNull
    private final ProcessHandler myProcessHandler;
    private JBList<T> myList;

    protected LifecycleFinderRecursivePanel(@NotNull Project project, @Nullable FinderRecursivePanel parent, @Nullable String groupId, @NotNull SpringBootApplicationRunConfiguration runConfiguration, @NotNull ProcessHandler processHandler) {
        if (project == null) {
            LifecycleFinderRecursivePanel.$$$reportNull$$$0(0);
        }
        if (runConfiguration == null) {
            LifecycleFinderRecursivePanel.$$$reportNull$$$0(1);
        }
        if (processHandler == null) {
            LifecycleFinderRecursivePanel.$$$reportNull$$$0(2);
        }
        super(project, parent, groupId);
        this.myRunConfiguration = runConfiguration;
        this.myProcessHandler = processHandler;
    }

    @NotNull
    protected final SpringBootApplicationRunConfiguration getRunConfiguration() {
        SpringBootApplicationRunConfiguration springBootApplicationRunConfiguration = this.myRunConfiguration;
        if (springBootApplicationRunConfiguration == null) {
            LifecycleFinderRecursivePanel.$$$reportNull$$$0(3);
        }
        return springBootApplicationRunConfiguration;
    }

    @NotNull
    protected final ProcessHandler getProcessHandler() {
        ProcessHandler processHandler = this.myProcessHandler;
        if (processHandler == null) {
            LifecycleFinderRecursivePanel.$$$reportNull$$$0(4);
        }
        return processHandler;
    }

    protected boolean performEditAction() {
        String message;
        Object selectedValue = this.getSelectedValue();
        this.updateItem(selectedValue);
        Navigatable data = (Navigatable)CommonDataKeys.NAVIGATABLE.getData((DataProvider)this);
        if (data != null && data.canNavigate()) {
            data.navigate(true);
        } else if (selectedValue != null && StringUtil.isNotEmpty((String)(message = this.getEditActionHintMessage(selectedValue)))) {
            this.showHint(message);
        }
        return false;
    }

    protected JBList<T> createList() {
        this.myList = super.createList();
        return this.myList;
    }

    @Nullable
    protected final LiveBeansModel getModel() {
        SpringBootApplicationInfo info = SpringBootApplicationLifecycleManager.getInstance((Project)this.getProject()).getSpringBootApplicationInfo(this.getProcessHandler());
        return info != null ? (LiveBeansModel)info.getLiveBeansModel().getValue() : null;
    }

    protected final void updateItem(@Nullable T t) {
        if (DumbService.isDumb((Project)this.getProject()) || t == null) {
            return;
        }
        boolean changed = this.doUpdateItem(t);
        if (changed) {
            this.updateRightComponent(!this.hasChildren(t));
        }
    }

    protected boolean doUpdateItem(@NotNull T t) {
        if (t == null) {
            LifecycleFinderRecursivePanel.$$$reportNull$$$0(5);
        }
        return false;
    }

    protected void showHint(@NotNull String message) {
        if (message == null) {
            LifecycleFinderRecursivePanel.$$$reportNull$$$0(6);
        }
        if (this.myList == null) {
            return;
        }
        JComponent messageComponent = HintUtil.createInformationLabel((String)message);
        BalloonBuilder builder = JBPopupFactory.getInstance().createBalloonBuilder(messageComponent);
        Balloon balloon = builder.setRequestFocus(false).setFadeoutTime(3000L).setFillColor(HintUtil.getInformationColor()).createBalloon();
        int selectedIndex = this.myList.getSelectedIndex();
        Rectangle cellBounds = this.myList.getCellBounds(selectedIndex, selectedIndex);
        if (cellBounds == null) {
            balloon.showInCenterOf(this.myList);
        } else {
            Point point = new Point(cellBounds.x + cellBounds.width / 2, cellBounds.y + cellBounds.height / 2);
            balloon.show(new RelativePoint(this.myList, point), Balloon.Position.below);
        }
    }

    protected String getEditActionHintMessage(@NotNull T t) {
        if (t == null) {
            LifecycleFinderRecursivePanel.$$$reportNull$$$0(7);
        }
        return null;
    }

    public final void updateComponent() {
        if (!this.isDisposed()) {
            this.updatePanel();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/run/lifecycle/tabs/LifecycleFinderRecursivePanel";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/tabs/LifecycleFinderRecursivePanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunConfiguration";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doUpdateItem";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showHint";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getEditActionHintMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

