/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.metadata;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.json.JsonFileType;
import com.intellij.json.psi.JsonFile;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.boot.application.metadata.SpringBootMetadataNotificationPanel;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.options.SpringBootSettings;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBootMetadataEditorNotificationsProvider
extends EditorNotifications.Provider<SpringBootMetadataNotificationPanel>
implements Disposable {
    private static final Key<SpringBootMetadataNotificationPanel> KEY = Key.create((String)"SpringBootMetadata");
    private final Project myProject;
    private final ParameterizedCachedValue<Object, PsiFile> myPsiClassOwnerCachedTrigger;
    private final MergingUpdateQueue myUpdateQueue;

    public SpringBootMetadataEditorNotificationsProvider(Project project) {
        this.myProject = project;
        Disposer.register((Disposable)this.myProject, (Disposable)this);
        this.myPsiClassOwnerCachedTrigger = CachedValuesManager.getManager((Project)project).createParameterizedCachedValue((ParameterizedCachedValueProvider)new ParameterizedCachedValueProvider<Object, PsiFile>(){

            @Nullable
            public CachedValueProvider.Result<Object> compute(PsiFile psiFile) {
                if (DumbService.isDumb((Project)SpringBootMetadataEditorNotificationsProvider.this.myProject) || SpringBootMetadataEditorNotificationsProvider.this.isRelevantProject()) {
                    SpringBootMetadataEditorNotificationsProvider.this.updateNotifications(psiFile.getVirtualFile());
                    return CachedValueProvider.Result.create(null, (Object[])new Object[]{SpringModificationTrackersManager.getInstance((Project)SpringBootMetadataEditorNotificationsProvider.this.myProject).getOuterModelsModificationTracker()});
                }
                return CachedValueProvider.Result.create(null, (Object[])new Object[]{ProjectRootManager.getInstance((Project)SpringBootMetadataEditorNotificationsProvider.this.myProject)});
            }
        }, false);
        this.myUpdateQueue = new MergingUpdateQueue("SpringBootMetadataEditorNotificationsProvider", 2000, true, null, (Disposable)this);
        this.installListeners(project);
    }

    private boolean isRelevantProject() {
        return SpringCommonUtils.hasSpringFacets((Project)this.myProject) && SpringBootLibraryUtil.hasSpringBootLibrary((Project)this.myProject);
    }

    @NotNull
    public Key<SpringBootMetadataNotificationPanel> getKey() {
        Key<SpringBootMetadataNotificationPanel> key = KEY;
        if (key == null) {
            SpringBootMetadataEditorNotificationsProvider.$$$reportNull$$$0(0);
        }
        return key;
    }

    @Nullable
    public SpringBootMetadataNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor) {
        if (file == null) {
            SpringBootMetadataEditorNotificationsProvider.$$$reportNull$$$0(1);
        }
        if (fileEditor == null) {
            SpringBootMetadataEditorNotificationsProvider.$$$reportNull$$$0(2);
        }
        if (!SpringBootSettings.getInstance((Project)this.myProject).isShowAdditionalConfigNotification()) {
            return null;
        }
        if (DumbService.isDumb((Project)this.myProject)) {
            DumbService.getInstance((Project)this.myProject).smartInvokeLater(() -> {
                if (file == null) {
                    SpringBootMetadataEditorNotificationsProvider.$$$reportNull$$$0(4);
                }
                this.updateNotifications(file);
            });
            return null;
        }
        if (!this.isRelevantProject()) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file);
        if (psiFile == null || !SpringBootMetadataEditorNotificationsProvider.isAdditionalConfigJSON(psiFile) && !SpringBootMetadataEditorNotificationsProvider.isConfigurationPropertiesAnnotatedClass(psiFile)) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)this.myProject);
        if (module == null) {
            return null;
        }
        if (!SpringBootLibraryUtil.isAtLeastVersion((Module)module, (SpringBootLibraryUtil.SpringBootVersion)SpringBootLibraryUtil.SpringBootVersion.VERSION_1_2_0)) {
            return null;
        }
        return new SpringBootMetadataNotificationPanel(module, psiFile);
    }

    private void updateNotifications(@NotNull VirtualFile file) {
        if (file == null) {
            SpringBootMetadataEditorNotificationsProvider.$$$reportNull$$$0(3);
        }
        EditorNotifications.getInstance((Project)this.myProject).updateNotifications(file);
    }

    private static boolean isConfigurationPropertiesAnnotatedClass(PsiFile psiFile) {
        if (!(psiFile instanceof PsiClassOwner)) {
            return false;
        }
        PsiClassOwner psiClassOwner = (PsiClassOwner)psiFile;
        Object[] classes = psiClassOwner.getClasses();
        PsiClass psiClass = (PsiClass)ArrayUtil.getFirstElement((Object[])classes);
        if (psiClass == null) {
            return false;
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)"org.springframework.boot.context.properties.ConfigurationProperties", (boolean)false);
    }

    private static boolean isAdditionalConfigJSON(PsiFile psiFile) {
        return psiFile instanceof JsonFile && psiFile.getName().equals("additional-spring-configuration-metadata.json");
    }

    private void installListeners(Project project) {
        VirtualFileManager.getInstance().addVirtualFileListener(new VirtualFileListener(){

            public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
                PsiFile file;
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                VirtualFile virtualFile = event.getFile();
                if (event.getPropertyName().equals("name") && virtualFile.getFileType() == JsonFileType.INSTANCE && (file = PsiManager.getInstance((Project)SpringBootMetadataEditorNotificationsProvider.this.myProject).findFile(virtualFile)) instanceof JsonFile) {
                    SpringBootMetadataEditorNotificationsProvider.this.updateNotifications(virtualFile);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/spring/boot/application/metadata/SpringBootMetadataEditorNotificationsProvider$2", "propertyChanged"));
            }
        }, (Disposable)project);
        PsiManager.getInstance((Project)project).addPsiTreeChangeListener((PsiTreeChangeListener)new PsiTreeChangeAdapter(){

            public void childMoved(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                this.handleChange(event);
            }

            public void childReplaced(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(1);
                }
                this.handleChange(event);
            }

            public void childRemoved(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(2);
                }
                this.handleChange(event);
            }

            public void childAdded(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(3);
                }
                this.handleChange(event);
            }

            public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(4);
                }
                this.handleChange(event);
            }

            private void handleChange(PsiTreeChangeEvent event) {
                final PsiFile file = event.getFile();
                if (file instanceof PsiClassOwner || file instanceof JsonFile) {
                    if (DumbService.isDumb((Project)SpringBootMetadataEditorNotificationsProvider.this.myProject)) {
                        return;
                    }
                    SpringBootMetadataEditorNotificationsProvider.this.myUpdateQueue.queue(new Update("SB metadata notification update"){

                        public void run() {
                            SpringBootMetadataEditorNotificationsProvider.this.myPsiClassOwnerCachedTrigger.getValue((Object)file);
                        }
                    });
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/spring/boot/application/metadata/SpringBootMetadataEditorNotificationsProvider$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childMoved";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childReplaced";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childRemoved";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childAdded";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childrenChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this.myProject);
    }

    public void dispose() {
        this.myUpdateQueue.cancelAllUpdates();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/application/metadata/SpringBootMetadataEditorNotificationsProvider";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/application/metadata/SpringBootMetadataEditorNotificationsProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationPanel";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateNotifications";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createNotificationPanel$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

