/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.banner;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;

enum BuiltinProperty {
    APPLICATION_TITLE("application.title", "My application"),
    APPLICATION_VERSION("application.version", "1.0.0"),
    APPLICATION_FORMATTED_VERSION("application.formatted-version", "(v1.0.0)"),
    SPRING_BOOT_VERSION("spring-boot.version", null){

        @Override
        String getTailText(Module module) {
            String fromJar = SpringBootLibraryUtil.getVersionFromJar((Module)module);
            return StringUtil.defaultIfEmpty((String)fromJar, (String)"unknown");
        }
    }
    ,
    SPRING_BOOT_FORMATTED_VERSION("spring-boot.formatted-version", null){

        @Override
        String getTailText(Module module) {
            String fromJar = SpringBootLibraryUtil.getVersionFromJar((Module)module);
            if (fromJar == null) {
                return "(unknown)";
            }
            return "(v" + fromJar + ")";
        }
    };

    private final String myPropertyName;
    private final String myTailText;

    private BuiltinProperty(String propertyName, String tailText) {
        this.myPropertyName = propertyName;
        this.myTailText = tailText;
    }

    String getPropertyName() {
        return this.myPropertyName;
    }

    String getTailText(Module module) {
        return this.myTailText;
    }
}

