/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common;

import java.io.PrintStream;

public class ExceptionUtils {
    public static void dumpStack(PrintStream printStream) {
        ExceptionUtils.dumpStack(printStream, 1, -1);
    }

    public static void dumpStack(PrintStream printStream, int n, int n2) {
        ExceptionUtils.dumpStack(printStream, new Exception(""), n + 1, n2);
    }

    public static void dumpStack(PrintStream printStream, Throwable throwable, int n, int n2) {
        ExceptionUtils.dumpStack(printStream, throwable.getStackTrace(), n, n2);
    }

    public static void dumpStack(PrintStream printStream, StackTraceElement[] stackTraceElementArray, int n, int n2) {
        if (null == stackTraceElementArray) {
            return;
        }
        int n3 = 0 > n2 ? stackTraceElementArray.length : Math.min(n2 + n, stackTraceElementArray.length);
        for (int i = n; i < n3; ++i) {
            int n4 = i;
            String string = String.valueOf(stackTraceElementArray[i]);
            printStream.println(new StringBuilder(19 + String.valueOf(string).length()).append("    [").append(n4).append("]: ").append(string).toString());
        }
    }

    public static int printCause(PrintStream printStream, String string, Throwable throwable, int n, int n2, int n3) {
        int n4;
        for (n4 = n; null != throwable && (-1 == n2 || n4 < n2); ++n4, throwable = throwable.getCause()) {
            if (throwable instanceof CustomStackTrace) {
                ((CustomStackTrace)((Object)throwable)).printCauseStack(printStream, string, n4, n3);
                continue;
            }
            int n5 = n4;
            String string2 = String.valueOf(throwable.getClass().getSimpleName());
            String string3 = String.valueOf(throwable.getMessage());
            String string4 = String.valueOf(Thread.currentThread().getName());
            printStream.println(new StringBuilder(30 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append(string).append("[").append(n5).append("] by ").append(string2).append(": ").append(string3).append(" on thread ").append(string4).toString());
            ExceptionUtils.dumpStack(printStream, throwable.getStackTrace(), 0, n3);
        }
        return n4;
    }

    public static void printStackTrace(PrintStream printStream, Throwable throwable, int n, int n2) {
        if (throwable instanceof CustomStackTrace) {
            ((CustomStackTrace)((Object)throwable)).printStackTrace(printStream, n, n2);
        } else {
            String string = String.valueOf(throwable.getClass().getSimpleName());
            String string2 = String.valueOf(throwable.getMessage());
            String string3 = String.valueOf(Thread.currentThread().getName());
            printStream.println(new StringBuilder(13 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string).append(": ").append(string2).append(" on thread ").append(string3).toString());
            ExceptionUtils.dumpStack(printStream, throwable.getStackTrace(), 0, n2);
            ExceptionUtils.printCause(printStream, "Caused", throwable.getCause(), 0, n, n2);
        }
    }

    public static void dumpThrowable(String string, Throwable throwable) {
        ExceptionUtils.dumpThrowable(string, throwable, -1, -1);
    }

    public static void dumpThrowable(String string, Throwable throwable, int n, int n2) {
        System.err.print(new StringBuilder(8 + String.valueOf(string).length()).append("Caught ").append(string).append(" ").toString());
        ExceptionUtils.printStackTrace(System.err, throwable, n, n2);
    }

    public static interface CustomStackTrace {
        public void printCauseStack(PrintStream var1, String var2, int var3, int var4);

        public void printStackTrace(PrintStream var1, int var2, int var3);
    }
}

