/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.debugger.jdi;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.openapi.util.UserDataHolderEx;
import com.jetbrains.debugger.jdi.ClassValue;
import com.jetbrains.debugger.jdi.JdiArray;
import com.jetbrains.debugger.jdi.JdiObject;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.LongValue;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StringReference;
import gnu.trove.TLongObjectHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.debugger.values.ValueManager;
import org.jetbrains.debugger.values.ValueType;

public final class JdiValueManager
extends ValueManager {
    private static final ObjectValueFactory OBJECT_VALUE_FACTORY = new ObjectValueFactory(){

        @Override
        public ObjectValue create(@NotNull ObjectReference objectReference, @NotNull JdiValueManager valueManager) {
            if (objectReference == null) {
                1.$$$reportNull$$$0(0);
            }
            if (valueManager == null) {
                1.$$$reportNull$$$0(1);
            }
            return new JdiObject(ValueType.OBJECT, objectReference, valueManager);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "objectReference";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "valueManager";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/debugger/jdi/JdiValueManager$1";
            objectArray[2] = "create";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private final DebuggerManagerThreadImpl managerThread;
    private final DebugProcessImpl debugProcess;
    private final TLongObjectHashMap<Value> refToValue;

    public JdiValueManager(@NotNull DebugProcessImpl debugProcess) {
        if (debugProcess == null) {
            JdiValueManager.$$$reportNull$$$0(0);
        }
        this.refToValue = new TLongObjectHashMap();
        this.debugProcess = debugProcess;
        this.managerThread = debugProcess.getManagerThread();
    }

    public DebugProcessImpl getDebugProcess() {
        return this.debugProcess;
    }

    public UserDataHolderEx getProcessLevelCache() {
        return this.debugProcess;
    }

    @NotNull
    public DebuggerManagerThreadImpl getManagerThread() {
        DebuggerManagerThreadImpl debuggerManagerThreadImpl = this.managerThread;
        if (debuggerManagerThreadImpl == null) {
            JdiValueManager.$$$reportNull$$$0(1);
        }
        return debuggerManagerThreadImpl;
    }

    @NotNull
    public Value createValue(@Nullable com.sun.jdi.Value value) {
        Value value2 = this.createValue(value, OBJECT_VALUE_FACTORY);
        if (value2 == null) {
            JdiValueManager.$$$reportNull$$$0(2);
        }
        return value2;
    }

    @NotNull
    public Value createValue(@Nullable com.sun.jdi.Value value, @NotNull ObjectValueFactory objectValueFactory) {
        if (objectValueFactory == null) {
            JdiValueManager.$$$reportNull$$$0(3);
        }
        if (value == null) {
            org.jetbrains.debugger.values.PrimitiveValue primitiveValue = org.jetbrains.debugger.values.PrimitiveValue.NULL;
            if (primitiveValue == null) {
                JdiValueManager.$$$reportNull$$$0(4);
            }
            return primitiveValue;
        }
        if (value instanceof PrimitiveValue) {
            if (value instanceof ByteValue || value instanceof ShortValue || value instanceof IntegerValue) {
                org.jetbrains.debugger.values.PrimitiveValue primitiveValue = new org.jetbrains.debugger.values.PrimitiveValue(ValueType.NUMBER, ((PrimitiveValue)value).intValue());
                if (primitiveValue == null) {
                    JdiValueManager.$$$reportNull$$$0(5);
                }
                return primitiveValue;
            }
            if (value instanceof LongValue) {
                org.jetbrains.debugger.values.PrimitiveValue primitiveValue = new org.jetbrains.debugger.values.PrimitiveValue(ValueType.NUMBER, ((PrimitiveValue)value).longValue());
                if (primitiveValue == null) {
                    JdiValueManager.$$$reportNull$$$0(6);
                }
                return primitiveValue;
            }
            if (value instanceof FloatValue || value instanceof DoubleValue) {
                org.jetbrains.debugger.values.PrimitiveValue primitiveValue = new org.jetbrains.debugger.values.PrimitiveValue(ValueType.NUMBER, Double.toString(((PrimitiveValue)value).doubleValue()));
                if (primitiveValue == null) {
                    JdiValueManager.$$$reportNull$$$0(7);
                }
                return primitiveValue;
            }
            if (value instanceof BooleanValue) {
                org.jetbrains.debugger.values.PrimitiveValue primitiveValue = new org.jetbrains.debugger.values.PrimitiveValue(ValueType.BOOLEAN, Boolean.toString(((PrimitiveValue)value).booleanValue()));
                if (primitiveValue == null) {
                    JdiValueManager.$$$reportNull$$$0(8);
                }
                return primitiveValue;
            }
            if (value instanceof CharValue) {
                org.jetbrains.debugger.values.PrimitiveValue primitiveValue = new org.jetbrains.debugger.values.PrimitiveValue(ValueType.STRING, Character.toString(((PrimitiveValue)value).charValue()));
                if (primitiveValue == null) {
                    JdiValueManager.$$$reportNull$$$0(9);
                }
                return primitiveValue;
            }
        } else if (value instanceof ObjectReference) {
            ObjectReference objectReference = (ObjectReference)value;
            Object result = this.getCachedValue(objectReference);
            if (result != null) {
                Value value2 = result;
                if (value2 == null) {
                    JdiValueManager.$$$reportNull$$$0(10);
                }
                return value2;
            }
            result = value instanceof StringReference ? new org.jetbrains.debugger.values.PrimitiveValue(ValueType.STRING, ((StringReference)value).value()) : (value instanceof ArrayReference ? new JdiArray((ArrayReference)value, this) : (value instanceof ClassObjectReference ? new ClassValue((ClassObjectReference)value, this) : objectValueFactory.create(objectReference, this)));
            Value value3 = this.getOrCacheValue(objectReference, (Value)result);
            if (value3 == null) {
                JdiValueManager.$$$reportNull$$$0(11);
            }
            return value3;
        }
        throw new IllegalArgumentException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Value getCachedValue(@NotNull ObjectReference objectReference) {
        if (objectReference == null) {
            JdiValueManager.$$$reportNull$$$0(12);
        }
        TLongObjectHashMap<Value> tLongObjectHashMap = this.refToValue;
        synchronized (tLongObjectHashMap) {
            return (Value)this.refToValue.get(objectReference.uniqueID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Value getOrCacheValue(@NotNull ObjectReference objectReference, @NotNull Value value) {
        if (objectReference == null) {
            JdiValueManager.$$$reportNull$$$0(13);
        }
        if (value == null) {
            JdiValueManager.$$$reportNull$$$0(14);
        }
        long uniqueId = objectReference.uniqueID();
        TLongObjectHashMap<Value> tLongObjectHashMap = this.refToValue;
        // MONITORENTER : tLongObjectHashMap
        Value newValue = (Value)this.refToValue.get(uniqueId);
        if (newValue == null) {
            this.refToValue.put(uniqueId, (Object)value);
            Value value2 = value;
            // MONITOREXIT : tLongObjectHashMap
            if (value2 != null) return value2;
            JdiValueManager.$$$reportNull$$$0(15);
            return value2;
        }
        Value value3 = newValue;
        // MONITOREXIT : tLongObjectHashMap
        if (value3 != null) return value3;
        JdiValueManager.$$$reportNull$$$0(16);
        return value3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/debugger/jdi/JdiValueManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectValueFactory";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectReference";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/debugger/jdi/JdiValueManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getManagerThread";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createValue";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCacheValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createValue";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getCachedValue";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getOrCacheValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class ObjectValueFactory {
        public abstract ObjectValue create(@NotNull ObjectReference var1, @NotNull JdiValueManager var2);
    }
}

