/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.codeInsight.attributes;

import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.xml.XmlAttributeDescriptor;
import org.angularjs.codeInsight.DirectiveUtil;
import org.angularjs.codeInsight.attributes.AngularAttributeDescriptor;
import org.angularjs.codeInsight.attributes.AngularJSAttributeDescriptorsProvider;
import org.angularjs.index.AngularControllerIndex;
import org.angularjs.index.AngularIndexUtil;
import org.angularjs.index.AngularModuleIndex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AngularAttributesRegistry {
    static AngularAttributeDescriptor createDescriptor(@Nullable Project project, @NotNull String directiveName, @Nullable PsiElement declaration) {
        if (directiveName == null) {
            AngularAttributesRegistry.$$$reportNull$$$0(0);
        }
        if ("ng-controller".equals(directiveName)) {
            return new AngularAttributeDescriptor(project, directiveName, AngularControllerIndex.KEY, declaration);
        }
        if ("ng-app".equals(directiveName)) {
            return new AngularAttributeDescriptor(project, directiveName, AngularModuleIndex.KEY, declaration);
        }
        return new AngularAttributeDescriptor(project, directiveName, null, declaration);
    }

    public static boolean isAngularExpressionAttribute(XmlAttribute parent) {
        String type = AngularAttributesRegistry.getType(parent);
        return type.endsWith("expression") || type.startsWith("string");
    }

    public static boolean isJSONAttribute(XmlAttribute parent) {
        String value = parent.getValue();
        if (value == null || !value.startsWith("{")) {
            return false;
        }
        String type = AngularAttributesRegistry.getType(parent);
        return type.contains("object literal") || type.equals("mixed");
    }

    @NotNull
    private static String getType(XmlAttribute parent) {
        PsiElement directive;
        String attributeName = DirectiveUtil.normalizeAttributeName(parent.getName());
        XmlAttributeDescriptor descriptor = AngularJSAttributeDescriptorsProvider.getDescriptor(attributeName, parent.getParent());
        PsiElement psiElement = directive = descriptor != null ? descriptor.getDeclaration() : null;
        if (directive instanceof JSImplicitElement) {
            String restrict = ((JSImplicitElement)directive).getTypeString();
            String[] args = restrict != null ? restrict.split(";", -1) : null;
            String string = args != null && args.length > 2 ? args[2] : "";
            if (string == null) {
                AngularAttributesRegistry.$$$reportNull$$$0(1);
            }
            return string;
        }
        if ("" == null) {
            AngularAttributesRegistry.$$$reportNull$$$0(2);
        }
        return "";
    }

    public static boolean isEventAttribute(String name, Project project) {
        return name.startsWith("(") && name.endsWith(")") && AngularIndexUtil.hasAngularJS2(project);
    }

    public static boolean isVariableAttribute(String name, Project project) {
        return name.startsWith("#") && AngularIndexUtil.hasAngularJS2(project);
    }

    public static boolean isTemplateAttribute(String name, Project project) {
        return name.startsWith("*") && AngularIndexUtil.hasAngularJS2(project);
    }

    public static boolean isBindingAttribute(String name, Project project) {
        return name.startsWith("[") && name.endsWith("]") && AngularIndexUtil.hasAngularJS2(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directiveName";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/angularjs/codeInsight/attributes/AngularAttributesRegistry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/angularjs/codeInsight/attributes/AngularAttributesRegistry";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createDescriptor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

