/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.gradle.api.internal.changedetection.state.ValueSnapshot;
import org.gradle.api.internal.changedetection.state.ValueSnapshotter;
import org.gradle.caching.internal.BuildCacheHasher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapValueSnapshot
implements ValueSnapshot {
    private final ImmutableMap<ValueSnapshot, ValueSnapshot> entries;

    public MapValueSnapshot(ImmutableMap<ValueSnapshot, ValueSnapshot> entries) {
        this.entries = entries;
    }

    public ImmutableMap<ValueSnapshot, ValueSnapshot> getEntries() {
        return this.entries;
    }

    @Override
    public void appendToHasher(BuildCacheHasher hasher) {
        hasher.putString("Map");
        hasher.putInt(this.entries.size());
        for (Map.Entry entry : this.entries.entrySet()) {
            ((ValueSnapshot)entry.getKey()).appendToHasher(hasher);
            ((ValueSnapshot)entry.getValue()).appendToHasher(hasher);
        }
    }

    @Override
    public ValueSnapshot snapshot(Object value, ValueSnapshotter snapshotter) {
        ValueSnapshot newSnapshot = snapshotter.snapshot(value);
        if (newSnapshot instanceof MapValueSnapshot) {
            MapValueSnapshot mapSnapshot = (MapValueSnapshot)newSnapshot;
            if (this.entries.equals(mapSnapshot.entries)) {
                return this;
            }
        }
        return newSnapshot;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        MapValueSnapshot other = (MapValueSnapshot)obj;
        return this.entries.equals(other.entries);
    }

    public int hashCode() {
        return this.entries.hashCode();
    }
}

