/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.maven;

import com.intellij.javascript.flex.maven.FlexConfigInformer;
import com.intellij.javascript.flex.maven.Flexmojos3Configurator;
import com.intellij.javascript.flex.maven.Flexmojos4Configurator;
import com.intellij.javascript.flex.maven.Flexmojos5Configurator;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.FlexModuleType;
import com.intellij.lang.javascript.flex.projectStructure.FlexBuildConfigurationsExtension;
import com.intellij.lang.javascript.flex.projectStructure.model.BuildConfigurationEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.FlexProjectConfigurationEditor;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PairConsumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.event.HyperlinkEvent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.MavenExtraArtifactType;
import org.jetbrains.idea.maven.importing.MavenImporter;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapter;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.project.ResolveContext;
import org.jetbrains.idea.maven.project.SupportedRequestType;
import org.jetbrains.idea.maven.server.MavenEmbedderWrapper;
import org.jetbrains.idea.maven.server.NativeMavenProjectHolder;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class FlexmojosImporter
extends MavenImporter
implements FlexConfigInformer {
    static final String[] SUPPORTED_PACKAGINGS = new String[]{"swf", "swc", "air"};
    static final String FLEXMOJOS_GROUP_ID = "org.sonatype.flexmojos";
    static final String FLEXMOJOS_ARTIFACT_ID = "flexmojos-maven-plugin";
    private static final List<String> DEPENDENCY_TYPES_FOR_IMPORT = Arrays.asList("swf", "swc", "ane", "resource-bundle", "rb.swc");
    private static final List<String> DEPENDENCY_TYPES_FOR_COMPLETION = Arrays.asList("swf", "swc", "ane", "resource-bundle", "rb.swc");
    private Notification myFlexConfigNotification;

    public FlexmojosImporter() {
        super(FLEXMOJOS_GROUP_ID, FLEXMOJOS_ARTIFACT_ID);
    }

    protected FlexmojosImporter(String pluginGroupID, String pluginArtifactID) {
        super(pluginGroupID, pluginArtifactID);
    }

    public boolean isApplicable(MavenProject mavenProject) {
        return ArrayUtil.contains((String)mavenProject.getPackaging(), (String[])SUPPORTED_PACKAGINGS) && super.isApplicable(mavenProject);
    }

    @NotNull
    public ModuleType getModuleType() {
        FlexModuleType flexModuleType = FlexModuleType.getInstance();
        if (flexModuleType == null) {
            FlexmojosImporter.$$$reportNull$$$0(0);
        }
        return flexModuleType;
    }

    public void getSupportedPackagings(Collection<String> result) {
        Collections.addAll(result, SUPPORTED_PACKAGINGS);
    }

    public void getSupportedDependencyTypes(Collection<String> result, SupportedRequestType type) {
        result.addAll(type == SupportedRequestType.FOR_COMPLETION ? DEPENDENCY_TYPES_FOR_COMPLETION : DEPENDENCY_TYPES_FOR_IMPORT);
    }

    public void getSupportedDependencyScopes(Collection<String> result) {
        Collections.addAll(result, "merged", "internal", "external", "caching", "rsl");
    }

    public void resolve(Project project, MavenProject mavenProject, NativeMavenProjectHolder nativeMavenProject, MavenEmbedderWrapper embedder, ResolveContext context) throws MavenProcessCanceledException {
        MavenPlugin plugin = this.getFlexmojosPlugin(mavenProject);
        String version = plugin.getVersion();
        if (version != null && StringUtil.compareVersionNumbers((String)version, (String)"4") < 0) {
            embedder.resolvePlugin(plugin, mavenProject.getRemoteRepositories(), nativeMavenProject, true);
        }
    }

    @NotNull
    private MavenPlugin getFlexmojosPlugin(MavenProject mavenProject) {
        MavenPlugin plugin = mavenProject.findPlugin(this.myPluginGroupID, this.myPluginArtifactID);
        assert (plugin != null);
        MavenPlugin mavenPlugin = plugin;
        if (mavenPlugin == null) {
            FlexmojosImporter.$$$reportNull$$$0(1);
        }
        return mavenPlugin;
    }

    static boolean isFlexmojos3(MavenPlugin plugin) {
        String version = plugin.getVersion();
        return version != null && version.startsWith("3.");
    }

    @Nullable
    public Pair<String, String> getExtraArtifactClassifierAndExtension(MavenArtifact artifact, MavenExtraArtifactType type) {
        if (!DEPENDENCY_TYPES_FOR_IMPORT.contains(artifact.getType())) {
            return null;
        }
        if (type == MavenExtraArtifactType.DOCS) {
            return Pair.create((Object)"asdoc", (Object)"zip");
        }
        return null;
    }

    static boolean isFlexApp(MavenProject project) {
        return "swf".equals(project.getPackaging()) || "air".equals(project.getPackaging());
    }

    public void preProcess(Module module, MavenProject mavenProject, MavenProjectChanges changes, IdeModifiableModelsProvider modifiableModelsProvider) {
    }

    public void process(IdeModifiableModelsProvider modelsProvider, Module module, final MavenRootModelAdapter modelAdapter, MavenProjectsTree mavenTree, MavenProject mavenProject, MavenProjectChanges changes, Map<MavenProject, String> mavenProjectToModuleName, List<MavenProjectsProcessorTask> postTasks) {
        this.expireNotification();
        FlexProjectConfigurationEditor currentEditor = FlexBuildConfigurationsExtension.getInstance().getConfigurator().getConfigEditor();
        boolean needToCommit = currentEditor == null;
        LibraryTable.ModifiableModel projectLibrariesModel = modelsProvider.getModifiableProjectLibrariesModel();
        Map<Module, ModifiableRootModel> moduleToModifiableModel = Collections.singletonMap(module, modelAdapter.getRootModel());
        FlexProjectConfigurationEditor flexEditor = currentEditor != null ? currentEditor : new FlexProjectConfigurationEditor(module.getProject(), FlexProjectConfigurationEditor.createModelProvider(moduleToModifiableModel, projectLibrariesModel, null)){

            @Override
            @Nullable
            protected Module findModuleWithBC(BuildConfigurationEntry bcEntry) {
                return modelAdapter.findModuleByName(bcEntry.getModuleName());
            }
        };
        MavenPlugin flexmojosPlugin = this.getFlexmojosPlugin(mavenProject);
        Flexmojos3Configurator configurator = StringUtil.compareVersionNumbers((String)flexmojosPlugin.getVersion(), (String)"5") >= 0 ? new Flexmojos5Configurator(module, modelsProvider, flexEditor, mavenTree, mavenProjectToModuleName, mavenProject, flexmojosPlugin, this.getCompiledLocales(mavenProject), this.getRuntimeLocales(mavenProject), this) : (StringUtil.compareVersionNumbers((String)flexmojosPlugin.getVersion(), (String)"4") >= 0 ? new Flexmojos4Configurator(module, modelsProvider, flexEditor, mavenTree, mavenProjectToModuleName, mavenProject, flexmojosPlugin, this.getCompiledLocales(mavenProject), this.getRuntimeLocales(mavenProject), this) : new Flexmojos3Configurator(module, modelsProvider, flexEditor, mavenTree, mavenProjectToModuleName, mavenProject, flexmojosPlugin, this.getCompiledLocales(mavenProject), this.getRuntimeLocales(mavenProject), this));
        configurator.configureAndAppendTasks(postTasks);
        if (needToCommit) {
            try {
                flexEditor.commit();
            }
            catch (ConfigurationException e) {
                MavenLog.LOG.error((Throwable)e);
            }
        }
    }

    public void collectSourceRoots(MavenProject mavenProject, PairConsumer<String, JpsModuleSourceRootType<?>> result) {
        String localesDir = this.findConfigValue(mavenProject, "resourceBundlePath", "src/main/locales/{locale}");
        assert (localesDir != null);
        for (String locale : this.getCompiledLocales(mavenProject)) {
            result.consume((Object)localesDir.replace("{locale}", locale), (Object)JavaSourceRootType.SOURCE);
        }
        for (String locale : this.getRuntimeLocales(mavenProject)) {
            result.consume((Object)localesDir.replace("{locale}", locale), (Object)JavaSourceRootType.SOURCE);
        }
    }

    private List<String> getRuntimeLocales(MavenProject mavenProject) {
        String elementName = FlexmojosImporter.isFlexmojos3(this.getFlexmojosPlugin(mavenProject)) ? "runtimeLocales" : "localesRuntime";
        Element localesElement = this.getConfig(mavenProject, elementName);
        return localesElement == null ? Collections.emptyList() : FlexmojosImporter.getChildrenValues(localesElement);
    }

    private List<String> getCompiledLocales(MavenProject mavenProject) {
        String defaultLocale;
        boolean flexmojos3 = FlexmojosImporter.isFlexmojos3(this.getFlexmojosPlugin(mavenProject));
        String elementName = flexmojos3 ? "compiledLocales" : "localesCompiled";
        Element localesElement = this.getConfig(mavenProject, elementName);
        if (flexmojos3 && localesElement == null) {
            localesElement = this.getConfig(mavenProject, "locales");
        }
        if (localesElement != null) {
            return FlexmojosImporter.getChildrenValues(localesElement);
        }
        if (FlexmojosImporter.isFlexApp(mavenProject) && (defaultLocale = this.getDefaultLocale(mavenProject)) != null) {
            return Collections.singletonList(defaultLocale);
        }
        return Collections.emptyList();
    }

    private static List<String> getChildrenValues(Element element) {
        ArrayList<String> result = new ArrayList<String>();
        for (Element child : element.getChildren()) {
            String childValue = child.getTextNormalize();
            if (StringUtil.isEmptyOrSpaces((String)childValue)) continue;
            result.add(childValue);
        }
        return result;
    }

    @Nullable
    private String getDefaultLocale(MavenProject mavenProject) {
        return "true".equals(this.findConfigValue(mavenProject, "useDefaultLocale", "true")) ? this.findConfigValue(mavenProject, "defaultLocale", "en_US") : null;
    }

    @Override
    public synchronized void showFlexConfigWarningIfNeeded(Project project) {
        if (this.myFlexConfigNotification != null) {
            return;
        }
        this.doShowFlexConfigWarning(project);
    }

    private synchronized void doShowFlexConfigWarning(final Project project) {
        NotificationListener listener = new NotificationListener(){

            public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                if (notification == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (event == null) {
                    2.$$$reportNull$$$0(1);
                }
                Messages.showWarningDialog((Project)project, (String)FlexBundle.message("flexmojos.warning.detailed", new Object[0]), (String)FlexBundle.message("flexmojos.project.import", new Object[0]));
                notification.expire();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/javascript/flex/maven/FlexmojosImporter$2";
                objectArray[2] = "hyperlinkUpdate";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.myFlexConfigNotification = new Notification("Maven", FlexBundle.message("flexmojos.project.import", new Object[0]), FlexBundle.message("flexmojos.warning.short", new Object[0]), NotificationType.WARNING, listener);
        this.myFlexConfigNotification.notify(project);
    }

    protected synchronized void expireNotification() {
        if (this.myFlexConfigNotification != null && !this.myFlexConfigNotification.isExpired()) {
            this.myFlexConfigNotification.expire();
        }
        this.myFlexConfigNotification = null;
    }

    public static String getOutputFilePath(MavenProject mavenProject) {
        String overriddenTargetFilePath;
        MavenPlugin flexmojosPlugin = mavenProject.findPlugin(FLEXMOJOS_GROUP_ID, FLEXMOJOS_ARTIFACT_ID);
        if (flexmojosPlugin == null) {
            flexmojosPlugin = mavenProject.findPlugin("net.flexmojos.oss", FLEXMOJOS_ARTIFACT_ID);
        }
        Element configurationElement = flexmojosPlugin == null ? null : flexmojosPlugin.getConfigurationElement();
        String string = overriddenTargetFilePath = configurationElement == null || StringUtil.compareVersionNumbers((String)flexmojosPlugin.getVersion(), (String)"4") >= 0 ? null : configurationElement.getChildTextNormalize("output", configurationElement.getNamespace());
        if (overriddenTargetFilePath != null && !overriddenTargetFilePath.isEmpty()) {
            return FileUtil.isAbsolute((String)overriddenTargetFilePath) ? FileUtil.toSystemIndependentName((String)overriddenTargetFilePath) : FileUtil.toSystemIndependentName((String)(mavenProject.getDirectory() + "/" + overriddenTargetFilePath));
        }
        String classifier = configurationElement == null ? null : configurationElement.getChildTextNormalize("classifier", configurationElement.getNamespace());
        String suffix = classifier == null ? "" : "-" + classifier;
        String fileExtension = "swc".equals(mavenProject.getPackaging()) ? "swc" : "swf";
        return FileUtil.toSystemIndependentName((String)mavenProject.getBuildDirectory()) + "/" + mavenProject.getFinalName() + suffix + "." + fileExtension;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/javascript/flex/maven/FlexmojosImporter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFlexmojosPlugin";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

