/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.resolve;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flex.JSResolveHelper;
import com.intellij.lang.javascript.index.JSIndexedRootProvider;
import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSQualifiedElementIndex;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.util.indexing.AdditionalIndexedRootsScope;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionScriptClassResolver
extends JSClassResolver {
    private static ActionScriptClassResolver INSTANCE = null;

    protected ActionScriptClassResolver() {
    }

    public static ActionScriptClassResolver getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ActionScriptClassResolver();
        }
        return INSTANCE;
    }

    public PsiElement findClassByQName(@NotNull String link, @NotNull PsiElement context) {
        if (link == null) {
            ActionScriptClassResolver.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ActionScriptClassResolver.$$$reportNull$$$0(1);
        }
        return ActionScriptClassResolver.findClassByQNameStatic(link, context);
    }

    public static PsiElement findClassByQNameStatic(@NotNull String link, @NotNull PsiElement context) {
        if (link == null) {
            ActionScriptClassResolver.$$$reportNull$$$0(2);
        }
        if (context == null) {
            ActionScriptClassResolver.$$$reportNull$$$0(3);
        }
        return ActionScriptClassResolver.getInstance().findClassByQName(link, JavaScriptIndex.getInstance((Project)context.getProject()), JSResolveUtil.getResolveScope((PsiElement)context), DialectOptionHolder.ECMA_4);
    }

    public static PsiElement findClassByQName(@NotNull String link, JavaScriptIndex index, Module module) {
        GlobalSearchScope searchScope;
        if (link == null) {
            ActionScriptClassResolver.$$$reportNull$$$0(4);
        }
        if ((searchScope = JSInheritanceUtil.getEnforcedScope()) == null) {
            searchScope = module != null ? GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module) : GlobalSearchScope.allScope((Project)index.getProject());
        }
        return ActionScriptClassResolver.getInstance().findClassByQName(link, index, searchScope, DialectOptionHolder.ECMA_4);
    }

    @Nullable
    public PsiElement findClassByQName(@NotNull String link, @NotNull GlobalSearchScope scope) {
        if (link == null) {
            ActionScriptClassResolver.$$$reportNull$$$0(5);
        }
        if (scope == null) {
            ActionScriptClassResolver.$$$reportNull$$$0(6);
        }
        return ActionScriptClassResolver.findClassByQNameStatic(link, scope);
    }

    public static PsiElement findClassByQNameStatic(@NotNull String link, @NotNull GlobalSearchScope scope) {
        if (link == null) {
            ActionScriptClassResolver.$$$reportNull$$$0(7);
        }
        if (scope == null) {
            ActionScriptClassResolver.$$$reportNull$$$0(8);
        }
        return ActionScriptClassResolver.getInstance().findClassByQName(link, JavaScriptIndex.getInstance((Project)scope.getProject()), scope, DialectOptionHolder.ECMA_4);
    }

    public static boolean isParentClass(JSClass clazz, String className) {
        return ActionScriptClassResolver.isParentClass(clazz, className, true);
    }

    public static boolean isParentClass(JSClass clazz, String className, boolean strict) {
        PsiElement parentClass = ActionScriptClassResolver.findClassByQNameStatic(className, clazz.getResolveScope());
        if (!(parentClass instanceof JSClass)) {
            return false;
        }
        return JSInheritanceUtil.isParentClass((JSClass)clazz, (JSClass)((JSClass)parentClass), (boolean)strict);
    }

    protected PsiElement doFindClassByQName(@NotNull String link, JavaScriptIndex index, GlobalSearchScope searchScope, boolean allowFileLocalSymbols, @NotNull DialectOptionHolder dialect) {
        String className;
        PsiElement result;
        boolean clazzShouldBeTakenFromOurLibrary;
        if (link == null) {
            ActionScriptClassResolver.$$$reportNull$$$0(9);
        }
        if (dialect == null) {
            ActionScriptClassResolver.$$$reportNull$$$0(10);
        }
        Project project = index.getProject();
        boolean bl = clazzShouldBeTakenFromOurLibrary = "Object".equals(link) || "Arguments".equals(link);
        if (clazzShouldBeTakenFromOurLibrary && !(searchScope instanceof AdditionalIndexedRootsScope)) {
            searchScope = new AdditionalIndexedRootsScope(searchScope, JSIndexedRootProvider.class);
        }
        Collection candidates = StubIndex.getElements((StubIndexKey)JSQualifiedElementIndex.KEY, (Object)link.hashCode(), (Project)project, (GlobalSearchScope)searchScope, JSQualifiedNamedElement.class);
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        PsiElement resultFromSourceContent = null;
        PsiElement resultFromLibraries = null;
        long resultFromLibrariesTimestamp = 0L;
        for (JSQualifiedNamedElement classCandidate : candidates) {
            long classTimestamp;
            PsiFile file;
            JSQualifiedNamedElement clazz;
            if (!(classCandidate instanceof JSQualifiedNamedElement) || JSResolveUtil.isConstructorFunction((PsiElement)classCandidate) || !link.equals((clazz = classCandidate).getQualifiedName()) || !(file = clazz.getContainingFile()).getLanguage().isKindOf((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4)) continue;
            VirtualFile vFile = file.getVirtualFile();
            if (clazzShouldBeTakenFromOurLibrary && !"ECMAScript.js2".equals(vFile.getName()) || !allowFileLocalSymbols && ActionScriptResolveUtil.isFileLocalSymbol((PsiElement)clazz)) continue;
            if (projectFileIndex.isInSourceContent(vFile)) {
                resultFromSourceContent = clazz;
                continue;
            }
            if (resultFromLibraries == null) {
                resultFromLibraries = clazz;
                continue;
            }
            if ("Vector".equals(link)) {
                if (!(clazz instanceof JSClass) || !(resultFromLibraries instanceof JSClass) || ((JSClass)clazz).getFunctions().length <= ((JSClass)resultFromLibraries).getFunctions().length) continue;
                resultFromLibraries = clazz;
                continue;
            }
            if (resultFromLibrariesTimestamp == 0L) {
                resultFromLibrariesTimestamp = ActionScriptClassResolver.getResolveResultTimestamp((PsiElement)resultFromLibraries);
            }
            if ((classTimestamp = ActionScriptClassResolver.getResolveResultTimestamp((PsiElement)clazz)) <= resultFromLibrariesTimestamp) continue;
            resultFromLibraries = clazz;
            resultFromLibrariesTimestamp = classTimestamp;
        }
        PsiElement psiElement = result = resultFromSourceContent != null ? resultFromSourceContent : resultFromLibraries;
        if (result == null && (className = link.substring(link.lastIndexOf(46) + 1)).length() > 0 && !ActionScriptClassResolver.isBuiltInClassName(className) && (Character.isLetter(className.charAt(0)) || '_' == className.charAt(0))) {
            result = ActionScriptClassResolver.findClassByQNameViaHelper(link, project, className, searchScope);
        }
        return result;
    }

    private static boolean isBuiltInClassName(String className) {
        return "Object".equals(className) || "Boolean".equals(className) || "Function".equals(className) || "String".equals(className);
    }

    @Nullable
    private static PsiElement findClassByQNameViaHelper(String link, Project project, String className, GlobalSearchScope scope) {
        for (JSResolveHelper helper : (JSResolveHelper[])Extensions.getExtensions((ExtensionPointName)JSResolveHelper.EP_NAME)) {
            PsiElement result = helper.findClassByQName(link, project, className, scope);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @NotNull
    public List<JSClass> findClassesByQName(@NotNull String qName, @NotNull GlobalSearchScope scope) {
        PsiElement clazz;
        if (qName == null) {
            ActionScriptClassResolver.$$$reportNull$$$0(11);
        }
        if (scope == null) {
            ActionScriptClassResolver.$$$reportNull$$$0(12);
        }
        List<JSClass> list = (clazz = this.findClassByQName(qName, scope)) instanceof JSClass ? Collections.singletonList((JSClass)clazz) : Collections.emptyList();
        if (list == null) {
            ActionScriptClassResolver.$$$reportNull$$$0(13);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "link";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/flex/resolve/ActionScriptClassResolver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/flex/resolve/ActionScriptClassResolver";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findClassesByQName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findClassByQName";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findClassByQNameStatic";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doFindClassByQName";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findClassesByQName";
                break;
            }
            case 13: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

