/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.resolve;

import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.parsing.xml.XmlBuilder;
import com.intellij.psi.impl.source.parsing.xml.XmlBuilderDriver;
import com.intellij.util.Consumer;
import com.intellij.util.containers.Stack;
import com.intellij.util.containers.StringInterner;
import gnu.trove.THashMap;
import gnu.trove.TObjectLongHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SwcCatalogXmlUtil {
    private static final Key<Pair<Long, THashMap<String, TObjectLongHashMap<String>>>> MOD_STAMP_AND_SWF_NAME_TO_QNAME_WITH_TIMESTAMP_MAP = Key.create((String)"MOD_STAMP_AND_SWF_NAME_TO_QNAME_WITH_TIMESTAMP_MAP");
    private static final Key<Long> TIMESTAMP_IN_CATALOG_XML = Key.create((String)"TIMESTAMP_IN_CATALOG_XML");
    private static final Key<Pair<Long, ComponentFromCatalogXml[]>> MOD_STAMP_AND_COMPONENTS_FROM_CATALOG_XML = Key.create((String)"MOD_STAMP_AND_COMPONENTS_FROM_CATALOG_XML");
    private static final Key<Pair<Long, ComponentFromManifest[]>> MOD_STAMP_AND_COMPONENTS_FROM_MANIFEST = Key.create((String)"MOD_STAMP_AND_COMPONENTS_FROM_MANIFEST");

    private SwcCatalogXmlUtil() {
    }

    public static long getTimestampFromCatalogXml(@NotNull PsiElement psiElement) {
        TObjectLongHashMap qnameWithTimestampMap;
        VirtualFile catalogFile;
        Long cachedTimestamp;
        if (psiElement == null) {
            SwcCatalogXmlUtil.$$$reportNull$$$0(0);
        }
        if ((cachedTimestamp = (Long)psiElement.getUserData(TIMESTAMP_IN_CATALOG_XML)) != null) {
            return cachedTimestamp;
        }
        if (!(psiElement instanceof JSQualifiedNamedElement)) {
            return -1L;
        }
        String qName = ((JSQualifiedNamedElement)psiElement).getQualifiedName();
        if (StringUtil.isEmpty((String)qName)) {
            return -1L;
        }
        PsiFile psiFile = psiElement.getContainingFile();
        if ("ECMAScript.js2".equals(psiFile.getName())) {
            return Integer.MIN_VALUE;
        }
        VirtualFile swfFile = psiFile.getVirtualFile();
        VirtualFile dir = swfFile != null && "swf".equalsIgnoreCase(swfFile.getExtension()) ? swfFile.getParent() : null;
        VirtualFile virtualFile = catalogFile = dir == null ? null : dir.findChild("catalog.xml");
        if (catalogFile == null) {
            return -1L;
        }
        Pair modStampAndSwfNameToQnameWithTimestampMap = (Pair)catalogFile.getUserData(MOD_STAMP_AND_SWF_NAME_TO_QNAME_WITH_TIMESTAMP_MAP);
        if (modStampAndSwfNameToQnameWithTimestampMap == null || ((Long)modStampAndSwfNameToQnameWithTimestampMap.first).longValue() != catalogFile.getModificationStamp()) {
            THashMap<String, TObjectLongHashMap<String>> swfNameToQnameWithTimestampMap = SwcCatalogXmlUtil.parseTimestampsFromCatalogXml(catalogFile);
            modStampAndSwfNameToQnameWithTimestampMap = Pair.create((Object)catalogFile.getModificationStamp(), swfNameToQnameWithTimestampMap);
            catalogFile.putUserData(MOD_STAMP_AND_SWF_NAME_TO_QNAME_WITH_TIMESTAMP_MAP, (Object)modStampAndSwfNameToQnameWithTimestampMap);
        }
        long timestamp = (qnameWithTimestampMap = (TObjectLongHashMap)((THashMap)modStampAndSwfNameToQnameWithTimestampMap.second).get((Object)swfFile.getName())) == null ? -1L : qnameWithTimestampMap.get((Object)qName);
        psiElement.putUserData(TIMESTAMP_IN_CATALOG_XML, (Object)timestamp);
        return timestamp;
    }

    private static THashMap<String, TObjectLongHashMap<String>> parseTimestampsFromCatalogXml(@NotNull VirtualFile catalogFile) {
        if (catalogFile == null) {
            SwcCatalogXmlUtil.$$$reportNull$$$0(1);
        }
        THashMap swfNameToQnameWithTimestampMap = new THashMap(1);
        try {
            Element rootElement = JDOMUtil.load((InputStream)catalogFile.getInputStream());
            if (rootElement != null && "swc".equals(rootElement.getName())) {
                for (Element librariesElement : rootElement.getChildren("libraries", rootElement.getNamespace())) {
                    for (Element libraryElement : librariesElement.getChildren("library", librariesElement.getNamespace())) {
                        String swfName = libraryElement.getAttributeValue("path");
                        if (StringUtil.isEmpty((String)swfName)) continue;
                        TObjectLongHashMap qNameWithTimestampMap = new TObjectLongHashMap();
                        swfNameToQnameWithTimestampMap.put((Object)swfName, (Object)qNameWithTimestampMap);
                        for (Element scriptElement : libraryElement.getChildren("script", libraryElement.getNamespace())) {
                            String mod = scriptElement.getAttributeValue("mod");
                            if (StringUtil.isEmpty((String)mod)) continue;
                            try {
                                long timestamp = Long.parseLong(mod);
                                for (Element defElement : scriptElement.getChildren("def", scriptElement.getNamespace())) {
                                    String id = defElement.getAttributeValue("id");
                                    if (StringUtil.isEmpty((String)id)) continue;
                                    String fqn = id.replace(':', '.');
                                    qNameWithTimestampMap.put((Object)fqn, timestamp);
                                }
                            }
                            catch (NumberFormatException numberFormatException) {
                            }
                        }
                    }
                }
            }
        }
        catch (JDOMException jDOMException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return swfNameToQnameWithTimestampMap;
    }

    public static void processComponentsFromCatalogXml(VirtualFile catalogFile, Consumer<ComponentFromCatalogXml> consumer) {
        Pair modStampAndComponents = (Pair)catalogFile.getUserData(MOD_STAMP_AND_COMPONENTS_FROM_CATALOG_XML);
        if (modStampAndComponents == null || ((Long)modStampAndComponents.first).longValue() != catalogFile.getModificationStamp()) {
            ComponentFromCatalogXml[] componentsFromCatalogXml = SwcCatalogXmlUtil.parseComponentsFromCatalogXml(catalogFile);
            modStampAndComponents = Pair.create((Object)catalogFile.getModificationStamp(), (Object)componentsFromCatalogXml);
            catalogFile.putUserData(MOD_STAMP_AND_COMPONENTS_FROM_CATALOG_XML, (Object)modStampAndComponents);
        }
        for (ComponentFromCatalogXml componentFromCatalogXml : (ComponentFromCatalogXml[])modStampAndComponents.second) {
            consumer.consume((Object)componentFromCatalogXml);
        }
    }

    private static ComponentFromCatalogXml[] parseComponentsFromCatalogXml(VirtualFile catalogFile) {
        final ArrayList result = new ArrayList();
        XmlBuilderAdapter xmlBuilder = new XmlBuilderAdapter(){
            private static final String COMPONENT_LOCATION = ".swc.components.component";
            private static final String NAME = "name";
            private static final String CLASS_NAME = "className";
            private static final String URI = "uri";
            private static final String ICON = "icon";
            private String myNameAttr = null;
            private String myClassNameAttr = null;
            private String myUriAttr = null;
            private String myIconAttr = null;
            private final StringInterner myStringInterner = new StringInterner();

            @Override
            public void attribute(CharSequence name, CharSequence value, int start, int end) {
                if (COMPONENT_LOCATION.equals(this.getLocation())) {
                    if (NAME.equals(name)) {
                        this.myNameAttr = value.toString().trim();
                    } else if (CLASS_NAME.equals(name)) {
                        this.myClassNameAttr = value.toString().trim();
                    } else if (URI.equals(name)) {
                        this.myUriAttr = value.toString().trim();
                    } else if (ICON.equals(name)) {
                        this.myIconAttr = value.toString().trim();
                    }
                }
            }

            @Override
            public void endTag(CharSequence localName, String namespace, int start, int end) {
                if (COMPONENT_LOCATION.equals(this.getLocation())) {
                    if (StringUtil.isNotEmpty((String)this.myNameAttr) && StringUtil.isNotEmpty((String)this.myClassNameAttr) && StringUtil.isNotEmpty((String)this.myUriAttr)) {
                        result.add(new ComponentFromCatalogXml(new String(this.myNameAttr), new String(this.myClassNameAttr.replace(":", ".")), (String)this.myStringInterner.intern((Object)new String(this.myUriAttr)), this.myIconAttr != null ? new String(this.myIconAttr) : null));
                    }
                    this.myNameAttr = null;
                    this.myClassNameAttr = null;
                    this.myUriAttr = null;
                    this.myIconAttr = null;
                }
                super.endTag(localName, namespace, start, end);
            }
        };
        try {
            new XmlBuilderDriver((CharSequence)VfsUtilCore.loadText((VirtualFile)catalogFile)).build((XmlBuilder)xmlBuilder);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result.toArray(new ComponentFromCatalogXml[result.size()]);
    }

    public static void processManifestFile(VirtualFile manifestFile, Consumer<ComponentFromManifest> consumer) {
        Pair modStampAndComponents = (Pair)manifestFile.getUserData(MOD_STAMP_AND_COMPONENTS_FROM_MANIFEST);
        if (modStampAndComponents == null || ((Long)modStampAndComponents.first).longValue() != manifestFile.getModificationStamp()) {
            ComponentFromManifest[] componentsFromManifests = SwcCatalogXmlUtil.parseManifestFile(manifestFile);
            modStampAndComponents = Pair.create((Object)manifestFile.getModificationStamp(), (Object)componentsFromManifests);
            manifestFile.putUserData(MOD_STAMP_AND_COMPONENTS_FROM_MANIFEST, (Object)modStampAndComponents);
        }
        for (ComponentFromManifest componentFromManifest : (ComponentFromManifest[])modStampAndComponents.second) {
            consumer.consume((Object)componentFromManifest);
        }
    }

    private static ComponentFromManifest[] parseManifestFile(VirtualFile manifestFile) {
        final ArrayList result = new ArrayList();
        XmlBuilderAdapter builder = new XmlBuilderAdapter(){
            private static final String COMPONENT = "component";
            private static final String ID = "id";
            private static final String CLASS = "class";
            private String idAttr = null;
            private String classAttr = null;

            @Override
            public void attribute(CharSequence name, CharSequence value, int start, int end) {
                if (ID.equals(name.toString())) {
                    this.idAttr = value.toString().trim();
                } else if (CLASS.equals(name.toString())) {
                    this.classAttr = value.toString().trim();
                }
            }

            @Override
            public void endTag(CharSequence localName, String namespace, int start, int end) {
                if (COMPONENT.equals(localName) && StringUtil.isNotEmpty((String)this.classAttr)) {
                    String classFqn = this.classAttr.replace(":", ".");
                    String componentName = this.idAttr != null ? this.idAttr : this.classAttr.substring(classFqn.lastIndexOf(46) + 1);
                    result.add(new ComponentFromManifest(new String(componentName), new String(classFqn)));
                }
                this.idAttr = null;
                this.classAttr = null;
                super.endTag(localName, namespace, start, end);
            }
        };
        try {
            new XmlBuilderDriver((CharSequence)VfsUtilCore.loadText((VirtualFile)manifestFile)).build((XmlBuilder)builder);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result.toArray(new ComponentFromManifest[result.size()]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "catalogFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/flex/resolve/SwcCatalogXmlUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getTimestampFromCatalogXml";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "parseTimestampsFromCatalogXml";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class XmlBuilderAdapter
    implements XmlBuilder {
        private final Stack<String> myLocation = new Stack();

        public XmlBuilderAdapter() {
            this.myLocation.push((Object)"");
        }

        public String getLocation() {
            return (String)this.myLocation.peek();
        }

        public void doctype(@Nullable CharSequence publicId, @Nullable CharSequence systemId, int start, int end) {
        }

        public XmlBuilder.ProcessingOrder startTag(CharSequence localName, String namespace, int start, int end, int headerEnd) {
            this.myLocation.push((Object)((String)this.myLocation.peek() + "." + localName));
            return XmlBuilder.ProcessingOrder.TAGS_AND_ATTRIBUTES;
        }

        public void endTag(CharSequence localName, String namespace, int start, int end) {
            this.myLocation.pop();
        }

        public void attribute(CharSequence name, CharSequence value, int start, int end) {
        }

        public void textElement(CharSequence display, CharSequence physical, int start, int end) {
        }

        public void entityRef(CharSequence ref, int start, int end) {
        }

        public void error(String message, int start, int end) {
        }
    }

    public static class ComponentFromManifest {
        @NotNull
        public final String myComponentName;
        @NotNull
        public final String myClassFqn;

        private ComponentFromManifest(@NotNull String componentName, @NotNull String classFqn) {
            if (componentName == null) {
                ComponentFromManifest.$$$reportNull$$$0(0);
            }
            if (classFqn == null) {
                ComponentFromManifest.$$$reportNull$$$0(1);
            }
            this.myComponentName = componentName;
            this.myClassFqn = classFqn;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "componentName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "classFqn";
                    break;
                }
            }
            objectArray[1] = "com/intellij/javascript/flex/resolve/SwcCatalogXmlUtil$ComponentFromManifest";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ComponentFromCatalogXml {
        @NotNull
        public final String myName;
        @NotNull
        public final String myClassFqn;
        @NotNull
        public final String myUri;
        @Nullable
        public final String myIcon;

        private ComponentFromCatalogXml(@NotNull String name, @NotNull String classFqn, @NotNull String uri, @Nullable String icon) {
            if (name == null) {
                ComponentFromCatalogXml.$$$reportNull$$$0(0);
            }
            if (classFqn == null) {
                ComponentFromCatalogXml.$$$reportNull$$$0(1);
            }
            if (uri == null) {
                ComponentFromCatalogXml.$$$reportNull$$$0(2);
            }
            this.myName = name;
            this.myClassFqn = classFqn;
            this.myUri = uri.intern();
            this.myIcon = icon;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "classFqn";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "uri";
                    break;
                }
            }
            objectArray[1] = "com/intellij/javascript/flex/resolve/SwcCatalogXmlUtil$ComponentFromCatalogXml";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

