/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.debug;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.flex.model.bc.TargetPlatform;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.actions.airpackage.AirPackageUtil;
import com.intellij.lang.javascript.flex.actions.airpackage.DeviceInfo;
import com.intellij.lang.javascript.flex.flexunit.FlexUnitRunConfiguration;
import com.intellij.lang.javascript.flex.flexunit.FlexUnitRunnerParameters;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.lang.javascript.flex.run.FlashRunConfiguration;
import com.intellij.lang.javascript.flex.run.FlashRunnerParameters;
import com.intellij.lang.javascript.flex.run.FlexBaseRunner;
import com.intellij.lang.javascript.flex.run.RemoteFlashRunConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class FlexDebugRunner
extends FlexBaseRunner {
    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            FlexDebugRunner.$$$reportNull$$$0(0);
        }
        if (profile == null) {
            FlexDebugRunner.$$$reportNull$$$0(1);
        }
        return DefaultDebugExecutor.EXECUTOR_ID.equals(executorId) && (profile instanceof FlashRunConfiguration || profile instanceof FlexUnitRunConfiguration || profile instanceof RemoteFlashRunConfiguration);
    }

    @NotNull
    public String getRunnerId() {
        if ("FlexDebugRunner" == null) {
            FlexDebugRunner.$$$reportNull$$$0(2);
        }
        return "FlexDebugRunner";
    }

    @Override
    protected RunContentDescriptor launchWebFlexUnit(Project project, RunContentDescriptor contentToReuse, ExecutionEnvironment env, FlexUnitRunnerParameters params, String swfFilePath) throws ExecutionException {
        try {
            Pair<Module, FlexBuildConfiguration> moduleAndBC = params.checkAndGetModuleAndBC(project);
            return this.launchDebugProcess((Module)moduleAndBC.first, (FlexBuildConfiguration)moduleAndBC.second, params, env);
        }
        catch (RuntimeConfigurationError e) {
            throw new ExecutionException(e.getMessage());
        }
    }

    @Override
    protected RunContentDescriptor launchAirFlexUnit(Project project, RunProfileState state, RunContentDescriptor contentToReuse, ExecutionEnvironment env, FlexUnitRunnerParameters params) throws ExecutionException {
        try {
            Pair<Module, FlexBuildConfiguration> moduleAndBC = params.checkAndGetModuleAndBC(project);
            return this.launchDebugProcess((Module)moduleAndBC.first, (FlexBuildConfiguration)moduleAndBC.second, params, env);
        }
        catch (RuntimeConfigurationError e) {
            throw new ExecutionException(e.getMessage());
        }
    }

    @Override
    protected RunContentDescriptor launchFlexConfig(Module module, FlexBuildConfiguration bc, FlashRunnerParameters runnerParameters, RunProfileState state, RunContentDescriptor contentToReuse, ExecutionEnvironment env) throws ExecutionException {
        Project project = module.getProject();
        if (bc.getTargetPlatform() == TargetPlatform.Mobile) {
            Sdk sdk = bc.getSdk();
            switch (runnerParameters.getMobileRunTarget()) {
                case Emulator: {
                    break;
                }
                case AndroidDevice: {
                    String androidDescriptorPath = FlexDebugRunner.getAirDescriptorPath(bc, bc.getAndroidPackagingOptions());
                    String androidAppId = FlexDebugRunner.getApplicationId(androidDescriptorPath);
                    if (androidAppId == null) {
                        Messages.showErrorDialog((Project)project, (String)FlexBundle.message("failed.to.read.app.id", FileUtil.toSystemDependentName((String)androidDescriptorPath)), (String)FlexBundle.message("error.title", new Object[0]));
                        return null;
                    }
                    if (!FlexDebugRunner.packAndInstallToAndroidDevice(module, bc, runnerParameters, androidAppId, true)) {
                        return null;
                    }
                    if (runnerParameters.getDebugTransport() != FlashRunnerParameters.AirMobileDebugTransport.USB || AirPackageUtil.androidForwardTcpPort(project, sdk, runnerParameters.getDeviceInfo(), runnerParameters.getUsbDebugPort())) break;
                    return null;
                }
                case iOSSimulator: {
                    String adtVersionSimulator = AirPackageUtil.getAdtVersion(module.getProject(), bc.getSdk());
                    String iosSimulatorDescriptorPath = FlexDebugRunner.getAirDescriptorPath(bc, bc.getIosPackagingOptions());
                    String iosSimulatorAppId = FlexDebugRunner.getApplicationId(iosSimulatorDescriptorPath);
                    if (iosSimulatorAppId == null) {
                        Messages.showErrorDialog((Project)project, (String)FlexBundle.message("failed.to.read.app.id", FileUtil.toSystemDependentName((String)iosSimulatorDescriptorPath)), (String)FlexBundle.message("error.title", new Object[0]));
                        return null;
                    }
                    if (FlexDebugRunner.packAndInstallToIOSSimulator(module, bc, runnerParameters, adtVersionSimulator, iosSimulatorAppId, true)) break;
                    return null;
                }
                case iOSDevice: {
                    String adtVersion = AirPackageUtil.getAdtVersion(module.getProject(), bc.getSdk());
                    if (StringUtil.compareVersionNumbers((String)adtVersion, (String)"3.4") >= 0) {
                        int deviceHandle;
                        if (!FlexDebugRunner.packAndInstallToIOSDevice(module, bc, runnerParameters, adtVersion, true)) {
                            return null;
                        }
                        if (runnerParameters.getDebugTransport() != FlashRunnerParameters.AirMobileDebugTransport.USB) break;
                        DeviceInfo device = runnerParameters.getDeviceInfo();
                        int n = deviceHandle = device == null ? -1 : device.IOS_HANDLE;
                        if (deviceHandle < 0) {
                            return null;
                        }
                        if (AirPackageUtil.iosForwardTcpPort(project, sdk, runnerParameters.getUsbDebugPort(), deviceHandle)) break;
                        return null;
                    }
                    if (AirPackageUtil.packageIpaForDevice(module, bc, runnerParameters, adtVersion, true)) break;
                    return null;
                }
            }
        }
        return this.launchDebugProcess(module, bc, runnerParameters, env);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/flex/debug/FlexDebugRunner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/flex/debug/FlexDebugRunner";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunnerId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canRun";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

