/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.debug;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

class ResponseLineIterator
implements Iterator<String> {
    private final List<String> lines = new ArrayList<String>();
    private int current;

    ResponseLineIterator(String commandOutput) {
        StringTokenizer tokenizer = new StringTokenizer(commandOutput, "\r\n");
        while (tokenizer.hasMoreElements()) {
            String s = tokenizer.nextToken().trim();
            if (s.length() == 0) continue;
            this.lines.add(s);
        }
    }

    @Override
    public boolean hasNext() {
        return this.current < this.lines.size();
    }

    @Override
    public String next() {
        String result = this.next_(this.current);
        ++this.current;
        return result;
    }

    private String next_(int current) {
        if (current >= this.lines.size()) {
            throw new NoSuchElementException();
        }
        String result = this.lines.get(current);
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String getNext() {
        return this.next_(this.current);
    }

    public void retreat() {
        if (this.current == 0) {
            throw new NoSuchElementException();
        }
        --this.current;
    }
}

