/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.flexunit;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.flex.flexunit.FlexUnitSupport;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSNameIndex;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.testIntegration.TestFinder;
import com.intellij.testIntegration.TestFinderHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlexUnitTestFinder
implements TestFinder {
    @Nullable
    public JSClass findSourceElement(@NotNull PsiElement element) {
        if (element == null) {
            FlexUnitTestFinder.$$$reportNull$$$0(0);
        }
        return FlexUnitTestFinder.findContextClass(element);
    }

    @Nullable
    static JSClass findContextClass(@NotNull PsiElement element) {
        if (element == null) {
            FlexUnitTestFinder.$$$reportNull$$$0(1);
        }
        if (FlexUnitSupport.getModuleAndSupport(element) == null) {
            return null;
        }
        PsiFile psiFile = (PsiFile)PsiTreeUtil.getParentOfType((PsiElement)element, PsiFile.class, (boolean)false);
        if (psiFile instanceof JSFile) {
            psiFile = InjectedLanguageManager.getInstance((Project)psiFile.getProject()).getTopLevelFile((PsiElement)psiFile);
        }
        if (psiFile instanceof JSFile) {
            return JSPsiImplUtils.findClass((JSFile)((JSFile)psiFile));
        }
        if (psiFile instanceof XmlFile) {
            return XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)((XmlFile)psiFile));
        }
        return null;
    }

    @NotNull
    public Collection<PsiElement> findTestsForClass(@NotNull PsiElement element) {
        if (element == null) {
            FlexUnitTestFinder.$$$reportNull$$$0(2);
        }
        VirtualFile file = element.getContainingFile().getVirtualFile();
        JSClass jsClass = this.findSourceElement(element);
        String className = jsClass == null ? null : jsClass.getName();
        Pair<Module, FlexUnitSupport> moduleAndSupport = FlexUnitSupport.getModuleAndSupport(element);
        Module module = moduleAndSupport == null ? null : (Module)moduleAndSupport.first;
        FlexUnitSupport flexUnitSupport = moduleAndSupport == null ? null : (FlexUnitSupport)moduleAndSupport.second;
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)element.getProject()).getFileIndex();
        if (className == null || module == null || flexUnitSupport == null || file != null && fileIndex.isInTestSourceContent(file)) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                FlexUnitTestFinder.$$$reportNull$$$0(3);
            }
            return list;
        }
        Collection allNames = StubIndex.getInstance().getAllKeys(JSNameIndex.KEY, element.getProject());
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependentsScope((Module)module);
        ArrayList<Pair> classesWithProximity = new ArrayList<Pair>();
        for (String possibleTestName : allNames) {
            if (!possibleTestName.contains(className)) continue;
            for (JSQualifiedNamedElement jsElement : JSResolveUtil.findElementsByName((String)possibleTestName, (Project)element.getProject(), (GlobalSearchScope)scope)) {
                boolean inTestSource;
                VirtualFile f = jsElement.getContainingFile().getVirtualFile();
                boolean bl = inTestSource = f != null && fileIndex.isInTestSourceContent(f);
                if (!(jsElement instanceof JSClass) || jsElement == jsClass || (!inTestSource || !possibleTestName.contains("Test")) && !flexUnitSupport.isTestClass((JSClass)jsElement, true)) continue;
                classesWithProximity.add(Pair.create((Object)jsElement, (Object)TestFinderHelper.calcTestNameProximity((String)className, (String)jsElement.getName())));
            }
        }
        List list = TestFinderHelper.getSortedElements(classesWithProximity, (boolean)true);
        if (list == null) {
            FlexUnitTestFinder.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public Collection<PsiElement> findClassesForTest(@NotNull PsiElement element) {
        FlexUnitSupport flexUnitSupport;
        JSClass jsClass;
        if (element == null) {
            FlexUnitTestFinder.$$$reportNull$$$0(5);
        }
        String className = (jsClass = this.findSourceElement(element)) == null ? null : jsClass.getName();
        Pair<Module, FlexUnitSupport> moduleAndSupport = FlexUnitSupport.getModuleAndSupport(element);
        Module module = moduleAndSupport == null ? null : (Module)moduleAndSupport.first;
        FlexUnitSupport flexUnitSupport2 = flexUnitSupport = moduleAndSupport == null ? null : (FlexUnitSupport)moduleAndSupport.second;
        if (className == null || module == null || flexUnitSupport == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                FlexUnitTestFinder.$$$reportNull$$$0(6);
            }
            return list;
        }
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesScope((Module)module).intersectWith(GlobalSearchScopesCore.projectProductionScope((Project)module.getProject()));
        ArrayList<Pair> classesWithWeights = new ArrayList<Pair>();
        for (Pair nameWithWeight : TestFinderHelper.collectPossibleClassNamesWithWeights((String)className)) {
            for (JSQualifiedNamedElement jsElement : JSResolveUtil.findElementsByName((String)((String)nameWithWeight.first), (Project)module.getProject(), (GlobalSearchScope)scope)) {
                if (!(jsElement instanceof JSClass) || jsElement == jsClass || ((JSClass)jsElement).isInterface() || flexUnitSupport.isTestClass((JSClass)jsElement, true)) continue;
                classesWithWeights.add(Pair.create((Object)jsElement, (Object)nameWithWeight.second));
            }
        }
        List list = TestFinderHelper.getSortedElements(classesWithWeights, (boolean)false);
        if (list == null) {
            FlexUnitTestFinder.$$$reportNull$$$0(7);
        }
        return list;
    }

    public boolean isTest(@NotNull PsiElement element) {
        if (element == null) {
            FlexUnitTestFinder.$$$reportNull$$$0(8);
        }
        JSClass jsClass = this.findSourceElement(element);
        Pair<Module, FlexUnitSupport> moduleAndSupport = FlexUnitSupport.getModuleAndSupport(element);
        PsiFile psiFile = element.getContainingFile();
        VirtualFile file = psiFile != null ? psiFile.getVirtualFile() : null;
        return jsClass != null && moduleAndSupport != null && (file != null && file.getName().contains("Test") && ModuleRootManager.getInstance((Module)((Module)moduleAndSupport.first)).getFileIndex().isInTestSourceContent(file) || ((FlexUnitSupport)moduleAndSupport.second).isTestClass(jsClass, true));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/flex/flexunit/FlexUnitTestFinder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/flex/flexunit/FlexUnitTestFinder";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findTestsForClass";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findClassesForTest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findSourceElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findContextClass";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findTestsForClass";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findClassesForTest";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isTest";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

