/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections.actionscript;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.javascript.validation.JSFunctionSignatureChecker;
import com.intellij.lang.javascript.validation.JSTypeChecker;
import com.intellij.lang.javascript.validation.ValidateTypesUtil;
import com.intellij.lang.javascript.validation.fixes.ActionScriptCreateConstructorFix;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public class ActionScriptFunctionSignatureChecker
extends JSFunctionSignatureChecker {
    public ActionScriptFunctionSignatureChecker(JSTypeChecker typeChecker) {
        super(typeChecker);
    }

    protected void registerProblem(JSCallExpression callExpression, String message, LocalQuickFix ... fixes) {
        PsiElement place = ValidateTypesUtil.getPlaceForSignatureProblem((JSCallExpression)callExpression, (JSArgumentList)callExpression.getArgumentList());
        this.myTypeChecker.registerProblem(place, message, ProblemHighlightType.GENERIC_ERROR, fixes);
    }

    public void checkConstructorCall(@NotNull JSCallExpression node, @NotNull JSClass target) {
        if (node == null) {
            ActionScriptFunctionSignatureChecker.$$$reportNull$$$0(0);
        }
        if (target == null) {
            ActionScriptFunctionSignatureChecker.$$$reportNull$$$0(1);
        }
        if (node instanceof JSNewExpression || node.getMethodExpression() instanceof JSSuperExpression) {
            JSExpression[] expressions;
            JSArgumentList argumentList = node.getArgumentList();
            JSExpression[] jSExpressionArray = expressions = argumentList != null ? argumentList.getArguments() : JSExpression.EMPTY_ARRAY;
            if (expressions.length > 0) {
                LocalQuickFix[] localQuickFixArray;
                ActionScriptCreateConstructorFix fix = ActionScriptCreateConstructorFix.createIfApplicable(node);
                String string = JSBundle.message((String)"javascript.invalid.number.of.parameters", (Object[])new Object[]{"0"});
                if (fix != null) {
                    LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                    localQuickFixArray = localQuickFixArray2;
                    localQuickFixArray2[0] = fix;
                } else {
                    localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                }
                this.registerProblem(node, string, localQuickFixArray);
            }
        } else {
            this.reportProblemIfNotExpectedCountOfParameters(node, 1, "one");
        }
    }

    protected boolean isCallableType(boolean inNewExpression, @NotNull JSType type) {
        String typeText;
        if (type == null) {
            ActionScriptFunctionSignatureChecker.$$$reportNull$$$0(2);
        }
        return "Class".equals(typeText = type.getTypeText()) || inNewExpression && type instanceof JSObjectType || JSTypeUtils.hasFunctionType((JSType)type);
    }

    protected void checkCallArgumentType(JSParameterItem p, JSExpression expression, JSCallExpression node, PsiElement resolveResult) {
        if (p instanceof JSParameter) {
            this.myTypeChecker.checkExpressionIsAssignableToVariable((JSVariable)((JSParameter)p), expression, node.getContainingFile(), "javascript.argument.type.mismatch", false);
        }
    }

    protected boolean obtainNextMatchedParams(int[] matchedParams, JSParameterItem[] parameters) {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/inspections/actionscript/ActionScriptFunctionSignatureChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkConstructorCall";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isCallableType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

