/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.mvc.config.viewresolver;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyManager;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.model.SpringBootConfigValueSearcher;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.web.mvc.views.ViewResolver;
import com.intellij.spring.web.mvc.views.ViewResolverFactory;
import com.intellij.spring.web.mvc.views.ViewResolverRegistry;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class SpringBootAutoConfigurationViewResolverFactoryBase
extends ViewResolverFactory {
    SpringBootAutoConfigurationViewResolverFactoryBase() {
    }

    @Nullable
    protected final String getBeanClass() {
        return null;
    }

    @NotNull
    protected abstract String getViewResolverBeanName();

    @NotNull
    protected abstract Set<String> getViewResolverClassNames();

    @NotNull
    protected abstract Set<String> getAutoConfigurationClassNames();

    protected boolean isMine(@Nullable CommonSpringBean bean, PsiClass beanClass) {
        return bean != null && this.matchesAutoConfigurationBean(bean, beanClass);
    }

    protected boolean matchesAutoConfigurationBean(CommonSpringBean bean, PsiClass beanClass) {
        if (!SpringBootLibraryUtil.hasSpringBootLibrary((Project)beanClass.getProject())) {
            return false;
        }
        if (!this.getViewResolverBeanName().equals(bean.getBeanName())) {
            return false;
        }
        if (!this.getViewResolverClassNames().contains(beanClass.getQualifiedName())) {
            return false;
        }
        PsiElement beanPsiElement = bean.getIdentifyingPsiElement();
        if (!(beanPsiElement instanceof PsiMethod)) {
            return false;
        }
        PsiMethod psiMethod = (PsiMethod)beanPsiElement;
        PsiClass psiClass = psiMethod.getContainingClass();
        if (psiClass == null) {
            return false;
        }
        return this.getAutoConfigurationClassNames().contains(psiClass.getQualifiedName());
    }

    protected ViewResolver createURLBasedViewResolver(String viewPrefix, String viewSuffix) {
        return ViewResolverRegistry.getInstance().createURLBasedViewResolver("SpringBoot: " + ((Object)((Object)this)).getClass().getSimpleName(), viewPrefix, viewSuffix);
    }

    @Nullable
    protected static String getConfigurationValue(SpringModel model, String key) {
        assert (model.getModule() != null);
        return SpringBootConfigValueSearcher.productionForProfiles((Module)model.getModule(), (String)key, (Set)model.getActiveProfiles()).findValueText();
    }

    @Nullable
    protected static String getConfigurationOrDefaultValue(SpringModel model, String key) {
        String value = SpringBootAutoConfigurationViewResolverFactoryBase.getConfigurationValue(model, key);
        if (value != null) {
            return value;
        }
        SpringBootApplicationMetaConfigKey metaConfigKey = SpringBootApplicationMetaConfigKeyManager.getInstance().findApplicationMetaConfigKey(model.getModule(), key);
        assert (metaConfigKey != null) : key;
        return metaConfigKey.getDefaultValue();
    }
}

