/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.xml.util;

import com.intellij.ide.presentation.Presentation;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.spring.model.values.converters.FieldRetrievingFactoryBeanConverter;
import com.intellij.spring.model.xml.BeanType;
import com.intellij.spring.model.xml.BeanTypeProvider;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.util.SpringUtilElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xml.ConverterManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.Referencing;
import com.intellij.util.xml.Required;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Presentation(typeName="Spring Constant")
@BeanType(provider=SpringConstantBeanTypeProvider.class)
public interface SpringConstant
extends SpringUtilElement,
DomSpringBean {
    @Required
    @Referencing(value=FieldRetrievingFactoryBeanConverter.FieldReferenceRequired.class)
    @NotNull
    public GenericAttributeValue<String> getStaticField();

    public static class SpringConstantBeanTypeProvider
    implements BeanTypeProvider<SpringConstant> {
        @Override
        @NotNull
        public String[] getBeanTypeCandidates() {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                SpringConstantBeanTypeProvider.$$$reportNull$$$0(0);
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }

        @Override
        @Nullable
        public String getBeanType(SpringConstant constant) {
            PsiClass psiClass = SpringConstantBeanTypeProvider.getStaticFieldType(constant);
            return psiClass != null ? StringUtil.notNullize((String)psiClass.getQualifiedName()) : "";
        }

        @Nullable
        private static PsiClass getStaticFieldType(SpringConstant constant) {
            GenericAttributeValue<String> staticField = constant.getStaticField();
            if (!DomUtil.hasXml(staticField)) {
                return null;
            }
            ConverterManager converterManager = (ConverterManager)ServiceManager.getService(ConverterManager.class);
            FieldRetrievingFactoryBeanConverter converter = (FieldRetrievingFactoryBeanConverter)converterManager.getConverterInstance(FieldRetrievingFactoryBeanConverter.class);
            PsiReference[] references = converter.createReferences((GenericDomValue<String>)staticField, (PsiElement)staticField.getXmlAttributeValue());
            if (references.length > 0) {
                PsiReference reference = references[references.length - 1];
                PsiElement element = reference.resolve();
                PsiType psiType = null;
                if (element instanceof PsiMethod) {
                    psiType = ((PsiMethod)element).getReturnType();
                } else if (element instanceof PsiField) {
                    psiType = ((PsiField)element).getType();
                }
                if (psiType instanceof PsiClassType) {
                    return ((PsiClassType)psiType).resolve();
                }
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/xml/util/SpringConstant$SpringConstantBeanTypeProvider", "getBeanTypeCandidates"));
        }
    }
}

