/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.config;

import com.intellij.credentialStore.Credentials;
import com.intellij.remote.AuthType;
import com.intellij.remote.MutableRemoteCredentials;
import com.jetbrains.plugins.webDeployment.config.Connectable;
import com.jetbrains.plugins.webDeployment.config.Mappable;
import com.jetbrains.plugins.webDeployment.config.ServerPasswordSafeDeployable;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Deployable
extends Connectable,
Mappable {
    @Nls
    public String getRootNodePresentableDescription(boolean var1);

    public boolean isPassMemoryOnly();

    @Override
    @NotNull
    default public Icon getIcon() {
        Icon icon = this.getAccessType().getIcon();
        if (icon == null) {
            Deployable.$$$reportNull$$$0(0);
        }
        return icon;
    }

    @Override
    @NotNull
    public Deployable clone();

    default public void copyToCredentials(MutableRemoteCredentials remoteCredentials) {
        String pass;
        remoteCredentials.setHost(this.getHost());
        remoteCredentials.setLiteralPort(this.getLiteralPort());
        if (this.isAnonymous()) {
            remoteCredentials.setUserName("anonymous");
            remoteCredentials.setPassword("user@example.com");
            remoteCredentials.setStorePassword(true);
        }
        remoteCredentials.setAuthType(this.getAuthType());
        remoteCredentials.setPrivateKeyFile(this.getPrivateKeyFile());
        Credentials credentials = this.getCredentials();
        remoteCredentials.setUserName(credentials == null ? null : credentials.getUserName());
        boolean store = !this.isPassMemoryOnly();
        String string = pass = credentials == null ? null : credentials.getPasswordAsString();
        if (this.getAuthType() == AuthType.KEY_PAIR) {
            remoteCredentials.setPassword(null);
            remoteCredentials.setStorePassword(false);
            remoteCredentials.setPassphrase(pass);
            remoteCredentials.setStorePassphrase(store);
        } else if (this.getAuthType() == AuthType.OPEN_SSH) {
            remoteCredentials.setPassword(null);
            remoteCredentials.setStorePassword(false);
            remoteCredentials.setPassphrase(null);
            remoteCredentials.setStorePassphrase(false);
        } else {
            remoteCredentials.setPassphrase(null);
            remoteCredentials.setStorePassphrase(false);
            remoteCredentials.setPassword(pass);
            remoteCredentials.setStorePassword(store);
        }
    }

    @Contract(value="null->null;!null->!null")
    public static Deployable create(@Nullable WebServerConfig serverConfig) {
        if (serverConfig == null) {
            return null;
        }
        return new ServerPasswordSafeDeployable(serverConfig);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/config/Deployable", "getIcon"));
    }
}

