/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.conflicts;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ssh.ForceDisconnectListener;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.HashSet;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.plugins.webDeployment.ConnectionOwnerFactory;
import com.jetbrains.plugins.webDeployment.CustomFileSystemException;
import com.jetbrains.plugins.webDeployment.DeploymentConfigChangeListener;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.DeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.DeploymentRevisionTrackerBase;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.FileTransferUtil;
import com.jetbrains.plugins.webDeployment.ProjectDeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.TransferOperation;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.WebDeploymentTopics;
import com.jetbrains.plugins.webDeployment.config.AdvancedOptionsConfig;
import com.jetbrains.plugins.webDeployment.config.Connectable;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.ExcludedPath;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.Mappable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServersConfigManager;
import com.jetbrains.plugins.webDeployment.conflicts.RemoteChangeNotificationPanelCreator;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnectionManager;
import com.jetbrains.plugins.webDeployment.ui.DeploymentNotifier;
import com.jetbrains.plugins.webDeployment.ui.FileTransferToolWindow;
import com.jetbrains.plugins.webDeployment.ui.PublishOptionsConfigurable;
import com.jetbrains.plugins.webDeployment.ui.auth.AuthHelper;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JComponent;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteChangeNotifier
implements ProjectComponent {
    private static final Logger LOG = Logger.getInstance(RemoteChangeNotifier.class);
    private static final Key<EditorNotificationPanel> PANEL_KEY = Key.create((String)"remoteFilesConflictsPanel");
    private static final Key<Integer> VERSION_KEY = Key.create((String)"remoteFilesConflictsVersion");
    @NonNls
    private static final String REMOTE_FILES_MERGING_TOOL_WINDOW_GROUP = "Remote files merging";
    @NotNull
    private final Project myProject;
    private final Set<VirtualFile> myOpenFiles;
    private final AtomicInteger myFailureReported;
    private final Object LOCK;

    public static RemoteChangeNotifier getInstance(@NotNull Project project) {
        if (project == null) {
            RemoteChangeNotifier.$$$reportNull$$$0(0);
        }
        return (RemoteChangeNotifier)project.getComponent(RemoteChangeNotifier.class);
    }

    protected RemoteChangeNotifier(@NotNull Project project) {
        if (project == null) {
            RemoteChangeNotifier.$$$reportNull$$$0(1);
        }
        this.myOpenFiles = new HashSet();
        this.myFailureReported = new AtomicInteger(0);
        this.LOCK = new Object();
        this.myProject = project;
    }

    public void projectOpened() {
        MessageBusConnection connection = this.myProject.getMessageBus().connect();
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                if (source == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (file == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (PublishConfig.getInstance(RemoteChangeNotifier.this.myProject).isNotifyRemoteChanges() && source.getAllEditors(file).length == 0) {
                    RemoteChangeNotifier.this.myOpenFiles.remove(file);
                }
            }

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (PublishConfig.getInstance(RemoteChangeNotifier.this.myProject).isNotifyRemoteChanges()) {
                    VirtualFile newFile = event.getNewFile();
                    if (newFile == null) {
                        return;
                    }
                    if (!newFile.isInLocalFileSystem()) {
                        return;
                    }
                    if (RemoteChangeNotifier.this.myOpenFiles.add(newFile)) {
                        RemoteChangeNotifier.this.updateNotifications(newFile);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "source";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/conflicts/RemoteChangeNotifier$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileClosed";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "selectionChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        connection.subscribe(WebDeploymentTopics.DEPLOYMENT_CONFIG, (Object)new DeploymentConfigChangeListener(){

            @Override
            public void deploymentConfigChanged() {
                this.update();
            }

            @Override
            public void optionsChanged() {
                this.update();
            }

            @Override
            public void excludedPathsChanged() {
                this.update();
            }

            private void update() {
                for (VirtualFile file : FileEditorManager.getInstance((Project)RemoteChangeNotifier.this.myProject).getOpenFiles()) {
                    RemoteChangeNotifier.this.updateNotifications(file);
                }
                if (!PublishConfig.getInstance(RemoteChangeNotifier.this.myProject).isNotifyRemoteChanges()) {
                    RemoteChangeNotifier.this.myOpenFiles.clear();
                }
            }
        });
    }

    public void updateNotificationsForRemoteItem(@NotNull FileObject fileObject, PublishConfig config, Deployable serverConfig) throws FileSystemException {
        if (fileObject == null) {
            RemoteChangeNotifier.$$$reportNull$$$0(2);
        }
        if (!StringUtil.equals((CharSequence)serverConfig.getId(), (CharSequence)((CharSequence)config.getDefaultServerIdAndName().getFirst()))) {
            return;
        }
        Pair<DeploymentPathMapping, Boolean> mappingPair = config.getNearestMappingDeploy2Local(fileObject, false, (Mappable)serverConfig);
        if (mappingPair.getFirst() != null) {
            FileObject source = ((DeploymentPathMapping)mappingPair.getFirst()).mapToLocalFile(fileObject, serverConfig);
            this.updateNotificationsForLocalItem(source);
        }
        Pair<List<DeploymentPathMapping>, Boolean> mappingCollectionPair = config.getChildMappingsDeploy2Local(fileObject, (Mappable)serverConfig);
        for (DeploymentPathMapping mapping : (List)mappingCollectionPair.getFirst()) {
            FileObject localRoot = DeploymentPathUtils.getLocalFile(mapping.getLocalPath());
            if (localRoot == null) continue;
            this.updateNotificationsForLocalItem(localRoot);
        }
    }

    public void updateNotificationsForLocalItem(@NotNull FileObject fileObject, @NotNull ExecutionContext context) throws FileSystemException {
        if (fileObject == null) {
            RemoteChangeNotifier.$$$reportNull$$$0(3);
        }
        if (context == null) {
            RemoteChangeNotifier.$$$reportNull$$$0(4);
        }
        if (!StringUtil.equals((CharSequence)context.getServer().getId(), (CharSequence)((CharSequence)context.getConfig().getDefaultServerIdAndName().getFirst()))) {
            return;
        }
        this.updateNotificationsForLocalItem(fileObject);
    }

    private void updateNotificationsForLocalItem(@NotNull FileObject fileObject) throws FileSystemException {
        VirtualFile fileByURL;
        if (fileObject == null) {
            RemoteChangeNotifier.$$$reportNull$$$0(5);
        }
        if ((fileByURL = VfsUtil.findFileByURL((URL)fileObject.getURL())) != null) {
            this.updateNotifications(fileByURL);
        }
    }

    public void updateNotifications(@NotNull VirtualFile file, @NotNull PublishConfig publishConfig, @NotNull Deployable server) {
        if (file == null) {
            RemoteChangeNotifier.$$$reportNull$$$0(6);
        }
        if (publishConfig == null) {
            RemoteChangeNotifier.$$$reportNull$$$0(7);
        }
        if (server == null) {
            RemoteChangeNotifier.$$$reportNull$$$0(8);
        }
        if (!StringUtil.equals((CharSequence)server.getId(), (CharSequence)((CharSequence)publishConfig.getDefaultServerIdAndName().getFirst()))) {
            return;
        }
        this.updateNotifications(file);
    }

    private void updateNotifications(@NotNull VirtualFile file) {
        if (file == null) {
            RemoteChangeNotifier.$$$reportNull$$$0(9);
        }
        Runnable action = () -> {
            if (file == null) {
                RemoteChangeNotifier.$$$reportNull$$$0(26);
            }
            if (this.myProject.isDisposed()) {
                return;
            }
            String defaultServerId = (String)PublishConfig.getInstance(this.myProject).getDefaultServerIdAndName().getFirst();
            if (defaultServerId == null) {
                return;
            }
            final WebServerConfig serverConfig = WebServersConfigManager.getInstance(this.myProject).findServer(defaultServerId);
            if (serverConfig == null) {
                return;
            }
            final Deployable deployable = Deployable.create(serverConfig);
            ArrayList<Object> files = new ArrayList<Object>();
            if (file.isDirectory()) {
                for (VirtualFile vFile : FileEditorManager.getInstance((Project)this.myProject).getOpenFiles()) {
                    if (!VfsUtilCore.isAncestor((VirtualFile)file, (VirtualFile)vFile, (boolean)false)) continue;
                    files.add(vFile);
                }
            } else if (FileEditorManager.getInstance((Project)this.myProject).isFileOpen(file)) {
                files.add(file);
            }
            for (final VirtualFile virtualFile : files) {
                String title = WDBundle.message("progress.title.for.change.notifier", virtualFile.getPresentableName());
                final int version = this.incAndGetNotificationVersion(virtualFile);
                ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, title, true){
                    private RemoteChangeNotificationPanelCreator myCreator;

                    public void run(@NotNull ProgressIndicator pi) {
                        if (pi == null) {
                            3.$$$reportNull$$$0(0);
                        }
                        this.myCreator = RemoteChangeNotifier.this.getNotificationCreator(virtualFile, pi, deployable);
                    }

                    public void onCancel() {
                        if (RemoteChangeNotifier.this.myProject.isDisposed()) {
                            return;
                        }
                        this.myCreator = new RemoteChangeNotificationPanelCreator.Cancel(virtualFile, RemoteChangeNotifier.this.myProject, PublishConfig.getInstance(RemoteChangeNotifier.this.myProject), Deployable.create(serverConfig));
                        RemoteChangeNotifier.this.updateNotificationForAllEditors(virtualFile, this.myCreator, version);
                    }

                    public void onSuccess() {
                        RemoteChangeNotifier.this.updateNotificationForAllEditors(virtualFile, this.myCreator, version);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pi", "com/jetbrains/plugins/webDeployment/conflicts/RemoteChangeNotifier$3", "run"));
                    }
                });
            }
        };
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            ApplicationManager.getApplication().invokeLater(action);
        } else {
            action.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNotificationForAllEditors(@NotNull VirtualFile file, @Nullable RemoteChangeNotificationPanelCreator creator, int version) {
        if (file == null) {
            RemoteChangeNotifier.$$$reportNull$$$0(10);
        }
        Object object = this.LOCK;
        synchronized (object) {
            if (version < this.getNotificationVersion(file) || this.myProject.isDisposed()) {
                return;
            }
            for (FileEditor editor : FileEditorManager.getInstance((Project)this.myProject).getAllEditors(file)) {
                this.updateNotificationForTheEditor(editor, creator == null ? null : creator.createPanel(editor));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int incAndGetNotificationVersion(VirtualFile file) {
        Object object = this.LOCK;
        synchronized (object) {
            Integer version = (Integer)file.getUserData(VERSION_KEY);
            version = version == null ? Integer.valueOf(0) : Integer.valueOf(version + 1);
            file.putUserData(VERSION_KEY, (Object)version);
            return version;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNotificationVersion(VirtualFile file) {
        Object object = this.LOCK;
        synchronized (object) {
            Integer version = (Integer)file.getUserData(VERSION_KEY);
            if (version == null) {
                version = 0;
                file.putUserData(VERSION_KEY, (Object)version);
            }
            return version;
        }
    }

    public void hideNotification(@NotNull FileEditor editor) {
        if (editor == null) {
            RemoteChangeNotifier.$$$reportNull$$$0(11);
        }
        this.updateNotificationForTheEditor(editor, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNotificationForTheEditor(@NotNull FileEditor editor, @Nullable EditorNotificationPanel component) {
        if (editor == null) {
            RemoteChangeNotifier.$$$reportNull$$$0(12);
        }
        Object object = this.LOCK;
        synchronized (object) {
            EditorNotificationPanel old = (EditorNotificationPanel)editor.getUserData(PANEL_KEY);
            if (old != null) {
                LOG.debug("old " + old);
                FileEditorManager.getInstance((Project)this.myProject).removeTopComponent(editor, (JComponent)old);
            }
            if (component != null) {
                LOG.debug("new " + component);
                FileEditorManager.getInstance((Project)this.myProject).addTopComponent(editor, (JComponent)component);
                editor.putUserData(PANEL_KEY, (Object)component);
            } else {
                editor.putUserData(PANEL_KEY, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private RemoteChangeNotificationPanelCreator getNotificationCreator(@NotNull VirtualFile file, @NotNull ProgressIndicator pi, @NotNull Deployable serverConfig) {
        if (file == null) {
            RemoteChangeNotifier.$$$reportNull$$$0(13);
        }
        if (pi == null) {
            RemoteChangeNotifier.$$$reportNull$$$0(14);
        }
        if (serverConfig == null) {
            RemoteChangeNotifier.$$$reportNull$$$0(15);
        }
        if (!PublishConfig.getInstance(this.myProject).isNotifyRemoteChanges()) {
            return null;
        }
        assert (PublishConfig.getInstance(this.myProject).getPromptOnRemoteOverwrite() != PublishConfig.PromptOnRemoteOverwrite.NONE);
        if (!serverConfig.needsTransfer() || serverConfig.validateFastInternal() != null) {
            return null;
        }
        DeploymentRevisionTracker.Revision revision = ProjectDeploymentRevisionTracker.getInstance(this.myProject).getBaseRevision(file.getPath(), serverConfig);
        DeploymentPathMapping mapping = (DeploymentPathMapping)PublishConfig.getInstance(this.myProject).getNearestMappingForLocal(file.getPath(), false, true, false, (Mappable)serverConfig).getFirst();
        if (mapping == null) {
            return null;
        }
        WebServerConfig.RemotePath remotePath = mapping.mapToDeployPath(file.getPath(), (Mappable)serverConfig);
        for (ExcludedPath excludedPath : PublishConfig.getInstance(this.myProject).getExcludedPaths(serverConfig.getId())) {
            if (excludedPath.isLocal() || !excludedPath.isParentForRemotePath(remotePath, serverConfig)) continue;
            return null;
        }
        if (!AuthHelper.ensureAuthSpecified(serverConfig, this.myProject)) {
            return null;
        }
        Ref resultRef = new Ref();
        Ref exceptionRef = new Ref();
        RemoteConnection connection = null;
        try {
            RemoteConnection finalConnection = connection = RemoteConnectionManager.getInstance().openConnection(ConnectionOwnerFactory.createConnectionOwner(this.myProject), WDBundle.message("browse.0", remotePath.path), (Connectable)serverConfig, FileTransferConfig.Origin.Default, (EventDispatcher<ForceDisconnectListener>)null, pi);
            connection.executeServerOperation((ThrowableRunnable<FileSystemException>)((ThrowableRunnable)() -> {
                FileObject remoteFile;
                if (serverConfig == null) {
                    RemoteChangeNotifier.$$$reportNull$$$0(23);
                }
                if (pi == null) {
                    RemoteChangeNotifier.$$$reportNull$$$0(24);
                }
                if (file == null) {
                    RemoteChangeNotifier.$$$reportNull$$$0(25);
                }
                if ((remoteFile = PublishUtils.findFile(finalConnection.getFileSystem(), remotePath, serverConfig)) != null) {
                    remoteFile.refresh();
                    FileObject parent = remoteFile.getParent();
                    if (parent != null) {
                        parent.refresh();
                    }
                }
                if (pi.isCanceled()) {
                    return;
                }
                try {
                    if (remoteFile == null || !remoteFile.exists()) {
                        resultRef.set((Object)new RemoteChangeNotificationPanelCreator.Delete(file, serverConfig, this.myProject));
                        return;
                    }
                    if (pi.isCanceled()) {
                        return;
                    }
                    if (remoteFile.getContent().getSize() > DeploymentRevisionTrackerBase.MAX_FILE_SIZE) {
                        resultRef.set((Object)new RemoteChangeNotificationPanelCreator.TooLargeFile(file, serverConfig, this.myProject, remoteFile, mapping));
                        return;
                    }
                    if (pi.isCanceled() || this.myProject.isDisposed()) {
                        return;
                    }
                    if (!RemoteChangeNotifier.isRemoteFileChangedAndLocalFileDifferentFromRemote(this.myProject, remoteFile, file, serverConfig, revision, PublishConfig.getInstance(this.myProject).getPromptOnRemoteOverwrite(), pi)) {
                        LOG.debug("Changed: false; file: " + remoteFile.getName().getPath());
                        return;
                    }
                    LOG.debug("Changed: true; file: " + remoteFile.getName().getPath());
                    resultRef.set((Object)new RemoteChangeNotificationPanelCreator.Update(file, serverConfig, PublishConfig.getInstance(this.myProject), revision, this.myProject));
                }
                catch (IOException e) {
                    exceptionRef.set((Object)e);
                }
            }), pi);
        }
        catch (FileSystemException e) {
            int reports = this.myFailureReported.incrementAndGet();
            RemoteChangeNotifier.showErrorMessage(WDBundle.message("operation.failed", WDBundle.message("error.message.remote.file.0.loading", remotePath), StringUtil.decapitalize((String)PublishUtils.getMessage(e, true))), serverConfig, this.myProject, PublishConfig.getInstance(this.myProject), reports == 1);
            RemoteChangeNotifier.complainOnFailures(reports, this.myProject, serverConfig, StringUtil.decapitalize((String)PublishUtils.getMessage(e, true)));
            if (PublishUtils.isAuthFail(e)) {
                serverConfig.clearPasswordIfNotStored();
            }
            RemoteChangeNotificationPanelCreator remoteChangeNotificationPanelCreator = null;
            return remoteChangeNotificationPanelCreator;
        }
        finally {
            if (connection != null) {
                connection.release();
            }
        }
        if (!exceptionRef.isNull()) {
            IOException e = (IOException)exceptionRef.get();
            LOG.warn((Throwable)e);
            int reports = this.myFailureReported.incrementAndGet();
            RemoteChangeNotifier.showErrorMessage(WDBundle.message("failed.to.check.remote.file.0", remotePath.path, StringUtil.decapitalize((String)PublishUtils.getMessage(e, true))), serverConfig, this.myProject, PublishConfig.getInstance(this.myProject), reports == 1);
            RemoteChangeNotifier.complainOnFailures(reports, this.myProject, serverConfig, StringUtil.decapitalize((String)PublishUtils.getMessage(e, true)));
            return null;
        }
        this.myFailureReported.set(0);
        return (RemoteChangeNotificationPanelCreator)resultRef.get();
    }

    private static boolean isRemoteFileChangedAndLocalFileDifferentFromRemote(@NotNull Project project, @NotNull FileObject remoteFile, @NotNull VirtualFile local, Deployable serverConfig, @Nullable DeploymentRevisionTracker.Revision baseRevision, PublishConfig.PromptOnRemoteOverwrite promptOnRemoteOverwrite, @Nullable ProgressIndicator pi) throws IOException {
        if (project == null) {
            RemoteChangeNotifier.$$$reportNull$$$0(16);
        }
        if (remoteFile == null) {
            RemoteChangeNotifier.$$$reportNull$$$0(17);
        }
        if (local == null) {
            RemoteChangeNotifier.$$$reportNull$$$0(18);
        }
        if (baseRevision == null) {
            return !RemoteChangeNotifier.compareFilesAndCreateRevisionIfEqual(project, remoteFile, local, serverConfig, promptOnRemoteOverwrite, pi);
        }
        boolean remoteFileUnchanged = RemoteChangeNotifier.isFileEqualToRevision(remoteFile, serverConfig, baseRevision, promptOnRemoteOverwrite, pi);
        if (remoteFileUnchanged) {
            return false;
        }
        return !RemoteChangeNotifier.compareFilesAndCreateRevisionIfEqual(project, remoteFile, local, serverConfig, promptOnRemoteOverwrite, pi);
    }

    private static boolean compareFilesAndCreateRevisionIfEqual(Project project, FileObject remoteFile, VirtualFile local, Deployable serverConfig, PublishConfig.PromptOnRemoteOverwrite promptOnRemoteOverwrite, @Nullable ProgressIndicator pi) throws IOException {
        FileObject localFile = DeploymentPathUtils.getLocalFile(local.getPath());
        if (localFile == null) {
            return false;
        }
        FileContent remoteFileContent = remoteFile.getContent();
        FileContent localFileContent = localFile.getContent();
        if (promptOnRemoteOverwrite == PublishConfig.PromptOnRemoteOverwrite.CHECK_TIMESTAMP) {
            boolean equal;
            boolean accurateTimestamp = serverConfig.getAccurateTimestamps() != AdvancedOptionsConfig.AccurateTimestamps.NEVER;
            long currentRemoteTimestamp = remoteFileContent.getLastModifiedTime(accurateTimestamp);
            long currentLocalTimestamp = localFileContent.getLastModifiedTime(accurateTimestamp);
            boolean bl = equal = TransferOperation.areTimestampsEqual(currentLocalTimestamp, currentRemoteTimestamp, localFile.getFileSystem().getLastModTimeAccuracy() + remoteFile.getFileSystem().getLastModTimeAccuracy()) && localFileContent.getSize() == remoteFileContent.getSize();
            if (equal) {
                RemoteChangeNotifier.createRevision(project, local.getPath(), RemoteChangeNotifier.getContent(localFile, pi, true), currentRemoteTimestamp, serverConfig);
            }
            return equal;
        }
        if (promptOnRemoteOverwrite == PublishConfig.PromptOnRemoteOverwrite.CHECK_CONTENT) {
            byte[] localContent;
            if (remoteFileContent.getSize() != localFileContent.getSize()) {
                return false;
            }
            byte[] remoteContent = RemoteChangeNotifier.getContent(remoteFile, pi, false);
            boolean equal = Arrays.equals(remoteContent, localContent = RemoteChangeNotifier.getContent(localFile, pi, true));
            if (equal) {
                boolean accurateTimestamp = serverConfig.getAccurateTimestamps() != AdvancedOptionsConfig.AccurateTimestamps.NEVER;
                long currentRemoteTimestamp = remoteFileContent.getLastModifiedTime(accurateTimestamp);
                RemoteChangeNotifier.createRevision(project, local.getPath(), localContent, currentRemoteTimestamp, serverConfig);
            }
            return equal;
        }
        throw new IllegalStateException("PublishConfig.PromptOnRemoteOverwrite.NONE is not expected here");
    }

    public static byte[] getContent(FileObject file, ProgressIndicator pi, boolean isLocal) throws CustomFileSystemException {
        try {
            return FileTransferUtil.getContent(file, pi);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            throw new CustomFileSystemException(WDBundle.message(isLocal ? "failed.to.load.local.file.0.content" : "failed.to.load.remote.file.0.content", file.getName().getPath()));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void createRevision(@NotNull Project project, String path, @NotNull byte[] content, long timestamp, @NotNull Deployable deployable) throws IOException {
        void server;
        if (project == null) {
            RemoteChangeNotifier.$$$reportNull$$$0(19);
        }
        if (content == null) {
            RemoteChangeNotifier.$$$reportNull$$$0(20);
        }
        if (deployable == null) {
            RemoteChangeNotifier.$$$reportNull$$$0(21);
        }
        if ((long)content.length > DeploymentRevisionTrackerBase.MAX_FILE_SIZE) {
            LOG.warn("File " + path + "  is larger than " + DeploymentRevisionTrackerBase.MAX_FILE_SIZE + " bytes, its base revision will not be stored");
            return;
        }
        if (project.isDisposed()) {
            return;
        }
        LOG.debug("Creating revision for '" + path + "' from RemoteChangeNotifier");
        DeploymentRevisionTracker tracker = ProjectDeploymentRevisionTracker.getInstance(project);
        ThrowableComputable revisionFactory = () -> {
            void content;
            if (content == null) {
                RemoteChangeNotifier.$$$reportNull$$$0(22);
            }
            return new DeploymentRevisionTracker.Revision(timestamp, (byte[])content);
        };
        tracker.putBaseRevision(path, server.clone(), (ThrowableComputable<DeploymentRevisionTracker.Revision, IOException>)revisionFactory);
    }

    public static boolean isFileChanged(@Nullable FileObject source, Deployable serverConfig, @Nullable DeploymentRevisionTracker.Revision baseRevision, PublishConfig.PromptOnRemoteOverwrite promptOnRemoteOverwrite, @Nullable ProgressIndicator pi) throws IOException {
        if (source == null || !source.exists()) {
            return baseRevision != null;
        }
        if (baseRevision == null) {
            return true;
        }
        return !RemoteChangeNotifier.isFileEqualToRevision(source, serverConfig, baseRevision, promptOnRemoteOverwrite, pi);
    }

    public static boolean isFileEqualToRevision(FileObject source, DeploymentRevisionTracker.Revision baseRevision, ExecutionContext context) throws IOException {
        return RemoteChangeNotifier.isFileEqualToRevision(source, context.getServer(), baseRevision, context.getConfig().getPromptOnRemoteOverwrite(), context.getProgressIndicator());
    }

    private static boolean isFileEqualToRevision(FileObject source, Deployable serverConfig, DeploymentRevisionTracker.Revision baseRevision, PublishConfig.PromptOnRemoteOverwrite promptOnRemoteOverwrite, @Nullable ProgressIndicator pi) throws IOException {
        LOG.debug("source " + source.getName().getPath());
        if (promptOnRemoteOverwrite == PublishConfig.PromptOnRemoteOverwrite.CHECK_TIMESTAMP) {
            boolean accurateTimestamp = serverConfig.getAccurateTimestamps() != AdvancedOptionsConfig.AccurateTimestamps.NEVER;
            long currentRemoteTimestamp = source.getContent().getLastModifiedTime(accurateTimestamp);
            LOG.debug("Timestamps\n local: " + source.getFileSystem().getLastModTimeAccuracy() + "\nremote: " + currentRemoteTimestamp + "\n revision: " + baseRevision.timestamp);
            return TransferOperation.areTimestampsEqual(baseRevision.timestamp, currentRemoteTimestamp, source.getFileSystem().getLastModTimeAccuracy()) && source.getContent().getSize() == (long)baseRevision.content.length;
        }
        Charset charset = Charset.forName("UTF-8");
        LOG.debug("Content\n local: " + new String(FileTransferUtil.getContent(source, pi), charset) + "\n revision: " + new String(baseRevision.content, charset));
        return Arrays.equals(baseRevision.content, FileTransferUtil.getContent(source, pi));
    }

    private static void showErrorMessage(String message, Deployable serverConfig, Project project, PublishConfig config, boolean showBalloon) {
        if (project.isDisposed()) {
            return;
        }
        FileTransferToolWindow.printWithTimestamp(project, serverConfig, message, ConsoleViewContentType.ERROR_OUTPUT, config.getTraceLevel());
        if (showBalloon) {
            NotificationGroup.toolWindowGroup((String)REMOTE_FILES_MERGING_TOOL_WINDOW_GROUP, (String)"File Transfer").createNotification(message, MessageType.ERROR).notify(project);
        }
    }

    private static void complainOnFailures(int number, final Project project, Deployable serverConfig, String failure) {
        if (number == 10 && !project.isDisposed()) {
            DumbAwareAction turnOffAction = new DumbAwareAction("Turn off notification"){

                public void actionPerformed(AnActionEvent e) {
                    ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)new PublishOptionsConfigurable(project));
                }
            };
            DeploymentNotifier.notifyWithBalloon(WDBundle.message("constantly.fail.to.connect.to.server.0.maybe.configure.turn.off.auto.notification", serverConfig.getName()), failure, NotificationType.WARNING, project, FileTransferToolWindow.ID_PROVIDER, new AnAction[]{turnOffAction});
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileObject";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 13: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "publishConfig";
                break;
            }
            case 8: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 14: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pi";
                break;
            }
            case 15: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverConfig";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteFile";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "local";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/plugins/webDeployment/conflicts/RemoteChangeNotifier";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "updateNotificationsForRemoteItem";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "updateNotificationsForLocalItem";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "updateNotifications";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "updateNotificationForAllEditors";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "hideNotification";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "updateNotificationForTheEditor";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "getNotificationCreator";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "isRemoteFileChangedAndLocalFileDifferentFromRemote";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "createRevision";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$createRevision$2";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getNotificationCreator$1";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$updateNotifications$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

