/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.BaseCoverageSuite;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.JavaCoverageRunner;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.util.PathUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jacoco.agent.rt.RT;
import org.jacoco.core.analysis.Analyzer;
import org.jacoco.core.analysis.CoverageBuilder;
import org.jacoco.core.analysis.IClassCoverage;
import org.jacoco.core.analysis.ICoverageVisitor;
import org.jacoco.core.analysis.ILine;
import org.jacoco.core.analysis.IMethodCoverage;
import org.jacoco.core.data.ExecutionDataReader;
import org.jacoco.core.data.ExecutionDataStore;
import org.jacoco.core.data.IExecutionDataVisitor;
import org.jacoco.core.data.ISessionInfoVisitor;
import org.jacoco.core.data.SessionInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JaCoCoCoverageRunner
extends JavaCoverageRunner {
    private static final Logger LOG = Logger.getInstance(JaCoCoCoverageRunner.class);

    @Override
    public ProjectData loadCoverageData(@NotNull File sessionDataFile, @Nullable CoverageSuite baseCoverageSuite) {
        if (sessionDataFile == null) {
            JaCoCoCoverageRunner.$$$reportNull$$$0(0);
        }
        ProjectData data = new ProjectData();
        try {
            Project project;
            Project project2 = project = baseCoverageSuite instanceof BaseCoverageSuite ? baseCoverageSuite.getProject() : null;
            if (project != null) {
                RunConfigurationBase configuration = ((BaseCoverageSuite)baseCoverageSuite).getConfiguration();
                Module mainModule = configuration instanceof ModuleBasedConfiguration ? ((ModuleBasedConfiguration)configuration).getConfigurationModule().getModule() : null;
                JaCoCoCoverageRunner.loadExecutionData(sessionDataFile, data, mainModule, project);
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return data;
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadExecutionData(@NotNull File sessionDataFile, ProjectData data, @Nullable Module mainModule, @NotNull Project project) throws IOException {
        Module[] modules;
        if (sessionDataFile == null) {
            JaCoCoCoverageRunner.$$$reportNull$$$0(1);
        }
        if (project == null) {
            JaCoCoCoverageRunner.$$$reportNull$$$0(2);
        }
        ExecutionDataStore executionDataStore = new ExecutionDataStore();
        try (FileInputStream fis = null;){
            fis = new FileInputStream(sessionDataFile);
            ExecutionDataReader executionDataReader = new ExecutionDataReader((InputStream)fis);
            executionDataReader.setExecutionDataVisitor((IExecutionDataVisitor)executionDataStore);
            executionDataReader.setSessionInfoVisitor(new ISessionInfoVisitor(){

                public void visitSessionInfo(SessionInfo info) {
                    System.out.println(info.toString());
                }
            });
            while (executionDataReader.read()) {
            }
        }
        CoverageBuilder coverageBuilder = new CoverageBuilder();
        final Analyzer analyzer = new Analyzer(executionDataStore, (ICoverageVisitor)coverageBuilder);
        if (mainModule != null) {
            HashSet mainModuleWithDependencies = new HashSet();
            ReadAction.run(() -> ModuleUtilCore.getDependencies((Module)mainModule, (Set)mainModuleWithDependencies));
            modules = mainModuleWithDependencies.toArray(Module.EMPTY_ARRAY);
        } else {
            modules = ModuleManager.getInstance((Project)project).getModules();
        }
        for (Module module : modules) {
            CompilerModuleExtension compilerModuleExtension = CompilerModuleExtension.getInstance((Module)module);
            if (compilerModuleExtension == null) continue;
            String[] roots = compilerModuleExtension.getOutputRootUrls(true);
            for (String root : roots) {
                try {
                    String rootPath = VfsUtilCore.urlToPath((String)root);
                    Files.walkFileTree(Paths.get(new File(FileUtil.toSystemDependentName((String)rootPath)).toURI()), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                            File file = path.toFile();
                            try {
                                analyzer.analyzeAll(file);
                            }
                            catch (Exception e) {
                                LOG.info((Throwable)e);
                            }
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                catch (NoSuchFileException rootPath) {
                    // empty catch block
                }
            }
        }
        for (IClassCoverage classCoverage : coverageBuilder.getClasses()) {
            String className = classCoverage.getName();
            className = className.replace('\\', '.').replace('/', '.');
            ClassData classData = data.getOrCreateClassData(className);
            Collection methods = classCoverage.getMethods();
            LineData[] lines = new LineData[classCoverage.getLastLine() + 1];
            for (IMethodCoverage method : methods) {
                String desc = method.getName() + method.getDesc();
                int firstLine = method.getFirstLine();
                int lastLine = method.getLastLine();
                for (int i = firstLine; i <= lastLine; ++i) {
                    ILine methodLine = method.getLine(i);
                    final int methodLineStatus = methodLine.getStatus();
                    if (methodLineStatus == 0) continue;
                    LineData lineData = new LineData(i, desc){

                        public int getStatus() {
                            switch (methodLineStatus) {
                                case 2: {
                                    return 2;
                                }
                                case 3: {
                                    return 1;
                                }
                            }
                            return 0;
                        }
                    };
                    lineData.setHits(methodLineStatus == 2 || methodLineStatus == 3 ? 1 : 0);
                    lines[i] = lineData;
                }
            }
            classData.setLines(lines);
        }
    }

    @Override
    public void appendCoverageArgument(String sessionDataFilePath, String[] patterns, SimpleJavaParameters javaParameters, boolean collectLineInfo, boolean isSampling) {
        StringBuilder argument = new StringBuilder("-javaagent:");
        String agentPath = PathUtil.getJarPathForClass(RT.class);
        String parentPath = JaCoCoCoverageRunner.handleSpacesInPath(agentPath);
        argument.append(parentPath).append(File.separator).append(new File(agentPath).getName());
        argument.append("=");
        argument.append("destfile=").append(sessionDataFilePath);
        argument.append(",append=false");
        javaParameters.getVMParametersList().add(argument.toString());
    }

    @Override
    public String getPresentableName() {
        return "JaCoCo";
    }

    @Override
    public String getId() {
        return "jacoco";
    }

    @Override
    public String getDataFileExtension() {
        return "exec";
    }

    @Override
    public boolean isCoverageByTestApplicable() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionDataFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/coverage/JaCoCoCoverageRunner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "loadCoverageData";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "loadExecutionData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

