/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.applet;

import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AudioClip;
import java.awt.Image;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.swing.applet.AppletViewer;
import org.fest.swing.applet.StatusDisplay;
import org.fest.util.Lists;
import org.fest.util.Maps;
import org.fest.util.Preconditions;

public class BasicAppletContext
implements AppletContext {
    private static final Enumeration<Applet> NO_APPLETS = new EmptyAppletEnumeration();
    private final Map<String, InputStream> streamMap;
    private final StatusDisplay statusDisplay;

    public BasicAppletContext(@Nonnull StatusDisplay statusDisplay) {
        if (statusDisplay == null) {
            BasicAppletContext.$$$reportNull$$$0(0);
        }
        this.streamMap = Maps.newHashMap();
        this.statusDisplay = (StatusDisplay)Preconditions.checkNotNull((Object)statusDisplay);
    }

    @Override
    @Nullable
    public Applet getApplet(@Nullable String name) {
        return BasicAppletContext.appletFrom(this.statusDisplay);
    }

    @Override
    @Nonnull
    public Enumeration<Applet> getApplets() {
        Applet applet = BasicAppletContext.appletFrom(this.statusDisplay);
        Enumeration<Applet> enumeration = applet == null ? NO_APPLETS : Collections.enumeration(Lists.newArrayList((Object[])new Applet[]{applet}));
        if (enumeration == null) {
            BasicAppletContext.$$$reportNull$$$0(1);
        }
        return enumeration;
    }

    @Nullable
    private static Applet appletFrom(@Nullable StatusDisplay statusDisplay) {
        if (!(statusDisplay instanceof AppletViewer)) {
            return null;
        }
        AppletViewer viewer = (AppletViewer)statusDisplay;
        return viewer.getApplet();
    }

    @Override
    @Nullable
    public AudioClip getAudioClip(@Nullable URL url) {
        return null;
    }

    @Override
    @Nullable
    public Image getImage(@Nullable URL url) {
        return null;
    }

    @Override
    @Nullable
    public InputStream getStream(@Nullable String key) {
        return this.streamMap.get(key);
    }

    @Override
    @Nonnull
    public Iterator<String> getStreamKeys() {
        Iterator<String> iterator = this.streamMap.keySet().iterator();
        if (iterator == null) {
            BasicAppletContext.$$$reportNull$$$0(2);
        }
        return iterator;
    }

    @Override
    public void setStream(@Nullable String key, @Nullable InputStream stream) {
        if (stream == null) {
            this.streamMap.remove(key);
            return;
        }
        this.streamMap.put(key, stream);
    }

    @Override
    public void showDocument(@Nullable URL url) {
    }

    @Override
    public void showDocument(@Nullable URL url, @Nullable String target) {
    }

    @Override
    public void showStatus(String status) {
        this.statusDisplay.showStatus((String)Preconditions.checkNotNull((Object)status));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusDisplay";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/applet/BasicAppletContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/applet/BasicAppletContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplets";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStreamKeys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class EmptyAppletEnumeration
    implements Enumeration<Applet> {
        EmptyAppletEnumeration() {
        }

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        @Nullable
        public Applet nextElement() {
            return null;
        }
    }
}

