/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import java.awt.Component;
import java.awt.Container;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JLabel;
import org.fest.assertions.Assertions;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.BasicComponentPrinter;
import org.fest.swing.core.ComponentFinder;
import org.fest.swing.core.ComponentMatcher;
import org.fest.swing.core.ComponentPrinter;
import org.fest.swing.core.FinderDelegate;
import org.fest.swing.core.GenericTypeMatcher;
import org.fest.swing.core.LabelMatcher;
import org.fest.swing.core.NameMatcher;
import org.fest.swing.core.Settings;
import org.fest.swing.core.TypeMatcher;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiTask;
import org.fest.swing.exception.ComponentLookupException;
import org.fest.swing.format.Formatting;
import org.fest.swing.hierarchy.ComponentHierarchy;
import org.fest.swing.hierarchy.ExistingHierarchy;
import org.fest.swing.hierarchy.NewHierarchy;
import org.fest.swing.hierarchy.SingleComponentHierarchy;
import org.fest.util.Preconditions;
import org.fest.util.Strings;
import org.fest.util.SystemProperties;

public final class BasicComponentFinder
implements ComponentFinder {
    private final ComponentHierarchy hierarchy;
    private final ComponentPrinter printer;
    private final Settings settings;
    private final FinderDelegate finderDelegate;
    private boolean includeHierarchyInComponentLookupException;

    @Nonnull
    public static ComponentFinder finderWithNewAwtHierarchy() {
        BasicComponentFinder basicComponentFinder = new BasicComponentFinder(NewHierarchy.ignoreExistingComponents());
        if (basicComponentFinder == null) {
            BasicComponentFinder.$$$reportNull$$$0(0);
        }
        return basicComponentFinder;
    }

    @Nonnull
    public static ComponentFinder finderWithCurrentAwtHierarchy() {
        BasicComponentFinder basicComponentFinder = new BasicComponentFinder(new ExistingHierarchy());
        if (basicComponentFinder == null) {
            BasicComponentFinder.$$$reportNull$$$0(1);
        }
        return basicComponentFinder;
    }

    protected BasicComponentFinder(@Nonnull ComponentHierarchy hierarchy) {
        if (hierarchy == null) {
            BasicComponentFinder.$$$reportNull$$$0(2);
        }
        this(hierarchy, null);
    }

    protected BasicComponentFinder(@Nonnull ComponentHierarchy hierarchy, @Nullable Settings settings) {
        if (hierarchy == null) {
            BasicComponentFinder.$$$reportNull$$$0(3);
        }
        this.finderDelegate = new FinderDelegate();
        this.hierarchy = hierarchy;
        this.settings = settings;
        this.printer = new BasicComponentPrinter(hierarchy);
        this.includeHierarchyIfComponentNotFound(true);
    }

    @Override
    @Nonnull
    public ComponentPrinter printer() {
        ComponentPrinter componentPrinter = this.printer;
        if (componentPrinter == null) {
            BasicComponentFinder.$$$reportNull$$$0(4);
        }
        return componentPrinter;
    }

    @Override
    @Nonnull
    public <T extends Component> T findByType(@Nonnull Class<T> type) {
        if (type == null) {
            BasicComponentFinder.$$$reportNull$$$0(5);
        }
        T t = this.findByType(type, this.requireShowing());
        if (t == null) {
            BasicComponentFinder.$$$reportNull$$$0(6);
        }
        return t;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public <T extends Component> T findByType(@Nonnull Class<T> type, boolean showing) {
        if (type == null) {
            BasicComponentFinder.$$$reportNull$$$0(7);
        }
        Component component = (Component)type.cast(this.find(new TypeMatcher(type, showing)));
        if (component == null) {
            BasicComponentFinder.$$$reportNull$$$0(8);
        }
        return (T)component;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public <T extends Component> T findByType(@Nonnull Container root, @Nonnull Class<T> type) {
        if (root == null) {
            BasicComponentFinder.$$$reportNull$$$0(9);
        }
        if (type == null) {
            BasicComponentFinder.$$$reportNull$$$0(10);
        }
        T t = this.findByType(root, type, this.requireShowing());
        if (t == null) {
            BasicComponentFinder.$$$reportNull$$$0(11);
        }
        return t;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public <T extends Component> T findByType(@Nonnull Container root, @Nonnull Class<T> type, boolean showing) {
        if (root == null) {
            BasicComponentFinder.$$$reportNull$$$0(12);
        }
        if (type == null) {
            BasicComponentFinder.$$$reportNull$$$0(13);
        }
        Component component = (Component)type.cast(this.find(root, (ComponentMatcher)new TypeMatcher(type, showing)));
        if (component == null) {
            BasicComponentFinder.$$$reportNull$$$0(14);
        }
        return (T)component;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public <T extends Component> T findByName(@Nullable String name, @Nonnull Class<T> type) {
        if (type == null) {
            BasicComponentFinder.$$$reportNull$$$0(15);
        }
        T t = this.findByName(name, type, this.requireShowing());
        if (t == null) {
            BasicComponentFinder.$$$reportNull$$$0(16);
        }
        return t;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public <T extends Component> T findByName(@Nullable String name, @Nonnull Class<T> type, boolean showing) {
        if (type == null) {
            BasicComponentFinder.$$$reportNull$$$0(17);
        }
        Component found = this.find(new NameMatcher(name, type, showing));
        Component component = (Component)type.cast(found);
        if (component == null) {
            BasicComponentFinder.$$$reportNull$$$0(18);
        }
        return (T)component;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public Component findByName(@Nullable String name) {
        Component component = this.findByName(name, this.requireShowing());
        if (component == null) {
            BasicComponentFinder.$$$reportNull$$$0(19);
        }
        return component;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public Component findByName(@Nullable String name, boolean showing) {
        Component component = this.find(new NameMatcher(name, showing));
        if (component == null) {
            BasicComponentFinder.$$$reportNull$$$0(20);
        }
        return component;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public <T extends Component> T findByLabel(@Nullable String label, @Nonnull Class<T> type) {
        if (type == null) {
            BasicComponentFinder.$$$reportNull$$$0(21);
        }
        T t = this.findByLabel(label, type, this.requireShowing());
        if (t == null) {
            BasicComponentFinder.$$$reportNull$$$0(22);
        }
        return t;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public <T extends Component> T findByLabel(@Nullable String label, @Nonnull Class<T> type, boolean showing) {
        if (type == null) {
            BasicComponentFinder.$$$reportNull$$$0(23);
        }
        Component found = this.find(new LabelMatcher(label, type, showing));
        Component component = (Component)this.labelFor(found, type);
        if (component == null) {
            BasicComponentFinder.$$$reportNull$$$0(24);
        }
        return (T)component;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public Component findByLabel(@Nullable String label) {
        Component component = this.findByLabel(label, this.requireShowing());
        if (component == null) {
            BasicComponentFinder.$$$reportNull$$$0(25);
        }
        return component;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public Component findByLabel(@Nullable String label, boolean showing) {
        Component found = this.find(new LabelMatcher(label, showing));
        Component component = this.labelFor(found, Component.class);
        if (component == null) {
            BasicComponentFinder.$$$reportNull$$$0(26);
        }
        return component;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public <T extends Component> T find(@Nonnull GenericTypeMatcher<T> m) {
        if (m == null) {
            BasicComponentFinder.$$$reportNull$$$0(27);
        }
        Component found = this.find((ComponentMatcher)m);
        Component component = (Component)m.supportedType().cast(found);
        if (component == null) {
            BasicComponentFinder.$$$reportNull$$$0(28);
        }
        return (T)component;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public Component find(@Nonnull ComponentMatcher m) {
        if (m == null) {
            BasicComponentFinder.$$$reportNull$$$0(29);
        }
        Component component = this.find(this.hierarchy, m);
        if (component == null) {
            BasicComponentFinder.$$$reportNull$$$0(30);
        }
        return component;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public <T extends Component> T findByName(@Nonnull Container root, @Nullable String name, @Nonnull Class<T> type) {
        if (root == null) {
            BasicComponentFinder.$$$reportNull$$$0(31);
        }
        if (type == null) {
            BasicComponentFinder.$$$reportNull$$$0(32);
        }
        T t = this.findByName(root, name, type, this.requireShowing());
        if (t == null) {
            BasicComponentFinder.$$$reportNull$$$0(33);
        }
        return t;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public <T extends Component> T findByName(@Nonnull Container root, @Nullable String name, @Nonnull Class<T> type, boolean showing) {
        if (root == null) {
            BasicComponentFinder.$$$reportNull$$$0(34);
        }
        if (type == null) {
            BasicComponentFinder.$$$reportNull$$$0(35);
        }
        Component found = this.find(root, (ComponentMatcher)new NameMatcher(name, type, showing));
        Component component = (Component)type.cast(found);
        if (component == null) {
            BasicComponentFinder.$$$reportNull$$$0(36);
        }
        return (T)component;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public Component findByName(@Nonnull Container root, @Nullable String name) {
        if (root == null) {
            BasicComponentFinder.$$$reportNull$$$0(37);
        }
        Component component = this.findByName(root, name, this.requireShowing());
        if (component == null) {
            BasicComponentFinder.$$$reportNull$$$0(38);
        }
        return component;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public Component findByName(@Nonnull Container root, @Nullable String name, boolean showing) {
        if (root == null) {
            BasicComponentFinder.$$$reportNull$$$0(39);
        }
        Component component = this.find(root, (ComponentMatcher)new NameMatcher(name, showing));
        if (component == null) {
            BasicComponentFinder.$$$reportNull$$$0(40);
        }
        return component;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public <T extends Component> T findByLabel(@Nonnull Container root, @Nullable String label, @Nonnull Class<T> type) {
        if (root == null) {
            BasicComponentFinder.$$$reportNull$$$0(41);
        }
        if (type == null) {
            BasicComponentFinder.$$$reportNull$$$0(42);
        }
        T t = this.findByLabel(root, label, type, this.requireShowing());
        if (t == null) {
            BasicComponentFinder.$$$reportNull$$$0(43);
        }
        return t;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public <T extends Component> T findByLabel(@Nonnull Container root, @Nullable String label, @Nonnull Class<T> type, boolean showing) {
        if (root == null) {
            BasicComponentFinder.$$$reportNull$$$0(44);
        }
        if (type == null) {
            BasicComponentFinder.$$$reportNull$$$0(45);
        }
        Component found = this.find(root, (ComponentMatcher)new LabelMatcher(label, type, showing));
        Component component = (Component)this.labelFor(found, type);
        if (component == null) {
            BasicComponentFinder.$$$reportNull$$$0(46);
        }
        return (T)component;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public Component findByLabel(@Nonnull Container root, @Nullable String label) {
        if (root == null) {
            BasicComponentFinder.$$$reportNull$$$0(47);
        }
        Component component = this.findByLabel(root, label, this.requireShowing());
        if (component == null) {
            BasicComponentFinder.$$$reportNull$$$0(48);
        }
        return component;
    }

    private boolean requireShowing() {
        return this.requireShowingFromSettingsOr(false);
    }

    @Override
    @Nonnull
    @RunsInEDT
    public Component findByLabel(@Nonnull Container root, @Nullable String label, boolean showing) {
        if (root == null) {
            BasicComponentFinder.$$$reportNull$$$0(49);
        }
        Component found = this.find(root, (ComponentMatcher)new LabelMatcher(label, showing));
        Component component = this.labelFor(found, Component.class);
        if (component == null) {
            BasicComponentFinder.$$$reportNull$$$0(50);
        }
        return component;
    }

    @Nonnull
    private <T> T labelFor(@Nonnull Component label, @Nonnull Class<T> type) {
        if (label == null) {
            BasicComponentFinder.$$$reportNull$$$0(51);
        }
        if (type == null) {
            BasicComponentFinder.$$$reportNull$$$0(52);
        }
        Assertions.assertThat((Object)label).isInstanceOf(JLabel.class);
        Component target = ((JLabel)label).getLabelFor();
        Assertions.assertThat((Object)target).isInstanceOf(type);
        T t = type.cast(target);
        if (t == null) {
            BasicComponentFinder.$$$reportNull$$$0(53);
        }
        return t;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public <T extends Component> T find(@Nonnull Container root, @Nonnull GenericTypeMatcher<T> m) {
        if (root == null) {
            BasicComponentFinder.$$$reportNull$$$0(54);
        }
        if (m == null) {
            BasicComponentFinder.$$$reportNull$$$0(55);
        }
        Component found = this.find(root, (ComponentMatcher)m);
        Component component = (Component)m.supportedType().cast(found);
        if (component == null) {
            BasicComponentFinder.$$$reportNull$$$0(56);
        }
        return (T)component;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public Component find(@Nullable Container root, @Nonnull ComponentMatcher m) {
        if (m == null) {
            BasicComponentFinder.$$$reportNull$$$0(57);
        }
        Component component = this.find(this.hierarchy(root), m);
        if (component == null) {
            BasicComponentFinder.$$$reportNull$$$0(58);
        }
        return component;
    }

    @Nonnull
    @RunsInEDT
    private Component find(@Nonnull ComponentHierarchy h, @Nonnull ComponentMatcher m) {
        Collection<Component> found;
        if (h == null) {
            BasicComponentFinder.$$$reportNull$$$0(59);
        }
        if (m == null) {
            BasicComponentFinder.$$$reportNull$$$0(60);
        }
        if ((found = this.finderDelegate.find(h, m)).isEmpty()) {
            throw this.componentNotFound(h, m);
        }
        if (found.size() > 1) {
            throw BasicComponentFinder.multipleComponentsFound(found, m);
        }
        Component component = (Component)Preconditions.checkNotNull((Object)found.iterator().next());
        if (component == null) {
            BasicComponentFinder.$$$reportNull$$$0(61);
        }
        return component;
    }

    @Nonnull
    @RunsInEDT
    private ComponentLookupException componentNotFound(@Nonnull ComponentHierarchy h, @Nonnull ComponentMatcher m) {
        if (h == null) {
            BasicComponentFinder.$$$reportNull$$$0(62);
        }
        if (m == null) {
            BasicComponentFinder.$$$reportNull$$$0(63);
        }
        String message = Strings.concat((Object[])new Object[]{"Unable to find component using matcher ", m, "."});
        if (this.includeHierarchyIfComponentNotFound()) {
            message = Strings.concat((Object[])new Object[]{message, SystemProperties.lineSeparator(), SystemProperties.lineSeparator(), "Component hierarchy:", SystemProperties.lineSeparator(), this.formattedHierarchy(BasicComponentFinder.root(h))});
        }
        throw new ComponentLookupException(message);
    }

    @Nullable
    private static Container root(@Nullable ComponentHierarchy h) {
        if (h instanceof SingleComponentHierarchy) {
            return ((SingleComponentHierarchy)h).root();
        }
        return null;
    }

    @Nonnull
    @RunsInEDT
    private String formattedHierarchy(@Nullable Container root) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(out, true);
        this.printer.printComponents(printStream, root);
        printStream.flush();
        String string = new String(out.toByteArray());
        if (string == null) {
            BasicComponentFinder.$$$reportNull$$$0(64);
        }
        return string;
    }

    @Nonnull
    @RunsInEDT
    private static ComponentLookupException multipleComponentsFound(@Nonnull Collection<Component> found, @Nonnull ComponentMatcher m) {
        if (found == null) {
            BasicComponentFinder.$$$reportNull$$$0(65);
        }
        if (m == null) {
            BasicComponentFinder.$$$reportNull$$$0(66);
        }
        StringBuilder message = new StringBuilder();
        String format = "Found more than one component using matcher %s. %n%nFound:";
        message.append(String.format(format, m.toString()));
        BasicComponentFinder.appendComponents(message, found);
        if (!found.isEmpty()) {
            message.append(SystemProperties.lineSeparator());
        }
        throw new ComponentLookupException(message.toString(), found);
    }

    @RunsInEDT
    private static void appendComponents(final @Nonnull StringBuilder message, final @Nonnull Collection<Component> found) {
        if (message == null) {
            BasicComponentFinder.$$$reportNull$$$0(67);
        }
        if (found == null) {
            BasicComponentFinder.$$$reportNull$$$0(68);
        }
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                for (Component c : found) {
                    message.append(String.format("%n%s", Formatting.format(c)));
                }
            }
        });
    }

    @Override
    public boolean includeHierarchyIfComponentNotFound() {
        return this.includeHierarchyInComponentLookupException;
    }

    @Override
    public void includeHierarchyIfComponentNotFound(boolean newValue) {
        this.includeHierarchyInComponentLookupException = newValue;
    }

    @Override
    @Nonnull
    public Collection<Component> findAll(@Nonnull ComponentMatcher m) {
        if (m == null) {
            BasicComponentFinder.$$$reportNull$$$0(69);
        }
        Collection<Component> collection = this.finderDelegate.find(this.hierarchy, m);
        if (collection == null) {
            BasicComponentFinder.$$$reportNull$$$0(70);
        }
        return collection;
    }

    @Override
    @Nonnull
    public Collection<Component> findAll(@Nonnull Container root, @Nonnull ComponentMatcher m) {
        if (root == null) {
            BasicComponentFinder.$$$reportNull$$$0(71);
        }
        if (m == null) {
            BasicComponentFinder.$$$reportNull$$$0(72);
        }
        Collection<Component> collection = this.finderDelegate.find(this.hierarchy(root), m);
        if (collection == null) {
            BasicComponentFinder.$$$reportNull$$$0(73);
        }
        return collection;
    }

    @Override
    @Nonnull
    public <T extends Component> Collection<T> findAll(@Nonnull GenericTypeMatcher<T> m) {
        if (m == null) {
            BasicComponentFinder.$$$reportNull$$$0(74);
        }
        Collection<T> collection = this.finderDelegate.find(this.hierarchy, m);
        if (collection == null) {
            BasicComponentFinder.$$$reportNull$$$0(75);
        }
        return collection;
    }

    @Override
    @Nonnull
    public <T extends Component> Collection<T> findAll(@Nonnull Container root, @Nonnull GenericTypeMatcher<T> m) {
        if (root == null) {
            BasicComponentFinder.$$$reportNull$$$0(76);
        }
        if (m == null) {
            BasicComponentFinder.$$$reportNull$$$0(77);
        }
        ComponentHierarchy h = this.hierarchy(root);
        Collection<T> collection = this.finderDelegate.find(h, m);
        if (collection == null) {
            BasicComponentFinder.$$$reportNull$$$0(78);
        }
        return collection;
    }

    protected final boolean requireShowingFromSettingsOr(boolean defaultValue) {
        if (this.settings == null) {
            return defaultValue;
        }
        return this.settings.componentLookupScope().requireShowing();
    }

    @Nonnull
    private ComponentHierarchy hierarchy(@Nullable Container root) {
        if (root == null) {
            ComponentHierarchy componentHierarchy = this.hierarchy;
            if (componentHierarchy == null) {
                BasicComponentFinder.$$$reportNull$$$0(79);
            }
            return componentHierarchy;
        }
        SingleComponentHierarchy singleComponentHierarchy = new SingleComponentHierarchy(root, this.hierarchy);
        if (singleComponentHierarchy == null) {
            BasicComponentFinder.$$$reportNull$$$0(80);
        }
        return singleComponentHierarchy;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 21: 
            case 23: 
            case 27: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 57: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 71: 
            case 72: 
            case 74: 
            case 76: 
            case 77: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 21: 
            case 23: 
            case 27: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 57: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 71: 
            case 72: 
            case 74: 
            case 76: 
            case 77: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/core/BasicComponentFinder";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hierarchy";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 13: 
            case 15: 
            case 17: 
            case 21: 
            case 23: 
            case 32: 
            case 35: 
            case 42: 
            case 45: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 9: 
            case 12: 
            case 31: 
            case 34: 
            case 37: 
            case 39: 
            case 41: 
            case 44: 
            case 47: 
            case 49: 
            case 54: 
            case 71: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 27: 
            case 29: 
            case 55: 
            case 57: 
            case 60: 
            case 63: 
            case 66: 
            case 69: 
            case 72: 
            case 74: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 59: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "h";
                break;
            }
            case 65: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "found";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "finderWithNewAwtHierarchy";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "finderWithCurrentAwtHierarchy";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 21: 
            case 23: 
            case 27: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 57: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 71: 
            case 72: 
            case 74: 
            case 76: 
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/core/BasicComponentFinder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "printer";
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "findByType";
                break;
            }
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 33: 
            case 36: 
            case 38: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "findByName";
                break;
            }
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 43: 
            case 46: 
            case 48: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "findByLabel";
                break;
            }
            case 28: 
            case 30: 
            case 56: 
            case 58: 
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "find";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "labelFor";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "formattedHierarchy";
                break;
            }
            case 70: 
            case 73: 
            case 75: 
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "findAll";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "hierarchy";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findByType";
                break;
            }
            case 15: 
            case 17: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 37: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "findByName";
                break;
            }
            case 21: 
            case 23: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 47: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "findByLabel";
                break;
            }
            case 27: 
            case 29: 
            case 54: 
            case 55: 
            case 57: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "labelFor";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "componentNotFound";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "multipleComponentsFound";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "appendComponents";
                break;
            }
            case 69: 
            case 71: 
            case 72: 
            case 74: 
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "findAll";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 21: 
            case 23: 
            case 27: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 57: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 71: 
            case 72: 
            case 74: 
            case 76: 
            case 77: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

