/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.InvocationEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.awt.AWT;
import org.fest.swing.core.AWTEventPoster;
import org.fest.swing.core.ActivateWindowTask;
import org.fest.swing.core.BasicComponentFinder;
import org.fest.swing.core.ComponentFinder;
import org.fest.swing.core.ComponentIsFocusableQuery;
import org.fest.swing.core.ComponentMatcher;
import org.fest.swing.core.ComponentPrinter;
import org.fest.swing.core.ComponentRequestFocusTask;
import org.fest.swing.core.FocusMonitor;
import org.fest.swing.core.FocusOwnerFinder;
import org.fest.swing.core.InputEventGenerator;
import org.fest.swing.core.InputModifiers;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.Robot;
import org.fest.swing.core.RobotEventGenerator;
import org.fest.swing.core.Scrolling;
import org.fest.swing.core.Settings;
import org.fest.swing.core.TypeMatcher;
import org.fest.swing.core.UnexpectedJOptionPaneFinder;
import org.fest.swing.core.WindowAncestorFinder;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.edt.GuiTask;
import org.fest.swing.exception.ActionFailedException;
import org.fest.swing.exception.ComponentLookupException;
import org.fest.swing.exception.WaitTimedOutError;
import org.fest.swing.format.Formatting;
import org.fest.swing.hierarchy.ComponentHierarchy;
import org.fest.swing.hierarchy.ExistingHierarchy;
import org.fest.swing.hierarchy.NewHierarchy;
import org.fest.swing.input.InputState;
import org.fest.swing.keystroke.KeyStrokeMap;
import org.fest.swing.lock.ScreenLock;
import org.fest.swing.monitor.WindowMonitor;
import org.fest.swing.query.ComponentShowingQuery;
import org.fest.swing.timing.Pause;
import org.fest.swing.util.Modifiers;
import org.fest.swing.util.Pair;
import org.fest.swing.util.TimeoutWatch;
import org.fest.swing.util.ToolkitProvider;
import org.fest.util.Lists;
import org.fest.util.Preconditions;
import org.fest.util.Strings;
import org.fest.util.VisibleForTesting;

public class BasicRobot
implements Robot {
    private static final int POPUP_DELAY = 10000;
    private static final int POPUP_TIMEOUT = 5000;
    private static final int WINDOW_DELAY = 20000;
    private static final ComponentMatcher POPUP_MATCHER = new TypeMatcher(JPopupMenu.class, true);
    private volatile boolean active;
    private static final Runnable EMPTY_RUNNABLE = new Runnable(){

        @Override
        public void run() {
        }
    };
    private static final int BUTTON_MASK = 28;
    private static Toolkit toolkit = ToolkitProvider.instance().defaultToolkit();
    private static WindowMonitor windowMonitor = WindowMonitor.instance();
    private static InputState inputState = new InputState(toolkit);
    private final ComponentHierarchy hierarchy;
    private final Object screenLockOwner;
    private final ComponentFinder finder;
    private final Settings settings;
    private final AWTEventPoster eventPoster;
    private final InputEventGenerator eventGenerator;
    private final UnexpectedJOptionPaneFinder unexpectedJOptionPaneFinder;

    @Nonnull
    public static Robot robotWithNewAwtHierarchy() {
        Object screenLockOwner = BasicRobot.acquireScreenLock();
        BasicRobot basicRobot = new BasicRobot(screenLockOwner, NewHierarchy.ignoreExistingComponents());
        if (basicRobot == null) {
            BasicRobot.$$$reportNull$$$0(0);
        }
        return basicRobot;
    }

    @Nonnull
    public static Robot robotWithNewAwtHierarchyWithoutScreenLock() {
        BasicRobot basicRobot = new BasicRobot(null, NewHierarchy.ignoreExistingComponents());
        if (basicRobot == null) {
            BasicRobot.$$$reportNull$$$0(1);
        }
        return basicRobot;
    }

    @Nonnull
    public static Robot robotWithCurrentAwtHierarchy() {
        Object screenLockOwner = BasicRobot.acquireScreenLock();
        BasicRobot basicRobot = new BasicRobot(screenLockOwner, new ExistingHierarchy());
        if (basicRobot == null) {
            BasicRobot.$$$reportNull$$$0(2);
        }
        return basicRobot;
    }

    @Nonnull
    public static Robot robotWithCurrentAwtHierarchyWithoutScreenLock() {
        BasicRobot basicRobot = new BasicRobot(null, new ExistingHierarchy());
        if (basicRobot == null) {
            BasicRobot.$$$reportNull$$$0(3);
        }
        return basicRobot;
    }

    @Nonnull
    private static Object acquireScreenLock() {
        Object screenLockOwner = new Object();
        ScreenLock.instance().acquire(screenLockOwner);
        Object object = screenLockOwner;
        if (object == null) {
            BasicRobot.$$$reportNull$$$0(4);
        }
        return object;
    }

    @VisibleForTesting
    BasicRobot(@Nullable Object screenLockOwner, @Nonnull ComponentHierarchy hierarchy) {
        if (hierarchy == null) {
            BasicRobot.$$$reportNull$$$0(5);
        }
        this.screenLockOwner = screenLockOwner;
        this.hierarchy = hierarchy;
        this.settings = new Settings();
        this.eventGenerator = new RobotEventGenerator(this.settings);
        this.eventPoster = new AWTEventPoster(toolkit, inputState, windowMonitor, this.settings);
        this.finder = new BasicComponentFinder(hierarchy, this.settings);
        this.unexpectedJOptionPaneFinder = new UnexpectedJOptionPaneFinder(this.finder);
        this.active = true;
    }

    @Override
    @Nonnull
    public ComponentPrinter printer() {
        ComponentPrinter componentPrinter = this.finder().printer();
        if (componentPrinter == null) {
            BasicRobot.$$$reportNull$$$0(6);
        }
        return componentPrinter;
    }

    @Override
    @Nonnull
    public ComponentFinder finder() {
        ComponentFinder componentFinder = this.finder;
        if (componentFinder == null) {
            BasicRobot.$$$reportNull$$$0(7);
        }
        return componentFinder;
    }

    @Override
    @RunsInEDT
    public void showWindow(@Nonnull Window w) {
        if (w == null) {
            BasicRobot.$$$reportNull$$$0(8);
        }
        this.showWindow(w, null, true);
    }

    @Override
    @RunsInEDT
    public void showWindow(@Nonnull Window w, @Nonnull Dimension size) {
        if (w == null) {
            BasicRobot.$$$reportNull$$$0(9);
        }
        if (size == null) {
            BasicRobot.$$$reportNull$$$0(10);
        }
        this.showWindow(w, size, true);
    }

    @Override
    @RunsInEDT
    public void showWindow(final @Nonnull Window w, final @Nullable Dimension size, final boolean pack) {
        if (w == null) {
            BasicRobot.$$$reportNull$$$0(11);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (pack) {
                    BasicRobot.this.packAndEnsureSafePosition(w);
                }
                if (size != null) {
                    w.setSize(size);
                }
                w.setVisible(true);
            }
        });
        this.waitForWindow(w);
    }

    @RunsInCurrentThread
    private void packAndEnsureSafePosition(@Nonnull Window w) {
        if (w == null) {
            BasicRobot.$$$reportNull$$$0(12);
        }
        w.pack();
        w.setLocation(100, 100);
    }

    @RunsInEDT
    private void waitForWindow(@Nonnull Window w) {
        if (w == null) {
            BasicRobot.$$$reportNull$$$0(13);
        }
        long start = System.currentTimeMillis();
        while (!windowMonitor.isWindowReady(w) || !ComponentShowingQuery.isShowing(w)) {
            long elapsed = System.currentTimeMillis() - start;
            if (elapsed > 20000L) {
                throw new WaitTimedOutError(Strings.concat((Object[])new Object[]{"Timed out waiting for Window to open (", String.valueOf(elapsed), "ms)"}));
            }
            Pause.pause();
        }
    }

    @Override
    @RunsInEDT
    public void close(@Nonnull Window w) {
        if (w == null) {
            BasicRobot.$$$reportNull$$$0(14);
        }
        WindowEvent event = new WindowEvent(w, 201);
        Applet applet = this.findAppletDescendent(w);
        EventQueue eventQueue = windowMonitor.eventQueueFor(applet != null ? applet : w);
        ((EventQueue)Preconditions.checkNotNull((Object)eventQueue)).postEvent(event);
        this.waitForIdle();
    }

    @Nullable
    @RunsInEDT
    private Applet findAppletDescendent(@Nonnull Container c) {
        ArrayList found;
        if (c == null) {
            BasicRobot.$$$reportNull$$$0(15);
        }
        if ((found = Lists.newArrayList(this.finder.findAll(c, new TypeMatcher(Applet.class)))).size() == 1) {
            return (Applet)found.get(0);
        }
        return null;
    }

    @Override
    @RunsInEDT
    public void focusAndWaitForFocusGain(@Nonnull Component c) {
        if (c == null) {
            BasicRobot.$$$reportNull$$$0(16);
        }
        this.focus(c, true);
    }

    @Override
    @RunsInEDT
    public void focus(@Nonnull Component c) {
        if (c == null) {
            BasicRobot.$$$reportNull$$$0(17);
        }
        this.focus(c, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RunsInEDT
    private void focus(@Nonnull Component target, boolean wait) {
        Component currentOwner;
        if (target == null) {
            BasicRobot.$$$reportNull$$$0(18);
        }
        if ((currentOwner = FocusOwnerFinder.inEdtFocusOwner()) == target) {
            return;
        }
        FocusMonitor focusMonitor = FocusMonitor.attachTo(target);
        this.moveMouse(target);
        this.activateWindowOfFocusTarget(target, currentOwner);
        ComponentRequestFocusTask.giveFocusTo(target);
        try {
            if (wait) {
                TimeoutWatch watch = TimeoutWatch.startWatchWithTimeoutOf(this.settings().timeoutToBeVisible());
                while (!focusMonitor.hasFocus()) {
                    if (watch.isTimeOut()) {
                        throw ActionFailedException.actionFailure(Strings.concat((Object[])new Object[]{"Focus change to ", Formatting.format(target), " failed"}));
                    }
                    Pause.pause();
                }
            }
        }
        finally {
            target.removeFocusListener(focusMonitor);
        }
    }

    @RunsInEDT
    private void activateWindowOfFocusTarget(@Nullable Component target, @Nullable Component currentOwner) {
        Pair<Window, Window> windowAncestors = BasicRobot.windowAncestorsOf(currentOwner, target);
        Window currentOwnerAncestor = (Window)windowAncestors.first;
        Window targetAncestor = (Window)windowAncestors.second;
        if (currentOwnerAncestor == targetAncestor) {
            return;
        }
        this.activate((Window)Preconditions.checkNotNull((Object)targetAncestor));
        this.waitForIdle();
    }

    @RunsInEDT
    private static Pair<Window, Window> windowAncestorsOf(final @Nullable Component one, final @Nullable Component two) {
        return GuiActionRunner.execute(new GuiQuery<Pair<Window, Window>>(){

            @Override
            protected Pair<Window, Window> executeInEDT() throws Throwable {
                return Pair.of(this.windowAncestor(one), this.windowAncestor(two));
            }

            @Nullable
            private Window windowAncestor(Component c) {
                return c != null ? WindowAncestorFinder.windowAncestorOf(c) : null;
            }
        });
    }

    @RunsInEDT
    private void activate(@Nonnull Window w) {
        if (w == null) {
            BasicRobot.$$$reportNull$$$0(19);
        }
        ActivateWindowTask.activateWindow(w);
        this.moveMouse(w);
    }

    @Override
    @RunsInEDT
    public synchronized void cleanUp() {
        this.cleanUp(true);
    }

    @Override
    @RunsInEDT
    public synchronized void cleanUpWithoutDisposingWindows() {
        this.cleanUp(false);
    }

    @RunsInEDT
    private void cleanUp(boolean disposeWindows) {
        try {
            if (disposeWindows) {
                BasicRobot.disposeWindows(this.hierarchy);
            }
            this.releaseMouseButtons();
        }
        finally {
            this.active = false;
            this.releaseScreenLock();
        }
    }

    private void releaseScreenLock() {
        ScreenLock screenLock = ScreenLock.instance();
        if (screenLock.acquiredBy(this.screenLockOwner)) {
            screenLock.release(this.screenLockOwner);
        }
    }

    @RunsInEDT
    private static void disposeWindows(final @Nonnull ComponentHierarchy hierarchy) {
        if (hierarchy == null) {
            BasicRobot.$$$reportNull$$$0(20);
        }
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                for (Container c : hierarchy.roots()) {
                    if (!(c instanceof Window)) continue;
                    BasicRobot.dispose(hierarchy, (Window)c);
                }
            }
        });
    }

    @RunsInCurrentThread
    private static void dispose(@Nonnull ComponentHierarchy hierarchy, @Nonnull Window w) {
        if (hierarchy == null) {
            BasicRobot.$$$reportNull$$$0(21);
        }
        if (w == null) {
            BasicRobot.$$$reportNull$$$0(22);
        }
        hierarchy.dispose(w);
        w.setVisible(false);
        w.dispose();
    }

    @Override
    @RunsInEDT
    public void click(@Nonnull Component c) {
        if (c == null) {
            BasicRobot.$$$reportNull$$$0(23);
        }
        this.click(c, MouseButton.LEFT_BUTTON);
    }

    @Override
    @RunsInEDT
    public void rightClick(@Nonnull Component c) {
        if (c == null) {
            BasicRobot.$$$reportNull$$$0(24);
        }
        this.click(c, MouseButton.RIGHT_BUTTON);
    }

    @Override
    @RunsInEDT
    public void click(@Nonnull Component c, @Nonnull MouseButton button) {
        if (c == null) {
            BasicRobot.$$$reportNull$$$0(25);
        }
        if (button == null) {
            BasicRobot.$$$reportNull$$$0(26);
        }
        this.click(c, button, 1);
    }

    @Override
    @RunsInEDT
    public void doubleClick(@Nonnull Component c) {
        if (c == null) {
            BasicRobot.$$$reportNull$$$0(27);
        }
        this.click(c, MouseButton.LEFT_BUTTON, 2);
    }

    @Override
    @RunsInEDT
    public void click(@Nonnull Component c, @Nonnull MouseButton button, int times) {
        if (c == null) {
            BasicRobot.$$$reportNull$$$0(28);
        }
        if (button == null) {
            BasicRobot.$$$reportNull$$$0(29);
        }
        Point where = AWT.visibleCenterOf(c);
        if (c instanceof JComponent) {
            where = this.scrollIfNecessary((JComponent)c);
        }
        this.click(c, where, button, times);
    }

    @Nonnull
    private Point scrollIfNecessary(@Nonnull JComponent c) {
        if (c == null) {
            BasicRobot.$$$reportNull$$$0(30);
        }
        Scrolling.scrollToVisible(this, c);
        Point point = AWT.visibleCenterOf(c);
        if (point == null) {
            BasicRobot.$$$reportNull$$$0(31);
        }
        return point;
    }

    @Override
    @RunsInEDT
    public void click(@Nonnull Component c, @Nonnull Point where) {
        if (c == null) {
            BasicRobot.$$$reportNull$$$0(32);
        }
        if (where == null) {
            BasicRobot.$$$reportNull$$$0(33);
        }
        this.click(c, where, MouseButton.LEFT_BUTTON, 1);
    }

    @Override
    @RunsInEDT
    public void click(@Nonnull Point where, @Nonnull MouseButton button, int times) {
        if (where == null) {
            BasicRobot.$$$reportNull$$$0(34);
        }
        if (button == null) {
            BasicRobot.$$$reportNull$$$0(35);
        }
        this.doClick(null, where, button, times);
    }

    @Override
    @RunsInEDT
    public void click(@Nonnull Component c, @Nonnull Point where, @Nonnull MouseButton button, int times) {
        if (c == null) {
            BasicRobot.$$$reportNull$$$0(36);
        }
        if (where == null) {
            BasicRobot.$$$reportNull$$$0(37);
        }
        if (button == null) {
            BasicRobot.$$$reportNull$$$0(38);
        }
        this.doClick(c, where, button, times);
    }

    private void doClick(@Nullable Component c, @Nonnull Point where, @Nonnull MouseButton button, int times) {
        if (where == null) {
            BasicRobot.$$$reportNull$$$0(39);
        }
        if (button == null) {
            BasicRobot.$$$reportNull$$$0(40);
        }
        int mask = button.mask;
        int modifierMask = mask & 0xFFFFFFE3;
        mask &= 0x1C;
        this.pressModifiers(modifierMask);
        int delayBetweenEvents = this.settings.delayBetweenEvents();
        if (this.shouldSetDelayBetweenEventsToZeroWhenClicking(times)) {
            this.settings.delayBetweenEvents(0);
        }
        if (c == null) {
            this.eventGenerator.pressMouse(where, mask);
            for (int i = times; i > 1; --i) {
                this.eventGenerator.releaseMouse(mask);
                this.eventGenerator.pressMouse(mask);
            }
        } else {
            this.eventGenerator.pressMouse(c, where, mask);
            for (int i = times; i > 1; --i) {
                this.eventGenerator.releaseMouse(mask);
                this.eventGenerator.pressMouse(mask);
            }
        }
        this.settings.delayBetweenEvents(delayBetweenEvents);
        this.eventGenerator.releaseMouse(mask);
        this.releaseModifiers(modifierMask);
        this.waitForIdle();
    }

    private boolean shouldSetDelayBetweenEventsToZeroWhenClicking(int times) {
        return times > 1;
    }

    @Override
    public void pressModifiers(int modifierMask) {
        for (int modifierKey : Modifiers.keysFor(modifierMask)) {
            this.pressKey(modifierKey);
        }
    }

    @Override
    public void releaseModifiers(int modifierMask) {
        int[] modifierKeys = Modifiers.keysFor(modifierMask);
        for (int i = modifierKeys.length - 1; i >= 0; --i) {
            this.releaseKey(modifierKeys[i]);
        }
    }

    @Override
    @RunsInEDT
    public void moveMouse(@Nonnull Component c) {
        if (c == null) {
            BasicRobot.$$$reportNull$$$0(41);
        }
        this.moveMouse(c, AWT.visibleCenterOf(c));
    }

    @Override
    @RunsInEDT
    public void moveMouse(@Nonnull Component c, @Nonnull Point p) {
        if (c == null) {
            BasicRobot.$$$reportNull$$$0(42);
        }
        if (p == null) {
            BasicRobot.$$$reportNull$$$0(43);
        }
        this.moveMouse(c, p.x, p.y);
    }

    @Override
    @RunsInEDT
    public void moveMouse(@Nonnull Component c, int x, int y) {
        if (c == null) {
            BasicRobot.$$$reportNull$$$0(44);
        }
        if (!this.waitForComponentToBeReady(c, this.settings.timeoutToBeVisible())) {
            throw ActionFailedException.actionFailure(Strings.concat((Object[])new Object[]{"Could not obtain position of component ", Formatting.format(c)}));
        }
        this.eventGenerator.moveMouse(c, x, y);
        this.waitForIdle();
    }

    @Override
    public void moveMouse(@Nonnull Point p) {
        if (p == null) {
            BasicRobot.$$$reportNull$$$0(45);
        }
        this.moveMouse(p.x, p.y);
    }

    @Override
    public void moveMouse(int x, int y) {
        this.eventGenerator.moveMouse(x, y);
    }

    @Override
    public void pressMouse(@Nonnull MouseButton button) {
        if (button == null) {
            BasicRobot.$$$reportNull$$$0(46);
        }
        this.eventGenerator.pressMouse(button.mask);
    }

    @Override
    public void pressMouse(@Nonnull Component c, @Nonnull Point where) {
        if (c == null) {
            BasicRobot.$$$reportNull$$$0(47);
        }
        if (where == null) {
            BasicRobot.$$$reportNull$$$0(48);
        }
        this.pressMouse(c, where, MouseButton.LEFT_BUTTON);
    }

    @Override
    public void pressMouse(@Nonnull Component c, @Nonnull Point where, @Nonnull MouseButton button) {
        if (c == null) {
            BasicRobot.$$$reportNull$$$0(49);
        }
        if (where == null) {
            BasicRobot.$$$reportNull$$$0(50);
        }
        if (button == null) {
            BasicRobot.$$$reportNull$$$0(51);
        }
        this.jitter(c, where);
        this.moveMouse(c, where.x, where.y);
        this.eventGenerator.pressMouse(c, where, button.mask);
    }

    @Override
    public void pressMouse(@Nonnull Point where, @Nonnull MouseButton button) {
        if (where == null) {
            BasicRobot.$$$reportNull$$$0(52);
        }
        if (button == null) {
            BasicRobot.$$$reportNull$$$0(53);
        }
        this.eventGenerator.pressMouse(where, button.mask);
    }

    @Override
    @RunsInEDT
    public void releaseMouse(@Nonnull MouseButton button) {
        if (button == null) {
            BasicRobot.$$$reportNull$$$0(54);
        }
        this.mouseRelease(button.mask);
    }

    @Override
    @RunsInEDT
    public void releaseMouseButtons() {
        int buttons = inputState.buttons();
        if (buttons == 0) {
            return;
        }
        this.mouseRelease(buttons);
    }

    @Override
    public void rotateMouseWheel(@Nonnull Component c, int amount) {
        if (c == null) {
            BasicRobot.$$$reportNull$$$0(55);
        }
        this.moveMouse(c);
        this.rotateMouseWheel(amount);
    }

    @Override
    public void rotateMouseWheel(int amount) {
        this.eventGenerator.rotateMouseWheel(amount);
        this.waitForIdle();
    }

    @Override
    @RunsInEDT
    public void jitter(@Nonnull Component c) {
        if (c == null) {
            BasicRobot.$$$reportNull$$$0(56);
        }
        this.jitter(c, AWT.visibleCenterOf(c));
    }

    @Override
    @RunsInEDT
    public void jitter(@Nonnull Component c, @Nonnull Point where) {
        if (c == null) {
            BasicRobot.$$$reportNull$$$0(57);
        }
        if (where == null) {
            BasicRobot.$$$reportNull$$$0(58);
        }
        int x = where.x;
        int y = where.y;
        this.moveMouse(c, x > 0 ? x - 1 : x + 1, y);
    }

    @RunsInEDT
    private boolean waitForComponentToBeReady(@Nonnull Component c, long timeout) {
        if (c == null) {
            BasicRobot.$$$reportNull$$$0(59);
        }
        if (this.isReadyForInput(c)) {
            return true;
        }
        TimeoutWatch watch = TimeoutWatch.startWatchWithTimeoutOf(timeout);
        while (!this.isReadyForInput(c)) {
            if (c instanceof JPopupMenu) {
                Pair<Component, Point> invokerAndCenterOfInvoker = BasicRobot.invokerAndCenterOfInvoker((JPopupMenu)c);
                Component invoker = (Component)invokerAndCenterOfInvoker.first;
                if (invoker instanceof JMenu) {
                    this.jitter(invoker, (Point)invokerAndCenterOfInvoker.second);
                }
            }
            if (watch.isTimeOut()) {
                return false;
            }
            Pause.pause();
        }
        return true;
    }

    @Nonnull
    @RunsInEDT
    private static Pair<Component, Point> invokerAndCenterOfInvoker(final @Nonnull JPopupMenu popupMenu) {
        if (popupMenu == null) {
            BasicRobot.$$$reportNull$$$0(60);
        }
        Pair<Component, Point> result = GuiActionRunner.execute(new GuiQuery<Pair<Component, Point>>(){

            @Override
            protected Pair<Component, Point> executeInEDT() {
                Component invoker = (Component)Preconditions.checkNotNull((Object)popupMenu.getInvoker());
                return Pair.of(invoker, AWT.centerOf(invoker));
            }
        });
        Pair pair = (Pair)Preconditions.checkNotNull(result);
        if (pair == null) {
            BasicRobot.$$$reportNull$$$0(61);
        }
        return pair;
    }

    @Override
    @RunsInEDT
    public void enterText(@Nonnull String text) {
        if (text == null) {
            BasicRobot.$$$reportNull$$$0(62);
        }
        Preconditions.checkNotNull((Object)text);
        if (text.isEmpty()) {
            return;
        }
        for (char character : text.toCharArray()) {
            this.type(character);
        }
        this.waitForIdle();
    }

    @Override
    @RunsInEDT
    public void type(char character) {
        KeyStroke keyStroke = KeyStrokeMap.keyStrokeFor(character);
        if (keyStroke == null) {
            Component focus = FocusOwnerFinder.focusOwner();
            if (focus == null) {
                return;
            }
            KeyEvent keyEvent = this.keyEventFor(focus, character);
            this.waitForIdle();
            this.eventPoster.postEvent(focus, keyEvent);
            return;
        }
        this.keyPressAndRelease(keyStroke.getKeyCode(), keyStroke.getModifiers());
    }

    private KeyEvent keyEventFor(Component c, char character) {
        return new KeyEvent(c, 400, System.currentTimeMillis(), 0, 0, character);
    }

    @Override
    @RunsInEDT
    public void pressAndReleaseKey(int keyCode, int ... modifiers) {
        if (modifiers == null) {
            BasicRobot.$$$reportNull$$$0(63);
        }
        this.keyPressAndRelease(keyCode, InputModifiers.unify(modifiers));
        this.waitForIdle();
    }

    @Override
    @RunsInEDT
    public void pressAndReleaseKeys(int ... keyCodes) {
        if (keyCodes == null) {
            BasicRobot.$$$reportNull$$$0(64);
        }
        for (int keyCode : keyCodes) {
            this.keyPressAndRelease(keyCode, 0);
            this.waitForIdle();
            Pause.pause(50L);
        }
    }

    @RunsInEDT
    private void keyPressAndRelease(int keyCode, int modifiers) {
        int updatedModifiers = Modifiers.updateModifierWithKeyCode(keyCode, modifiers);
        this.pressModifiers(updatedModifiers);
        if (updatedModifiers == modifiers) {
            this.doPressKey(keyCode);
            this.eventGenerator.releaseKey(keyCode);
        }
        this.releaseModifiers(updatedModifiers);
    }

    @Override
    @RunsInEDT
    public void pressKey(int keyCode) {
        this.doPressKey(keyCode);
        this.waitForIdle();
    }

    @RunsInEDT
    private void doPressKey(int keyCode) {
        this.eventGenerator.pressKey(keyCode, '\uffff');
    }

    @Override
    @RunsInEDT
    public void releaseKey(int keyCode) {
        this.eventGenerator.releaseKey(keyCode);
        this.waitForIdle();
    }

    @RunsInEDT
    private void mouseRelease(int buttons) {
        this.eventGenerator.releaseMouse(buttons);
    }

    @Override
    @RunsInEDT
    public void waitForIdle() {
        this.waitIfNecessary();
        Collection<EventQueue> queues = windowMonitor.allEventQueues();
        if (queues.size() == 1) {
            this.waitForIdle((EventQueue)Preconditions.checkNotNull((Object)toolkit.getSystemEventQueue()));
            return;
        }
        for (EventQueue queue : queues) {
            this.waitForIdle((EventQueue)Preconditions.checkNotNull((Object)queue));
        }
    }

    private void waitIfNecessary() {
        int delayBetweenEvents = this.settings.delayBetweenEvents();
        int eventPostingDelay = this.settings.eventPostingDelay();
        if (eventPostingDelay > delayBetweenEvents) {
            Pause.pause(eventPostingDelay - delayBetweenEvents);
        }
    }

    private void waitForIdle(@Nonnull EventQueue eventQueue) {
        int idleTimeout;
        if (eventQueue == null) {
            BasicRobot.$$$reportNull$$$0(65);
        }
        if (EventQueue.isDispatchThread()) {
            throw new IllegalThreadStateException("Cannot call method from the event dispatcher thread");
        }
        long start = System.currentTimeMillis();
        int count = 0;
        while (!this.postInvocationEvent(eventQueue, idleTimeout = this.settings.idleTimeout()) && System.currentTimeMillis() - start <= (long)idleTimeout) {
            ++count;
            Pause.pause();
            if (eventQueue.peekEvent() != null) continue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RunsInEDT
    private boolean postInvocationEvent(@Nonnull EventQueue eventQueue, long timeout) {
        RobotIdleLock lock;
        if (eventQueue == null) {
            BasicRobot.$$$reportNull$$$0(66);
        }
        RobotIdleLock robotIdleLock = lock = new RobotIdleLock();
        synchronized (robotIdleLock) {
            eventQueue.postEvent(new InvocationEvent((Object)toolkit, EMPTY_RUNNABLE, lock, true));
            long start = System.currentTimeMillis();
            try {
                lock.wait(timeout);
                return System.currentTimeMillis() - start >= (long)this.settings.idleTimeout();
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
    }

    @Override
    public boolean isDragging() {
        return inputState.dragInProgress();
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JPopupMenu showPopupMenu(@Nonnull Component invoker) {
        if (invoker == null) {
            BasicRobot.$$$reportNull$$$0(67);
        }
        JPopupMenu jPopupMenu = this.showPopupMenu(invoker, AWT.visibleCenterOf(invoker));
        if (jPopupMenu == null) {
            BasicRobot.$$$reportNull$$$0(68);
        }
        return jPopupMenu;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JPopupMenu showPopupMenu(@Nonnull Component invoker, @Nonnull Point location) {
        if (invoker == null) {
            BasicRobot.$$$reportNull$$$0(69);
        }
        if (location == null) {
            BasicRobot.$$$reportNull$$$0(70);
        }
        if (ComponentIsFocusableQuery.isFocusable(invoker)) {
            this.focusAndWaitForFocusGain(invoker);
        }
        this.click(invoker, location, MouseButton.RIGHT_BUTTON, 1);
        JPopupMenu popup = this.findActivePopupMenu();
        if (popup == null) {
            throw new ComponentLookupException(Strings.concat((Object[])new Object[]{"Unable to show popup at ", location, " on ", Formatting.inEdtFormat(invoker)}));
        }
        long start = System.currentTimeMillis();
        while (!this.isWindowAncestorReadyForInput(popup) && System.currentTimeMillis() - start > 10000L) {
            Pause.pause();
        }
        JPopupMenu jPopupMenu = popup;
        if (jPopupMenu == null) {
            BasicRobot.$$$reportNull$$$0(71);
        }
        return jPopupMenu;
    }

    @RunsInEDT
    private boolean isWindowAncestorReadyForInput(final JPopupMenu popup) {
        Boolean result = GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() {
                Window ancestor = (Window)Preconditions.checkNotNull((Object)SwingUtilities.getWindowAncestor(popup));
                return BasicRobot.this.isReadyForInput(ancestor);
            }
        });
        return (Boolean)Preconditions.checkNotNull((Object)result);
    }

    @Override
    @RunsInCurrentThread
    public boolean isReadyForInput(@Nonnull Component c) {
        Window w;
        if (c == null) {
            BasicRobot.$$$reportNull$$$0(72);
        }
        if ((w = WindowAncestorFinder.windowAncestorOf(c)) == null) {
            throw ActionFailedException.actionFailure(Strings.concat((Object[])new Object[]{"Component ", Formatting.format(c), " does not have a Window ancestor"}));
        }
        return c.isShowing() && windowMonitor.isWindowReady(w);
    }

    @Override
    @Nullable
    @RunsInEDT
    public JPopupMenu findActivePopupMenu() {
        JPopupMenu popup = this.activePopupMenu();
        if (popup != null || SwingUtilities.isEventDispatchThread()) {
            return popup;
        }
        TimeoutWatch watch = TimeoutWatch.startWatchWithTimeoutOf(5000L);
        while ((popup = this.activePopupMenu()) == null && !watch.isTimeOut()) {
            Pause.pause(100L);
        }
        return popup;
    }

    @Nullable
    @RunsInEDT
    private JPopupMenu activePopupMenu() {
        ArrayList found = Lists.newArrayList(this.finder().findAll(POPUP_MATCHER));
        if (found.size() == 1) {
            return (JPopupMenu)found.get(0);
        }
        return null;
    }

    @Override
    @RunsInEDT
    public void requireNoJOptionPaneIsShowing() {
        this.unexpectedJOptionPaneFinder.requireNoJOptionPaneIsShowing();
    }

    @Override
    @Nonnull
    public Settings settings() {
        Settings settings = this.settings;
        if (settings == null) {
            BasicRobot.$$$reportNull$$$0(73);
        }
        return settings;
    }

    @Override
    @Nonnull
    public ComponentHierarchy hierarchy() {
        ComponentHierarchy componentHierarchy = this.hierarchy;
        if (componentHierarchy == null) {
            BasicRobot.$$$reportNull$$$0(74);
        }
        return componentHierarchy;
    }

    @Override
    public synchronized boolean isActive() {
        return this.active;
    }

    @Nullable
    @VisibleForTesting
    final Object screenLockOwner() {
        return this.screenLockOwner;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 72: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 72: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/core/BasicRobot";
                break;
            }
            case 5: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hierarchy";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "w";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "size";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 36: 
            case 41: 
            case 42: 
            case 44: 
            case 47: 
            case 49: 
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 26: 
            case 29: 
            case 35: 
            case 38: 
            case 40: 
            case 46: 
            case 51: 
            case 53: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "button";
                break;
            }
            case 33: 
            case 34: 
            case 37: 
            case 39: 
            case 48: 
            case 50: 
            case 52: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "where";
                break;
            }
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupMenu";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiers";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyCodes";
                break;
            }
            case 65: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventQueue";
                break;
            }
            case 67: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invoker";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "robotWithNewAwtHierarchy";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "robotWithNewAwtHierarchyWithoutScreenLock";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "robotWithCurrentAwtHierarchy";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "robotWithCurrentAwtHierarchyWithoutScreenLock";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "acquireScreenLock";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/core/BasicRobot";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "printer";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "finder";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "scrollIfNecessary";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "invokerAndCenterOfInvoker";
                break;
            }
            case 68: 
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "showPopupMenu";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "settings";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "hierarchy";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "showWindow";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "packAndEnsureSafePosition";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "waitForWindow";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "close";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findAppletDescendent";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "focusAndWaitForFocusGain";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "focus";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "activate";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "disposeWindows";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "dispose";
                break;
            }
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "click";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "rightClick";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "doubleClick";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "scrollIfNecessary";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "doClick";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "moveMouse";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "pressMouse";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "releaseMouse";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "rotateMouseWheel";
                break;
            }
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "jitter";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "waitForComponentToBeReady";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "invokerAndCenterOfInvoker";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "enterText";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "pressAndReleaseKey";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "pressAndReleaseKeys";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "waitForIdle";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "postInvocationEvent";
                break;
            }
            case 67: 
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "showPopupMenu";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "isReadyForInput";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 72: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RobotIdleLock {
        RobotIdleLock() {
        }
    }
}

