/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import java.awt.Point;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import org.fest.assertions.Assertions;
import org.fest.assertions.Description;
import org.fest.assertions.Fail;
import org.fest.assertions.IntArrayAssert;
import org.fest.assertions.IntAssert;
import org.fest.assertions.ListAssert;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.awt.AWT;
import org.fest.swing.cell.JListCellReader;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.BasicJListCellReader;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JListContentQuery;
import org.fest.swing.driver.JListItemCountQuery;
import org.fest.swing.driver.JListItemPreconditions;
import org.fest.swing.driver.JListItemValueQuery;
import org.fest.swing.driver.JListMatchingItemQuery;
import org.fest.swing.driver.JListScrollToItemTask;
import org.fest.swing.driver.JListSelectedIndexQuery;
import org.fest.swing.driver.JListSelectionIndicesQuery;
import org.fest.swing.driver.JListSelectionValueQuery;
import org.fest.swing.driver.JListSelectionValuesQuery;
import org.fest.swing.driver.MultipleSelectionTemplate;
import org.fest.swing.driver.TextAssert;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.edt.GuiTask;
import org.fest.swing.exception.LocationUnavailableException;
import org.fest.swing.util.ArrayPreconditions;
import org.fest.swing.util.Pair;
import org.fest.swing.util.PatternTextMatcher;
import org.fest.swing.util.Range;
import org.fest.swing.util.StringTextMatcher;
import org.fest.swing.util.TextMatcher;
import org.fest.util.Arrays;
import org.fest.util.InternalApi;
import org.fest.util.Preconditions;

@InternalApi
public class JListDriver
extends JComponentDriver {
    private static final String SELECTED_INDICES_PROPERTY = "selectedIndices";
    private static final String SELECTED_INDEX_PROPERTY = "selectedIndex";
    private JListCellReader cellReader;

    public JListDriver(@Nonnull Robot robot) {
        if (robot == null) {
            JListDriver.$$$reportNull$$$0(0);
        }
        super(robot);
        this.replaceCellReader(new BasicJListCellReader());
    }

    @Nonnull
    @RunsInEDT
    public String[] contentsOf(@Nonnull JList list) {
        if (list == null) {
            JListDriver.$$$reportNull$$$0(1);
        }
        String[] stringArray = JListContentQuery.contents(list, this.cellReader());
        if (stringArray == null) {
            JListDriver.$$$reportNull$$$0(2);
        }
        return stringArray;
    }

    @RunsInEDT
    public void selectItems(@Nonnull JList list, @Nonnull String[] values) {
        if (list == null) {
            JListDriver.$$$reportNull$$$0(3);
        }
        if (values == null) {
            JListDriver.$$$reportNull$$$0(4);
        }
        this.selectItems(list, new StringTextMatcher(values));
    }

    @RunsInEDT
    public void selectItems(@Nonnull JList list, @Nonnull Pattern[] patterns) {
        if (list == null) {
            JListDriver.$$$reportNull$$$0(5);
        }
        if (patterns == null) {
            JListDriver.$$$reportNull$$$0(6);
        }
        this.selectItems(list, new PatternTextMatcher(patterns));
    }

    @RunsInEDT
    private void selectItems(final @Nonnull JList list, @Nonnull TextMatcher matcher) {
        List<Integer> indices;
        if (list == null) {
            JListDriver.$$$reportNull$$$0(7);
        }
        if (matcher == null) {
            JListDriver.$$$reportNull$$$0(8);
        }
        if ((indices = JListMatchingItemQuery.matchingItemIndices(list, matcher, this.cellReader())).isEmpty()) {
            throw this.failMatchingNotFound(list, matcher);
        }
        this.clearSelection(list);
        new MultipleSelectionTemplate(this.robot){

            @Override
            int elementCount() {
                return indices.size();
            }

            @Override
            void selectElement(int index) {
                JListDriver.this.selectItem(list, (Integer)indices.get(index));
            }
        }.multiSelect();
    }

    @RunsInEDT
    public void selectItem(@Nonnull JList list, @Nullable String value) {
        if (list == null) {
            JListDriver.$$$reportNull$$$0(9);
        }
        this.selectItem(list, new StringTextMatcher(value));
    }

    @RunsInEDT
    public void selectItem(@Nonnull JList list, @Nonnull Pattern pattern) {
        if (list == null) {
            JListDriver.$$$reportNull$$$0(10);
        }
        if (pattern == null) {
            JListDriver.$$$reportNull$$$0(11);
        }
        this.selectItem(list, new PatternTextMatcher(pattern));
    }

    @RunsInEDT
    private void selectItem(@Nonnull JList list, @Nonnull TextMatcher matcher) {
        if (list == null) {
            JListDriver.$$$reportNull$$$0(12);
        }
        if (matcher == null) {
            JListDriver.$$$reportNull$$$0(13);
        }
        Pair<Integer, Point> scrollInfo = JListScrollToItemTask.scrollToItemIfNotSelectedYet(list, matcher, this.cellReader());
        this.robot.waitForIdle();
        this.checkItemFound(list, scrollInfo, matcher);
        if (scrollInfo.second == null) {
            return;
        }
        this.robot.click((Component)list, this.cellCenterIn(scrollInfo));
    }

    public void clickItem(@Nonnull JList list, @Nullable String value, @Nonnull MouseButton button, int times) {
        if (list == null) {
            JListDriver.$$$reportNull$$$0(14);
        }
        if (button == null) {
            JListDriver.$$$reportNull$$$0(15);
        }
        this.clickItem(list, new StringTextMatcher(value), button, times);
    }

    public void clickItem(@Nonnull JList list, @Nonnull Pattern pattern, @Nonnull MouseButton button, int times) {
        if (list == null) {
            JListDriver.$$$reportNull$$$0(16);
        }
        if (pattern == null) {
            JListDriver.$$$reportNull$$$0(17);
        }
        if (button == null) {
            JListDriver.$$$reportNull$$$0(18);
        }
        this.clickItem(list, new PatternTextMatcher(pattern), button, times);
    }

    private void clickItem(@Nonnull JList list, @Nonnull TextMatcher matcher, @Nonnull MouseButton button, int times) {
        if (list == null) {
            JListDriver.$$$reportNull$$$0(19);
        }
        if (matcher == null) {
            JListDriver.$$$reportNull$$$0(20);
        }
        if (button == null) {
            JListDriver.$$$reportNull$$$0(21);
        }
        Pair<Integer, Point> scrollInfo = JListScrollToItemTask.scrollToItem(list, matcher, this.cellReader());
        this.robot.waitForIdle();
        this.checkItemFound(list, scrollInfo, matcher);
        this.robot.click(list, this.cellCenterIn(scrollInfo), button, times);
    }

    public void selectItems(final @Nonnull JList list, final @Nonnull int[] indices) {
        if (list == null) {
            JListDriver.$$$reportNull$$$0(22);
        }
        if (indices == null) {
            JListDriver.$$$reportNull$$$0(23);
        }
        ArrayPreconditions.checkNotNullOrEmpty(indices);
        this.clearSelection(list);
        new MultipleSelectionTemplate(this.robot){

            @Override
            int elementCount() {
                return indices.length;
            }

            @Override
            void selectElement(int index) {
                JListDriver.this.selectItem(list, indices[index]);
            }
        }.multiSelect();
    }

    public void clearSelection(@Nonnull JList list) {
        if (list == null) {
            JListDriver.$$$reportNull$$$0(24);
        }
        JListDriver.clearSelectionOf(list);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    private static void clearSelectionOf(final @Nonnull JList list) {
        if (list == null) {
            JListDriver.$$$reportNull$$$0(25);
        }
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                list.clearSelection();
            }
        });
    }

    @RunsInEDT
    public void selectItems(@Nonnull JList list, @Nonnull Range.From from, @Nonnull Range.To to) {
        if (list == null) {
            JListDriver.$$$reportNull$$$0(26);
        }
        if (from == null) {
            JListDriver.$$$reportNull$$$0(27);
        }
        if (to == null) {
            JListDriver.$$$reportNull$$$0(28);
        }
        this.selectItems(list, from.value, to.value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RunsInEDT
    public void selectItems(@Nonnull JList list, int start, int end) {
        if (list == null) {
            JListDriver.$$$reportNull$$$0(29);
        }
        JListDriver.validateIndicesAndClearSelection(list, start, end);
        this.selectItem(list, start);
        this.robot.pressKey(16);
        try {
            this.clickItem(list, end, MouseButton.LEFT_BUTTON, 1);
        }
        finally {
            this.robot.releaseKey(16);
        }
    }

    @RunsInEDT
    private static void validateIndicesAndClearSelection(final @Nonnull JList list, final int ... indices) {
        if (list == null) {
            JListDriver.$$$reportNull$$$0(30);
        }
        if (indices == null) {
            JListDriver.$$$reportNull$$$0(31);
        }
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                JListItemPreconditions.checkIndicesInBounds(list, indices);
                list.clearSelection();
            }
        });
    }

    @RunsInEDT
    public void selectItem(@Nonnull JList list, int index) {
        if (list == null) {
            JListDriver.$$$reportNull$$$0(32);
        }
        Point cellCenter = JListScrollToItemTask.scrollToItemIfNotSelectedYet(list, index);
        this.robot.waitForIdle();
        if (cellCenter == null) {
            return;
        }
        this.robot.click((Component)list, cellCenter);
    }

    @RunsInEDT
    public void clickItem(@Nonnull JList list, int index, @Nonnull MouseButton button, int times) {
        if (list == null) {
            JListDriver.$$$reportNull$$$0(33);
        }
        if (button == null) {
            JListDriver.$$$reportNull$$$0(34);
        }
        Point cellCenter = JListScrollToItemTask.scrollToItem(list, index);
        this.robot.waitForIdle();
        this.robot.click(list, cellCenter, button, times);
    }

    @RunsInEDT
    public void requireSelection(@Nonnull JList list, @Nullable String value) {
        if (list == null) {
            JListDriver.$$$reportNull$$$0(35);
        }
        String selection = this.requiredSelection(list);
        TextAssert.verifyThat(selection).as(this.selectedIndexProperty(list)).isEqualOrMatches(value);
    }

    @RunsInEDT
    public void requireSelection(@Nonnull JList list, @Nonnull Pattern pattern) {
        if (list == null) {
            JListDriver.$$$reportNull$$$0(36);
        }
        if (pattern == null) {
            JListDriver.$$$reportNull$$$0(37);
        }
        String selection = this.requiredSelection(list);
        TextAssert.verifyThat(selection).as(this.selectedIndexProperty(list)).matches(pattern);
    }

    @Nullable
    private String requiredSelection(@Nonnull JList list) {
        Object selection;
        if (list == null) {
            JListDriver.$$$reportNull$$$0(38);
        }
        if (JListSelectionValueQuery.NO_SELECTION_VALUE == (selection = JListSelectionValueQuery.singleSelectionValue(list, this.cellReader()))) {
            this.failNoSelection(list);
        }
        return (String)selection;
    }

    @RunsInEDT
    public void requireSelection(@Nonnull JList list, int index) {
        int selectedIndex;
        if (list == null) {
            JListDriver.$$$reportNull$$$0(39);
        }
        if ((selectedIndex = JListSelectedIndexQuery.selectedIndexOf(list)) == -1) {
            this.failNoSelection(list);
        }
        ((IntAssert)Assertions.assertThat((int)selectedIndex).as(this.selectedIndexProperty(list))).isEqualTo(index);
    }

    @Nonnull
    @RunsInEDT
    public String[] selectionOf(@Nonnull JList list) {
        if (list == null) {
            JListDriver.$$$reportNull$$$0(40);
        }
        List<String> selection = JListSelectionValuesQuery.selectionValues(list, this.cellReader());
        String[] stringArray = selection.toArray(new String[selection.size()]);
        if (stringArray == null) {
            JListDriver.$$$reportNull$$$0(41);
        }
        return stringArray;
    }

    @RunsInEDT
    public void requireSelectedItems(@Nonnull JList list, String ... items) {
        if (list == null) {
            JListDriver.$$$reportNull$$$0(42);
        }
        if (items == null) {
            JListDriver.$$$reportNull$$$0(43);
        }
        this.requireSelectedItems(list, new StringTextMatcher(items));
    }

    @RunsInEDT
    public void requireSelectedItems(@Nonnull JList list, Pattern ... patterns) {
        if (list == null) {
            JListDriver.$$$reportNull$$$0(44);
        }
        if (patterns == null) {
            JListDriver.$$$reportNull$$$0(45);
        }
        this.requireSelectedItems(list, new PatternTextMatcher(patterns));
    }

    @RunsInEDT
    private void requireSelectedItems(@Nonnull JList list, @Nonnull TextMatcher matcher) {
        if (list == null) {
            JListDriver.$$$reportNull$$$0(46);
        }
        if (matcher == null) {
            JListDriver.$$$reportNull$$$0(47);
        }
        List<String> matchingValues = JListMatchingItemQuery.matchingItemValues(list, matcher, this.cellReader());
        ((ListAssert)Assertions.assertThat(JListSelectionValuesQuery.selectionValues(list, this.cellReader())).as(JListDriver.propertyName(list, SELECTED_INDICES_PROPERTY))).isEqualTo(matchingValues);
    }

    @RunsInEDT
    public void requireSelectedItems(@Nonnull JList list, int ... indices) {
        if (list == null) {
            JListDriver.$$$reportNull$$$0(48);
        }
        if (indices == null) {
            JListDriver.$$$reportNull$$$0(49);
        }
        ArrayPreconditions.checkNotNullOrEmpty(indices);
        java.util.Arrays.sort(indices);
        ((IntArrayAssert)Assertions.assertThat((int[])JListSelectionIndicesQuery.selectedIndices(list)).as(JListDriver.propertyName(list, SELECTED_INDICES_PROPERTY))).isEqualTo(indices);
    }

    @RunsInEDT
    public void requireNoSelection(@Nonnull JList list) {
        if (list == null) {
            JListDriver.$$$reportNull$$$0(50);
        }
        ((IntAssert)Assertions.assertThat((int)JListSelectedIndexQuery.selectedIndexOf(list)).as(this.selectedIndexProperty(list))).isEqualTo(-1);
    }

    @RunsInEDT
    private void failNoSelection(@Nonnull JList list) {
        if (list == null) {
            JListDriver.$$$reportNull$$$0(51);
        }
        Fail.fail((String)String.format("[%s] No selection", this.selectedIndexProperty(list).value()));
    }

    @RunsInEDT
    private Description selectedIndexProperty(@Nonnull JList list) {
        if (list == null) {
            JListDriver.$$$reportNull$$$0(52);
        }
        return JListDriver.propertyName(list, SELECTED_INDEX_PROPERTY);
    }

    @RunsInEDT
    public void drag(@Nonnull JList list, @Nullable String value) {
        if (list == null) {
            JListDriver.$$$reportNull$$$0(53);
        }
        this.drag(list, new StringTextMatcher(value));
    }

    @RunsInEDT
    public void drag(@Nonnull JList list, @Nonnull Pattern pattern) {
        if (list == null) {
            JListDriver.$$$reportNull$$$0(54);
        }
        if (pattern == null) {
            JListDriver.$$$reportNull$$$0(55);
        }
        this.drag(list, new PatternTextMatcher(pattern));
    }

    private void drag(@Nonnull JList list, @Nonnull TextMatcher matcher) {
        if (list == null) {
            JListDriver.$$$reportNull$$$0(56);
        }
        if (matcher == null) {
            JListDriver.$$$reportNull$$$0(57);
        }
        Pair<Integer, Point> scrollInfo = JListScrollToItemTask.scrollToItem(list, matcher, this.cellReader());
        this.robot.waitForIdle();
        this.checkItemFound(list, scrollInfo, matcher);
        super.drag(list, this.cellCenterIn(scrollInfo));
    }

    @RunsInEDT
    public void drop(@Nonnull JList list, @Nullable String value) {
        if (list == null) {
            JListDriver.$$$reportNull$$$0(58);
        }
        this.drop(list, new StringTextMatcher(value));
    }

    public void drop(@Nonnull JList list, @Nonnull Pattern pattern) {
        if (list == null) {
            JListDriver.$$$reportNull$$$0(59);
        }
        if (pattern == null) {
            JListDriver.$$$reportNull$$$0(60);
        }
        this.drop(list, new PatternTextMatcher(pattern));
    }

    private void drop(@Nonnull JList list, @Nonnull TextMatcher matcher) {
        if (list == null) {
            JListDriver.$$$reportNull$$$0(61);
        }
        if (matcher == null) {
            JListDriver.$$$reportNull$$$0(62);
        }
        Pair<Integer, Point> scrollInfo = JListScrollToItemTask.scrollToItem(list, matcher, this.cellReader());
        this.robot.waitForIdle();
        this.checkItemFound(list, scrollInfo, matcher);
        super.drop(list, this.cellCenterIn(scrollInfo));
    }

    private void checkItemFound(@Nonnull JList list, @Nonnull Pair<Integer, Point> scrollInfo, @Nonnull TextMatcher matcher) {
        if (list == null) {
            JListDriver.$$$reportNull$$$0(63);
        }
        if (scrollInfo == null) {
            JListDriver.$$$reportNull$$$0(64);
        }
        if (matcher == null) {
            JListDriver.$$$reportNull$$$0(65);
        }
        if (JListScrollToItemTask.ITEM_NOT_FOUND == scrollInfo) {
            throw this.failMatchingNotFound(list, matcher);
        }
    }

    @RunsInEDT
    public void drag(@Nonnull JList list, int index) {
        if (list == null) {
            JListDriver.$$$reportNull$$$0(66);
        }
        Point cellCenter = JListScrollToItemTask.scrollToItem(list, index);
        this.robot.waitForIdle();
        super.drag(list, cellCenter);
    }

    @RunsInEDT
    public void drop(@Nonnull JList list, int index) {
        if (list == null) {
            JListDriver.$$$reportNull$$$0(67);
        }
        Point cellCenter = JListScrollToItemTask.scrollToItem(list, index);
        this.robot.waitForIdle();
        super.drop(list, cellCenter);
    }

    @RunsInEDT
    public void drop(@Nonnull JList list) {
        if (list == null) {
            JListDriver.$$$reportNull$$$0(68);
        }
        JListDriver.checkInEdtEnabledAndShowing(list);
        super.drop(list, AWT.visibleCenterOf(list));
    }

    @RunsInEDT
    public JPopupMenu showPopupMenu(@Nonnull JList list, @Nullable String value) {
        if (list == null) {
            JListDriver.$$$reportNull$$$0(69);
        }
        return this.showPopupMenu(list, new StringTextMatcher(value));
    }

    @RunsInEDT
    public JPopupMenu showPopupMenu(@Nonnull JList list, @Nonnull Pattern pattern) {
        if (list == null) {
            JListDriver.$$$reportNull$$$0(70);
        }
        if (pattern == null) {
            JListDriver.$$$reportNull$$$0(71);
        }
        return this.showPopupMenu(list, new PatternTextMatcher(pattern));
    }

    @Nonnull
    @RunsInEDT
    private JPopupMenu showPopupMenu(@Nonnull JList list, @Nonnull TextMatcher matcher) {
        if (list == null) {
            JListDriver.$$$reportNull$$$0(72);
        }
        if (matcher == null) {
            JListDriver.$$$reportNull$$$0(73);
        }
        Pair<Integer, Point> scrollInfo = JListScrollToItemTask.scrollToItem(list, matcher, this.cellReader());
        this.robot.waitForIdle();
        this.checkItemFound(list, scrollInfo, matcher);
        JPopupMenu jPopupMenu = this.robot.showPopupMenu(list, this.cellCenterIn(scrollInfo));
        if (jPopupMenu == null) {
            JListDriver.$$$reportNull$$$0(74);
        }
        return jPopupMenu;
    }

    @Nonnull
    private Point cellCenterIn(@Nonnull Pair<Integer, Point> scrollInfo) {
        if (scrollInfo == null) {
            JListDriver.$$$reportNull$$$0(75);
        }
        Point point = (Point)Preconditions.checkNotNull(scrollInfo.second);
        if (point == null) {
            JListDriver.$$$reportNull$$$0(76);
        }
        return point;
    }

    @Nonnull
    @RunsInEDT
    public JPopupMenu showPopupMenu(@Nonnull JList list, int index) {
        if (list == null) {
            JListDriver.$$$reportNull$$$0(77);
        }
        Point cellCenter = JListScrollToItemTask.scrollToItem(list, index);
        this.robot.waitForIdle();
        JPopupMenu jPopupMenu = this.robot.showPopupMenu(list, cellCenter);
        if (jPopupMenu == null) {
            JListDriver.$$$reportNull$$$0(78);
        }
        return jPopupMenu;
    }

    @Nonnull
    @RunsInEDT
    public Point pointAt(@Nonnull JList list, @Nullable String value) {
        if (list == null) {
            JListDriver.$$$reportNull$$$0(79);
        }
        Point point = JListMatchingItemQuery.centerOfMatchingItemCell(list, value, this.cellReader());
        if (point == null) {
            JListDriver.$$$reportNull$$$0(80);
        }
        return point;
    }

    @RunsInEDT
    public int indexOf(@Nonnull JList list, @Nullable String value) {
        if (list == null) {
            JListDriver.$$$reportNull$$$0(81);
        }
        return this.indexOf(list, new StringTextMatcher(value));
    }

    @RunsInEDT
    public int indexOf(@Nonnull JList list, @Nonnull Pattern pattern) {
        if (list == null) {
            JListDriver.$$$reportNull$$$0(82);
        }
        if (pattern == null) {
            JListDriver.$$$reportNull$$$0(83);
        }
        return this.indexOf(list, new PatternTextMatcher(pattern));
    }

    @RunsInEDT
    private int indexOf(@Nonnull JList list, @Nonnull TextMatcher matcher) {
        int index;
        if (list == null) {
            JListDriver.$$$reportNull$$$0(84);
        }
        if (matcher == null) {
            JListDriver.$$$reportNull$$$0(85);
        }
        if ((index = JListDriver.itemIndex(list, matcher, this.cellReader())) >= 0) {
            return index;
        }
        throw this.failMatchingNotFound(list, matcher);
    }

    @RunsInEDT
    private static int itemIndex(final @Nonnull JList list, final @Nonnull TextMatcher matcher, final @Nonnull JListCellReader cellReader) {
        if (list == null) {
            JListDriver.$$$reportNull$$$0(86);
        }
        if (matcher == null) {
            JListDriver.$$$reportNull$$$0(87);
        }
        if (cellReader == null) {
            JListDriver.$$$reportNull$$$0(88);
        }
        Integer result = GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() {
                return JListMatchingItemQuery.matchingItemIndex(list, matcher, cellReader);
            }
        });
        return (Integer)Preconditions.checkNotNull((Object)result);
    }

    @Nonnull
    private LocationUnavailableException failMatchingNotFound(@Nonnull JList list, @Nonnull TextMatcher matcher) {
        if (list == null) {
            JListDriver.$$$reportNull$$$0(89);
        }
        if (matcher == null) {
            JListDriver.$$$reportNull$$$0(90);
        }
        String format = "Unable to find item matching the %s %s among the JList contents %s";
        String msg = String.format(format, matcher.description(), matcher.formattedValues(), Arrays.format((Object)JListContentQuery.contents(list, this.cellReader())));
        LocationUnavailableException locationUnavailableException = new LocationUnavailableException(msg);
        if (locationUnavailableException == null) {
            JListDriver.$$$reportNull$$$0(91);
        }
        return locationUnavailableException;
    }

    @Nullable
    @RunsInEDT
    public String value(@Nonnull JList list, int index) {
        if (list == null) {
            JListDriver.$$$reportNull$$$0(92);
        }
        return JListItemValueQuery.itemValue(list, index, this.cellReader());
    }

    public void replaceCellReader(@Nonnull JListCellReader newCellReader) {
        if (newCellReader == null) {
            JListDriver.$$$reportNull$$$0(93);
        }
        this.cellReader = (JListCellReader)Preconditions.checkNotNull((Object)newCellReader);
    }

    @RunsInEDT
    public void requireItemCount(@Nonnull JList list, int expected) {
        if (list == null) {
            JListDriver.$$$reportNull$$$0(94);
        }
        int actual = JListItemCountQuery.itemCountIn(list);
        ((IntAssert)Assertions.assertThat((int)actual).as(JListDriver.propertyName(list, "itemCount"))).isEqualTo(expected);
    }

    @Nonnull
    private JListCellReader cellReader() {
        JListCellReader jListCellReader = this.cellReader;
        if (jListCellReader == null) {
            JListDriver.$$$reportNull$$$0(95);
        }
        return jListCellReader;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 41: 
            case 74: 
            case 76: 
            case 78: 
            case 80: 
            case 91: 
            case 95: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 41: 
            case 74: 
            case 76: 
            case 78: 
            case 80: 
            case 91: 
            case 95: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "robot";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 56: 
            case 58: 
            case 59: 
            case 61: 
            case 63: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 72: 
            case 77: 
            case 79: 
            case 81: 
            case 82: 
            case 84: 
            case 86: 
            case 89: 
            case 92: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 2: 
            case 41: 
            case 74: 
            case 76: 
            case 78: 
            case 80: 
            case 91: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/driver/JListDriver";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 6: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
            case 8: 
            case 13: 
            case 20: 
            case 47: 
            case 57: 
            case 62: 
            case 65: 
            case 73: 
            case 85: 
            case 87: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 11: 
            case 17: 
            case 37: 
            case 55: 
            case 60: 
            case 71: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 15: 
            case 18: 
            case 21: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "button";
                break;
            }
            case 23: 
            case 31: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indices";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 64: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scrollInfo";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cellReader";
                break;
            }
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newCellReader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/driver/JListDriver";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsOf";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "selectionOf";
                break;
            }
            case 74: 
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "showPopupMenu";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "cellCenterIn";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "pointAt";
                break;
            }
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "failMatchingNotFound";
                break;
            }
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "cellReader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "contentsOf";
                break;
            }
            case 2: 
            case 41: 
            case 74: 
            case 76: 
            case 78: 
            case 80: 
            case 91: 
            case 95: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "selectItems";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "selectItem";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "clickItem";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "clearSelection";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "clearSelectionOf";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "validateIndicesAndClearSelection";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "requireSelection";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "requiredSelection";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "selectionOf";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "requireSelectedItems";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "requireNoSelection";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "failNoSelection";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "selectedIndexProperty";
                break;
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "drag";
                break;
            }
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "drop";
                break;
            }
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "checkItemFound";
                break;
            }
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "showPopupMenu";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "cellCenterIn";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "pointAt";
                break;
            }
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "indexOf";
                break;
            }
            case 86: 
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "itemIndex";
                break;
            }
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "failMatchingNotFound";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "value";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "replaceCellReader";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "requireItemCount";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 41: 
            case 74: 
            case 76: 
            case 78: 
            case 80: 
            case 91: 
            case 95: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

