/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Point;
import javax.annotation.Nonnull;
import javax.swing.JSplitPane;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.ComponentPreconditions;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JSplitPaneLocationCalculator;
import org.fest.swing.driver.JSplitPaneSetDividerLocationTask;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.util.GenericRange;
import org.fest.util.InternalApi;
import org.fest.util.Preconditions;

@InternalApi
public class JSplitPaneDriver
extends JComponentDriver {
    public JSplitPaneDriver(@Nonnull Robot robot) {
        if (robot == null) {
            JSplitPaneDriver.$$$reportNull$$$0(0);
        }
        super(robot);
    }

    @RunsInEDT
    public void moveDividerTo(@Nonnull JSplitPane splitPane, int location) {
        if (splitPane == null) {
            JSplitPaneDriver.$$$reportNull$$$0(1);
        }
        int newLocation = JSplitPaneLocationCalculator.locationToMoveDividerTo(splitPane, location);
        this.simulateMovingDivider(splitPane, newLocation);
        JSplitPaneSetDividerLocationTask.setDividerLocation(splitPane, newLocation);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    private void simulateMovingDivider(@Nonnull JSplitPane split, int location) {
        if (split == null) {
            JSplitPaneDriver.$$$reportNull$$$0(2);
        }
        if (split.getOrientation() == 0) {
            this.simulateMovingDividerVertically(split, location);
            return;
        }
        this.simulateMovingDividerHorizontally(split, location);
    }

    @RunsInEDT
    private void simulateMovingDividerVertically(@Nonnull JSplitPane splitPane, int location) {
        if (splitPane == null) {
            JSplitPaneDriver.$$$reportNull$$$0(3);
        }
        GenericRange<Point> whereToMove = JSplitPaneDriver.findWhereToMoveDividerVertically(splitPane, location);
        this.simulateMovingDivider(splitPane, whereToMove);
    }

    @Nonnull
    @RunsInEDT
    private static GenericRange<Point> findWhereToMoveDividerVertically(final @Nonnull JSplitPane splitPane, final int location) {
        if (splitPane == null) {
            JSplitPaneDriver.$$$reportNull$$$0(4);
        }
        GenericRange<Point> result = GuiActionRunner.execute(new GuiQuery<GenericRange<Point>>(){

            @Override
            protected GenericRange<Point> executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(splitPane);
                return JSplitPaneDriver.whereToMoveDividerVertically(splitPane, location);
            }
        });
        GenericRange genericRange = (GenericRange)Preconditions.checkNotNull(result);
        if (genericRange == null) {
            JSplitPaneDriver.$$$reportNull$$$0(5);
        }
        return genericRange;
    }

    @Nonnull
    @RunsInCurrentThread
    private static GenericRange<Point> whereToMoveDividerVertically(@Nonnull JSplitPane splitPane, int location) {
        if (splitPane == null) {
            JSplitPaneDriver.$$$reportNull$$$0(6);
        }
        int x = splitPane.getWidth() / 2;
        int dividerLocation = splitPane.getDividerLocation();
        GenericRange<Point> genericRange = new GenericRange<Point>(new Point(x, dividerLocation), new Point(x, location));
        if (genericRange == null) {
            JSplitPaneDriver.$$$reportNull$$$0(7);
        }
        return genericRange;
    }

    private void simulateMovingDividerHorizontally(@Nonnull JSplitPane splitPane, int location) {
        if (splitPane == null) {
            JSplitPaneDriver.$$$reportNull$$$0(8);
        }
        GenericRange<Point> whereToMove = JSplitPaneDriver.findWhereToMoveDividerHorizontally(splitPane, location);
        this.simulateMovingDivider(splitPane, whereToMove);
    }

    @Nonnull
    @RunsInEDT
    private static GenericRange<Point> findWhereToMoveDividerHorizontally(final @Nonnull JSplitPane splitPane, final int location) {
        if (splitPane == null) {
            JSplitPaneDriver.$$$reportNull$$$0(9);
        }
        GenericRange<Point> result = GuiActionRunner.execute(new GuiQuery<GenericRange<Point>>(){

            @Override
            protected GenericRange<Point> executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(splitPane);
                return JSplitPaneDriver.whereToMoveDividerHorizontally(splitPane, location);
            }
        });
        GenericRange genericRange = (GenericRange)Preconditions.checkNotNull(result);
        if (genericRange == null) {
            JSplitPaneDriver.$$$reportNull$$$0(10);
        }
        return genericRange;
    }

    @Nonnull
    @RunsInCurrentThread
    private static GenericRange<Point> whereToMoveDividerHorizontally(@Nonnull JSplitPane splitPane, int location) {
        if (splitPane == null) {
            JSplitPaneDriver.$$$reportNull$$$0(11);
        }
        int y = splitPane.getHeight() / 2;
        int dividerLocation = splitPane.getDividerLocation();
        GenericRange<Point> genericRange = new GenericRange<Point>(new Point(dividerLocation, y), new Point(location, y));
        if (genericRange == null) {
            JSplitPaneDriver.$$$reportNull$$$0(12);
        }
        return genericRange;
    }

    @RunsInEDT
    private void simulateMovingDivider(@Nonnull JSplitPane splitPane, @Nonnull GenericRange<Point> range) {
        if (splitPane == null) {
            JSplitPaneDriver.$$$reportNull$$$0(13);
        }
        if (range == null) {
            JSplitPaneDriver.$$$reportNull$$$0(14);
        }
        try {
            this.robot.moveMouse(splitPane, range.from());
            this.robot.pressMouse(MouseButton.LEFT_BUTTON);
            this.robot.moveMouse(splitPane, range.to());
            this.robot.releaseMouse(MouseButton.LEFT_BUTTON);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 12: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "robot";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "splitPane";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "split";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/driver/JSplitPaneDriver";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/driver/JSplitPaneDriver";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findWhereToMoveDividerVertically";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "whereToMoveDividerVertically";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findWhereToMoveDividerHorizontally";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "whereToMoveDividerHorizontally";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "moveDividerTo";
                break;
            }
            case 2: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "simulateMovingDivider";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "simulateMovingDividerVertically";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findWhereToMoveDividerVertically";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 12: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "whereToMoveDividerVertically";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "simulateMovingDividerHorizontally";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findWhereToMoveDividerHorizontally";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "whereToMoveDividerHorizontally";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

