/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.fest.assertions.Assertions;
import org.fest.assertions.BooleanAssert;
import org.fest.assertions.Description;
import org.fest.assertions.StringAssert;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.ComponentPreconditions;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JTextComponentEditableQuery;
import org.fest.swing.driver.JTextComponentSelectAllTask;
import org.fest.swing.driver.JTextComponentSelectTextTask;
import org.fest.swing.driver.JTextComponentSetTextTask;
import org.fest.swing.driver.JTextComponentTextQuery;
import org.fest.swing.driver.PointAndParentForScrollingJTextFieldQuery;
import org.fest.swing.driver.TextAssert;
import org.fest.swing.driver.TextDisplayDriver;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.edt.GuiTask;
import org.fest.swing.exception.ActionFailedException;
import org.fest.swing.format.Formatting;
import org.fest.swing.util.Pair;
import org.fest.swing.util.Platform;
import org.fest.util.InternalApi;
import org.fest.util.Preconditions;
import org.fest.util.Strings;

@InternalApi
public class JTextComponentDriver
extends JComponentDriver
implements TextDisplayDriver<JTextComponent> {
    private static final String EDITABLE_PROPERTY = "editable";
    private static final String TEXT_PROPERTY = "text";

    public JTextComponentDriver(@Nonnull Robot robot) {
        if (robot == null) {
            JTextComponentDriver.$$$reportNull$$$0(0);
        }
        super(robot);
    }

    @RunsInEDT
    public void deleteText(@Nonnull JTextComponent textBox) {
        if (textBox == null) {
            JTextComponentDriver.$$$reportNull$$$0(1);
        }
        this.selectAll(textBox);
        this.invokeAction(textBox, "delete-previous");
    }

    @RunsInEDT
    public void replaceText(@Nonnull JTextComponent textBox, @Nonnull String text) {
        if (textBox == null) {
            JTextComponentDriver.$$$reportNull$$$0(2);
        }
        if (text == null) {
            JTextComponentDriver.$$$reportNull$$$0(3);
        }
        Preconditions.checkNotNullOrEmpty((String)text);
        this.selectAll(textBox);
        this.enterText(textBox, text);
    }

    @RunsInEDT
    public void selectAll(@Nonnull JTextComponent textBox) {
        if (textBox == null) {
            JTextComponentDriver.$$$reportNull$$$0(4);
        }
        JTextComponentDriver.checkStateAndScrollToPosition(textBox, 0);
        JTextComponentSelectAllTask.selectAllText(textBox);
    }

    @RunsInEDT
    public void enterText(@Nonnull JTextComponent textBox, @Nonnull String text) {
        if (textBox == null) {
            JTextComponentDriver.$$$reportNull$$$0(5);
        }
        if (text == null) {
            JTextComponentDriver.$$$reportNull$$$0(6);
        }
        this.focusAndWaitForFocusGain(textBox);
        this.robot.enterText(text);
    }

    @RunsInEDT
    public void setText(@Nonnull JTextComponent textBox, @Nullable String text) {
        if (textBox == null) {
            JTextComponentDriver.$$$reportNull$$$0(7);
        }
        this.focusAndWaitForFocusGain(textBox);
        JTextComponentSetTextTask.setTextIn(textBox, text);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    public void selectText(@Nonnull JTextComponent textBox, @Nonnull String text) {
        int indexFound;
        if (textBox == null) {
            JTextComponentDriver.$$$reportNull$$$0(8);
        }
        if (text == null) {
            JTextComponentDriver.$$$reportNull$$$0(9);
        }
        if ((indexFound = JTextComponentDriver.indexOfText(textBox, text)) == -1) {
            throw new IllegalArgumentException(String.format("The text %s was not found", Strings.quote((String)text)));
        }
        this.selectText(textBox, indexFound, indexFound + text.length());
    }

    @RunsInEDT
    private static int indexOfText(final @Nonnull JTextComponent textBox, final @Nonnull String text) {
        if (textBox == null) {
            JTextComponentDriver.$$$reportNull$$$0(10);
        }
        if (text == null) {
            JTextComponentDriver.$$$reportNull$$$0(11);
        }
        Integer result = GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(textBox);
                String actualText = textBox.getText();
                if (Strings.isNullOrEmpty((String)actualText)) {
                    return -1;
                }
                return actualText.indexOf(text);
            }
        });
        return (Integer)Preconditions.checkNotNull((Object)result);
    }

    @RunsInEDT
    public void selectText(@Nonnull JTextComponent textBox, int start, int end) {
        if (textBox == null) {
            JTextComponentDriver.$$$reportNull$$$0(12);
        }
        this.robot.moveMouse(textBox, JTextComponentDriver.checkStateAndScrollToPosition(textBox, start));
        this.robot.moveMouse(textBox, JTextComponentDriver.scrollToPosition(textBox, end));
        JTextComponentDriver.performAndValidateTextSelection(textBox, start, end);
    }

    @Nonnull
    @RunsInEDT
    private static Point checkStateAndScrollToPosition(final @Nonnull JTextComponent textBox, final int index) {
        if (textBox == null) {
            JTextComponentDriver.$$$reportNull$$$0(13);
        }
        Point result = GuiActionRunner.execute(new GuiQuery<Point>(){

            @Override
            protected Point executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(textBox);
                return JTextComponentDriver.scrollToVisible(textBox, index);
            }
        });
        Point point = (Point)Preconditions.checkNotNull((Object)result);
        if (point == null) {
            JTextComponentDriver.$$$reportNull$$$0(14);
        }
        return point;
    }

    @Nonnull
    @RunsInEDT
    private static Point scrollToPosition(final @Nonnull JTextComponent textBox, final int index) {
        if (textBox == null) {
            JTextComponentDriver.$$$reportNull$$$0(15);
        }
        Point result = GuiActionRunner.execute(new GuiQuery<Point>(){

            @Override
            protected Point executeInEDT() {
                return JTextComponentDriver.scrollToVisible(textBox, index);
            }
        });
        Point point = (Point)Preconditions.checkNotNull((Object)result);
        if (point == null) {
            JTextComponentDriver.$$$reportNull$$$0(16);
        }
        return point;
    }

    @Nonnull
    @RunsInCurrentThread
    private static Point scrollToVisible(@Nonnull JTextComponent textBox, int index) {
        Rectangle indexLocation;
        if (textBox == null) {
            JTextComponentDriver.$$$reportNull$$$0(17);
        }
        if (JTextComponentDriver.isRectangleVisible(textBox, indexLocation = JTextComponentDriver.locationOf(textBox, index))) {
            Point point = JTextComponentDriver.centerOf(indexLocation);
            if (point == null) {
                JTextComponentDriver.$$$reportNull$$$0(18);
            }
            return point;
        }
        JTextComponentDriver.scrollToVisible(textBox, indexLocation);
        indexLocation = JTextComponentDriver.locationOf(textBox, index);
        if (JTextComponentDriver.isRectangleVisible(textBox, indexLocation)) {
            Point point = JTextComponentDriver.centerOf(indexLocation);
            if (point == null) {
                JTextComponentDriver.$$$reportNull$$$0(19);
            }
            return point;
        }
        String format = "Unable to make visible the location of the index <%d> by scrolling to the point <%s> on %s";
        String msg = String.format(format, index, JTextComponentDriver.formatOriginOf(indexLocation), Formatting.format(textBox));
        throw ActionFailedException.actionFailure(msg);
    }

    @Nonnull
    @RunsInCurrentThread
    private static Rectangle locationOf(@Nonnull JTextComponent textBox, int index) {
        if (textBox == null) {
            JTextComponentDriver.$$$reportNull$$$0(20);
        }
        Rectangle r = null;
        try {
            r = textBox.modelToView(index);
        }
        catch (BadLocationException e) {
            throw JTextComponentDriver.cannotGetLocation(textBox, index);
        }
        if (r != null) {
            if (Platform.isMacintosh() && r.y == -1) {
                r.y = 0;
            }
            Rectangle rectangle = r;
            if (rectangle == null) {
                JTextComponentDriver.$$$reportNull$$$0(21);
            }
            return rectangle;
        }
        throw JTextComponentDriver.cannotGetLocation(textBox, index);
    }

    private static ActionFailedException cannotGetLocation(@Nonnull JTextComponent textBox, int index) {
        if (textBox == null) {
            JTextComponentDriver.$$$reportNull$$$0(22);
        }
        String msg = String.format("Unable to get location for index <%d> in %s", index, Formatting.format(textBox));
        throw ActionFailedException.actionFailure(msg);
    }

    @RunsInCurrentThread
    private static boolean isRectangleVisible(@Nonnull JTextComponent textBox, @Nonnull Rectangle r) {
        if (textBox == null) {
            JTextComponentDriver.$$$reportNull$$$0(23);
        }
        if (r == null) {
            JTextComponentDriver.$$$reportNull$$$0(24);
        }
        Rectangle visible = textBox.getVisibleRect();
        return visible.contains(r.x, r.y);
    }

    private static String formatOriginOf(Rectangle r) {
        return Strings.concat((Object[])new Object[]{String.valueOf(r.x), ",", String.valueOf(r.y)});
    }

    @RunsInCurrentThread
    private static void scrollToVisible(@Nonnull JTextComponent textBox, @Nonnull Rectangle r) {
        if (textBox == null) {
            JTextComponentDriver.$$$reportNull$$$0(25);
        }
        if (r == null) {
            JTextComponentDriver.$$$reportNull$$$0(26);
        }
        textBox.scrollRectToVisible(r);
        if (JTextComponentDriver.isVisible(textBox, r)) {
            return;
        }
        JTextComponentDriver.scrollToVisibleIfIsTextField(textBox, r);
    }

    @RunsInCurrentThread
    private static void scrollToVisibleIfIsTextField(@Nonnull JTextComponent textBox, @Nonnull Rectangle r) {
        if (textBox == null) {
            JTextComponentDriver.$$$reportNull$$$0(27);
        }
        if (r == null) {
            JTextComponentDriver.$$$reportNull$$$0(28);
        }
        if (!(textBox instanceof JTextField)) {
            return;
        }
        Pair<Point, Container> pointAndParent = PointAndParentForScrollingJTextFieldQuery.pointAndParentForScrolling((JTextField)textBox);
        Container parent = (Container)pointAndParent.second;
        if (parent == null || parent instanceof CellRendererPane || !(parent instanceof JComponent)) {
            return;
        }
        ((JComponent)parent).scrollRectToVisible(JTextComponentDriver.addPointToRectangle((Point)Preconditions.checkNotNull(pointAndParent.first), r));
    }

    @Nonnull
    private static Rectangle addPointToRectangle(@Nonnull Point p, @Nonnull Rectangle r) {
        if (p == null) {
            JTextComponentDriver.$$$reportNull$$$0(29);
        }
        if (r == null) {
            JTextComponentDriver.$$$reportNull$$$0(30);
        }
        Rectangle destination = new Rectangle(r);
        destination.x += p.x;
        destination.y += p.y;
        Rectangle rectangle = destination;
        if (rectangle == null) {
            JTextComponentDriver.$$$reportNull$$$0(31);
        }
        return rectangle;
    }

    @Nonnull
    private static Point centerOf(@Nonnull Rectangle r) {
        if (r == null) {
            JTextComponentDriver.$$$reportNull$$$0(32);
        }
        Point point = new Point(r.x + r.width / 2, r.y + r.height / 2);
        if (point == null) {
            JTextComponentDriver.$$$reportNull$$$0(33);
        }
        return point;
    }

    @RunsInEDT
    private static void performAndValidateTextSelection(final @Nonnull JTextComponent textBox, final int start, final int end) {
        if (textBox == null) {
            JTextComponentDriver.$$$reportNull$$$0(34);
        }
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                JTextComponentSelectTextTask.selectTextInRange(textBox, start, end);
                JTextComponentDriver.verifyTextWasSelected(textBox, start, end);
            }
        });
    }

    @RunsInCurrentThread
    private static void verifyTextWasSelected(@Nonnull JTextComponent textBox, int start, int end) {
        if (textBox == null) {
            JTextComponentDriver.$$$reportNull$$$0(35);
        }
        int actualStart = textBox.getSelectionStart();
        int actualEnd = textBox.getSelectionEnd();
        if (actualStart == Math.min(start, end) && actualEnd == Math.max(start, end)) {
            return;
        }
        String format = "Unable to select text uses indices <%d> and <%d>, current selection starts at <%d> and ends at <%d>";
        String msg = String.format(format, start, end, actualStart, actualEnd);
        throw ActionFailedException.actionFailure(msg);
    }

    @Override
    @RunsInEDT
    public void requireText(@Nonnull JTextComponent textBox, @Nullable String expected) {
        if (textBox == null) {
            JTextComponentDriver.$$$reportNull$$$0(36);
        }
        TextAssert.verifyThat(this.textOf(textBox)).as(JTextComponentDriver.textProperty(textBox)).isEqualOrMatches(expected);
    }

    @Override
    @RunsInEDT
    public void requireText(@Nonnull JTextComponent textBox, @Nonnull Pattern pattern) {
        if (textBox == null) {
            JTextComponentDriver.$$$reportNull$$$0(37);
        }
        if (pattern == null) {
            JTextComponentDriver.$$$reportNull$$$0(38);
        }
        TextAssert.verifyThat(this.textOf(textBox)).as(JTextComponentDriver.textProperty(textBox)).matches(pattern);
    }

    @RunsInEDT
    public void requireEmpty(@Nonnull JTextComponent textBox) {
        if (textBox == null) {
            JTextComponentDriver.$$$reportNull$$$0(39);
        }
        ((StringAssert)Assertions.assertThat((String)this.textOf(textBox)).as(JTextComponentDriver.textProperty(textBox))).isEmpty();
    }

    @Nonnull
    @RunsInEDT
    private static Description textProperty(@Nonnull JTextComponent textBox) {
        if (textBox == null) {
            JTextComponentDriver.$$$reportNull$$$0(40);
        }
        Description description = JTextComponentDriver.propertyName(textBox, TEXT_PROPERTY);
        if (description == null) {
            JTextComponentDriver.$$$reportNull$$$0(41);
        }
        return description;
    }

    @RunsInEDT
    public void requireEditable(@Nonnull JTextComponent textBox) {
        if (textBox == null) {
            JTextComponentDriver.$$$reportNull$$$0(42);
        }
        this.assertEditable(textBox, true);
    }

    @RunsInEDT
    public void requireNotEditable(@Nonnull JTextComponent textBox) {
        if (textBox == null) {
            JTextComponentDriver.$$$reportNull$$$0(43);
        }
        this.assertEditable(textBox, false);
    }

    @RunsInEDT
    private void assertEditable(@Nonnull JTextComponent textBox, boolean editable) {
        if (textBox == null) {
            JTextComponentDriver.$$$reportNull$$$0(44);
        }
        ((BooleanAssert)Assertions.assertThat((boolean)JTextComponentEditableQuery.isEditable(textBox)).as(JTextComponentDriver.editableProperty(textBox))).isEqualTo(editable);
    }

    @Nonnull
    @RunsInEDT
    private static Description editableProperty(@Nonnull JTextComponent textBox) {
        if (textBox == null) {
            JTextComponentDriver.$$$reportNull$$$0(45);
        }
        Description description = JTextComponentDriver.propertyName(textBox, EDITABLE_PROPERTY);
        if (description == null) {
            JTextComponentDriver.$$$reportNull$$$0(46);
        }
        return description;
    }

    @Override
    @Nullable
    @RunsInEDT
    public String textOf(@Nonnull JTextComponent textBox) {
        if (textBox == null) {
            JTextComponentDriver.$$$reportNull$$$0(47);
        }
        return JTextComponentTextQuery.textOf(textBox);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 31: 
            case 33: 
            case 41: 
            case 46: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 31: 
            case 33: 
            case 41: 
            case 46: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "robot";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textBox";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = TEXT_PROPERTY;
                break;
            }
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 31: 
            case 33: 
            case 41: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/driver/JTextComponentDriver";
                break;
            }
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/driver/JTextComponentDriver";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "checkStateAndScrollToPosition";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "scrollToPosition";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "scrollToVisible";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "locationOf";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "addPointToRectangle";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "centerOf";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "textProperty";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "editableProperty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "deleteText";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "replaceText";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "selectAll";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "enterText";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
            case 8: 
            case 9: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "selectText";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "indexOfText";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "checkStateAndScrollToPosition";
                break;
            }
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 31: 
            case 33: 
            case 41: 
            case 46: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "scrollToPosition";
                break;
            }
            case 17: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "scrollToVisible";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "locationOf";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "cannotGetLocation";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isRectangleVisible";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "scrollToVisibleIfIsTextField";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "addPointToRectangle";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "centerOf";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "performAndValidateTextSelection";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "verifyTextWasSelected";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "requireText";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "requireEmpty";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "textProperty";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "requireEditable";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "requireNotEditable";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "assertEditable";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "editableProperty";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "textOf";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 31: 
            case 33: 
            case 41: 
            case 46: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

