/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.driver.JTreeLocation;
import org.fest.swing.driver.JTreeMatchingPathQuery;
import org.fest.swing.driver.JTreePathFinder;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.util.Preconditions;

final class JTreeNodeTextQuery {
    @Nullable
    @RunsInEDT
    static String nodeText(final @Nonnull JTree tree, final int row, final @Nonnull JTreeLocation location, final @Nonnull JTreePathFinder pathFinder) {
        if (tree == null) {
            JTreeNodeTextQuery.$$$reportNull$$$0(0);
        }
        if (location == null) {
            JTreeNodeTextQuery.$$$reportNull$$$0(1);
        }
        if (pathFinder == null) {
            JTreeNodeTextQuery.$$$reportNull$$$0(2);
        }
        return GuiActionRunner.execute(new GuiQuery<String>(){

            @Override
            protected String executeInEDT() {
                TreePath matchingPath = location.pathFor(tree, row);
                return pathFinder.cellReader().valueAt(tree, Preconditions.checkNotNull((Object)matchingPath.getLastPathComponent()));
            }
        });
    }

    @Nullable
    @RunsInEDT
    static String nodeText(final @Nonnull JTree tree, final @Nonnull String path, final @Nonnull JTreePathFinder pathFinder) {
        if (tree == null) {
            JTreeNodeTextQuery.$$$reportNull$$$0(3);
        }
        if (path == null) {
            JTreeNodeTextQuery.$$$reportNull$$$0(4);
        }
        if (pathFinder == null) {
            JTreeNodeTextQuery.$$$reportNull$$$0(5);
        }
        return GuiActionRunner.execute(new GuiQuery<String>(){

            @Override
            protected String executeInEDT() {
                TreePath matchingPath = JTreeMatchingPathQuery.matchingPathWithRootIfInvisible(tree, path, pathFinder);
                return pathFinder.cellReader().valueAt(tree, Preconditions.checkNotNull((Object)matchingPath.getLastPathComponent()));
            }
        });
    }

    private JTreeNodeTextQuery() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "tree";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "location";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "pathFinder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "path";
                break;
            }
        }
        objectArray[1] = "org/fest/swing/driver/JTreeNodeTextQuery";
        objectArray[2] = "nodeText";
        throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

