/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.finder;

import java.awt.Component;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.swing.core.ComponentFoundCondition;
import org.fest.swing.core.ComponentMatcher;
import org.fest.swing.core.GenericTypeMatcher;
import org.fest.swing.core.NameMatcher;
import org.fest.swing.core.Robot;
import org.fest.swing.core.TypeMatcher;
import org.fest.swing.fixture.AbstractComponentFixture;
import org.fest.swing.timing.Condition;
import org.fest.swing.timing.Pause;
import org.fest.util.Preconditions;
import org.fest.util.Strings;

public abstract class ComponentFinderTemplate<T extends Component> {
    static final long TIMEOUT = 5000L;
    private long timeout;
    private final ComponentMatcher matcher;
    private final String searchDescription;

    protected ComponentFinderTemplate(@Nullable String componentName, @Nonnull Class<? extends T> componentType) {
        if (componentType == null) {
            ComponentFinderTemplate.$$$reportNull$$$0(0);
        }
        this(new NameMatcher(componentName, componentType, true));
    }

    protected ComponentFinderTemplate(@Nonnull GenericTypeMatcher<? extends T> matcher) {
        if (matcher == null) {
            ComponentFinderTemplate.$$$reportNull$$$0(1);
        }
        this((ComponentMatcher)matcher);
    }

    protected ComponentFinderTemplate(@Nonnull Class<? extends T> componentType) {
        if (componentType == null) {
            ComponentFinderTemplate.$$$reportNull$$$0(2);
        }
        this(new TypeMatcher(componentType, true));
    }

    private ComponentFinderTemplate(@Nonnull ComponentMatcher matcher) {
        if (matcher == null) {
            ComponentFinderTemplate.$$$reportNull$$$0(3);
        }
        this.timeout = 5000L;
        this.matcher = (ComponentMatcher)Preconditions.checkNotNull((Object)matcher);
        this.searchDescription = Strings.concat((Object[])new Object[]{"component to be found using matcher ", matcher});
    }

    /*
     * WARNING - void declaration
     */
    protected ComponentFinderTemplate<T> withTimeout(@Nonnegative long newTimeout, @Nonnull TimeUnit timeUnit) {
        void unit;
        if (timeUnit == null) {
            ComponentFinderTemplate.$$$reportNull$$$0(4);
        }
        Preconditions.checkNotNull((Object)unit);
        return this.withTimeout(unit.toMillis(newTimeout));
    }

    @Nonnull
    protected ComponentFinderTemplate<T> withTimeout(@Nonnegative long newTimeout) {
        if (newTimeout < 0L) {
            throw new IllegalArgumentException("Timeout cannot be a negative number");
        }
        this.timeout = newTimeout;
        ComponentFinderTemplate componentFinderTemplate = this;
        if (componentFinderTemplate == null) {
            ComponentFinderTemplate.$$$reportNull$$$0(5);
        }
        return componentFinderTemplate;
    }

    @Nonnull
    public abstract AbstractComponentFixture<?, T, ?> using(@Nonnull Robot var1);

    @Nonnull
    protected final T findComponentWith(@Nonnull Robot robot) {
        if (robot == null) {
            ComponentFinderTemplate.$$$reportNull$$$0(6);
        }
        ComponentFoundCondition condition = new ComponentFoundCondition(this.searchDescription, robot.finder(), this.matcher);
        Pause.pause((Condition)condition, this.timeout);
        Component component = (Component)Preconditions.checkNotNull(this.cast(condition.found()));
        if (component == null) {
            ComponentFinderTemplate.$$$reportNull$$$0(7);
        }
        return (T)component;
    }

    @Nullable
    protected abstract T cast(@Nullable Component var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentType";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/finder/ComponentFinderTemplate";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "robot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/finder/ComponentFinderTemplate";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "withTimeout";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findComponentWith";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "withTimeout";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findComponentWith";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

