/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.input;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import java.util.Stack;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.swing.query.ComponentShowingQuery;

class MouseInfo {
    static final int BUTTON_MASK = 28;
    private Point location = new Point(0, 0);
    private Point locationOnScreen = new Point(0, 0);
    private final Stack<WeakReference<Component>> componentStack = new Stack();
    private final Stack<Point> locationStack = new Stack();
    private final Stack<Point> screenLocationStack = new Stack();
    private int buttons;
    private int modifiers;
    private int clickCount;

    MouseInfo() {
    }

    void clear() {
        this.clickCount = 0;
        this.modifiers = 0;
        this.buttons = 0;
        this.componentStack.clear();
        this.locationStack.clear();
        this.screenLocationStack.clear();
    }

    void update(@Nonnull MouseEvent event, @Nullable Point eventScreenLocation) {
        if (event == null) {
            MouseInfo.$$$reportNull$$$0(0);
        }
        this.clickCount(event.getClickCount());
        this.updateOnMousePressed(event);
        this.updateOnMouseReleased(event);
        this.updateOnMouseEntered(event, eventScreenLocation);
        this.updateOnMouseExited(event);
        if (eventScreenLocation != null) {
            Point where = event.getPoint();
            this.location = this.componentStack.empty() ? null : new Point(where);
            this.locationOnScreen.setLocation(eventScreenLocation);
            this.locationOnScreen.translate(where.x, where.y);
        }
    }

    private void updateOnMousePressed(@Nonnull MouseEvent event) {
        if (event == null) {
            MouseInfo.$$$reportNull$$$0(1);
        }
        if (event.getID() != 501) {
            return;
        }
        int buttonUsed = this.buttonUsed(event);
        this.buttons |= buttonUsed;
        this.modifiers |= buttonUsed;
    }

    private void updateOnMouseReleased(@Nonnull MouseEvent event) {
        if (event == null) {
            MouseInfo.$$$reportNull$$$0(2);
        }
        if (event.getID() != 502) {
            return;
        }
        int buttonUsed = this.buttonUsed(event);
        this.buttons &= ~buttonUsed;
        this.modifiers &= ~buttonUsed;
    }

    private int buttonUsed(@Nonnull MouseEvent event) {
        if (event == null) {
            MouseInfo.$$$reportNull$$$0(3);
        }
        return event.getModifiers() & 0x1C;
    }

    private void updateOnMouseEntered(@Nonnull MouseEvent event, @Nullable Point eventScreenLocation) {
        if (event == null) {
            MouseInfo.$$$reportNull$$$0(4);
        }
        if (event.getID() != 504) {
            return;
        }
        this.componentStack.push(new WeakReference<Component>(event.getComponent()));
        Point eventPoint = event.getPoint();
        this.locationStack.push(eventPoint);
        this.screenLocationStack.push(eventScreenLocation != null ? eventScreenLocation : eventPoint);
    }

    private void updateOnMouseExited(@Nonnull MouseEvent event) {
        if (event == null) {
            MouseInfo.$$$reportNull$$$0(5);
        }
        if (event.getID() != 505 || this.componentStack.empty()) {
            return;
        }
        this.componentStack.pop();
        this.locationStack.pop();
        this.screenLocationStack.pop();
    }

    @Nullable
    public Component component() {
        if (this.componentStack.empty()) {
            return null;
        }
        Component c = (Component)this.componentStack.peek().get();
        if (c != null && ComponentShowingQuery.isShowing(c)) {
            return c;
        }
        this.componentStack.pop();
        this.locationStack.pop();
        this.screenLocationStack.pop();
        c = this.component();
        if (c != null) {
            this.location = this.locationStack.peek();
            this.locationOnScreen = this.screenLocationStack.peek();
        }
        return c;
    }

    int buttons() {
        return this.buttons;
    }

    void buttons(int newButtons) {
        this.buttons = newButtons;
    }

    int modifiers() {
        return this.modifiers;
    }

    void modifiers(int newModifiers) {
        this.modifiers = newModifiers;
    }

    int clickCount() {
        return this.clickCount;
    }

    void clickCount(int newClickCount) {
        this.clickCount = newClickCount;
    }

    @Nullable
    Point location() {
        return this.pointFrom(this.location);
    }

    @Nullable
    Point locationOnScreen() {
        return this.pointFrom(this.locationOnScreen);
    }

    @Nullable
    private Point pointFrom(Point source) {
        return source != null ? new Point(source) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "event";
        objectArray2[1] = "org/fest/swing/input/MouseInfo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "updateOnMousePressed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "updateOnMouseReleased";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "buttonUsed";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "updateOnMouseEntered";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "updateOnMouseExited";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

