/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.inspections;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.ws.rest.RSBundle;
import com.intellij.ws.rest.inspections.AbstractRestJavaInspection;
import com.intellij.ws.rest.model.jam.RSHttpMethod;
import com.intellij.ws.rest.model.jam.RSJamPsiMethodPath;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RestResourceMethodInspection
extends AbstractRestJavaInspection {
    @Override
    protected void checkClass(PsiClass psiClass, ProblemsHolder holder, @NotNull Module module) {
        if (module == null) {
            RestResourceMethodInspection.$$$reportNull$$$0(0);
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)"javax.ws.rs.Path", (boolean)true) && !RestResourceMethodInspection.hasPublicResourceMethods(psiClass, module)) {
            PsiIdentifier identifier = psiClass.getNameIdentifier();
            holder.registerProblem((PsiElement)(identifier != null ? identifier : psiClass), RSBundle.message("resource.methods.inspection.class.has.no.public.methods", new Object[0]), ProblemHighlightType.ERROR, new LocalQuickFix[0]);
        }
        super.checkClass(psiClass, holder, module);
    }

    private static boolean hasPublicResourceMethods(PsiClass psiClass, @NotNull Module module) {
        if (module == null) {
            RestResourceMethodInspection.$$$reportNull$$$0(1);
        }
        JamService jamService = JamService.getJamService((Project)module.getProject());
        List methods = jamService.getAnnotatedMembersList(psiClass, RSHttpMethod.RS_HTTP_METHOD_JAM_KEY, false, true, false, true);
        for (RSHttpMethod method : methods) {
            if (!method.getPsiElement().getModifierList().hasModifierProperty("public")) continue;
            return true;
        }
        for (RSJamPsiMethodPath path : jamService.getAnnotatedMembersList(psiClass, false, true, false, true, new JamMemberMeta[]{RSJamPsiMethodPath.META})) {
            if (!path.getPsiElement().getModifierList().hasModifierProperty("public")) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void checkMethod(@NotNull PsiMethod method, @NotNull ProblemsHolder problemsHolder, @NotNull Module module) {
        PsiClass c;
        if (method == null) {
            RestResourceMethodInspection.$$$reportNull$$$0(2);
        }
        if (problemsHolder == null) {
            RestResourceMethodInspection.$$$reportNull$$$0(3);
        }
        if (module == null) {
            RestResourceMethodInspection.$$$reportNull$$$0(4);
        }
        if ((c = method.getContainingClass()) == null) {
            return;
        }
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, Arrays.asList("javax.ws.rs.Path", "javax.ws.rs.GET", "javax.ws.rs.POST", "javax.ws.rs.PUT", "javax.ws.rs.DELETE", "javax.ws.rs.HEAD"));
        if (annotation != null) {
            RestResourceMethodInspection.checkPublicMethod(method, annotation, problemsHolder);
        }
    }

    private static void checkPublicMethod(@NotNull PsiMethod method, PsiAnnotation annotation, @NotNull ProblemsHolder holder) {
        if (method == null) {
            RestResourceMethodInspection.$$$reportNull$$$0(5);
        }
        if (holder == null) {
            RestResourceMethodInspection.$$$reportNull$$$0(6);
        }
        if (!method.getModifierList().hasModifierProperty("public")) {
            String shortName = "@" + StringUtil.getShortName((String)annotation.getQualifiedName());
            holder.registerProblem((PsiElement)method.getNameIdentifier(), RSBundle.message("resource.methods.inspection.method.must.be.public", shortName), ProblemHighlightType.ERROR, new LocalQuickFix[0]);
        }
    }

    @NotNull
    public String getDisplayName() {
        String string = RSBundle.message("resource.methods.inspection", new Object[0]);
        if (string == null) {
            RestResourceMethodInspection.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("RestResourceMethodInspection" == null) {
            RestResourceMethodInspection.$$$reportNull$$$0(8);
        }
        return "RestResourceMethodInspection";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemsHolder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/rest/inspections/RestResourceMethodInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/rest/inspections/RestResourceMethodInspection";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasPublicResourceMethods";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkMethod";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkPublicMethod";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

