/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.core.model.externalizable.toclasschain;

import com.intellij.tapestry.core.java.IJavaField;
import com.intellij.tapestry.core.model.externalizable.toclasschain.ToClassExternalizer;
import com.intellij.tapestry.core.model.presentation.Mixin;
import com.intellij.tapestry.core.util.PathUtils;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.chain.Context;

public class MixinExternalizer
extends ToClassExternalizer {
    @Override
    public boolean execute(Context context) throws Exception {
        if (!super.execute(context)) {
            return false;
        }
        if (!(this.getContext().getElement() instanceof Mixin)) {
            return false;
        }
        Mixin mixin = (Mixin)this.getContext().getElement();
        IJavaField field = mixin.getProject().getJavaTypeCreator().createField(PathUtils.getLastPathElement(mixin.getName()), mixin.getElementClass(), true, true);
        String suggestedFieldName = this.suggestName(field.getName(), new ArrayList<String>(this.getContext().getTargetClass().getFields(false).keySet()));
        if (!suggestedFieldName.equals(field.getName())) {
            field = mixin.getProject().getJavaTypeCreator().createField(suggestedFieldName, mixin.getElementClass(), true, true);
        }
        mixin.getProject().getJavaTypeCreator().createFieldAnnotation(field, "org.apache.tapestry5.annotations.Mixin", new HashMap<String, String>());
        String serialized = field.getStringRepresentation();
        if (mixin.getProject().getJavaTypeCreator().ensureClassImport(this.getContext().getTargetClass(), mixin.getElementClass())) {
            serialized = serialized.replace(mixin.getElementClass().getFullyQualifiedName(), mixin.getElementClass().getName());
        }
        if (mixin.getProject().getJavaTypeCreator().ensureClassImport(this.getContext().getTargetClass(), mixin.getProject().getJavaTypeFinder().findType("org.apache.tapestry5.annotations.Mixin", true))) {
            serialized = serialized.replace("org.apache.tapestry5.annotations.Mixin", "Mixin");
        }
        this.getContext().setResult("\n" + serialized + "\n");
        return true;
    }
}

