/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.intellij.actions.navigation;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiFile;
import com.intellij.tapestry.core.exceptions.NotTapestryElementException;
import com.intellij.tapestry.core.model.presentation.PresentationLibraryElement;
import com.intellij.tapestry.core.resource.IResource;
import com.intellij.tapestry.intellij.TapestryModuleSupportLoader;
import com.intellij.tapestry.intellij.actions.navigation.ClassTemplateNavigation;
import com.intellij.tapestry.intellij.core.java.IntellijJavaClassType;
import com.intellij.tapestry.intellij.core.resource.IntellijResource;
import com.intellij.tapestry.intellij.util.IdeaUtils;
import com.intellij.tapestry.intellij.util.TapestryUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplatesNavigation
extends ActionGroup
implements DumbAware {
    private static final AnAction[] EMPTY_ACTION_ARRAY = AnAction.EMPTY_ARRAY;
    private PresentationLibraryElement tapestryElement;
    private final ClassTemplateNavigation classTemplateNavigation = new ClassTemplateNavigation();

    public void update(AnActionEvent event) {
        boolean isTapestryModule = TapestryUtils.isTapestryModule((Module)event.getData(DataKeys.MODULE));
        Presentation presentation = event.getPresentation();
        presentation.setEnabled(isTapestryModule);
        presentation.setVisible(isTapestryModule);
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent event) {
        if (event == null) {
            if (EMPTY_ACTION_ARRAY == null) {
                TemplatesNavigation.$$$reportNull$$$0(0);
            }
            return EMPTY_ACTION_ARRAY;
        }
        PsiFile psiFile = ClassTemplateNavigation.getEventPsiFile(event);
        if (psiFile == null) {
            if (EMPTY_ACTION_ARRAY == null) {
                TemplatesNavigation.$$$reportNull$$$0(1);
            }
            return EMPTY_ACTION_ARRAY;
        }
        if (psiFile instanceof PsiClassOwner && event.getPresentation().getText().equals("Tapestry Template")) {
            PsiClass psiClass;
            DefaultActionGroup actions;
            block15: {
                block16: {
                    actions = new DefaultActionGroup("TemplatesGroup", true);
                    try {
                        psiClass = IdeaUtils.findPublicClass(psiFile);
                        if (psiClass != null) break block15;
                        if (EMPTY_ACTION_ARRAY != null) break block16;
                    }
                    catch (NotTapestryElementException ex) {
                        if (EMPTY_ACTION_ARRAY == null) {
                            TemplatesNavigation.$$$reportNull$$$0(3);
                        }
                        return EMPTY_ACTION_ARRAY;
                    }
                    TemplatesNavigation.$$$reportNull$$$0(2);
                }
                return EMPTY_ACTION_ARRAY;
            }
            this.tapestryElement = PresentationLibraryElement.createProjectElementInstance(new IntellijJavaClassType((Module)event.getDataContext().getData(DataKeys.MODULE.getName()), psiClass.getContainingFile()), TapestryModuleSupportLoader.getTapestryProject((Module)event.getDataContext().getData(DataKeys.MODULE.getName())));
            if (this.tapestryElement.allowsTemplate()) {
                for (int i = 0; i < this.tapestryElement.getTemplate().length; ++i) {
                    TemplateNavigate templateNavigate = new TemplateNavigate(this.tapestryElement.getTemplate()[i]);
                    actions.add((AnAction)templateNavigate);
                }
            }
            if (actions.getChildrenCount() != 0) {
                AnAction[] anActionArray = actions.getChildren(event);
                if (anActionArray == null) {
                    TemplatesNavigation.$$$reportNull$$$0(4);
                }
                return anActionArray;
            }
            if (EMPTY_ACTION_ARRAY == null) {
                TemplatesNavigation.$$$reportNull$$$0(5);
            }
            return EMPTY_ACTION_ARRAY;
        }
        if (EMPTY_ACTION_ARRAY == null) {
            TemplatesNavigation.$$$reportNull$$$0(6);
        }
        return EMPTY_ACTION_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/intellij/actions/navigation/TemplatesNavigation", "getChildren"));
    }

    private class TemplateNavigate
    extends AnAction {
        public TemplateNavigate(IResource template) {
            super(template.getName().replace("_", "__"), template.getName(), null);
        }

        public void actionPerformed(AnActionEvent event) {
            Project project = (Project)event.getDataContext().getData(DataKeys.PROJECT.getName());
            for (int i = 0; i < TemplatesNavigation.this.tapestryElement.getTemplate().length; ++i) {
                IResource template = TemplatesNavigation.this.tapestryElement.getTemplate()[i];
                if (!template.getName().equals(event.getPresentation().getDescription())) continue;
                FileEditorManager.getInstance((Project)project).openFile(((IntellijResource)template).getPsiFile().getVirtualFile(), true);
                return;
            }
        }
    }
}

