/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.experimental;

import java.lang.reflect.Method;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.coroutines.experimental.Continuation;
import kotlin.coroutines.experimental.ContinuationInterceptor;
import kotlin.coroutines.experimental.jvm.internal.CoroutineIntrinsics;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.coroutines.experimental.Delay;
import kotlinx.coroutines.experimental.Job;
import kotlinx.coroutines.experimental.JobKt;
import kotlinx.coroutines.experimental.ScheduledKt;
import kotlinx.coroutines.experimental.TimeoutContinuation;
import kotlinx.coroutines.experimental.intrinsics.UndispatchedKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u00000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\u001a\b\u0010\t\u001a\u00020\u0005H\u0003\u001a\b\u0010\n\u001a\u00020\u000bH\u0001\u001a\b\u0010\f\u001a\u00020\u000bH\u0001\u001aG\u0010\r\u001a\u0002H\u000e\"\u0004\b\u0000\u0010\u000e2\u0006\u0010\u000f\u001a\u00020\u00012\b\b\u0002\u0010\u0010\u001a\u00020\u00112\u001c\u0010\u0012\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000e0\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0013H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016\"\u0018\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0003\"\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0006\u001a\u00020\u00058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u0082\u0002\u0004\n\u0002\b\t\u00a8\u0006\u0017"}, d2={"KEEP_ALIVE", "", "kotlin.jvm.PlatformType", "Ljava/lang/Long;", "_scheduledExecutor", "Ljava/util/concurrent/ScheduledExecutorService;", "scheduledExecutor", "getScheduledExecutor", "()Ljava/util/concurrent/ScheduledExecutorService;", "getOrCreateScheduledExecutorSync", "scheduledExecutorShutdownNow", "", "scheduledExecutorShutdownNowAndRelease", "withTimeout", "T", "time", "unit", "Ljava/util/concurrent/TimeUnit;", "block", "Lkotlin/Function1;", "Lkotlin/coroutines/experimental/Continuation;", "", "(JLjava/util/concurrent/TimeUnit;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/experimental/Continuation;)Ljava/lang/Object;", "kotlinx-coroutines-core"})
public final class ScheduledKt {
    private static final Long KEEP_ALIVE = Long.getLong("kotlinx.coroutines.ScheduledExecutor.keepAlive", 1000L);
    private static volatile ScheduledExecutorService _scheduledExecutor;

    @NotNull
    public static final ScheduledExecutorService getScheduledExecutor() {
        ScheduledExecutorService scheduledExecutorService = _scheduledExecutor;
        if (scheduledExecutorService == null) {
            scheduledExecutorService = ScheduledKt.getOrCreateScheduledExecutorSync();
        }
        return scheduledExecutorService;
    }

    private static final synchronized ScheduledExecutorService getOrCreateScheduledExecutorSync() {
        ScheduledExecutorService scheduledExecutorService = _scheduledExecutor;
        if (scheduledExecutorService == null) {
            ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
            ScheduledThreadPoolExecutor $receiver = scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1, getOrCreateScheduledExecutorSync.1.INSTANCE);
            Long l = KEEP_ALIVE;
            Intrinsics.checkExpressionValueIsNotNull(l, "KEEP_ALIVE");
            $receiver.setKeepAliveTime(l, TimeUnit.MILLISECONDS);
            $receiver.allowCoreThreadTimeOut(true);
            $receiver.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
            try {
                Method m = $receiver.getClass().getMethod("setRemoveOnCancelPolicy", JvmClassMappingKt.getJavaPrimitiveType(Reflection.getOrCreateKotlinClass(Boolean.TYPE)));
                m.invoke((Object)$receiver, true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            _scheduledExecutor = $receiver;
            scheduledExecutorService = scheduledThreadPoolExecutor;
        }
        return scheduledExecutorService;
    }

    public static final synchronized void scheduledExecutorShutdownNow() {
        block0: {
            ScheduledExecutorService scheduledExecutorService = _scheduledExecutor;
            if (scheduledExecutorService == null) break block0;
            scheduledExecutorService.shutdownNow();
        }
    }

    public static final synchronized void scheduledExecutorShutdownNowAndRelease() {
        block0: {
            ScheduledExecutorService scheduledExecutorService;
            ScheduledExecutorService scheduledExecutorService2 = _scheduledExecutor;
            if (scheduledExecutorService2 == null) break block0;
            ScheduledExecutorService $receiver = scheduledExecutorService = scheduledExecutorService2;
            $receiver.shutdownNow();
            _scheduledExecutor = null;
        }
    }

    @Nullable
    public static final <T> Object withTimeout(long time, @NotNull TimeUnit unit, @NotNull Function1<? super Continuation<? super T>, ? extends Object> block, @NotNull Continuation<? super T> $continuation) {
        Delay delay;
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)unit, "unit");
        Intrinsics.checkParameterIsNotNull(block, "block");
        Intrinsics.checkParameterIsNotNull($continuation, "$continuation");
        boolean bl2 = bl = time >= (long)0;
        if (!bl) {
            String string = "Timeout time " + time + " cannot be negative";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (time <= 0L) {
            throw (Throwable)new CancellationException("Timed out immediately");
        }
        Continuation<? super T> delegate2 = CoroutineIntrinsics.normalizeContinuation($continuation);
        TimeoutContinuation<T> cont = new TimeoutContinuation<T>(time, unit, delegate2);
        Object e = cont.getContext().get(ContinuationInterceptor.Key);
        if (!(e instanceof Delay)) {
            e = null;
        }
        if ((delay = (Delay)e) != null) {
            JobKt.disposeOnCompletion(cont, delay.invokeOnTimeout(time, unit, cont));
        } else {
            Job job = cont;
            ScheduledFuture<?> scheduledFuture = ScheduledKt.getScheduledExecutor().schedule(cont, time, unit);
            Intrinsics.checkExpressionValueIsNotNull(scheduledFuture, "scheduledExecutor.schedule(cont, time, unit)");
            JobKt.cancelFutureOnCompletion(job, (Future)scheduledFuture);
        }
        UndispatchedKt.startCoroutineUndispatched(block, (Continuation)cont);
        return cont.getResult();
    }

    @Nullable
    public static /* bridge */ /* synthetic */ Object withTimeout$default(long l, TimeUnit timeUnit, Function1 function1, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            timeUnit = TimeUnit.MILLISECONDS;
        }
        return ScheduledKt.withTimeout(l, timeUnit, function1, continuation);
    }
}

