/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jbpm.annotation;

import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.JBIterable;
import gnu.trove.THashMap;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class AnnotationsCoordinator {
    private final Set<Class<? extends Annotation>> annotationsSet;

    public AnnotationsCoordinator(Collection<Class<? extends Annotation>> annotations) {
        this.annotationsSet = new java.util.HashSet<Class<? extends Annotation>>(annotations);
    }

    public AnnotationsCoordinator(Class<? extends Annotation> annotation) {
        this.annotationsSet = new java.util.HashSet<Class<? extends Annotation>>();
        this.annotationsSet.add(annotation);
    }

    public Map<Class<? extends Annotation>, Annotation> findAnnotations(Iterable<Class<?>> classes) {
        return this.findAnnotations(classes, Collections.emptySet());
    }

    private Map<Class<? extends Annotation>, Annotation> findAnnotations(Iterable<Class<?>> classes, Set<Class<? extends Annotation>> excludedAnnotations) {
        THashMap annotationMap = new THashMap();
        List annotations = JBIterable.from(classes).filter(aClass -> aClass != null).transform(aClass -> this.findAnnotations((Class<?>)aClass, excludedAnnotations)).flatten(map -> map.entrySet()).toList();
        for (Map.Entry entry : annotations) {
            assert (!AnnotationsCoordinator.annotationAlreadyExistAndDiffer((Map<Class<? extends Annotation>, Annotation>)annotationMap, (Annotation)entry.getValue())) : "Found multiple annotations with type " + ((Class)entry.getKey()).getName() + " and different values; you should annotate child class too to avoid this warning";
            annotationMap.put(entry.getKey(), entry.getValue());
        }
        return annotationMap;
    }

    private static boolean annotationAlreadyExistAndDiffer(@NotNull Map<Class<? extends Annotation>, Annotation> annotations, @NotNull Annotation annotation) {
        Annotation existAnnotation;
        if (annotations == null) {
            AnnotationsCoordinator.$$$reportNull$$$0(0);
        }
        if (annotation == null) {
            AnnotationsCoordinator.$$$reportNull$$$0(1);
        }
        return (existAnnotation = annotations.get(annotation.annotationType())) != null && !existAnnotation.equals(annotation);
    }

    private Map<Class<? extends Annotation>, Annotation> findAnnotations(Class<?> clazz, Set<Class<? extends Annotation>> excludedAnnotations) {
        THashMap annotations = new THashMap();
        for (Annotation annotation : clazz.getAnnotations()) {
            Class<? extends Annotation> annotationClass = annotation.annotationType();
            if (excludedAnnotations.contains(annotationClass) || !this.annotationsSet.contains(annotationClass)) continue;
            annotations.put(annotationClass, annotation);
        }
        HashSet parentExcludedAnnotations = new HashSet(excludedAnnotations);
        parentExcludedAnnotations.addAll(annotations.keySet());
        Map<Class<? extends Annotation>, Annotation> parentAnnotations = this.findAnnotations((Iterable<Class<?>>)JBIterable.of(clazz.getSuperclass()).append((Object[])clazz.getInterfaces()), (Set<Class<? extends Annotation>>)parentExcludedAnnotations);
        annotations.putAll(parentAnnotations);
        return annotations;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "annotations";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "annotation";
                break;
            }
        }
        objectArray[1] = "com/intellij/jboss/jbpm/annotation/AnnotationsCoordinator";
        objectArray[2] = "annotationAlreadyExistAndDiffer";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

