/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.internal.daemon;

import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.gradle.initialization.BuildLayoutParameters;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.logging.events.OutputEvent;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.remote.internal.Connection;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.launcher.daemon.client.DaemonClientConnection;
import org.gradle.launcher.daemon.client.DaemonClientFactory;
import org.gradle.launcher.daemon.client.DaemonConnector;
import org.gradle.launcher.daemon.client.ReportStatusDispatcher;
import org.gradle.launcher.daemon.configuration.DaemonParameters;
import org.gradle.launcher.daemon.context.DaemonConnectDetails;
import org.gradle.launcher.daemon.protocol.Command;
import org.gradle.launcher.daemon.protocol.ReportStatus;
import org.gradle.launcher.daemon.protocol.Status;
import org.gradle.launcher.daemon.registry.DaemonInfo;
import org.gradle.launcher.daemon.registry.DaemonRegistry;
import org.gradle.launcher.daemon.registry.DaemonStopEvent;
import org.gradle.launcher.daemon.registry.DaemonStopEvents;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationStatus;
import org.gradle.util.GradleVersion;
import org.jetbrains.plugins.gradle.internal.daemon.DaemonState;

public class DaemonStatusAction {
    public List<DaemonState> run(DaemonClientFactory daemonClientFactory) {
        OutputEventListener outputEventListener = new OutputEventListener(){

            public void onOutput(OutputEvent event) {
            }
        };
        ServiceRegistry daemonServices = daemonClientFactory.createStopDaemonServices(outputEventListener, new DaemonParameters(new BuildLayoutParameters()));
        DaemonConnector daemonConnector = (DaemonConnector)daemonServices.get(DaemonConnector.class);
        DaemonRegistry daemonRegistry = (DaemonRegistry)daemonServices.get(DaemonRegistry.class);
        IdGenerator idGenerator = (IdGenerator)daemonServices.get(IdGenerator.class);
        return new ReportDaemonStatusClient(daemonRegistry, daemonConnector, idGenerator).get();
    }

    static class ReportDaemonStatusClient {
        private final DaemonRegistry daemonRegistry;
        private final DaemonConnector connector;
        private final IdGenerator<?> idGenerator;
        private final ReportStatusDispatcher reportStatusDispatcher;

        public ReportDaemonStatusClient(DaemonRegistry daemonRegistry, DaemonConnector connector, IdGenerator<?> idGenerator) {
            this.daemonRegistry = daemonRegistry;
            this.connector = connector;
            this.idGenerator = idGenerator;
            this.reportStatusDispatcher = new ReportStatusDispatcher();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<DaemonState> get() {
            ArrayList<DaemonState> daemons = new ArrayList<DaemonState>();
            for (DaemonInfo daemon : this.daemonRegistry.getAll()) {
                DaemonClientConnection connection = this.connector.maybeConnect((DaemonConnectDetails)daemon);
                if (connection == null) continue;
                DaemonInfo connectionDaemon = connection.getDaemon() instanceof DaemonInfo ? (DaemonInfo)connection.getDaemon() : daemon;
                try {
                    List daemonOpts = connectionDaemon.getContext().getDaemonOpts();
                    File javaHome = connectionDaemon.getContext().getJavaHome();
                    Integer idleTimeout = connectionDaemon.getContext().getIdleTimeout();
                    File registryDir = connectionDaemon.getContext().getDaemonRegistryDir();
                    ReportStatus statusCommand = new ReportStatus(this.idGenerator.generateId(), daemon.getToken());
                    Status status = this.reportStatusDispatcher.dispatch((Connection)connection, (Command)statusCommand);
                    if (status != null) {
                        daemons.add(new DaemonState(connectionDaemon.getPid(), connectionDaemon.getToken(), status.getVersion(), status.getStatus(), null, connectionDaemon.getLastBusy().getTime(), null, daemonOpts, javaHome, idleTimeout, registryDir));
                        continue;
                    }
                    daemons.add(new DaemonState(connectionDaemon.getPid(), connectionDaemon.getToken(), "UNKNOWN", "UNKNOWN", null, connectionDaemon.getLastBusy().getTime(), null, daemonOpts, javaHome, idleTimeout, registryDir));
                }
                finally {
                    connection.stop();
                }
            }
            List stopEvents = DaemonStopEvents.uniqueRecentDaemonStopEvents((List)this.daemonRegistry.getStopEvents());
            for (DaemonStopEvent stopEvent : stopEvents) {
                Long stopEventPid;
                String daemonExpirationStatus;
                DaemonExpirationStatus expirationStatus = stopEvent.getStatus();
                String string = daemonExpirationStatus = expirationStatus != null ? expirationStatus.name().replace("_", " ").toLowerCase(Locale.ENGLISH) : "";
                if (GradleVersion.current().compareTo(GradleVersion.version((String)"3.0")) <= 0) {
                    try {
                        Field pidField = stopEvent.getClass().getDeclaredField("pid");
                        pidField.setAccessible(true);
                        stopEventPid = pidField.getLong(stopEvent);
                    }
                    catch (Exception ignore) {
                        stopEventPid = -1L;
                    }
                } else {
                    stopEventPid = stopEvent.getPid();
                }
                daemons.add(new DaemonState(stopEventPid, null, null, "Stopped", stopEvent.getReason(), stopEvent.getTimestamp().getTime(), daemonExpirationStatus, null, null, null, null));
            }
            return daemons;
        }
    }
}

