/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.wizard;

import com.intellij.externalSystem.JavaProjectData;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.internal.InternalExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectRefreshCallback;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.project.wizard.AbstractExternalProjectImportBuilder;
import com.intellij.openapi.externalSystem.service.settings.AbstractImportFromExternalSystemControl;
import com.intellij.openapi.externalSystem.service.ui.ExternalProjectDataSelectorDialog;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import icons.GradleIcons;
import java.io.File;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.settings.ImportFromGradleControl;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleProjectImportBuilder
extends AbstractExternalProjectImportBuilder<ImportFromGradleControl> {
    public GradleProjectImportBuilder(@NotNull ProjectDataManager dataManager) {
        if (dataManager == null) {
            GradleProjectImportBuilder.$$$reportNull$$$0(0);
        }
        this((com.intellij.openapi.externalSystem.service.project.ProjectDataManager)dataManager);
    }

    public GradleProjectImportBuilder(@NotNull com.intellij.openapi.externalSystem.service.project.ProjectDataManager dataManager) {
        if (dataManager == null) {
            GradleProjectImportBuilder.$$$reportNull$$$0(1);
        }
        super(dataManager, (AbstractImportFromExternalSystemControl)new ImportFromGradleControl(), GradleConstants.SYSTEM_ID);
    }

    @NotNull
    public String getName() {
        String string = GradleBundle.message("gradle.name", new Object[0]);
        if (string == null) {
            GradleProjectImportBuilder.$$$reportNull$$$0(2);
        }
        return string;
    }

    public Icon getIcon() {
        return GradleIcons.Gradle;
    }

    protected void doPrepare(@NotNull WizardContext context) {
        if (context == null) {
            GradleProjectImportBuilder.$$$reportNull$$$0(3);
        }
        String pathToUse = this.getFileToImport();
        VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(pathToUse);
        if (file != null && !file.isDirectory() && file.getParent() != null) {
            pathToUse = file.getParent().getPath();
        }
        ImportFromGradleControl importFromGradleControl = (ImportFromGradleControl)this.getControl(context.getProject());
        importFromGradleControl.setLinkedProjectPath(pathToUse);
        Pair sdkPair = ExternalSystemJdkUtil.getAvailableJdk((Project)context.getProject());
        if (sdkPair != null && !"#JAVA_INTERNAL".equals(sdkPair.first)) {
            ((GradleProjectSettings)importFromGradleControl.getProjectSettings()).setGradleJvm((String)sdkPair.first);
        }
    }

    protected ExternalProjectRefreshCallback createFinalImportCallback(final @NotNull Project project, final @NotNull ExternalProjectSettings projectSettings) {
        if (project == null) {
            GradleProjectImportBuilder.$$$reportNull$$$0(4);
        }
        if (projectSettings == null) {
            GradleProjectImportBuilder.$$$reportNull$$$0(5);
        }
        return new ExternalProjectRefreshCallback(){

            public void onSuccess(@Nullable DataNode<ProjectData> externalProject) {
                if (externalProject == null) {
                    return;
                }
                Runnable selectDataTask = () -> {
                    ExternalProjectDataSelectorDialog dialog;
                    if (project == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (projectSettings == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    if ((dialog = new ExternalProjectDataSelectorDialog(project, (ExternalProjectInfo)new InternalExternalProjectInfo(GradleConstants.SYSTEM_ID, projectSettings.getExternalProjectPath(), externalProject))).hasMultipleDataToSelect()) {
                        dialog.showAndGet();
                    } else {
                        Disposer.dispose((Disposable)dialog.getDisposable());
                    }
                };
                Runnable importTask = () -> {
                    if (project == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    ((com.intellij.openapi.externalSystem.service.project.ProjectDataManager)ServiceManager.getService(com.intellij.openapi.externalSystem.service.project.ProjectDataManager.class)).importData(externalProject, project, false);
                };
                boolean showSelectiveImportDialog = GradleSettings.getInstance(project).showSelectiveImportDialogOnInitialImport();
                if (showSelectiveImportDialog && !ApplicationManager.getApplication().isHeadlessEnvironment()) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        selectDataTask.run();
                        ApplicationManager.getApplication().executeOnPooledThread(importTask);
                    });
                } else {
                    importTask.run();
                }
            }

            public void onFailure(@NotNull String errorMessage, @Nullable String errorDetails) {
                if (errorMessage == null) {
                    1.$$$reportNull$$$0(0);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorMessage";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "projectSettings";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/project/wizard/GradleProjectImportBuilder$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onFailure";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$onSuccess$1";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$onSuccess$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    protected void beforeCommit(@NotNull DataNode<ProjectData> dataNode, @NotNull Project project) {
        LanguageLevelProjectExtension languageLevelExtension;
        DataNode javaProjectNode;
        if (dataNode == null) {
            GradleProjectImportBuilder.$$$reportNull$$$0(6);
        }
        if (project == null) {
            GradleProjectImportBuilder.$$$reportNull$$$0(7);
        }
        if ((javaProjectNode = ExternalSystemApiUtil.find(dataNode, (Key)JavaProjectData.KEY)) == null) {
            return;
        }
        LanguageLevel externalLanguageLevel = ((JavaProjectData)javaProjectNode.getData()).getLanguageLevel();
        if (externalLanguageLevel != (languageLevelExtension = LanguageLevelProjectExtension.getInstance((Project)project)).getLanguageLevel()) {
            languageLevelExtension.setLanguageLevel(externalLanguageLevel);
        }
    }

    protected void applyExtraSettings(@NotNull WizardContext context) {
        DataNode node;
        if (context == null) {
            GradleProjectImportBuilder.$$$reportNull$$$0(8);
        }
        if ((node = this.getExternalProjectNode()) == null) {
            return;
        }
        DataNode javaProjectNode = ExternalSystemApiUtil.find((DataNode)node, (Key)JavaProjectData.KEY);
        if (javaProjectNode != null) {
            JavaProjectData data = (JavaProjectData)javaProjectNode.getData();
            context.setCompilerOutputDirectory(data.getCompileOutputPath());
            JavaSdkVersion version = data.getJdkVersion();
            Sdk jdk = GradleProjectImportBuilder.findJdk(version);
            if (jdk != null) {
                context.setProjectJdk(jdk);
            }
        }
    }

    @Nullable
    private static Sdk findJdk(@NotNull JavaSdkVersion version) {
        if (version == null) {
            GradleProjectImportBuilder.$$$reportNull$$$0(9);
        }
        JavaSdk javaSdk = JavaSdk.getInstance();
        List javaSdks = ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)javaSdk);
        Sdk candidate = null;
        for (Sdk sdk : javaSdks) {
            JavaSdkVersion v = javaSdk.getVersion(sdk);
            if (v == version) {
                return sdk;
            }
            if (candidate != null || v == null || !version.getMaxLanguageLevel().isAtLeast(version.getMaxLanguageLevel())) continue;
            candidate = sdk;
        }
        return candidate;
    }

    @NotNull
    protected File getExternalProjectConfigToUse(@NotNull File file) {
        if (file == null) {
            GradleProjectImportBuilder.$$$reportNull$$$0(10);
        }
        File file2 = file.isDirectory() ? file : file.getParentFile();
        if (file2 == null) {
            GradleProjectImportBuilder.$$$reportNull$$$0(11);
        }
        return file2;
    }

    public boolean isSuitableSdkType(SdkTypeId sdk) {
        return sdk == JavaSdk.getInstance();
    }

    @Nullable
    public Project createProject(String name, String path) {
        Project project = super.createProject(name, path);
        if (project != null) {
            GradleProjectSettings settings = (GradleProjectSettings)((ImportFromGradleControl)this.getControl(project)).getProjectSettings();
            ExternalProjectsManagerImpl.getInstance((Project)project).setStoreExternally(settings.isStoreProjectFilesExternally());
        }
        return project;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataManager";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/service/project/wizard/GradleProjectImportBuilder";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSettings";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataNode";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/project/wizard/GradleProjectImportBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalProjectConfigToUse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 11: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doPrepare";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createFinalImportCallback";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "beforeCommit";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "applyExtraSettings";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findJdk";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getExternalProjectConfigToUse";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

