/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.quickFix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.quickFix.CreateFileFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.jsp.JspBundle;
import com.intellij.jsp.impl.TldDescriptor;
import com.intellij.jsp.impl.TldTagFileDescriptor;
import com.intellij.lang.Language;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.jsp.TagdirSupport;
import com.intellij.psi.jsp.JspDirectiveKind;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.util.XmlUtil;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TagFileQuickFixProvider {
    @NonNls
    private static final String TAGX_EXTENSION = ".tagx";
    @NonNls
    private static final String TAG_EXTENSION = ".tag";

    private TagFileQuickFixProvider() {
    }

    @Nullable
    private static XmlFile getTagDirDescriptorFile(@NotNull XmlTag tag, @NotNull PsiFile file) {
        XmlFile xmlFile;
        XmlNSDescriptor nsDescriptor;
        if (tag == null) {
            TagFileQuickFixProvider.$$$reportNull$$$0(0);
        }
        if (file == null) {
            TagFileQuickFixProvider.$$$reportNull$$$0(1);
        }
        if (JspPsiUtil.isInJspFile((PsiElement)file) && (nsDescriptor = tag.getNSDescriptor(tag.getNamespace(), true)) instanceof TldDescriptor && (xmlFile = nsDescriptor.getDescriptorFile()) != null && !xmlFile.isPhysical()) {
            return xmlFile;
        }
        return null;
    }

    @Nullable
    public static LocalQuickFix createTagFileReferenceQuickFix(@NotNull XmlTag element) {
        PsiFile psiFile;
        if (element == null) {
            TagFileQuickFixProvider.$$$reportNull$$$0(2);
        }
        if ((psiFile = element.getContainingFile()) == null) {
            return null;
        }
        XmlFile xmlFile = TagFileQuickFixProvider.getTagDirDescriptorFile(element, psiFile);
        if (xmlFile == null) {
            return null;
        }
        List<VirtualFile> data = TagdirSupport.getTagFiles(xmlFile);
        if (data == null || data.isEmpty()) {
            return null;
        }
        PsiDirectory directory = element.getManager().findDirectory(data.get(0));
        if (directory == null || !directory.isWritable()) {
            return null;
        }
        String fileNameWithoutExtension = XmlUtil.findLocalNameByQualifiedName((String)element.getName());
        Language language = psiFile.getViewProvider().getBaseLanguage();
        boolean jspSyntax = language == StdLanguages.JSP;
        String text = jspSyntax ? "" : "<jsp:root xmlns:jsp=\"http://java.sun.com/JSP/Page\" version=\"2.0\">\n";
        for (XmlAttribute attribute : element.getAttributes()) {
            text = text + TagFileQuickFixProvider.createAttributeString(jspSyntax, attribute);
        }
        if (!jspSyntax) {
            text = text + "</jsp:root>";
        }
        String newFileName = fileNameWithoutExtension + (jspSyntax ? TAG_EXTENSION : TAGX_EXTENSION);
        try {
            directory.checkCreateFile(newFileName);
        }
        catch (IncorrectOperationException e) {
            return null;
        }
        return new CreateFileFix(false, newFileName, directory, text, "create.tagfile.text");
    }

    @NonNls
    private static String createAttributeString(boolean jspSyntax, XmlAttribute attribute) {
        return (jspSyntax ? "<%@ attribute name=\"" + attribute.getName() + "\" %>" : "<jsp:directive.attribute name=\"" + attribute.getName() + "\" />") + "\n";
    }

    @Nullable
    public static IntentionAction createTagFileAttributeReferenceQuickFix(final XmlAttribute attribute) {
        final XmlTag element = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)attribute, XmlTag.class, (boolean)false);
        if (element == null) {
            return null;
        }
        final XmlElementDescriptor descriptor = element.getDescriptor();
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        XmlFile xmlFile = TagFileQuickFixProvider.getTagDirDescriptorFile(element, psiFile);
        if (descriptor instanceof TldTagFileDescriptor && xmlFile != null) {
            return new IntentionAction(){

                @NotNull
                public String getText() {
                    String string = JspBundle.message("create.tagfile.attribute.text", attribute.getName());
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                @NotNull
                public String getFamilyName() {
                    String string = JspBundle.message("create.tagfile.attribute.family", new Object[0]);
                    if (string == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return string;
                }

                public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
                    if (project == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    XmlElementDescriptor descriptor2 = element.isValid() ? element.getDescriptor() : null;
                    return descriptor2 != null && descriptor2.getAttributeDescriptor(attribute) == null;
                }

                public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
                    if (project == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
                        return;
                    }
                    XmlTag declaration = ((TldTagFileDescriptor)descriptor).getRealDeclaration();
                    PsiFile containingFile = declaration.getContainingFile();
                    if (!FileModificationService.getInstance().prepareFileForWrite(containingFile)) {
                        return;
                    }
                    XmlDocument document = ((XmlFile)containingFile).getDocument();
                    assert (document != null);
                    XmlTag rootTag = document.getRootTag();
                    XmlTag tag = ((JspFile)containingFile).createDirective(rootTag, JspDirectiveKind.ATTRIBUTE);
                    tag.setAttribute("name", attribute.getName());
                    assert (rootTag != null);
                    rootTag.add((PsiElement)tag);
                }

                public boolean startInWriteAction() {
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                        case 2: 
                        case 3: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 2;
                            break;
                        }
                        case 2: 
                        case 3: {
                            n2 = 3;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/codeInsight/daemon/quickFix/TagFileQuickFixProvider$1";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "project";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getText";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getFamilyName";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/codeInsight/daemon/quickFix/TagFileQuickFixProvider$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            break;
                        }
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "isAvailable";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray;
                            objectArray[2] = "invoke";
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                        case 2: 
                        case 3: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/quickFix/TagFileQuickFixProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getTagDirDescriptorFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createTagFileReferenceQuickFix";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

