/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.wordSelection;

import com.intellij.codeInsight.editorActions.wordSelection.BasicSelectioner;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.jsp.JspxFileViewProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.jsp.JspFile;
import java.util.List;

public class ScriptletSelectioner
extends BasicSelectioner {
    public boolean canSelect(PsiElement e) {
        return JspPsiUtil.isInJspFile((PsiElement)e) && e.getLanguage() instanceof JavaLanguage;
    }

    public List<TextRange> select(PsiElement e, CharSequence editorText, int cursorOffset, Editor editor) {
        List ranges = super.select(e, editorText, cursorOffset, editor);
        JspFile psiFile = JspPsiUtil.getJspFile((PsiElement)e);
        if (e.getParent().getTextLength() == psiFile.getTextLength()) {
            JspxFileViewProvider viewProvider = psiFile.getViewProvider();
            PsiElement elt = viewProvider.findElementAt(cursorOffset, viewProvider.getTemplateDataLanguage());
            ranges.add(elt.getTextRange());
        }
        return ranges;
    }
}

