/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.eval4j.jdi;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import java.lang.reflect.AccessibleObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.eval4j.AbstractValue;
import org.jetbrains.eval4j.Eval;
import org.jetbrains.eval4j.FieldDescription;
import org.jetbrains.eval4j.MembersKt;
import org.jetbrains.eval4j.MethodDescription;
import org.jetbrains.eval4j.NewObjectValue;
import org.jetbrains.eval4j.Value;
import org.jetbrains.eval4j.ValuesKt;
import org.jetbrains.eval4j.jdi.JDIEval;
import org.jetbrains.eval4j.jdi.JdiEvalKt;
import org.jetbrains.eval4j.jdi.JdiValuesKt;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015J&\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\t2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\t0\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u001a\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\b\b\u0002\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010'\u001a\u00020\u00152\u0006\u0010(\u001a\u00020\u00152\u0006\u0010)\u001a\u00020\u0015H\u0016J\u0010\u0010*\u001a\u00020\u00152\u0006\u0010(\u001a\u00020\u0015H\u0016J\u0018\u0010+\u001a\u00020\u00152\u0006\u0010,\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010-\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J.\u0010.\u001a\u00020\u00152\u0006\u0010,\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020#2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00150\u001b2\u0006\u00100\u001a\u000201H\u0016J0\u00102\u001a\u00020\u00152\u0006\u00103\u001a\u00020\u00112\u0006\u0010,\u001a\u00020\u00152\u000e\u00104\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001050\u001b2\u0006\u0010\"\u001a\u00020#H\u0002J\u001e\u00106\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020#2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00150\u001bH\u0016J\u001c\u00107\u001a\u0002012\b\u00108\u001a\u0004\u0018\u00010\u000f2\b\u00109\u001a\u0004\u0018\u00010\u000fH\u0002J\u0018\u0010:\u001a\u0002012\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010;\u001a\u00020\u0011H\u0016J\u0010\u0010<\u001a\u00020\u00152\u0006\u0010=\u001a\u00020\u0011H\u0016J\u0018\u0010<\u001a\u00020\u00152\u0006\u0010=\u001a\u00020\u00112\b\u0010>\u001a\u0004\u0018\u00010\u0005J\u0010\u0010?\u001a\u00020\u00152\u0006\u0010@\u001a\u00020\rH\u0016J,\u0010A\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001050\u001b2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00150\u001b2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001bH\u0002J\u0018\u0010C\u001a\u00020\u00152\u0006\u0010D\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\tH\u0016J\u0010\u0010E\u001a\u00020\u00152\u0006\u0010=\u001a\u00020\u0011H\u0016J\u001e\u0010F\u001a\u00020\u00152\u0006\u0010D\u001a\u00020\u00112\f\u0010G\u001a\b\u0012\u0004\u0012\u00020\t0\u001bH\u0016J \u0010H\u001a\u00020I2\u0006\u0010(\u001a\u00020\u00152\u0006\u0010)\u001a\u00020\u00152\u0006\u0010J\u001a\u00020\u0015H\u0016J \u0010K\u001a\u00020I2\u0006\u0010,\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010J\u001a\u00020\u0015H\u0016J\u0018\u0010L\u001a\u00020I2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010J\u001a\u00020\u0015H\u0016J \u0010M\u001a\u0002012\u0006\u0010N\u001a\u00020!2\u000e\u00104\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001050\u001bH\u0002J\u0016\u0010O\u001a\u00020\u00152\u0006\u0010P\u001a\u00020\u00152\u0006\u0010Q\u001a\u00020\u0011J\f\u0010(\u001a\u00020R*\u00020\u0015H\u0002J\u0016\u0010S\u001a\u00020T*\u00020\u00112\n\b\u0002\u0010>\u001a\u0004\u0018\u00010\u0005J\u0016\u0010U\u001a\u00020%*\u00020\u00112\n\b\u0002\u0010>\u001a\u0004\u0018\u00010\u0005J\u0014\u0010V\u001a\u00020I*\n\u0012\u0006\u0012\u0004\u0018\u0001050\u001bH\u0002J\u0014\u0010W\u001a\u00020I*\n\u0012\u0006\u0012\u0004\u0018\u0001050\u001bH\u0002J\u0012\u0010X\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001b*\u00020!H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000b\u001a\u001e\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u000f0\u000f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0010\u001a\u00020\u0011*\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006Y"}, d2={"Lorg/jetbrains/eval4j/jdi/JDIEval;", "Lorg/jetbrains/eval4j/Eval;", "vm", "Lcom/sun/jdi/VirtualMachine;", "defaultClassLoader", "Lcom/sun/jdi/ClassLoaderReference;", "thread", "Lcom/sun/jdi/ThreadReference;", "invokePolicy", "", "(Lcom/sun/jdi/VirtualMachine;Lcom/sun/jdi/ClassLoaderReference;Lcom/sun/jdi/ThreadReference;I)V", "primitiveTypes", "", "", "kotlin.jvm.PlatformType", "Lcom/sun/jdi/Type;", "arrayElementType", "Lorg/jetbrains/org/objectweb/asm/Type;", "getArrayElementType", "(Lorg/jetbrains/org/objectweb/asm/Type;)Lorg/jetbrains/org/objectweb/asm/Type;", "boxType", "Lorg/jetbrains/eval4j/Value;", "value", "fillArray", "elementType", "size", "nestedSizes", "", "findField", "Lcom/sun/jdi/Field;", "fieldDesc", "Lorg/jetbrains/eval4j/FieldDescription;", "findMethod", "Lcom/sun/jdi/Method;", "methodDesc", "Lorg/jetbrains/eval4j/MethodDescription;", "_class", "Lcom/sun/jdi/ReferenceType;", "findStaticField", "getArrayElement", "array", "index", "getArrayLength", "getField", "instance", "getStaticField", "invokeMethod", "arguments", "invokespecial", "", "invokeMethodWithReflection", "ownerType", "args", "Lcom/sun/jdi/Value;", "invokeStaticMethod", "isArrayOfInterfaces", "valueType", "expectedType", "isInstanceOf", "targetType", "loadClass", "classType", "classLoader", "loadString", "str", "mapArguments", "expecetedTypes", "newArray", "arrayType", "newInstance", "newMultiDimensionalArray", "dimensionSizes", "setArrayElement", "", "newValue", "setField", "setStaticField", "shouldInvokeMethodWithReflection", "method", "unboxType", "boxedValue", "type", "Lcom/sun/jdi/ArrayReference;", "asArrayType", "Lcom/sun/jdi/ArrayType;", "asReferenceType", "disableCollection", "enableCollection", "safeArgumentTypes", "eval4j"})
public final class JDIEval
implements Eval {
    private final Map<String, com.sun.jdi.Type> primitiveTypes;
    private final VirtualMachine vm;
    private final ClassLoaderReference defaultClassLoader;
    private final ThreadReference thread;
    private final int invokePolicy;

    @Override
    @NotNull
    public Value loadClass(@NotNull Type classType) {
        Intrinsics.checkParameterIsNotNull((Object)classType, (String)"classType");
        return this.loadClass(classType, this.defaultClassLoader);
    }

    @NotNull
    public final Value loadClass(@NotNull Type classType, @Nullable ClassLoaderReference classLoader) {
        Intrinsics.checkParameterIsNotNull((Object)classType, (String)"classType");
        List<ReferenceType> loadedClasses = this.vm.classesByName(classType.getInternalName());
        if (!loadedClasses.isEmpty()) {
            Iterator<ReferenceType> iterator2 = loadedClasses.iterator();
            while (iterator2.hasNext()) {
                ReferenceType loadedClass;
                ReferenceType referenceType = loadedClass = iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)referenceType, (String)"loadedClass");
                if (!referenceType.isPrepared() || !JdiEvalKt.access$getBOOTSTRAP_CLASS_DESCRIPTORS$p().contains(classType.getDescriptor()) && !Intrinsics.areEqual((Object)loadedClass.classLoader(), (Object)classLoader)) continue;
                return JdiValuesKt.asValue(loadedClass.classObject());
            }
        }
        if (classLoader == null) {
            Type type2 = JdiEvalKt.access$getCLASS$p();
            Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"CLASS");
            String string = type2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"CLASS.internalName");
            MethodDescription methodDescription = new MethodDescription(string, "forName", "(Ljava/lang/String;)Ljava/lang/Class;", true);
            String string2 = classType.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"classType.internalName");
            return this.invokeStaticMethod(methodDescription, CollectionsKt.listOf((Object)JdiValuesKt.asValue(this.vm.mirrorOf(StringsKt.replace$default((String)string2, (char)'/', (char)'.', (boolean)false, (int)4, null)))));
        }
        Type type3 = JdiEvalKt.access$getCLASS$p();
        Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"CLASS");
        String string = type3.getInternalName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"CLASS.internalName");
        MethodDescription methodDescription = new MethodDescription(string, "forName", "(Ljava/lang/String;ZLjava/lang/ClassLoader;)Ljava/lang/Class;", true);
        Object[] objectArray = new AbstractValue[3];
        String string3 = classType.getInternalName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"classType.internalName");
        objectArray[0] = JdiValuesKt.asValue(this.vm.mirrorOf(StringsKt.replace$default((String)string3, (char)'/', (char)'.', (boolean)false, (int)4, null)));
        objectArray[1] = ValuesKt.boolean(true);
        objectArray[2] = JdiValuesKt.asValue(classLoader);
        return this.invokeStaticMethod(methodDescription, CollectionsKt.listOf((Object[])objectArray));
    }

    @Override
    @NotNull
    public Value loadString(@NotNull String str) {
        Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
        return JdiValuesKt.asValue(this.vm.mirrorOf(str));
    }

    @Override
    @NotNull
    public Value newInstance(@NotNull Type classType) {
        Intrinsics.checkParameterIsNotNull((Object)classType, (String)"classType");
        return new NewObjectValue(classType);
    }

    @Override
    public boolean isInstanceOf(@NotNull Value value2, @NotNull Type targetType) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)targetType, (String)"targetType");
        boolean bl2 = bl = targetType.getSort() == 10 || targetType.getSort() == 9;
        if (_Assertions.ENABLED && !bl) {
            String string = "Can't check isInstanceOf() for non-object type " + targetType;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Value _class = this.loadClass(targetType);
        Type type2 = JdiEvalKt.access$getCLASS$p();
        Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"CLASS");
        String string = type2.getInternalName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"CLASS.internalName");
        return ValuesKt.getBoolean(Eval.DefaultImpls.invokeMethod$default(this, _class, new MethodDescription(string, "isInstance", "(Ljava/lang/Object;)Z", false), CollectionsKt.listOf((Object)value2), false, 8, null));
    }

    @NotNull
    public final ReferenceType asReferenceType(@NotNull Type $receiver, @Nullable ClassLoaderReference classLoader) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ClassObjectReference classObjectReference = JdiValuesKt.getJdiClass(this.loadClass($receiver, classLoader));
        if (classObjectReference == null) {
            Intrinsics.throwNpe();
        }
        ReferenceType referenceType = classObjectReference.reflectedType();
        Intrinsics.checkExpressionValueIsNotNull((Object)referenceType, (String)"loadClass(this, classLoa\u2026diClass!!.reflectedType()");
        return referenceType;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ ReferenceType asReferenceType$default(JDIEval jDIEval, Type type2, ClassLoaderReference classLoaderReference, int n, Object object) {
        if ((n & 1) != 0) {
            classLoaderReference = jDIEval.defaultClassLoader;
        }
        return jDIEval.asReferenceType(type2, classLoaderReference);
    }

    @NotNull
    public final ArrayType asArrayType(@NotNull Type $receiver, @Nullable ClassLoaderReference classLoader) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ReferenceType referenceType = this.asReferenceType($receiver, classLoader);
        if (referenceType == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.sun.jdi.ArrayType");
        }
        return (ArrayType)referenceType;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ ArrayType asArrayType$default(JDIEval jDIEval, Type type2, ClassLoaderReference classLoaderReference, int n, Object object) {
        if ((n & 1) != 0) {
            classLoaderReference = jDIEval.defaultClassLoader;
        }
        return jDIEval.asArrayType(type2, classLoaderReference);
    }

    @Override
    @NotNull
    public Value newArray(@NotNull Type arrayType, int size) {
        Intrinsics.checkParameterIsNotNull((Object)arrayType, (String)"arrayType");
        ArrayType jdiArrayType = JDIEval.asArrayType$default(this, arrayType, null, 1, null);
        return JdiValuesKt.asValue(jdiArrayType.newInstance(size));
    }

    private final Type getArrayElementType(@NotNull Type $receiver) {
        boolean bl;
        boolean bl2 = bl = $receiver.getSort() == 9;
        if (_Assertions.ENABLED && !bl) {
            String string = "Not an array type: " + $receiver;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        String string = $receiver.getDescriptor();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"descriptor");
        String string2 = string;
        int n = 1;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
        Type type2 = Type.getType((String)string4);
        Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"Type.getType(descriptor.substring(1))");
        return type2;
    }

    /*
     * WARNING - void declaration
     */
    private final Value fillArray(Type elementType, int size, List<Integer> nestedSizes) {
        Type type2 = Type.getType((String)("[" + elementType.getDescriptor()));
        Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"Type.getType(\"[\" + elementType.descriptor)");
        Value arr = this.newArray(type2, size);
        if (!nestedSizes.isEmpty()) {
            Type nestedElementType = this.getArrayElementType(elementType);
            int nestedSize = ((Number)nestedSizes.get(0)).intValue();
            List tail = CollectionsKt.drop((Iterable)nestedSizes, (int)1);
            int n = 0;
            int n2 = size - 1;
            if (n <= n2) {
                while (true) {
                    void i;
                    this.setArrayElement(arr, ValuesKt.int((int)i), this.fillArray(nestedElementType, nestedSize, tail));
                    if (i == n2) break;
                    ++i;
                }
            }
        }
        return arr;
    }

    @Override
    @NotNull
    public Value newMultiDimensionalArray(@NotNull Type arrayType, @NotNull List<Integer> dimensionSizes) {
        Intrinsics.checkParameterIsNotNull((Object)arrayType, (String)"arrayType");
        Intrinsics.checkParameterIsNotNull(dimensionSizes, (String)"dimensionSizes");
        return this.fillArray(this.getArrayElementType(arrayType), ((Number)dimensionSizes.get(0)).intValue(), CollectionsKt.drop((Iterable)dimensionSizes, (int)1));
    }

    private final ArrayReference array(@NotNull Value $receiver) {
        ObjectReference objectReference = ValuesKt.checkNull(JdiValuesKt.getJdiObj($receiver));
        if (objectReference == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.sun.jdi.ArrayReference");
        }
        return (ArrayReference)objectReference;
    }

    @Override
    @NotNull
    public Value getArrayLength(@NotNull Value array) {
        Intrinsics.checkParameterIsNotNull((Object)array, (String)"array");
        return ValuesKt.int(this.array(array).length());
    }

    @Override
    @NotNull
    public Value getArrayElement(@NotNull Value array, @NotNull Value index2) {
        Intrinsics.checkParameterIsNotNull((Object)array, (String)"array");
        Intrinsics.checkParameterIsNotNull((Object)index2, (String)"index");
        try {
            return JdiValuesKt.asValue(this.array(array).getValue(ValuesKt.getInt(index2)));
        }
        catch (IndexOutOfBoundsException e) {
            Void void_ = ValuesKt.throwEvalException(new ArrayIndexOutOfBoundsException(e.getMessage()));
            throw null;
        }
    }

    @Override
    public void setArrayElement(@NotNull Value array, @NotNull Value index2, @NotNull Value newValue) {
        Intrinsics.checkParameterIsNotNull((Object)array, (String)"array");
        Intrinsics.checkParameterIsNotNull((Object)index2, (String)"index");
        Intrinsics.checkParameterIsNotNull((Object)newValue, (String)"newValue");
        try {
            this.array(array).setValue(ValuesKt.getInt(index2), JdiValuesKt.asJdiValue(newValue, this.vm, this.getArrayElementType(array.getAsmType())));
            return;
        }
        catch (IndexOutOfBoundsException e) {
            Void void_ = ValuesKt.throwEvalException(new ArrayIndexOutOfBoundsException(e.getMessage()));
            throw null;
        }
    }

    private final Field findField(FieldDescription fieldDesc) {
        ReferenceType _class = JDIEval.asReferenceType$default(this, MembersKt.getOwnerType(fieldDesc), null, 1, null);
        Field field2 = _class.fieldByName(fieldDesc.getName());
        if (field2 == null) {
            Void void_ = ValuesKt.throwBrokenCodeException(new NoSuchFieldError("Field not found: " + fieldDesc));
            throw null;
        }
        return field2;
    }

    private final Field findStaticField(FieldDescription fieldDesc) {
        Field field2 = this.findField(fieldDesc);
        if (!field2.isStatic()) {
            Void void_ = ValuesKt.throwBrokenCodeException(new NoSuchFieldError("Field is not static: " + fieldDesc));
            throw null;
        }
        return field2;
    }

    @Override
    @NotNull
    public Value getStaticField(@NotNull FieldDescription fieldDesc) {
        Intrinsics.checkParameterIsNotNull((Object)fieldDesc, (String)"fieldDesc");
        Field field2 = this.findStaticField(fieldDesc);
        return JdiValuesKt.asValue((com.sun.jdi.Value)JdiEvalKt.ifFail$default(JdiEvalKt.access$mayThrow((Function0)new Function0<com.sun.jdi.Value>(field2){
            final /* synthetic */ Field $field;

            public final com.sun.jdi.Value invoke() {
                return this.$field.declaringType().getValue(this.$field);
            }
            {
                this.$field = field2;
                super(0);
            }
        }), field2, null, 2, null));
    }

    @Override
    public void setStaticField(@NotNull FieldDescription fieldDesc, @NotNull Value newValue) {
        Intrinsics.checkParameterIsNotNull((Object)fieldDesc, (String)"fieldDesc");
        Intrinsics.checkParameterIsNotNull((Object)newValue, (String)"newValue");
        Field field2 = this.findStaticField(fieldDesc);
        if (field2.isFinal()) {
            Void void_ = ValuesKt.throwBrokenCodeException(new NoSuchFieldError("Can't modify a final field: " + field2));
            throw null;
        }
        ReferenceType _class = field2.declaringType();
        if (!(_class instanceof ClassType)) {
            Void void_ = ValuesKt.throwBrokenCodeException(new NoSuchFieldError("Can't a field in a non-class: " + field2));
            throw null;
        }
        com.sun.jdi.Type type2 = field2.type();
        Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"field.type()");
        com.sun.jdi.Value jdiValue = JdiValuesKt.asJdiValue(newValue, this.vm, JdiValuesKt.asType(type2));
        JdiEvalKt.ifFail$default(JdiEvalKt.access$mayThrow((Function0)new Function0<Unit>(_class, field2, jdiValue){
            final /* synthetic */ ReferenceType $_class;
            final /* synthetic */ Field $field;
            final /* synthetic */ com.sun.jdi.Value $jdiValue;

            public final void invoke() {
                ((ClassType)this.$_class).setValue(this.$field, this.$jdiValue);
            }
            {
                this.$_class = referenceType;
                this.$field = field2;
                this.$jdiValue = value2;
                super(0);
            }
        }), field2, null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final Method findMethod(MethodDescription methodDesc, ReferenceType _class) {
        Method method;
        Method method2;
        String methodName = methodDesc.getName();
        ReferenceType referenceType = _class;
        if (referenceType instanceof ClassType) {
            method2 = ((ClassType)_class).concreteMethodByName(methodName, methodDesc.getDesc());
        } else {
            List<Method> list2 = _class.methodsByName(methodName, methodDesc.getDesc());
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"_class.methodsByName(methodName, methodDesc.desc)");
            method2 = method = (Method)CollectionsKt.firstOrNull(list2);
        }
        if (method != null) {
            return method;
        }
        String internalNameWithoutSuffix = KotlinTypeMapper.InternalNameMapper.internalNameWithoutModuleSuffix(methodName);
        if (internalNameWithoutSuffix != null) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            List<Method> list3 = _class.visibleMethods();
            Intrinsics.checkExpressionValueIsNotNull(list3, (String)"_class.visibleMethods()");
            Iterable iterable = $receiver$iv = (Iterable)list3;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                String name2;
                Method it = (Method)element$iv$iv;
                String string = name2 = it.name();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
                boolean bl = StringsKt.startsWith$default((String)string, (String)internalNameWithoutSuffix, (boolean)false, (int)2, null) && KotlinTypeMapper.InternalNameMapper.canBeMangledInternalName(name2) && Intrinsics.areEqual((Object)it.signature(), (Object)methodDesc.getDesc());
                if (!bl) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List internalMethods = (List)destination$iv$iv;
            if (!internalMethods.isEmpty()) {
                Method method3 = (Method)CollectionsKt.singleOrNull((List)internalMethods);
                if (method3 == null) {
                    Void void_ = ValuesKt.throwBrokenCodeException(new IllegalArgumentException("Several internal methods found for " + methodDesc));
                    throw null;
                }
                return method3;
            }
        }
        Void void_ = ValuesKt.throwBrokenCodeException(new NoSuchMethodError("Method not found: " + methodDesc));
        throw null;
    }

    static /* bridge */ /* synthetic */ Method findMethod$default(JDIEval jDIEval, MethodDescription methodDescription, ReferenceType referenceType, int n, Object object) {
        if ((n & 2) != 0) {
            referenceType = JDIEval.asReferenceType$default(jDIEval, MembersKt.getOwnerType(methodDescription), null, 1, null);
        }
        return jDIEval.findMethod(methodDescription, referenceType);
    }

    @Override
    @NotNull
    public Value invokeStaticMethod(@NotNull MethodDescription methodDesc, @NotNull List<? extends Value> arguments2) {
        Intrinsics.checkParameterIsNotNull((Object)methodDesc, (String)"methodDesc");
        Intrinsics.checkParameterIsNotNull(arguments2, (String)"arguments");
        Method method = JDIEval.findMethod$default(this, methodDesc, null, 2, null);
        if (!method.isStatic()) {
            Void void_ = ValuesKt.throwBrokenCodeException(new NoSuchMethodError("Method is not static: " + methodDesc));
            throw null;
        }
        ReferenceType _class = method.declaringType();
        if (!(_class instanceof ClassType)) {
            Void void_ = ValuesKt.throwBrokenCodeException(new NoSuchMethodError("Static method is a non-class type: " + method));
            throw null;
        }
        List<com.sun.jdi.Value> args = this.mapArguments(arguments2, this.safeArgumentTypes(method));
        if (this.shouldInvokeMethodWithReflection(method, args)) {
            return this.invokeMethodWithReflection(JdiValuesKt.asType(_class), ValuesKt.getNULL_VALUE(), args, methodDesc);
        }
        this.disableCollection(args);
        com.sun.jdi.Value result2 = (com.sun.jdi.Value)JdiEvalKt.ifFail$default(JdiEvalKt.access$mayThrow((Function0)new Function0<com.sun.jdi.Value>(this, _class, method, args){
            final /* synthetic */ JDIEval this$0;
            final /* synthetic */ ReferenceType $_class;
            final /* synthetic */ Method $method;
            final /* synthetic */ List $args;

            public final com.sun.jdi.Value invoke() {
                return ((ClassType)this.$_class).invokeMethod(JDIEval.access$getThread$p(this.this$0), this.$method, this.$args, JDIEval.access$getInvokePolicy$p(this.this$0));
            }
            {
                this.this$0 = jDIEval;
                this.$_class = referenceType;
                this.$method = method;
                this.$args = list2;
                super(0);
            }
        }), method, null, 2, null);
        this.enableCollection(args);
        return JdiValuesKt.asValue(result2);
    }

    @Override
    @NotNull
    public Value getField(@NotNull Value instance, @NotNull FieldDescription fieldDesc) {
        Intrinsics.checkParameterIsNotNull((Object)instance, (String)"instance");
        Intrinsics.checkParameterIsNotNull((Object)fieldDesc, (String)"fieldDesc");
        Field field2 = this.findField(fieldDesc);
        ObjectReference obj = ValuesKt.checkNull(JdiValuesKt.getJdiObj(instance));
        return JdiValuesKt.asValue((com.sun.jdi.Value)JdiEvalKt.access$ifFail(JdiEvalKt.access$mayThrow((Function0)new Function0<com.sun.jdi.Value>(obj, field2){
            final /* synthetic */ ObjectReference $obj;
            final /* synthetic */ Field $field;

            public final com.sun.jdi.Value invoke() {
                return this.$obj.getValue(this.$field);
            }
            {
                this.$obj = objectReference;
                this.$field = field2;
                super(0);
            }
        }), field2, obj));
    }

    @Override
    public void setField(@NotNull Value instance, @NotNull FieldDescription fieldDesc, @NotNull Value newValue) {
        Intrinsics.checkParameterIsNotNull((Object)instance, (String)"instance");
        Intrinsics.checkParameterIsNotNull((Object)fieldDesc, (String)"fieldDesc");
        Intrinsics.checkParameterIsNotNull((Object)newValue, (String)"newValue");
        Field field2 = this.findField(fieldDesc);
        ObjectReference obj = ValuesKt.checkNull(JdiValuesKt.getJdiObj(instance));
        com.sun.jdi.Type type2 = field2.type();
        Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"field.type()");
        com.sun.jdi.Value jdiValue = JdiValuesKt.asJdiValue(newValue, this.vm, JdiValuesKt.asType(type2));
        JdiEvalKt.access$mayThrow((Function0)new Function0<Unit>(obj, field2, jdiValue){
            final /* synthetic */ ObjectReference $obj;
            final /* synthetic */ Field $field;
            final /* synthetic */ com.sun.jdi.Value $jdiValue;

            public final void invoke() {
                this.$obj.setValue(this.$field, this.$jdiValue);
            }
            {
                this.$obj = objectReference;
                this.$field = field2;
                this.$jdiValue = value2;
                super(0);
            }
        });
    }

    @NotNull
    public final Value unboxType(@NotNull Value boxedValue, @NotNull Type type2) {
        MethodDescription methodDescription;
        Intrinsics.checkParameterIsNotNull((Object)boxedValue, (String)"boxedValue");
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        Type type3 = type2;
        if (Intrinsics.areEqual((Object)type3, (Object)Type.INT_TYPE)) {
            methodDescription = new MethodDescription("java/lang/Integer", "intValue", "()I", false);
        } else if (Intrinsics.areEqual((Object)type3, (Object)Type.BOOLEAN_TYPE)) {
            methodDescription = new MethodDescription("java/lang/Boolean", "booleanValue", "()Z", false);
        } else if (Intrinsics.areEqual((Object)type3, (Object)Type.CHAR_TYPE)) {
            methodDescription = new MethodDescription("java/lang/Character", "charValue", "()C", false);
        } else if (Intrinsics.areEqual((Object)type3, (Object)Type.SHORT_TYPE)) {
            methodDescription = new MethodDescription("java/lang/Character", "shortValue", "()S", false);
        } else if (Intrinsics.areEqual((Object)type3, (Object)Type.LONG_TYPE)) {
            methodDescription = new MethodDescription("java/lang/Long", "longValue", "()J", false);
        } else if (Intrinsics.areEqual((Object)type3, (Object)Type.BYTE_TYPE)) {
            methodDescription = new MethodDescription("java/lang/Byte", "byteValue", "()B", false);
        } else if (Intrinsics.areEqual((Object)type3, (Object)Type.FLOAT_TYPE)) {
            methodDescription = new MethodDescription("java/lang/Float", "floatValue", "()F", false);
        } else if (Intrinsics.areEqual((Object)type3, (Object)Type.DOUBLE_TYPE)) {
            methodDescription = new MethodDescription("java/lang/Double", "doubleValue", "()D", false);
        } else {
            throw (Throwable)new UnsupportedOperationException("Couldn't unbox non primitive type " + type2.getInternalName());
        }
        MethodDescription method = methodDescription;
        return this.invokeMethod(boxedValue, method, CollectionsKt.emptyList(), true);
    }

    @NotNull
    public final Value boxType(@NotNull Value value2) {
        MethodDescription methodDescription;
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        Type type2 = value2.getAsmType();
        if (Intrinsics.areEqual((Object)type2, (Object)Type.INT_TYPE)) {
            methodDescription = new MethodDescription("java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
        } else if (Intrinsics.areEqual((Object)type2, (Object)Type.BYTE_TYPE)) {
            methodDescription = new MethodDescription("java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;", false);
        } else if (Intrinsics.areEqual((Object)type2, (Object)Type.SHORT_TYPE)) {
            methodDescription = new MethodDescription("java/lang/Short", "valueOf", "(S)Ljava/lang/Short;", false);
        } else if (Intrinsics.areEqual((Object)type2, (Object)Type.LONG_TYPE)) {
            methodDescription = new MethodDescription("java/lang/Long", "valueOf", "(J)Ljava/lang/Long;", false);
        } else if (Intrinsics.areEqual((Object)type2, (Object)Type.BOOLEAN_TYPE)) {
            methodDescription = new MethodDescription("java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;", false);
        } else if (Intrinsics.areEqual((Object)type2, (Object)Type.CHAR_TYPE)) {
            methodDescription = new MethodDescription("java/lang/Character", "valueOf", "(C)Ljava/lang/Character;", false);
        } else if (Intrinsics.areEqual((Object)type2, (Object)Type.FLOAT_TYPE)) {
            methodDescription = new MethodDescription("java/lang/Float", "valueOf", "(F)Ljava/lang/Float;", false);
        } else if (Intrinsics.areEqual((Object)type2, (Object)Type.DOUBLE_TYPE)) {
            methodDescription = new MethodDescription("java/lang/Double", "valueOf", "(D)Ljava/lang/Double;", false);
        } else {
            throw (Throwable)new UnsupportedOperationException("Couldn't box non primitive type " + value2.getAsmType().getInternalName());
        }
        MethodDescription method = methodDescription;
        return this.invokeStaticMethod(method, CollectionsKt.listOf((Object)value2));
    }

    @Override
    @NotNull
    public Value invokeMethod(@NotNull Value instance, @NotNull MethodDescription methodDesc, @NotNull List<? extends Value> arguments2, boolean invokespecial) {
        Value value2;
        Intrinsics.checkParameterIsNotNull((Object)instance, (String)"instance");
        Intrinsics.checkParameterIsNotNull((Object)methodDesc, (String)"methodDesc");
        Intrinsics.checkParameterIsNotNull(arguments2, (String)"arguments");
        if (invokespecial && Intrinsics.areEqual((Object)methodDesc.getName(), (Object)"<init>")) {
            Method ctor = JDIEval.findMethod$default(this, methodDesc, null, 2, null);
            ReferenceType referenceType = JDIEval.asReferenceType$default(this, ((NewObjectValue)instance).getAsmType(), null, 1, null);
            if (referenceType == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.sun.jdi.ClassType");
            }
            ClassType _class = (ClassType)referenceType;
            List<com.sun.jdi.Value> args = this.mapArguments(arguments2, this.safeArgumentTypes(ctor));
            this.disableCollection(args);
            ObjectReference result2 = (ObjectReference)JdiEvalKt.ifFail$default(JdiEvalKt.access$mayThrow((Function0)new Function0<ObjectReference>(this, _class, ctor, args){
                final /* synthetic */ JDIEval this$0;
                final /* synthetic */ ClassType $_class;
                final /* synthetic */ Method $ctor;
                final /* synthetic */ List $args;

                public final ObjectReference invoke() {
                    return this.$_class.newInstance(JDIEval.access$getThread$p(this.this$0), this.$ctor, this.$args, JDIEval.access$getInvokePolicy$p(this.this$0));
                }
                {
                    this.this$0 = jDIEval;
                    this.$_class = classType;
                    this.$ctor = method;
                    this.$args = list2;
                    super(0);
                }
            }), ctor, null, 2, null);
            this.enableCollection(args);
            ((NewObjectValue)instance).setValue(result2);
            return JdiValuesKt.asValue(result2);
        }
        Function3<ObjectReference, Method, Integer, Value> doInvokeMethod$ = new Function3<ObjectReference, Method, Integer, Value>(this, arguments2, instance, methodDesc){
            final /* synthetic */ JDIEval this$0;
            final /* synthetic */ List $arguments;
            final /* synthetic */ Value $instance;
            final /* synthetic */ MethodDescription $methodDesc;

            @NotNull
            public final Value invoke(@NotNull ObjectReference obj, @NotNull Method method, int policy) {
                Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
                Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
                List args = JDIEval.access$mapArguments(this.this$0, this.$arguments, JDIEval.access$safeArgumentTypes(this.this$0, method));
                if (JDIEval.access$shouldInvokeMethodWithReflection(this.this$0, method, args)) {
                    return JDIEval.access$invokeMethodWithReflection(this.this$0, this.$instance.getAsmType(), this.$instance, args, this.$methodDesc);
                }
                JDIEval.access$disableCollection(this.this$0, args);
                com.sun.jdi.Value result2 = (com.sun.jdi.Value)JdiEvalKt.access$ifFail(JdiEvalKt.access$mayThrow((Function0)new Function0<com.sun.jdi.Value>(this, obj, method, args, policy){
                    final /* synthetic */ invokeMethod.1 this$0;
                    final /* synthetic */ ObjectReference $obj;
                    final /* synthetic */ Method $method;
                    final /* synthetic */ List $args;
                    final /* synthetic */ int $policy;

                    public final com.sun.jdi.Value invoke() {
                        return this.$obj.invokeMethod(JDIEval.access$getThread$p(this.this$0.this$0), this.$method, this.$args, this.$policy);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$obj = objectReference;
                        this.$method = method;
                        this.$args = list2;
                        this.$policy = n;
                        super(0);
                    }
                }), method, obj);
                JDIEval.access$enableCollection(this.this$0, args);
                return JdiValuesKt.asValue(result2);
            }
            {
                this.this$0 = jDIEval;
                this.$arguments = list2;
                this.$instance = value2;
                this.$methodDesc = methodDescription;
                super(3);
            }
        };
        ObjectReference obj = ValuesKt.checkNull(JdiValuesKt.getJdiObj(instance));
        if (invokespecial) {
            Method method = JDIEval.findMethod$default(this, methodDesc, null, 2, null);
            value2 = doInvokeMethod$.invoke(obj, method, this.invokePolicy | 2);
        } else {
            ReferenceType referenceType = obj.referenceType();
            if (referenceType == null) {
                referenceType = JDIEval.asReferenceType$default(this, MembersKt.getOwnerType(methodDesc), null, 1, null);
            }
            Method method = this.findMethod(methodDesc, referenceType);
            value2 = doInvokeMethod$.invoke(obj, method, this.invokePolicy);
        }
        return value2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldInvokeMethodWithReflection(Method method, List<? extends com.sun.jdi.Value> args) {
        Pair it;
        com.sun.jdi.Value value2;
        if (method.isVarArgs()) return false;
        Iterable iterable = args;
        List<com.sun.jdi.Type> list2 = method.argumentTypes();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"method.argumentTypes()");
        Iterable $receiver$iv = CollectionsKt.zip((Iterable)iterable, (Iterable)list2);
        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $receiver$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            it = (Pair)element$iv;
            value2 = (com.sun.jdi.Value)it.getFirst();
        } while (!this.isArrayOfInterfaces(value2 != null ? value2.type() : null, (com.sun.jdi.Type)it.getSecond()));
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isArrayOfInterfaces(com.sun.jdi.Type valueType, com.sun.jdi.Type expectedType2) {
        com.sun.jdi.Type type2 = valueType;
        if (!(type2 instanceof ArrayType)) {
            type2 = null;
        }
        ArrayType arrayType = (ArrayType)type2;
        if (!((arrayType != null ? arrayType.componentType() : null) instanceof InterfaceType)) return false;
        com.sun.jdi.Type type3 = expectedType2;
        if (!(type3 instanceof ArrayType)) {
            type3 = null;
        }
        ArrayType arrayType2 = (ArrayType)type3;
        com.sun.jdi.Type type4 = arrayType2 != null ? arrayType2.componentType() : null;
        Type type5 = JdiEvalKt.access$getOBJECT$p();
        Intrinsics.checkExpressionValueIsNotNull((Object)type5, (String)"OBJECT");
        if (!Intrinsics.areEqual((Object)type4, (Object)JDIEval.asReferenceType$default(this, type5, null, 1, null))) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final Value invokeMethodWithReflection(Type ownerType, Value instance, List<? extends com.sun.jdi.Value> args, MethodDescription methodDesc) {
        void $receiver$iv$iv;
        Collection<Value> $receiver$iv;
        Value value2;
        Collection<Value> collection;
        void $receiver$iv$iv2;
        Collection $receiver$iv2;
        Value value3 = this.loadClass(ownerType);
        Type type2 = JdiEvalKt.access$getCLASS$p();
        Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"CLASS");
        String string = type2.getInternalName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"CLASS.internalName");
        StringBuilder stringBuilder = new StringBuilder().append("(Ljava/lang/String;[L");
        Type type3 = JdiEvalKt.access$getCLASS$p();
        Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"CLASS");
        MethodDescription methodDescription = new MethodDescription(string, "getDeclaredMethod", stringBuilder.append(type3.getInternalName()).append(";)Ljava/lang/reflect/Method;").toString(), true);
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.add((Object)JdiValuesKt.asValue(this.vm.mirrorOf(methodDesc.getName())));
        Iterable iterable = MembersKt.getParameterTypes(methodDesc);
        SpreadBuilder spreadBuilder2 = spreadBuilder;
        SpreadBuilder spreadBuilder3 = spreadBuilder;
        MethodDescription methodDescription2 = methodDescription;
        Value value4 = value3;
        JDIEval jDIEval = this;
        void var7_11 = $receiver$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            void it;
            Type type4 = (Type)item$iv$iv;
            collection = destination$iv$iv;
            value2 = this.loadClass((Type)it);
            collection.add(value2);
        }
        collection = (List)destination$iv$iv;
        SpreadBuilder spreadBuilder4 = spreadBuilder3;
        $receiver$iv2 = collection;
        Iterable thisCollection$iv = $receiver$iv2;
        Value[] valueArray = thisCollection$iv.toArray(new Value[thisCollection$iv.size()]);
        if (valueArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        spreadBuilder2.addSpread((Object)valueArray);
        Value methodToInvoke = Eval.DefaultImpls.invokeMethod$default(jDIEval, value4, methodDescription2, CollectionsKt.listOf((Object[])((Value[])spreadBuilder4.toArray((Object[])new Value[spreadBuilder4.size()]))), false, 8, null);
        Type type5 = Type.getType(AccessibleObject.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)type5, (String)"Type.getType(AccessibleObject::class.java)");
        String string2 = type5.getInternalName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Type.getType(AccessibleO\u2026:class.java).internalName");
        Eval.DefaultImpls.invokeMethod$default(this, methodToInvoke, new MethodDescription(string2, "setAccessible", "(Z)V", true), CollectionsKt.listOf((Object)JdiValuesKt.asValue(this.vm.mirrorOf(true))), false, 8, null);
        String string3 = methodToInvoke.getAsmType().getInternalName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"methodToInvoke.asmType.internalName");
        StringBuilder stringBuilder2 = new StringBuilder().append("(L");
        Type type6 = JdiEvalKt.access$getOBJECT$p();
        Intrinsics.checkExpressionValueIsNotNull((Object)type6, (String)"OBJECT");
        StringBuilder stringBuilder3 = stringBuilder2.append(type6.getInternalName()).append(";[L");
        Type type7 = JdiEvalKt.access$getOBJECT$p();
        Intrinsics.checkExpressionValueIsNotNull((Object)type7, (String)"OBJECT");
        StringBuilder stringBuilder4 = stringBuilder3.append(type7.getInternalName()).append(";)L");
        Type type8 = JdiEvalKt.access$getOBJECT$p();
        Intrinsics.checkExpressionValueIsNotNull((Object)type8, (String)"OBJECT");
        MethodDescription methodDescription3 = new MethodDescription(string3, "invoke", stringBuilder4.append(type8.getInternalName()).append(';').toString(), true);
        SpreadBuilder spreadBuilder5 = new SpreadBuilder(2);
        spreadBuilder5.add((Object)instance);
        thisCollection$iv = args;
        spreadBuilder2 = spreadBuilder5;
        spreadBuilder3 = spreadBuilder5;
        methodDescription2 = methodDescription3;
        value4 = methodToInvoke;
        jDIEval = this;
        void $i$f$toTypedArray = $receiver$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            com.sun.jdi.Value $i$a$1$map = (com.sun.jdi.Value)item$iv$iv;
            collection = destination$iv$iv2;
            value2 = JdiValuesKt.asValue((com.sun.jdi.Value)it);
            collection.add(value2);
        }
        collection = (List)destination$iv$iv2;
        SpreadBuilder spreadBuilder6 = spreadBuilder3;
        $receiver$iv = collection;
        Collection<Value> thisCollection$iv2 = $receiver$iv;
        Value[] valueArray2 = thisCollection$iv2.toArray(new Value[thisCollection$iv2.size()]);
        if (valueArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        spreadBuilder2.addSpread((Object)valueArray2);
        Value invocationResult = Eval.DefaultImpls.invokeMethod$default(jDIEval, value4, methodDescription2, CollectionsKt.listOf((Object[])((Value[])spreadBuilder6.toArray((Object[])new Value[spreadBuilder6.size()]))), false, 8, null);
        if (MembersKt.getReturnType(methodDesc).getSort() != 10 && MembersKt.getReturnType(methodDesc).getSort() != 9 && MembersKt.getReturnType(methodDesc).getSort() != 0) {
            return this.unboxType(invocationResult, MembersKt.getReturnType(methodDesc));
        }
        return invocationResult;
    }

    private final void disableCollection(@NotNull List<? extends com.sun.jdi.Value> $receiver) {
        Iterable $receiver$iv = $receiver;
        for (Object element$iv : $receiver$iv) {
            com.sun.jdi.Value it = (com.sun.jdi.Value)element$iv;
            com.sun.jdi.Value value2 = it;
            if (!(value2 instanceof ObjectReference)) {
                value2 = null;
            }
            ObjectReference objectReference = (ObjectReference)value2;
            if (objectReference == null) continue;
            objectReference.disableCollection();
        }
    }

    private final void enableCollection(@NotNull List<? extends com.sun.jdi.Value> $receiver) {
        Iterable $receiver$iv = $receiver;
        for (Object element$iv : $receiver$iv) {
            com.sun.jdi.Value it = (com.sun.jdi.Value)element$iv;
            com.sun.jdi.Value value2 = it;
            if (!(value2 instanceof ObjectReference)) {
                value2 = null;
            }
            ObjectReference objectReference = (ObjectReference)value2;
            if (objectReference == null) continue;
            objectReference.enableCollection();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<com.sun.jdi.Value> mapArguments(List<? extends Value> arguments2, List<? extends com.sun.jdi.Type> expecetedTypes) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)CollectionsKt.zip((Iterable)arguments2, (Iterable)expecetedTypes);
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void arg;
            void it;
            Pair pair2 = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            void var9_9 = it;
            Value value2 = (Value)var9_9.component1();
            com.sun.jdi.Type expectedType2 = (com.sun.jdi.Type)var9_9.component2();
            com.sun.jdi.Value value3 = JdiValuesKt.asJdiValue((Value)arg, this.vm, JdiValuesKt.asType(expectedType2));
            collection.add(value3);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<com.sun.jdi.Type> safeArgumentTypes(@NotNull Method $receiver) {
        try {
            List<com.sun.jdi.Type> list2 = $receiver.argumentTypes();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"argumentTypes()");
            return list2;
        }
        catch (ClassNotLoadedException e) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            List<String> list3 = $receiver.argumentTypeNames();
            if (list3 == null) {
                Intrinsics.throwNpe();
            }
            Iterable iterable = $receiver$iv = (Iterable)list3;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                com.sun.jdi.Type type2;
                com.sun.jdi.Type baseType;
                com.sun.jdi.Type type3;
                void baseTypeName;
                String string;
                int n;
                void name2;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                void v2 = name2;
                Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"name");
                CharSequence $receiver$iv2 = (CharSequence)v2;
                int count$iv2 = 0;
                CharSequence charSequence = $receiver$iv2;
                for (n = 0; n < charSequence.length(); ++n) {
                    char element$iv = charSequence.charAt(n);
                    char it = element$iv;
                    if (!(it == '[')) continue;
                    ++count$iv2;
                }
                int dimensions = count$iv2;
                if (dimensions > 0) {
                    void count$iv2 = name2;
                    int n2 = 0;
                    n = StringsKt.indexOf$default((CharSequence)((CharSequence)name2), (char)'[', (int)0, (boolean)false, (int)6, null);
                    String string3 = count$iv2.substring(n2, n);
                    string = string3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                } else {
                    string = baseTypeName = name2;
                }
                if ((type3 = this.primitiveTypes.get(baseTypeName)) == null) {
                    Type type4 = Type.getType((String)('L' + (String)baseTypeName + ';'));
                    Intrinsics.checkExpressionValueIsNotNull((Object)type4, (String)"Type.getType(\"L$baseTypeName;\")");
                    type3 = baseType = (com.sun.jdi.Type)this.asReferenceType(type4, $receiver.declaringType().classLoader());
                }
                if (dimensions == 0) {
                    type2 = baseType;
                } else {
                    Type type5 = Type.getType((String)(StringsKt.repeat((CharSequence)"[", (int)dimensions) + JdiValuesKt.asType(baseType).getDescriptor()));
                    Intrinsics.checkExpressionValueIsNotNull((Object)type5, (String)"Type.getType(\"[\".repeat(\u2026Type.asType().descriptor)");
                    type2 = this.asReferenceType(type5, $receiver.declaringType().classLoader());
                }
                com.sun.jdi.Type type6 = type2;
                collection.add(type6);
            }
            return (List)destination$iv$iv;
        }
    }

    public JDIEval(@NotNull VirtualMachine vm, @Nullable ClassLoaderReference defaultClassLoader, @NotNull ThreadReference thread, int invokePolicy) {
        Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
        Intrinsics.checkParameterIsNotNull((Object)thread, (String)"thread");
        this.vm = vm;
        this.defaultClassLoader = defaultClassLoader;
        this.thread = thread;
        this.invokePolicy = invokePolicy;
        Pair[] pairArray = new Pair[8];
        Type type2 = Type.BOOLEAN_TYPE;
        Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"Type.BOOLEAN_TYPE");
        pairArray[0] = TuplesKt.to((Object)type2.getClassName(), (Object)this.vm.mirrorOf(true).type());
        Type type3 = Type.BYTE_TYPE;
        Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"Type.BYTE_TYPE");
        pairArray[1] = TuplesKt.to((Object)type3.getClassName(), (Object)this.vm.mirrorOf((byte)1).type());
        Type type4 = Type.SHORT_TYPE;
        Intrinsics.checkExpressionValueIsNotNull((Object)type4, (String)"Type.SHORT_TYPE");
        pairArray[2] = TuplesKt.to((Object)type4.getClassName(), (Object)this.vm.mirrorOf((short)1).type());
        Type type5 = Type.INT_TYPE;
        Intrinsics.checkExpressionValueIsNotNull((Object)type5, (String)"Type.INT_TYPE");
        pairArray[3] = TuplesKt.to((Object)type5.getClassName(), (Object)this.vm.mirrorOf(1).type());
        Type type6 = Type.CHAR_TYPE;
        Intrinsics.checkExpressionValueIsNotNull((Object)type6, (String)"Type.CHAR_TYPE");
        pairArray[4] = TuplesKt.to((Object)type6.getClassName(), (Object)this.vm.mirrorOf('1').type());
        Type type7 = Type.LONG_TYPE;
        Intrinsics.checkExpressionValueIsNotNull((Object)type7, (String)"Type.LONG_TYPE");
        pairArray[5] = TuplesKt.to((Object)type7.getClassName(), (Object)this.vm.mirrorOf(1L).type());
        Type type8 = Type.FLOAT_TYPE;
        Intrinsics.checkExpressionValueIsNotNull((Object)type8, (String)"Type.FLOAT_TYPE");
        pairArray[6] = TuplesKt.to((Object)type8.getClassName(), (Object)this.vm.mirrorOf(1.0f).type());
        Type type9 = Type.DOUBLE_TYPE;
        Intrinsics.checkExpressionValueIsNotNull((Object)type9, (String)"Type.DOUBLE_TYPE");
        pairArray[7] = TuplesKt.to((Object)type9.getClassName(), (Object)this.vm.mirrorOf(1.0).type());
        this.primitiveTypes = MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public static final /* synthetic */ ThreadReference access$getThread$p(JDIEval $this) {
        return $this.thread;
    }

    public static final /* synthetic */ int access$getInvokePolicy$p(JDIEval $this) {
        return $this.invokePolicy;
    }

    @NotNull
    public static final /* synthetic */ List access$mapArguments(JDIEval $this, @NotNull List arguments2, @NotNull List expecetedTypes) {
        return $this.mapArguments(arguments2, expecetedTypes);
    }

    @NotNull
    public static final /* synthetic */ List access$safeArgumentTypes(JDIEval $this, @NotNull Method $receiver) {
        return $this.safeArgumentTypes($receiver);
    }

    public static final /* synthetic */ boolean access$shouldInvokeMethodWithReflection(JDIEval $this, @NotNull Method method, @NotNull List args) {
        return $this.shouldInvokeMethodWithReflection(method, args);
    }

    @NotNull
    public static final /* synthetic */ Value access$invokeMethodWithReflection(JDIEval $this, @NotNull Type ownerType, @NotNull Value instance, @NotNull List args, @NotNull MethodDescription methodDesc) {
        return $this.invokeMethodWithReflection(ownerType, instance, args, methodDesc);
    }

    public static final /* synthetic */ void access$disableCollection(JDIEval $this, @NotNull List $receiver) {
        $this.disableCollection($receiver);
    }

    public static final /* synthetic */ void access$enableCollection(JDIEval $this, @NotNull List $receiver) {
        $this.enableCollection($receiver);
    }
}

