/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor;

import com.intellij.lang.ASTNode;
import com.intellij.lang.SmartEnterProcessorWithFixers;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.CharArrayUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.editor.KotlinSmartEnterHandlerKt;
import org.jetbrains.kotlin.idea.editor.fixers.FixersUtilKt;
import org.jetbrains.kotlin.idea.editor.fixers.KotlinCatchBodyFixer;
import org.jetbrains.kotlin.idea.editor.fixers.KotlinCatchParameterFixer;
import org.jetbrains.kotlin.idea.editor.fixers.KotlinClassBodyFixer;
import org.jetbrains.kotlin.idea.editor.fixers.KotlinClassInitializerFixer;
import org.jetbrains.kotlin.idea.editor.fixers.KotlinDoWhileFixer;
import org.jetbrains.kotlin.idea.editor.fixers.KotlinFinallyBodyFixer;
import org.jetbrains.kotlin.idea.editor.fixers.KotlinForConditionFixer;
import org.jetbrains.kotlin.idea.editor.fixers.KotlinFunctionDeclarationBodyFixer;
import org.jetbrains.kotlin.idea.editor.fixers.KotlinFunctionParametersFixer;
import org.jetbrains.kotlin.idea.editor.fixers.KotlinIfConditionFixer;
import org.jetbrains.kotlin.idea.editor.fixers.KotlinLastLambdaParameterFixer;
import org.jetbrains.kotlin.idea.editor.fixers.KotlinMissingForOrWhileBodyFixer;
import org.jetbrains.kotlin.idea.editor.fixers.KotlinMissingIfBranchFixer;
import org.jetbrains.kotlin.idea.editor.fixers.KotlinMissingWhenBodyFixer;
import org.jetbrains.kotlin.idea.editor.fixers.KotlinPropertySetterBodyFixer;
import org.jetbrains.kotlin.idea.editor.fixers.KotlinPropertySetterParametersFixer;
import org.jetbrains.kotlin.idea.editor.fixers.KotlinTryBodyFixer;
import org.jetbrains.kotlin.idea.editor.fixers.KotlinWhenSubjectCaretFixer;
import org.jetbrains.kotlin.idea.editor.fixers.KotlinWhileConditionFixer;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtParameter;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0014J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\bH\u0014J\f\u0010\f\u001a\u00020\r*\u00020\u0004H\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/editor/KotlinSmartEnterHandler;", "Lcom/intellij/lang/SmartEnterProcessorWithFixers;", "()V", "getStatementAtCaret", "Lcom/intellij/psi/PsiElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "psiFile", "Lcom/intellij/psi/PsiFile;", "moveCaretInsideBracesIfAny", "", "file", "isKotlinStatement", "", "KotlinPlainEnterProcessor", "idea"})
public final class KotlinSmartEnterHandler
extends SmartEnterProcessorWithFixers {
    @Nullable
    protected PsiElement getStatementAtCaret(@Nullable Editor editor, @Nullable PsiFile psiFile) {
        PsiElement atCaret = super.getStatementAtCaret(editor, psiFile);
        if (atCaret instanceof PsiWhiteSpace) {
            return null;
        }
        while (atCaret != null) {
            PsiElement declaration2;
            if (this.isKotlinStatement(atCaret)) {
                return atCaret;
            }
            if (atCaret.getParent() instanceof KtFunctionLiteral) {
                return atCaret;
            }
            if (atCaret instanceof KtDeclaration && (!((declaration2 = atCaret) instanceof KtParameter) || KotlinSmartEnterHandlerKt.access$isInLambdaExpression((KtParameter)declaration2)) && !(((KtDeclaration)declaration2).getParent() instanceof KtForExpression)) {
                return atCaret;
            }
            atCaret = atCaret.getParent();
        }
        return null;
    }

    protected void moveCaretInsideBracesIfAny(@NotNull Editor editor, @NotNull PsiFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        CaretModel caretModel = editor.getCaretModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.caretModel");
        int caretOffset = caretModel.getOffset();
        Document document = editor.getDocument();
        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"editor.document");
        CharSequence chars = document.getCharsSequence();
        if (CharArrayUtil.regionMatches((CharSequence)chars, (int)caretOffset, (CharSequence)"{}")) {
            caretOffset += 2;
        } else if (CharArrayUtil.regionMatches((CharSequence)chars, (int)caretOffset, (CharSequence)"{\n}")) {
            caretOffset += 3;
        }
        caretOffset = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(caretOffset - 1), (String)" \t") + 1;
        if (CharArrayUtil.regionMatches((CharSequence)chars, (int)(caretOffset - "{}".length()), (CharSequence)"{}") || CharArrayUtil.regionMatches((CharSequence)chars, (int)(caretOffset - "{\n}".length()), (CharSequence)"{\n}")) {
            this.commit(editor);
            CodeStyleSettings settings2 = CodeStyleSettingsManager.getSettings((Project)file2.getProject());
            boolean old = settings2.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE;
            settings2.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE = false;
            PsiElement psiElement2 = file2.findElementAt(caretOffset - 1);
            if (psiElement2 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"file.findElementAt(caretOffset - 1)!!");
            PsiElement $receiver$iv = psiElement2;
            KtBlockExpression elt = (KtBlockExpression)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtBlockExpression.class, (boolean)true);
            if (elt != null) {
                this.reformat((PsiElement)elt);
            }
            settings2.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE = old;
            editor.getCaretModel().moveToOffset(caretOffset - 1);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isKotlinStatement(@NotNull PsiElement $receiver) {
        PsiElement psiElement2;
        if ($receiver.getParent() instanceof KtBlockExpression) {
            ASTNode aSTNode = $receiver.getNode();
            if (!KotlinSmartEnterHandlerKt.access$getBRACES$p().contains((IElementType)(aSTNode != null ? aSTNode.getElementType() : null))) {
                return true;
            }
        }
        if (!KotlinSmartEnterHandlerKt.access$getBRANCH_CONTAINERS$p().contains((psiElement2 = $receiver.getParent()) != null && (psiElement2 = psiElement2.getNode()) != null ? psiElement2.getElementType() : null)) return false;
        if ($receiver instanceof KtBlockExpression) return false;
        return true;
    }

    public KotlinSmartEnterHandler() {
        this.addFixers(new SmartEnterProcessorWithFixers.Fixer[]{new KotlinIfConditionFixer(), new KotlinMissingIfBranchFixer(), new KotlinWhileConditionFixer(), new KotlinForConditionFixer(), new KotlinMissingForOrWhileBodyFixer(), new KotlinWhenSubjectCaretFixer(), new KotlinMissingWhenBodyFixer(), new KotlinDoWhileFixer(), new KotlinFunctionParametersFixer(), new KotlinFunctionDeclarationBodyFixer(), new KotlinPropertySetterParametersFixer(), new KotlinPropertySetterBodyFixer(), new KotlinTryBodyFixer(), new KotlinCatchParameterFixer(), new KotlinCatchBodyFixer(), new KotlinFinallyBodyFixer(), new KotlinLastLambdaParameterFixer(), new KotlinClassInitializerFixer(), new KotlinClassBodyFixer()});
        this.addEnterProcessors(new SmartEnterProcessorWithFixers.FixEnterProcessor[]{new KotlinPlainEnterProcessor()});
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0016J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0006H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/editor/KotlinSmartEnterHandler$KotlinPlainEnterProcessor;", "Lcom/intellij/lang/SmartEnterProcessorWithFixers$FixEnterProcessor;", "()V", "doEnter", "", "atCaret", "Lcom/intellij/psi/PsiElement;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "modified", "getControlStatementBlock", "Lorg/jetbrains/kotlin/psi/KtExpression;", "caret", "", "element", "idea"})
    public static final class KotlinPlainEnterProcessor
    extends SmartEnterProcessorWithFixers.FixEnterProcessor {
        private final KtExpression getControlStatementBlock(int caret, PsiElement element3) {
            PsiElement psiElement2 = element3;
            if (psiElement2 instanceof KtDeclarationWithBody) {
                return ((KtDeclarationWithBody)element3).getBodyExpression();
            }
            if (psiElement2 instanceof KtIfExpression) {
                if (FixersUtilKt.isWithCaret((PsiElement)((KtIfExpression)element3).getThen(), caret)) {
                    return ((KtIfExpression)element3).getThen();
                }
                if (FixersUtilKt.isWithCaret((PsiElement)((KtIfExpression)element3).getElse(), caret)) {
                    return ((KtIfExpression)element3).getElse();
                }
            } else if (psiElement2 instanceof KtLoopExpression) {
                return ((KtLoopExpression)element3).getBody();
            }
            return null;
        }

        public boolean doEnter(@NotNull PsiElement atCaret, @Nullable PsiFile file2, @NotNull Editor editor, boolean modified) {
            KtBlockExpression block;
            Intrinsics.checkParameterIsNotNull((Object)atCaret, (String)"atCaret");
            Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
            CaretModel caretModel = editor.getCaretModel();
            Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.caretModel");
            KtExpression ktExpression = this.getControlStatementBlock(caretModel.getOffset(), atCaret);
            if (!(ktExpression instanceof KtBlockExpression)) {
                ktExpression = null;
            }
            if ((block = (KtBlockExpression)ktExpression) != null) {
                int n;
                PsiElement firstElement;
                PsiElement psiElement2 = block.getFirstChild();
                Object object = firstElement = psiElement2 != null ? psiElement2.getNextSibling() : null;
                if (firstElement != null) {
                    TextRange textRange = firstElement.getTextRange();
                    if (textRange == null) {
                        Intrinsics.throwNpe();
                    }
                    n = textRange.getStartOffset() - 1;
                } else {
                    TextRange textRange = block.getTextRange();
                    if (textRange == null) {
                        Intrinsics.throwNpe();
                    }
                    n = textRange.getEndOffset();
                }
                int offset2 = n;
                editor.getCaretModel().moveToOffset(offset2);
            }
            this.plainEnter(editor);
            return true;
        }
    }
}

