/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.icons.AllIcons;
import java.net.URL;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.TypeMismatchDueToTypeProjectionsData;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticFactoryToRendererMap;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.IncompatibleExpectedActualClassScopesRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.LanguageFeatureMessageRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.MultiRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.PlatformIncompatibilityDiagnosticRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.Renderers;
import org.jetbrains.kotlin.diagnostics.rendering.RenderingContext;
import org.jetbrains.kotlin.diagnostics.rendering.TabledDescriptorRenderer;
import org.jetbrains.kotlin.idea.highlighter.HtmlTabledDescriptorRenderer;
import org.jetbrains.kotlin.idea.highlighter.IdeMultiplatformDiagnosticRenderingMode;
import org.jetbrains.kotlin.idea.highlighter.IdeRenderers;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.js.resolve.diagnostics.JsCallDataHtmlRenderer;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

public class IdeErrorMessages {
    private static final DiagnosticFactoryToRendererMap MAP = new DiagnosticFactoryToRendererMap("IDE");

    @NotNull
    public static String render(@NotNull Diagnostic diagnostic) {
        DiagnosticRenderer<?> renderer2 = MAP.get(diagnostic.getFactory());
        if (renderer2 != null) {
            return renderer2.render(diagnostic);
        }
        return DefaultErrorMessages.render(diagnostic);
    }

    public static boolean hasIdeSpecificMessage(@NotNull Diagnostic diagnostic) {
        return MAP.get(diagnostic.getFactory()) != null;
    }

    private IdeErrorMessages() {
    }

    static {
        MAP.put(Errors.TYPE_MISMATCH, "<html>Type mismatch.<table><tr><td>Required:</td><td>{0}</td></tr><tr><td>Found:</td><td>{1}</td></tr></table></html>", IdeRenderers.HTML_RENDER_TYPE, IdeRenderers.HTML_RENDER_TYPE);
        MAP.put(Errors.TYPE_MISMATCH_DUE_TO_TYPE_PROJECTIONS, "<html>Type mismatch.<table><tr><td>Required:</td><td>{0}</td></tr><tr><td>Found:</td><td>{1}</td></tr></table><br />\nProjected type {2} restricts use of <br />\n{3}\n</html>", new MultiRenderer<TypeMismatchDueToTypeProjectionsData>(){

            @Override
            @NotNull
            public String[] render(@NotNull TypeMismatchDueToTypeProjectionsData object) {
                RenderingContext context = RenderingContext.of(object.getExpectedType(), object.getExpressionType(), object.getReceiverType(), object.getCallableDescriptor());
                return new String[]{IdeRenderers.HTML_RENDER_TYPE.render(object.getExpectedType(), context), IdeRenderers.HTML_RENDER_TYPE.render(object.getExpressionType(), context), IdeRenderers.HTML_RENDER_TYPE.render(object.getReceiverType(), context), IdeRenderers.HTML.render(object.getCallableDescriptor(), context)};
            }
        });
        MAP.put(Errors.ASSIGN_OPERATOR_AMBIGUITY, "<html>Assignment operators ambiguity. All these functions match.<ul>{0}</ul></table></html>", IdeRenderers.HTML_AMBIGUOUS_CALLS);
        MAP.put(Errors.TYPE_INFERENCE_CONFLICTING_SUBSTITUTIONS, "<html>Type inference failed: {0}</html>", IdeRenderers.HTML_TYPE_INFERENCE_CONFLICTING_SUBSTITUTIONS_RENDERER);
        MAP.put(Errors.TYPE_INFERENCE_NO_INFORMATION_FOR_PARAMETER, "<html>Type inference failed: {0}</html>", IdeRenderers.HTML_TYPE_INFERENCE_NO_INFORMATION_FOR_PARAMETER_RENDERER);
        MAP.put(Errors.TYPE_INFERENCE_PARAMETER_CONSTRAINT_ERROR, "<html>Type inference failed: {0}</html>", IdeRenderers.HTML_TYPE_INFERENCE_PARAMETER_CONSTRAINT_ERROR_RENDERER);
        MAP.put(Errors.TYPE_INFERENCE_EXPECTED_TYPE_MISMATCH, HtmlTabledDescriptorRenderer.tableForTypes("Type inference failed. Expected type mismatch: ", "required: ", TabledDescriptorRenderer.TextElementType.STRONG, "found: ", TabledDescriptorRenderer.TextElementType.ERROR), IdeRenderers.HTML_RENDER_TYPE, IdeRenderers.HTML_RENDER_TYPE);
        MAP.put(Errors.TYPE_INFERENCE_UPPER_BOUND_VIOLATED, "<html>{0}</html>", IdeRenderers.HTML_TYPE_INFERENCE_UPPER_BOUND_VIOLATED_RENDERER);
        MAP.put(Errors.WRONG_SETTER_PARAMETER_TYPE, "<html>Setter parameter type must be equal to the type of the property.<table><tr><td>Expected:</td><td>{0}</td></tr><tr><td>Found:</td><td>{1}</td></tr></table></html>", IdeRenderers.HTML_RENDER_TYPE, IdeRenderers.HTML_RENDER_TYPE);
        MAP.put(Errors.WRONG_GETTER_RETURN_TYPE, "<html>Getter return type must be equal to the type of the property.<table><tr><td>Expected:</td><td>{0}</td></tr><tr><td>Found:</td><td>{1}</td></tr></table></html>", IdeRenderers.HTML_RENDER_TYPE, IdeRenderers.HTML_RENDER_TYPE);
        MAP.put(Errors.ITERATOR_AMBIGUITY, "<html>Method ''iterator()'' is ambiguous for this expression.<ul>{0}</ul></html>", IdeRenderers.HTML_AMBIGUOUS_CALLS);
        MAP.put(Errors.UPPER_BOUND_VIOLATED, "<html>Type argument is not within its bounds.<table><tr><td>Expected:</td><td>{0}</td></tr><tr><td>Found:</td><td>{1}</td></tr></table></html>", IdeRenderers.HTML_RENDER_TYPE, IdeRenderers.HTML_RENDER_TYPE);
        MAP.put(Errors.TYPE_MISMATCH_IN_FOR_LOOP, "<html>Loop parameter type mismatch.<table><tr><td>Iterated values:</td><td>{0}</td></tr><tr><td>Parameter:</td><td>{1}</td></tr></table></html>", IdeRenderers.HTML_RENDER_TYPE, IdeRenderers.HTML_RENDER_TYPE);
        MAP.put(Errors.RETURN_TYPE_MISMATCH_ON_OVERRIDE, "<html>Return type is ''{0}'', which is not a subtype of overridden<br/>{1}</html>", IdeRenderers.HTML_RENDER_RETURN_TYPE, IdeRenderers.HTML);
        MAP.put(Errors.RETURN_TYPE_MISMATCH_ON_INHERITANCE, "<html>Return types of inherited members are incompatible:<br/>{0},<br/>{1}</html>", IdeRenderers.HTML, IdeRenderers.HTML);
        MAP.put(Errors.PROPERTY_TYPE_MISMATCH_ON_OVERRIDE, "<html>Property type is ''{0}'', which is not a subtype type of overridden<br/>{1}</html>", IdeRenderers.HTML_RENDER_RETURN_TYPE, IdeRenderers.HTML);
        MAP.put(Errors.VAR_TYPE_MISMATCH_ON_OVERRIDE, "<html>Var-property type is ''{0}'', which is not a type of overridden<br/>{1}</html>", IdeRenderers.HTML_RENDER_RETURN_TYPE, IdeRenderers.HTML);
        MAP.put(Errors.PROPERTY_TYPE_MISMATCH_ON_INHERITANCE, "<html>Types of inherited properties are incompatible:<br/>{0},<br/>{1}</html>", IdeRenderers.HTML, IdeRenderers.HTML);
        MAP.put(Errors.VAR_TYPE_MISMATCH_ON_INHERITANCE, "<html>Types of inherited var-properties do not match:<br/>{0},<br/>{1}</html>", IdeRenderers.HTML, IdeRenderers.HTML);
        MAP.put(Errors.VAR_OVERRIDDEN_BY_VAL, "<html>Val-property cannot override var-property<br />{1}</html>", IdeRenderers.HTML, IdeRenderers.HTML);
        MAP.put(Errors.VAR_OVERRIDDEN_BY_VAL_BY_DELEGATION, "<html>Val-property cannot override var-property<br />{1}</html>", IdeRenderers.HTML, IdeRenderers.HTML);
        MAP.put(Errors.ABSTRACT_MEMBER_NOT_IMPLEMENTED, "<html>{0} is not abstract and does not implement abstract member<br/>{1}</html>", Renderers.RENDER_CLASS_OR_OBJECT, IdeRenderers.HTML);
        MAP.put(Errors.ABSTRACT_CLASS_MEMBER_NOT_IMPLEMENTED, "<html>{0} is not abstract and does not implement abstract base class member<br/>{1}</html>", Renderers.RENDER_CLASS_OR_OBJECT, IdeRenderers.HTML);
        MAP.put(Errors.MANY_IMPL_MEMBER_NOT_IMPLEMENTED, "<html>{0} must override {1}<br />because it inherits many implementations of it</html>", Renderers.RENDER_CLASS_OR_OBJECT, IdeRenderers.HTML);
        MAP.put(Errors.RESULT_TYPE_MISMATCH, "<html>Function return type mismatch.<table><tr><td>Expected:</td><td>{1}</td></tr><tr><td>Found:</td><td>{2}</td></tr></table></html>", Renderers.STRING, IdeRenderers.HTML_RENDER_TYPE, IdeRenderers.HTML_RENDER_TYPE);
        MAP.put(Errors.OVERLOAD_RESOLUTION_AMBIGUITY, "<html>Overload resolution ambiguity. All these functions match. <ul>{0}</ul></html>", IdeRenderers.HTML_AMBIGUOUS_CALLS);
        MAP.put(Errors.NONE_APPLICABLE, "<html>None of the following functions can be called with the arguments supplied. <ul>{0}</ul></html>", IdeRenderers.HTML_NONE_APPLICABLE_CALLS);
        MAP.put(Errors.CANNOT_COMPLETE_RESOLVE, "<html>Cannot choose among the following candidates without completing type inference: <ul>{0}</ul></html>", IdeRenderers.HTML_AMBIGUOUS_CALLS);
        MAP.put(Errors.UNRESOLVED_REFERENCE_WRONG_RECEIVER, "<html>Unresolved reference. <br/> None of the following candidates is applicable because of receiver type mismatch: <ul>{0}</ul></html>", IdeRenderers.HTML_AMBIGUOUS_CALLS);
        MAP.put(Errors.DELEGATE_SPECIAL_FUNCTION_AMBIGUITY, "<html>Overload resolution ambiguity on method ''{0}''. All these functions match. <ul>{1}</ul></html>", Renderers.STRING, IdeRenderers.HTML_AMBIGUOUS_CALLS);
        MAP.put(Errors.DELEGATE_SPECIAL_FUNCTION_NONE_APPLICABLE, "<html>Property delegate must have a ''{0}'' method. None of the following functions is suitable. <ul>{1}</ul></html>", Renderers.STRING, IdeRenderers.HTML_NONE_APPLICABLE_CALLS);
        MAP.put(Errors.DELEGATE_PD_METHOD_NONE_APPLICABLE, "<html>''{0}'' method may be missing. None of the following functions will be called: <ul>{1}</ul></html>", Renderers.STRING, IdeRenderers.HTML_NONE_APPLICABLE_CALLS);
        MAP.put(ErrorsJvm.CONFLICTING_JVM_DECLARATIONS, "<html>Platform declaration clash: {0}</html>", IdeRenderers.HTML_CONFLICTING_JVM_DECLARATIONS_DATA);
        MAP.put(ErrorsJvm.ACCIDENTAL_OVERRIDE, "<html>Accidental override: {0}</html>", IdeRenderers.HTML_CONFLICTING_JVM_DECLARATIONS_DATA);
        URL errorIconUrl = AllIcons.class.getResource("/general/error.png");
        MAP.put(Errors.EXCEPTION_FROM_ANALYZER, "<html>Internal Error occurred while analyzing this expression <br/><table cellspacing=\"0\" cellpadding=\"0\"><tr><td>(<strong>Please use the \"</strong></td><td><img src=\"" + errorIconUrl + "\"/></td><td><strong>\" icon in the bottom-right corner to report this error</strong>):</td></tr></table><br/><pre>{0}</pre></html>", IdeRenderers.HTML_THROWABLE);
        MAP.put(ErrorsJs.JSCODE_ERROR, "<html>JavaScript: {0}</html>", JsCallDataHtmlRenderer.INSTANCE);
        MAP.put(ErrorsJs.JSCODE_WARNING, "<html>JavaScript: {0}</html>", JsCallDataHtmlRenderer.INSTANCE);
        MAP.put(Errors.UNSUPPORTED_FEATURE, "<html>{0}</html>", new LanguageFeatureMessageRenderer(LanguageFeatureMessageRenderer.Type.UNSUPPORTED, true));
        MAP.put(Errors.EXPERIMENTAL_FEATURE_WARNING, "<html>{0}</html>", new LanguageFeatureMessageRenderer(LanguageFeatureMessageRenderer.Type.WARNING, true));
        MAP.put(Errors.EXPERIMENTAL_FEATURE_ERROR, "<html>{0}</html>", new LanguageFeatureMessageRenderer(LanguageFeatureMessageRenderer.Type.ERROR, true));
        MAP.put(Errors.NO_ACTUAL_FOR_EXPECT, "<html>Expected {0} has no actual declaration in module{1}{2}</html>", Renderers.DECLARATION_NAME_WITH_KIND, Renderers.PLATFORM, new PlatformIncompatibilityDiagnosticRenderer(IdeMultiplatformDiagnosticRenderingMode.INSTANCE));
        MAP.put(Errors.ACTUAL_WITHOUT_EXPECT, "<html>{0} has no corresponding expected declaration{1}</html>", Renderers.CAPITALIZED_DECLARATION_NAME_WITH_KIND_AND_PLATFORM, new PlatformIncompatibilityDiagnosticRenderer(IdeMultiplatformDiagnosticRenderingMode.INSTANCE));
        MAP.put(Errors.NO_ACTUAL_CLASS_MEMBER_FOR_EXPECTED_CLASS, "<html>Actual class ''{0}'' has no corresponding members for expected class members:{1}</html>", Renderers.NAME, new IncompatibleExpectedActualClassScopesRenderer(IdeMultiplatformDiagnosticRenderingMode.INSTANCE));
        MAP.setImmutable();
    }
}

