/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u0007J\u0018\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000RB\u0010\u0005\u001a6\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \b*\b\u0012\u0002\b\u0003\u0018\u00010\u00070\u0007 \b*\u001a\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \b*\b\u0012\u0002\b\u0003\u0018\u00010\u00070\u0007\u0018\u00010\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/NoDeclarationDescriptorsChecker;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "checkedQuickFixClasses", "", "Ljava/lang/Class;", "kotlin.jvm.PlatformType", "", "check", "", "quickFixClass", "checkType", "type", "Ljava/lang/reflect/Type;", "field", "Ljava/lang/reflect/Field;", "idea-core"})
final class NoDeclarationDescriptorsChecker {
    private static final Logger LOG;
    private static final Set<Class<?>> checkedQuickFixClasses;
    public static final NoDeclarationDescriptorsChecker INSTANCE;

    public final void check(@NotNull Class<?> quickFixClass) {
        block2: {
            Class<?> clazz;
            Intrinsics.checkParameterIsNotNull(quickFixClass, (String)"quickFixClass");
            if (!checkedQuickFixClasses.add(quickFixClass)) {
                return;
            }
            Field[] fieldArray = quickFixClass.getDeclaredFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                Field field2;
                Field field3 = field2 = fieldArray[i];
                Intrinsics.checkExpressionValueIsNotNull((Object)field3, (String)"field");
                Type type2 = field3.getGenericType();
                Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"field.genericType");
                this.checkType(type2, field2);
            }
            Class<?> clazz2 = quickFixClass.getSuperclass();
            if (clazz2 == null) break block2;
            Class<?> it = clazz = clazz2;
            INSTANCE.check(it);
        }
    }

    private final void checkType(Type type2, Field field2) {
        block6: {
            Type type3;
            block8: {
                block7: {
                    block5: {
                        type3 = type2;
                        if (!(type3 instanceof Class)) break block5;
                        if (DeclarationDescriptor.class.isAssignableFrom((Class)type2) || KotlinType.class.isAssignableFrom((Class)type2)) {
                            StringBuilder stringBuilder = new StringBuilder().append("QuickFix class ");
                            Class<?> clazz = field2.getDeclaringClass();
                            Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"field.declaringClass");
                            LOG.error(stringBuilder.append(clazz.getName()).append(" contains field ").append(field2.getName()).append(" that holds ").append(((Class)type2).getSimpleName()).append(". ").append("This leads to holding too much memory through this quick-fix instance. ").append("Possible solution can be wrapping it using KotlinIntentionActionFactoryWithDelegate.").toString());
                        }
                        if (!IntentionAction.class.isAssignableFrom((Class)type2)) break block6;
                        this.check((Class)type2);
                        break block6;
                    }
                    if (!(type3 instanceof GenericArrayType)) break block7;
                    Type type4 = ((GenericArrayType)type2).getGenericComponentType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)type4, (String)"type.genericComponentType");
                    this.checkType(type4, field2);
                    break block6;
                }
                if (!(type3 instanceof ParameterizedType)) break block8;
                Type type5 = ((ParameterizedType)type2).getRawType();
                if (type5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<*>");
                }
                if (!Collection.class.isAssignableFrom((Class)type5)) break block6;
                Type[] typeArray = ((ParameterizedType)type2).getActualTypeArguments();
                Intrinsics.checkExpressionValueIsNotNull((Object)typeArray, (String)"type.actualTypeArguments");
                Object[] $receiver$iv = typeArray;
                for (int i = 0; i < $receiver$iv.length; ++i) {
                    Type it;
                    Object element$iv = $receiver$iv[i];
                    Type type6 = it = (Type)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)type6, (String)"it");
                    INSTANCE.checkType(type6, field2);
                }
                break block6;
            }
            if (type3 instanceof WildcardType) {
                Type[] typeArray = ((WildcardType)type2).getUpperBounds();
                Intrinsics.checkExpressionValueIsNotNull((Object)typeArray, (String)"type.upperBounds");
                Object[] $receiver$iv = typeArray;
                for (int i = 0; i < $receiver$iv.length; ++i) {
                    Type it;
                    Object element$iv = $receiver$iv[i];
                    Type type7 = it = (Type)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)type7, (String)"it");
                    INSTANCE.checkType(type7, field2);
                }
            }
        }
    }

    private NoDeclarationDescriptorsChecker() {
    }

    static {
        NoDeclarationDescriptorsChecker noDeclarationDescriptorsChecker;
        INSTANCE = noDeclarationDescriptorsChecker = new NoDeclarationDescriptorsChecker();
        LOG = Logger.getInstance(NoDeclarationDescriptorsChecker.class);
        checkedQuickFixClasses = Collections.synchronizedSet(new HashSet());
    }
}

