/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.geronimo.admin;

import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.oss.agent.AgentProxyFactory;
import com.intellij.javaee.oss.geronimo.GeronimoUtil;
import com.intellij.javaee.oss.geronimo.admin.GeronimoAdminServerBase;
import com.intellij.javaee.oss.geronimo.model.GeronimoCommonRoot;
import com.intellij.javaee.oss.geronimo.model.GeronimoModuleId;
import com.intellij.openapi.application.ReadAction;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class Geronimo11AdminServerImpl
extends GeronimoAdminServerBase {
    private static final String DEFAULT_GROUP_ID = "default";
    private static final String SPECIFICS_MODULE_NAME = "idea-geronimo-srv11";
    private static final String SPECIFICS_JAR_PATH = "specifics/geronimo11-specifics.jar";

    public Geronimo11AdminServerImpl(AgentProxyFactory agentProxyFactory, List<File> libraries) throws Exception {
        super(agentProxyFactory, libraries, SPECIFICS_MODULE_NAME, SPECIFICS_JAR_PATH, "com.intellij.javaee.oss.geronimo.agent.Geronimo11Agent");
    }

    @Override
    @NotNull
    protected String getDeploymentModelName(DeploymentModel deployment, File source) throws Exception {
        String result = (String)ReadAction.compute(() -> {
            GeronimoModuleId id;
            GeronimoCommonRoot root = GeronimoUtil.getCommonRoot(deployment);
            if (root != null && (id = root.getEnvironment().getModuleId()).getXmlTag() != null) {
                return Geronimo11AdminServerImpl.getDeploymentId(id);
            }
            return null;
        });
        if (result == null) {
            result = Geronimo11AdminServerImpl.getDeploymentId(source);
        }
        String string = result;
        if (string == null) {
            Geronimo11AdminServerImpl.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static String getDeploymentId(GeronimoModuleId id) {
        StringBuilder str = new StringBuilder();
        String group = (String)id.getGroupId().getValue();
        str.append(group == null ? DEFAULT_GROUP_ID : group);
        str.append('/');
        String artifact = (String)id.getArtifactId().getValue();
        str.append(artifact == null ? "" : artifact);
        str.append('/');
        String version = (String)id.getVersion().getValue();
        str.append(version == null ? "" : version);
        str.append('/');
        String type = (String)id.getType().getValue();
        str.append(type == null ? "" : type);
        return str.toString();
    }

    private static String getDeploymentId(File file) {
        String name = file.getName();
        if (name.indexOf(46) > 0) {
            name = name.substring(0, name.lastIndexOf(46));
        }
        return '/' + name + "//";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/oss/geronimo/admin/Geronimo11AdminServerImpl", "getDeploymentModelName"));
    }
}

