/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.components;

import com.intellij.diagram.AbstractDiagramElementManager;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramElementManager;
import com.intellij.diagram.DiagramNode;
import com.intellij.openapi.graph.builder.renderer.GradientFilledPanel;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.CellRendererPanel;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;

public class DiagramNodeHeaderComponent
extends GradientFilledPanel {
    public DiagramNodeHeaderComponent(DiagramNode node, DiagramBuilder builder) {
        super(builder.getProvider().getColorManager().drawGradientInHeader() ? DiagramNodeHeaderComponent.getColor(node, builder) : null);
        int style;
        Object element = node.getIdentifyingElement();
        SimpleColoredComponent label = new SimpleColoredComponent(){

            protected boolean shouldDrawMacShadow() {
                return !GraphViewUtil.isPrintMode() && (super.shouldDrawMacShadow() || UIUtil.isUnderDarcula());
            }
        };
        if (!builder.getProvider().getColorManager().drawGradientInHeader()) {
            this.setBackground(builder.getProvider().getColorManager().getNodeHeaderColor(builder, node));
        }
        label.setIcon(node.getIcon());
        if (GraphViewUtil.isPrintMode()) {
            label.setForeground((Color)JBColor.BLACK);
        }
        DiagramElementManager manager = builder.getProvider().getElementManager();
        String presentableName = manager.getElementTitle(element);
        int n = style = manager instanceof AbstractDiagramElementManager ? ((AbstractDiagramElementManager)manager).getTitleAttributes(element) : 0;
        if (presentableName != null) {
            if (GraphViewUtil.isPrintMode()) {
                label.append(presentableName, new SimpleTextAttributes(style, (Color)JBColor.BLACK));
            } else {
                label.append(presentableName, new SimpleTextAttributes(style, null));
            }
        }
        label.setAlignmentX(0.0f);
        label.setOpaque(false);
        label.setIconOpaque(false);
        CellRendererPanel.SuperPreferredSize wrap = new CellRendererPanel.SuperPreferredSize();
        wrap.setLayout(new BorderLayout());
        wrap.add((Component)label, "Center");
        wrap.setBorder(JBUI.Borders.empty((int)3));
        this.setLayout(new BorderLayout());
        this.add((Component)wrap, "Center");
        label.setForeground(DiagramNodeHeaderComponent.getElementColor(node.getIdentifyingElement()));
        this.setFocusable(false);
    }

    @NotNull
    protected static Color getElementColor(@NotNull Object element) {
        PsiFile containingFile;
        if (element == null) {
            DiagramNodeHeaderComponent.$$$reportNull$$$0(0);
        }
        Color color = null;
        if (element instanceof PsiElement && ((PsiElement)element).isValid() && (containingFile = ((PsiElement)element).getContainingFile()) != null) {
            VirtualFile file = containingFile.getVirtualFile();
            if (file == null) {
                Color color2 = JBColor.foreground();
                if (color2 == null) {
                    DiagramNodeHeaderComponent.$$$reportNull$$$0(1);
                }
                return color2;
            }
            color = FileStatusManager.getInstance((Project)((PsiElement)element).getProject()).getStatus(file).getColor();
        }
        Color color3 = color == null ? JBColor.foreground() : color;
        if (color3 == null) {
            DiagramNodeHeaderComponent.$$$reportNull$$$0(2);
        }
        return color3;
    }

    private static Color getColor(DiagramNode node, DiagramBuilder builder) {
        return builder.getProvider().getColorManager().getNodeHeaderColor(builder, node);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/components/DiagramNodeHeaderComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/components/DiagramNodeHeaderComponent";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementColor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getElementColor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

